/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesV2AbstractManifestProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.model.ManifestProvider;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2ManifestProvider
extends KubernetesV2AbstractManifestProvider {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2ManifestProvider.class);
    private final KubernetesCacheUtils cacheUtils;
    private final KubernetesResourcePropertyRegistry registry;
    private final AccountCredentialsRepository credentialsRepository;

    @Autowired
    public KubernetesV2ManifestProvider(AccountCredentialsRepository credentialsRepository, KubernetesResourcePropertyRegistry registry, KubernetesCacheUtils cacheUtils) {
        this.registry = registry;
        this.cacheUtils = cacheUtils;
        this.credentialsRepository = credentialsRepository;
    }

    public KubernetesV2Manifest getManifest(String account, String location, String name) {
        Pair<KubernetesKind, String> parsedName;
        if (!this.isAccountRelevant(account)) {
            return null;
        }
        if (this.makesLiveCalls(account)) {
            return null;
        }
        try {
            parsedName = KubernetesManifest.fromFullResourceName(name);
        }
        catch (Exception e) {
            return null;
        }
        KubernetesKind kind = (KubernetesKind)parsedName.getLeft();
        if (!kind.isNamespaced() && StringUtils.isNotEmpty((String)location)) {
            log.warn("Kind {} is not namespaced, but namespace {} was provided (ignoring)", (Object)kind, (Object)location);
            location = "";
        }
        String key = Keys.infrastructure(kind, account, location, (String)parsedName.getRight());
        Optional<CacheData> dataOptional = this.cacheUtils.getSingleEntry(kind.toString(), key);
        if (!dataOptional.isPresent()) {
            return null;
        }
        CacheData data = dataOptional.get();
        return this.fromCacheData(data, account);
    }

    public List<KubernetesV2Manifest> getClusterAndSortAscending(String account, String location, String kind, String app, String cluster, ManifestProvider.Sort sort) {
        KubernetesResourceProperties properties = this.registry.get(account, KubernetesKind.fromString(kind));
        if (properties == null) {
            return null;
        }
        KubernetesHandler handler = properties.getHandler();
        return this.cacheUtils.getSingleEntry(Keys.LogicalKind.CLUSTERS.toString(), Keys.cluster(account, app, cluster)).map(c -> this.cacheUtils.loadRelationshipsFromCache((CacheData)c, kind).stream().map(cd -> this.fromCacheData((CacheData)cd, account)).filter(Objects::nonNull).filter(m -> m.getLocation().equals(location)).sorted((m1, m2) -> handler.comparatorFor(sort).compare(m1.getManifest(), m2.getManifest())).collect(Collectors.toList())).orElse(new ArrayList());
    }

    private KubernetesV2Manifest fromCacheData(CacheData data, String account) {
        KubernetesManifest manifest = KubernetesCacheDataConverter.getManifest(data);
        String namespace = manifest.getNamespace();
        KubernetesKind kind = manifest.getKind();
        String key = data.getId();
        List<KubernetesManifest> events = this.cacheUtils.getTransitiveRelationship(kind.toString(), Collections.singletonList(key), KubernetesKind.EVENT.toString()).stream().map(KubernetesCacheDataConverter::getManifest).collect(Collectors.toList());
        String metricKey = Keys.metric(kind, account, namespace, manifest.getName());
        List<Map> metrics = this.cacheUtils.getSingleEntry(Keys.Kind.KUBERNETES_METRIC.toString(), metricKey).map(KubernetesCacheDataConverter::getMetrics).orElse(Collections.emptyList());
        return this.buildManifest(account, manifest, events, metrics);
    }

    @Override
    public KubernetesResourcePropertyRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public AccountCredentialsRepository getCredentialsRepository() {
        return this.credentialsRepository;
    }
}

