/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider;

import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2SecurityGroup;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.model.SecurityGroupProvider;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2SecurityGroupProvider
implements SecurityGroupProvider<KubernetesV2SecurityGroup> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2SecurityGroupProvider.class);
    private final KubernetesCacheUtils cacheUtils;
    private final KubernetesSpinnakerKindMap kindMap;

    @Autowired
    KubernetesV2SecurityGroupProvider(KubernetesCacheUtils cacheUtils, KubernetesSpinnakerKindMap kindMap) {
        this.cacheUtils = cacheUtils;
        this.kindMap = kindMap;
    }

    public String getCloudProvider() {
        return KubernetesCloudProvider.getID();
    }

    public Set<KubernetesV2SecurityGroup> getAll(boolean includeRules) {
        return this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.SECURITY_GROUPS).stream().map(KubernetesKind::toString).map(this.cacheUtils::getAllKeys).flatMap(Collection::stream).map(KubernetesV2SecurityGroup::fromCacheData).collect(Collectors.toSet());
    }

    public Set<KubernetesV2SecurityGroup> getAllByRegion(boolean includeRules, String namespace) {
        return this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.SECURITY_GROUPS).stream().map(k -> {
            String key = Keys.infrastructure(k, "*", namespace, "*");
            return this.cacheUtils.getAllDataMatchingPattern(k.toString(), key);
        }).flatMap(Collection::stream).map(KubernetesV2SecurityGroup::fromCacheData).collect(Collectors.toSet());
    }

    public Set<KubernetesV2SecurityGroup> getAllByAccount(boolean includeRules, String account) {
        return this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.SECURITY_GROUPS).stream().map(k -> {
            String key = Keys.infrastructure(k, account, "*", "*");
            return this.cacheUtils.getAllDataMatchingPattern(k.toString(), key);
        }).flatMap(Collection::stream).map(KubernetesV2SecurityGroup::fromCacheData).collect(Collectors.toSet());
    }

    public Set<KubernetesV2SecurityGroup> getAllByAccountAndName(boolean includeRules, String account, String fullName) {
        String name;
        try {
            name = (String)KubernetesManifest.fromFullResourceName(fullName).getRight();
        }
        catch (Exception e) {
            return null;
        }
        return this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.SECURITY_GROUPS).stream().map(k -> {
            String key = Keys.infrastructure(k, account, "*", name);
            return this.cacheUtils.getAllDataMatchingPattern(k.toString(), key);
        }).flatMap(Collection::stream).map(KubernetesV2SecurityGroup::fromCacheData).collect(Collectors.toSet());
    }

    public Set<KubernetesV2SecurityGroup> getAllByAccountAndRegion(boolean includeRule, String account, String namespace) {
        return this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.SECURITY_GROUPS).stream().map(k -> {
            String key = Keys.infrastructure(k, account, namespace, "*");
            return this.cacheUtils.getAllDataMatchingPattern(k.toString(), key);
        }).flatMap(Collection::stream).map(KubernetesV2SecurityGroup::fromCacheData).collect(Collectors.toSet());
    }

    public KubernetesV2SecurityGroup get(String account, String namespace, String fullName, String _unused) {
        String name;
        try {
            name = (String)KubernetesManifest.fromFullResourceName(fullName).getRight();
        }
        catch (Exception e) {
            return null;
        }
        return this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.SECURITY_GROUPS).stream().map(k -> {
            String key = Keys.infrastructure(k, account, namespace, name);
            return this.cacheUtils.getSingleEntry(k.toString(), key).orElse(null);
        }).filter(Objects::nonNull).map(KubernetesV2SecurityGroup::fromCacheData).findFirst().orElse(null);
    }
}

