/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.validators;

import com.netflix.spinnaker.clouddriver.kubernetes.v1.security.KubernetesV1Credentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import java.util.List;
import org.apache.http.conn.util.InetAddressUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.validation.Errors;

public class StandardKubernetesAttributeValidator
implements GroovyObject {
    private static final Object namePattern;
    private static final Object dnsSubdomainPattern;
    private static final Object credentialsPattern;
    private static final Object prefixPattern;
    private static final Object httpPathPattern;
    private static final Object unixPathPattern;
    private static final Object winPathPattern;
    private static final Object quantityPattern;
    private static final Object protocolList;
    private static final Object serviceTypeList;
    private static final Object sessionAffinityList;
    private static final Object restartPolicyList;
    private static final Object uriSchemeList;
    private static final Object maxPort;
    private String context;
    private Errors errors;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public StandardKubernetesAttributeValidator(String context, Errors errors) {
        MetaClass metaClass;
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        String string = context;
        this.context = ShortTypeHandling.castToString((Object)string);
        Errors errors2 = errors;
        this.errors = (Errors)ScriptBytecodeAdapter.castToType((Object)errors2, Errors.class);
    }

    public Object validateByRegex(String value, String attribute, String regex) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (ScriptBytecodeAdapter.matchRegex((Object)value, (Object)regex)) {
            boolean bl = true;
            result = bl;
        } else {
            callSiteArray[0].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, regex}, new String[]{"", ".", ".invalid (Must match ", ")"}));
            boolean bl = false;
            result = bl;
        }
        return result;
    }

    public Object validateByContainment(Object value, String attribute, List<Object> list) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(list, value))) {
            boolean bl = true;
            result = bl;
        } else {
            callSiteArray[2].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, list}, new String[]{"", ".", ".invalid (Must be one of ", ")"}));
            boolean bl = false;
            result = bl;
        }
        return result;
    }

    public Object reject(String attribute, String reason) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        return callSiteArray[3].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, reason}, new String[]{"", ".", ".invalid (", ")"}));
    }

    public Object validateDetails(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return true;
        }
        return callSiteArray[4].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, namePattern);
    }

    public Object validateName(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            return callSiteArray[6].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, namePattern);
        }
        return false;
    }

    public Object validateSecretName(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            return callSiteArray[8].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, dnsSubdomainPattern);
        }
        return false;
    }

    public Object validatePath(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            if (ScriptBytecodeAdapter.matchRegex((Object)value, (Object)unixPathPattern) || ScriptBytecodeAdapter.matchRegex((Object)value, (Object)winPathPattern)) {
                boolean bl = true;
                result = bl;
            } else {
                callSiteArray[10].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, unixPathPattern, winPathPattern}, new String[]{"", ".", ".invalid (Must match ", " or ", ")"}));
                boolean bl = false;
                result = bl;
            }
        } else {
            boolean bl = false;
            result = bl;
        }
        return result;
    }

    public Object validateHttpPath(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            return callSiteArray[12].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, httpPathPattern);
        }
        return false;
    }

    public Object validateRelativePath(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            if (ScriptBytecodeAdapter.matchRegex((Object)value, (Object)unixPathPattern) || ScriptBytecodeAdapter.matchRegex((Object)value, (Object)winPathPattern)) {
                callSiteArray[14].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, unixPathPattern, winPathPattern}, new String[]{"", ".", ".invalid (Must not match ", " or ", ")"}));
                boolean bl = false;
                result = bl;
            } else {
                boolean bl = true;
                result = bl;
            }
        } else {
            boolean bl = false;
            result = bl;
        }
        return result;
    }

    public Object validateProtocol(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            return callSiteArray[16].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, protocolList);
        }
        return false;
    }

    public Object validateSessionAffinity(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)value) ? callSiteArray[17].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, sessionAffinityList) : null;
    }

    public Object validateUriScheme(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)value) ? callSiteArray[18].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, uriSchemeList) : null;
    }

    public Object validateIpv4(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Object result = callSiteArray[19].call(InetAddressUtils.class, (Object)value);
        if (!DefaultTypeTransformation.booleanUnbox((Object)result)) {
            callSiteArray[20].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid (Not valid IPv4 address)"}));
        }
        return result;
    }

    public Object validateServiceType(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)value) ? callSiteArray[21].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, serviceTypeList) : Boolean.valueOf(true);
    }

    public Object validatePort(int port, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            boolean bl = port >= 1 && ScriptBytecodeAdapter.compareLessThanEqual((Object)port, (Object)maxPort);
            result = bl;
        } else {
            boolean bl = port >= 1 && ScriptBytecodeAdapter.compareLessThanEqual((Object)port, (Object)maxPort);
            result = bl;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)result)) {
            callSiteArray[22].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, maxPort}, new String[]{"", ".", ".invalid (Must be in range [1, ", "])"}));
        }
        return result;
    }

    public Object validateApplication(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            return callSiteArray[24].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, prefixPattern);
        }
        return false;
    }

    public Object validateStack(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return true;
        }
        return callSiteArray[25].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, prefixPattern);
    }

    public Object validateCpu(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return true;
        }
        return callSiteArray[26].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, quantityPattern);
    }

    public Object validateMemory(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return true;
        }
        return callSiteArray[27].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, quantityPattern);
    }

    public Object validateImagePullSecret(KubernetesV1Credentials credentials, String value, String namespace, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].call((Object)credentials, (Object)value, (Object)namespace))) {
            callSiteArray[29].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".notRegistered"}));
            return false;
        }
        return callSiteArray[30].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, namePattern);
    }

    public Object validateNamespace(KubernetesV1Credentials credentials, String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return true;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].call((Object)credentials, (Object)value))) {
            callSiteArray[32].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".notRegistered"}));
            return false;
        }
        return callSiteArray[33].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, namePattern);
    }

    public Object validateNotEmpty(Object value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)"") && ScriptBytecodeAdapter.compareNotEqual((Object)value, null) && ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]))) {
                boolean bl = true;
                result = bl;
            } else {
                callSiteArray[34].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
                boolean bl = false;
                result = bl;
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)"") && ScriptBytecodeAdapter.compareNotEqual((Object)value, null) && ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]))) {
            boolean bl = true;
            result = bl;
        } else {
            callSiteArray[35].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
            boolean bl = false;
            result = bl;
        }
        return result;
    }

    public Object validateCredentials(String credentials, AccountCredentialsProvider accountCredentialsProvider) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Object result = callSiteArray[36].callCurrent((GroovyObject)this, (Object)credentials, (Object)"account");
        if (DefaultTypeTransformation.booleanUnbox((Object)result)) {
            Object kubernetesCredentials = callSiteArray[37].call((Object)accountCredentialsProvider, (Object)credentials);
            if (!(callSiteArray[38].callGetPropertySafe(kubernetesCredentials) instanceof KubernetesV1Credentials)) {
                callSiteArray[39].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".account"}), (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".account.notFound"}));
                boolean bl = false;
                result = bl;
            }
        }
        return result;
    }

    public Object validateNonNegative(int value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (value >= 0) {
                boolean bl = true;
                result = bl;
            } else {
                callSiteArray[40].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".negative"}));
                boolean bl = false;
                result = bl;
            }
        } else if (value >= 0) {
            boolean bl = true;
            result = bl;
        } else {
            callSiteArray[41].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".negative"}));
            boolean bl = false;
            result = bl;
        }
        return result;
    }

    public Object validatePositive(int value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (value > 0) {
                boolean bl = true;
                result = bl;
            } else {
                callSiteArray[42].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".notPositive"}));
                boolean bl = false;
                result = bl;
            }
        } else if (value > 0) {
            boolean bl = true;
            result = bl;
        } else {
            callSiteArray[43].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".notPositive"}));
            boolean bl = false;
            result = bl;
        }
        return result;
    }

    public Object validateRestartPolicy(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)value) ? callSiteArray[44].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, restartPolicyList) : null;
    }

    public Object validateJobCloneSource(Object value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            callSiteArray[45].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
            return false;
        }
        return callSiteArray[46].callCurrent((GroovyObject)this, callSiteArray[47].callGetProperty(value), (Object)attribute);
    }

    public Object validateServerGroupCloneSource(Object value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            callSiteArray[48].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
            return false;
        }
        return callSiteArray[49].callCurrent((GroovyObject)this, callSiteArray[50].callGetProperty(value), (Object)attribute);
    }

    public Object validateNotLessThan(Integer value1, Integer value2, String attribute1, String attribute2) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareLessThan((Object)value1, (Object)value2)) {
            return callSiteArray[51].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute1}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute1, this.context, attribute2}, new String[]{"", ".", ".lessThan ", ".", ""}));
        }
        return null;
    }

    public Object validateInRangeInclusive(Integer value, int min, int max, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)min, (Object)value)) {
            callSiteArray[52].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, min}, new String[]{"", ".", ".greaterThan ", ""}));
        }
        if (ScriptBytecodeAdapter.compareLessThan((Object)max, (Object)value)) {
            return callSiteArray[53].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, max}, new String[]{"", ".", ".lessThan ", ""}));
        }
        return null;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StandardKubernetesAttributeValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string = "^([+-]?[0-9.]+)([eEimkKMGTP]*[-+]?[0-9]*)$";
        quantityPattern = string;
        String string2 = "^[a-zA-Z]:(\\\\|/).*$";
        winPathPattern = string2;
        String string3 = "^/.*$";
        unixPathPattern = string3;
        String string4 = "^/.*$";
        httpPathPattern = string4;
        String string5 = "^[a-z0-9]+$";
        prefixPattern = string5;
        String string6 = "^[a-z0-9]+([-a-z0-9_]*[a-z0-9])?$";
        credentialsPattern = string6;
        String string7 = "^[a-z0-9]+([-\\.a-z0-9]*[a-z0-9])?$";
        dnsSubdomainPattern = string7;
        String string8 = "^[a-z0-9]+([-a-z0-9]*[a-z0-9])?$";
        namePattern = string8;
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"TCP", "UDP"});
        protocolList = list;
        List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"ClusterIP", "NodePort", "LoadBalancer"});
        serviceTypeList = list2;
        List list3 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"None", "ClientIP"});
        sessionAffinityList = list3;
        List list4 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"Always", "OnFailure", "Never"});
        restartPolicyList = list4;
        List list5 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"HTTP", "HTTPS"});
        uriSchemeList = list5;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            maxPort = object = StandardKubernetesAttributeValidator.$getCallSiteArray()[54].call(StandardKubernetesAttributeValidator.$getCallSiteArray()[55].call((Object)1, (Object)16), (Object)1);
        } else {
            int n = (1 << 16) - 1;
            maxPort = n;
        }
    }

    public static Object getNamePattern() {
        return namePattern;
    }

    public static Object getDnsSubdomainPattern() {
        return dnsSubdomainPattern;
    }

    public static Object getCredentialsPattern() {
        return credentialsPattern;
    }

    public static Object getPrefixPattern() {
        return prefixPattern;
    }

    public static Object getHttpPathPattern() {
        return httpPathPattern;
    }

    public static Object getUnixPathPattern() {
        return unixPathPattern;
    }

    public static Object getWinPathPattern() {
        return winPathPattern;
    }

    public static Object getQuantityPattern() {
        return quantityPattern;
    }

    public static Object getProtocolList() {
        return protocolList;
    }

    public static Object getServiceTypeList() {
        return serviceTypeList;
    }

    public static Object getSessionAffinityList() {
        return sessionAffinityList;
    }

    public static Object getRestartPolicyList() {
        return restartPolicyList;
    }

    public static Object getUriSchemeList() {
        return uriSchemeList;
    }

    public static Object getMaxPort() {
        return maxPort;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String string) {
        this.context = string;
    }

    public Errors getErrors() {
        return this.errors;
    }

    public void setErrors(Errors errors) {
        this.errors = errors;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "rejectValue";
        stringArray[1] = "contains";
        stringArray[2] = "rejectValue";
        stringArray[3] = "rejectValue";
        stringArray[4] = "validateByRegex";
        stringArray[5] = "validateNotEmpty";
        stringArray[6] = "validateByRegex";
        stringArray[7] = "validateNotEmpty";
        stringArray[8] = "validateByRegex";
        stringArray[9] = "validateNotEmpty";
        stringArray[10] = "rejectValue";
        stringArray[11] = "validateNotEmpty";
        stringArray[12] = "validateByRegex";
        stringArray[13] = "validateNotEmpty";
        stringArray[14] = "rejectValue";
        stringArray[15] = "validateNotEmpty";
        stringArray[16] = "validateByContainment";
        stringArray[17] = "validateByContainment";
        stringArray[18] = "validateByContainment";
        stringArray[19] = "isIPv4Address";
        stringArray[20] = "rejectValue";
        stringArray[21] = "validateByContainment";
        stringArray[22] = "rejectValue";
        stringArray[23] = "validateNotEmpty";
        stringArray[24] = "validateByRegex";
        stringArray[25] = "validateByRegex";
        stringArray[26] = "validateByRegex";
        stringArray[27] = "validateByRegex";
        stringArray[28] = "isRegisteredImagePullSecret";
        stringArray[29] = "rejectValue";
        stringArray[30] = "validateByRegex";
        stringArray[31] = "isRegisteredNamespace";
        stringArray[32] = "rejectValue";
        stringArray[33] = "validateByRegex";
        stringArray[34] = "rejectValue";
        stringArray[35] = "rejectValue";
        stringArray[36] = "validateNotEmpty";
        stringArray[37] = "getCredentials";
        stringArray[38] = "credentials";
        stringArray[39] = "rejectValue";
        stringArray[40] = "rejectValue";
        stringArray[41] = "rejectValue";
        stringArray[42] = "rejectValue";
        stringArray[43] = "rejectValue";
        stringArray[44] = "validateByContainment";
        stringArray[45] = "rejectValue";
        stringArray[46] = "validateNotEmpty";
        stringArray[47] = "jobName";
        stringArray[48] = "rejectValue";
        stringArray[49] = "validateNotEmpty";
        stringArray[50] = "serverGroupName";
        stringArray[51] = "rejectValue";
        stringArray[52] = "rejectValue";
        stringArray[53] = "rejectValue";
        stringArray[54] = "minus";
        stringArray[55] = "leftShift";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[56];
        StandardKubernetesAttributeValidator.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(StandardKubernetesAttributeValidator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = StandardKubernetesAttributeValidator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

