/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v1.model;

import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.provider.KubernetesModelUtil;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.api.KubernetesApiAdaptor;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.api.KubernetesApiConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.api.KubernetesClientApiConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.KubernetesUtil;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.description.servergroup.DeployKubernetesAtomicOperationDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.description.servergroup.KubernetesContainerDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.description.servergroup.KubernetesDeployment;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.model.KubernetesAutoscalerStatus;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.model.KubernetesDeploymentStatus;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.model.KubernetesEvent;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.model.KubernetesV1Instance;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.EqualsAndHashCode;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1PodTemplateSpec;
import io.kubernetes.client.models.V1beta1DaemonSet;
import io.kubernetes.client.models.V1beta1DaemonSetSpec;
import io.kubernetes.client.models.V1beta1StatefulSet;
import io.kubernetes.client.models.V1beta1StatefulSetSpec;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;
import org.joda.time.DateTime;

@EqualsAndHashCode(includes={"name", "namespace", "account"})
public class KubernetesV1ServerGroup
implements ServerGroup,
Serializable,
GroovyObject {
    private String name;
    private final String type;
    private final String cloudProvider;
    private String region;
    private String namespace;
    private String account;
    private Long createdTime;
    private Integer replicas;
    private Boolean hostNetwork;
    private Set<String> zones;
    private Set<KubernetesV1Instance> instances;
    private Set<String> loadBalancers;
    private Set<String> securityGroups;
    private Map<String, Object> launchConfig;
    private Map<String, String> labels;
    private Map<String, String> annotations;
    private DeployKubernetesAtomicOperationDescription deployDescription;
    private KubernetesAutoscalerStatus autoscalerStatus;
    private KubernetesDeploymentStatus deploymentStatus;
    private String kind;
    private String yaml;
    private String revision;
    private Map buildInfo;
    private List<KubernetesEvent> events;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public KubernetesV1ServerGroup() {
        MetaClass metaClass;
        Map map;
        Map map2;
        Set set;
        Set set2;
        String string;
        String string2;
        this.type = string2 = KubernetesCloudProvider.getID();
        this.cloudProvider = string = KubernetesCloudProvider.getID();
        int n = 0;
        this.replicas = n;
        boolean bl = false;
        this.hostNetwork = bl;
        this.loadBalancers = set2 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.securityGroups = set = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.labels = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.annotations = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public KubernetesV1ServerGroup(String name, String namespace) {
        String string;
        String string2;
        String string3;
        MetaClass metaClass;
        Map map;
        Map map2;
        Set set;
        Set set2;
        String string4;
        String string5;
        this.type = string5 = KubernetesCloudProvider.getID();
        this.cloudProvider = string4 = KubernetesCloudProvider.getID();
        int n = 0;
        this.replicas = n;
        boolean bl = false;
        this.hostNetwork = bl;
        this.loadBalancers = set2 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.securityGroups = set = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.labels = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.annotations = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.name = string3 = name;
        this.region = string2 = namespace;
        this.namespace = string = namespace;
    }

    public KubernetesV1ServerGroup(V1beta1StatefulSet statefulSet, String account, List<Event> events) {
        String string;
        String string2;
        DeployKubernetesAtomicOperationDescription deployKubernetesAtomicOperationDescription;
        Map map;
        Map map2;
        Integer n;
        Set set;
        Long l;
        String string3;
        String string4;
        String string5;
        String string6;
        MetaClass metaClass;
        Map map3;
        Map map4;
        Set set2;
        Set set3;
        String string7;
        String string8;
        this.type = string8 = KubernetesCloudProvider.getID();
        this.cloudProvider = string7 = KubernetesCloudProvider.getID();
        int n2 = 0;
        this.replicas = n2;
        boolean bl = false;
        this.hostNetwork = bl;
        this.loadBalancers = set3 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.securityGroups = set2 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.labels = map4 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.annotations = map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        V1ObjectMeta v1ObjectMeta = statefulSet.getMetadata();
        this.name = string6 = v1ObjectMeta != null ? v1ObjectMeta.getName() : null;
        this.account = string5 = account;
        V1ObjectMeta v1ObjectMeta2 = statefulSet.getMetadata();
        this.region = string4 = v1ObjectMeta2 != null ? v1ObjectMeta2.getNamespace() : null;
        this.namespace = string3 = this.region;
        V1ObjectMeta v1ObjectMeta3 = statefulSet.getMetadata();
        DateTime dateTime = v1ObjectMeta3 != null ? v1ObjectMeta3.getCreationTimestamp() : null;
        this.createdTime = l = dateTime != null ? Long.valueOf(dateTime.getMillis()) : null;
        this.zones = set = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{this.region}), Set.class);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.securityGroups = (Set)ScriptBytecodeAdapter.castToType((Object)list, Set.class);
        V1beta1StatefulSetSpec v1beta1StatefulSetSpec = statefulSet.getSpec();
        Integer n3 = v1beta1StatefulSetSpec != null ? v1beta1StatefulSetSpec.getReplicas() : null;
        this.replicas = n = DefaultTypeTransformation.booleanUnbox((Object)n3) ? n3 : Integer.valueOf(0);
        this.launchConfig = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        V1beta1StatefulSetSpec v1beta1StatefulSetSpec2 = statefulSet.getSpec();
        V1PodTemplateSpec v1PodTemplateSpec = v1beta1StatefulSetSpec2 != null ? v1beta1StatefulSetSpec2.getTemplate() : null;
        V1ObjectMeta v1ObjectMeta4 = v1PodTemplateSpec != null ? v1PodTemplateSpec.getMetadata() : null;
        this.labels = map = v1ObjectMeta4 != null ? v1ObjectMeta4.getLabels() : null;
        this.deployDescription = deployKubernetesAtomicOperationDescription = KubernetesClientApiConverter.fromStatefulSet(statefulSet);
        this.yaml = string2 = KubernetesClientApiConverter.getYaml(statefulSet);
        this.kind = string = statefulSet.getKind();
        List<Event> list2 = events;
        List list3 = list2 != null ? DefaultGroovyMethods.collect(list2, (Closure)new _closure1(this, this)) : null;
        this.events = list3;
    }

    public KubernetesV1ServerGroup(V1beta1DaemonSet daemonSet, String account, List<Event> events) {
        String string;
        String string2;
        DeployKubernetesAtomicOperationDescription deployKubernetesAtomicOperationDescription;
        Map map;
        Map map2;
        Set set;
        Long l;
        String string3;
        String string4;
        String string5;
        String string6;
        MetaClass metaClass;
        Map map3;
        Map map4;
        Set set2;
        Set set3;
        String string7;
        String string8;
        this.type = string8 = KubernetesCloudProvider.getID();
        this.cloudProvider = string7 = KubernetesCloudProvider.getID();
        int n = 0;
        this.replicas = n;
        boolean bl = false;
        this.hostNetwork = bl;
        this.loadBalancers = set3 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.securityGroups = set2 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.labels = map4 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.annotations = map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        V1ObjectMeta v1ObjectMeta = daemonSet.getMetadata();
        this.name = string6 = v1ObjectMeta != null ? v1ObjectMeta.getName() : null;
        this.account = string5 = account;
        V1ObjectMeta v1ObjectMeta2 = daemonSet.getMetadata();
        this.region = string4 = v1ObjectMeta2 != null ? v1ObjectMeta2.getNamespace() : null;
        this.namespace = string3 = this.region;
        V1ObjectMeta v1ObjectMeta3 = daemonSet.getMetadata();
        DateTime dateTime = v1ObjectMeta3 != null ? v1ObjectMeta3.getCreationTimestamp() : null;
        this.createdTime = l = dateTime != null ? Long.valueOf(dateTime.getMillis()) : null;
        this.zones = set = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{this.region}), Set.class);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.securityGroups = (Set)ScriptBytecodeAdapter.castToType((Object)list, Set.class);
        this.launchConfig = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        V1beta1DaemonSetSpec v1beta1DaemonSetSpec = daemonSet.getSpec();
        V1PodTemplateSpec v1PodTemplateSpec = v1beta1DaemonSetSpec != null ? v1beta1DaemonSetSpec.getTemplate() : null;
        V1ObjectMeta v1ObjectMeta4 = v1PodTemplateSpec != null ? v1PodTemplateSpec.getMetadata() : null;
        this.labels = map = v1ObjectMeta4 != null ? v1ObjectMeta4.getLabels() : null;
        this.deployDescription = deployKubernetesAtomicOperationDescription = KubernetesClientApiConverter.fromDaemonSet(daemonSet);
        this.yaml = string2 = KubernetesClientApiConverter.getYaml(daemonSet);
        this.kind = string = daemonSet.getKind();
        List<Event> list2 = events;
        List list3 = list2 != null ? DefaultGroovyMethods.collect(list2, (Closure)new _closure2(this, this)) : null;
        this.events = list3;
    }

    public KubernetesV1ServerGroup(ReplicaSet replicaSet, String account, List<Event> events, HorizontalPodAutoscaler autoscaler) {
        String string;
        Map map;
        String string2;
        String string3;
        DeployKubernetesAtomicOperationDescription deployKubernetesAtomicOperationDescription;
        Map map2;
        Map map3;
        Set set;
        Integer n;
        Set set2;
        String string4;
        String string5;
        String string6;
        String string7;
        MetaClass metaClass;
        Map map4;
        Map map5;
        Set set3;
        Set set4;
        String string8;
        String string9;
        this.type = string9 = KubernetesCloudProvider.getID();
        this.cloudProvider = string8 = KubernetesCloudProvider.getID();
        int n2 = 0;
        this.replicas = n2;
        boolean bl = false;
        this.hostNetwork = bl;
        this.loadBalancers = set4 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.securityGroups = set3 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.labels = map5 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.annotations = map4 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        ObjectMeta objectMeta = replicaSet.getMetadata();
        this.name = string7 = objectMeta != null ? objectMeta.getName() : null;
        this.account = string6 = account;
        ObjectMeta objectMeta2 = replicaSet.getMetadata();
        this.region = string5 = objectMeta2 != null ? objectMeta2.getNamespace() : null;
        this.namespace = string4 = this.region;
        ObjectMeta objectMeta3 = replicaSet.getMetadata();
        long l = KubernetesModelUtil.translateTime(objectMeta3 != null ? objectMeta3.getCreationTimestamp() : null);
        this.createdTime = l;
        this.zones = set2 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{this.region}), Set.class);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.securityGroups = (Set)ScriptBytecodeAdapter.castToType((Object)list, Set.class);
        ReplicaSetSpec replicaSetSpec = replicaSet.getSpec();
        Integer n3 = replicaSetSpec != null ? replicaSetSpec.getReplicas() : null;
        this.replicas = n = DefaultTypeTransformation.booleanUnbox((Object)n3) ? n3 : Integer.valueOf(0);
        this.loadBalancers = set = (Set)ScriptBytecodeAdapter.asType(KubernetesUtil.getLoadBalancers(replicaSet), Set.class);
        this.launchConfig = map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ReplicaSetSpec replicaSetSpec2 = replicaSet.getSpec();
        PodTemplateSpec podTemplateSpec = replicaSetSpec2 != null ? replicaSetSpec2.getTemplate() : null;
        ObjectMeta objectMeta4 = podTemplateSpec != null ? podTemplateSpec.getMetadata() : null;
        this.labels = map2 = objectMeta4 != null ? objectMeta4.getLabels() : null;
        this.deployDescription = deployKubernetesAtomicOperationDescription = KubernetesApiConverter.fromReplicaSet(replicaSet);
        this.yaml = string3 = SerializationUtils.dumpWithoutRuntimeStateAsYaml((HasMetadata)replicaSet);
        this.kind = string2 = replicaSet.getKind();
        ObjectMeta objectMeta5 = replicaSet.getMetadata();
        this.annotations = map = objectMeta5 != null ? objectMeta5.getAnnotations() : null;
        List<Event> list2 = events;
        List list3 = list2 != null ? DefaultGroovyMethods.collect(list2, (Closure)new _closure3(this, this)) : null;
        this.events = list3;
        if (DefaultTypeTransformation.booleanUnbox((Object)autoscaler)) {
            KubernetesAutoscalerStatus kubernetesAutoscalerStatus;
            KubernetesApiConverter.attachAutoscaler(this.deployDescription, autoscaler);
            this.autoscalerStatus = kubernetesAutoscalerStatus = new KubernetesAutoscalerStatus(autoscaler);
        }
        this.revision = string = KubernetesApiAdaptor.getDeploymentRevision(replicaSet);
    }

    public KubernetesV1ServerGroup(ReplicationController replicationController, String account, List<Event> events, HorizontalPodAutoscaler autoscaler) {
        Map map;
        String string;
        String string2;
        DeployKubernetesAtomicOperationDescription deployKubernetesAtomicOperationDescription;
        Map map2;
        Map map3;
        Set set;
        Integer n;
        Set set2;
        String string3;
        String string4;
        String string5;
        String string6;
        MetaClass metaClass;
        Map map4;
        Map map5;
        Set set3;
        Set set4;
        String string7;
        String string8;
        this.type = string8 = KubernetesCloudProvider.getID();
        this.cloudProvider = string7 = KubernetesCloudProvider.getID();
        int n2 = 0;
        this.replicas = n2;
        boolean bl = false;
        this.hostNetwork = bl;
        this.loadBalancers = set4 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.securityGroups = set3 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.labels = map5 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.annotations = map4 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        ObjectMeta objectMeta = replicationController.getMetadata();
        this.name = string6 = objectMeta != null ? objectMeta.getName() : null;
        this.account = string5 = account;
        ObjectMeta objectMeta2 = replicationController.getMetadata();
        this.region = string4 = objectMeta2 != null ? objectMeta2.getNamespace() : null;
        this.namespace = string3 = this.region;
        ObjectMeta objectMeta3 = replicationController.getMetadata();
        long l = KubernetesModelUtil.translateTime(objectMeta3 != null ? objectMeta3.getCreationTimestamp() : null);
        this.createdTime = l;
        this.zones = set2 = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{this.region}), Set.class);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.securityGroups = (Set)ScriptBytecodeAdapter.castToType((Object)list, Set.class);
        ReplicationControllerSpec replicationControllerSpec = replicationController.getSpec();
        Integer n3 = replicationControllerSpec != null ? replicationControllerSpec.getReplicas() : null;
        this.replicas = n = DefaultTypeTransformation.booleanUnbox((Object)n3) ? n3 : Integer.valueOf(0);
        this.loadBalancers = set = (Set)ScriptBytecodeAdapter.asType(KubernetesUtil.getLoadBalancers(replicationController), Set.class);
        this.launchConfig = map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ReplicationControllerSpec replicationControllerSpec2 = replicationController.getSpec();
        PodTemplateSpec podTemplateSpec = replicationControllerSpec2 != null ? replicationControllerSpec2.getTemplate() : null;
        ObjectMeta objectMeta4 = podTemplateSpec != null ? podTemplateSpec.getMetadata() : null;
        this.labels = map2 = objectMeta4 != null ? objectMeta4.getLabels() : null;
        this.deployDescription = deployKubernetesAtomicOperationDescription = KubernetesApiConverter.fromReplicationController(replicationController);
        this.yaml = string2 = SerializationUtils.dumpWithoutRuntimeStateAsYaml((HasMetadata)replicationController);
        this.kind = string = replicationController.getKind();
        ObjectMeta objectMeta5 = replicationController.getMetadata();
        this.annotations = map = objectMeta5 != null ? objectMeta5.getAnnotations() : null;
        List<Event> list2 = events;
        List list3 = list2 != null ? DefaultGroovyMethods.collect(list2, (Closure)new _closure4(this, this)) : null;
        this.events = list3;
        if (DefaultTypeTransformation.booleanUnbox((Object)autoscaler)) {
            KubernetesAutoscalerStatus kubernetesAutoscalerStatus;
            KubernetesApiConverter.attachAutoscaler(this.deployDescription, autoscaler);
            this.autoscalerStatus = kubernetesAutoscalerStatus = new KubernetesAutoscalerStatus(autoscaler);
        }
    }

    public Map<String, Object> getBuildInfo() {
        List imageList = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        LinkedHashMap buildInfo = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        if (this.deployDescription != null) {
            KubernetesContainerDescription container = null;
            Iterator<KubernetesContainerDescription> iterator = this.deployDescription.getContainers().iterator();
            while (iterator.hasNext()) {
                container = (KubernetesContainerDescription)ScriptBytecodeAdapter.castToType((Object)iterator.next(), KubernetesContainerDescription.class);
                imageList.add(KubernetesUtil.getImageIdWithoutRegistry(container.getImageDescription()));
            }
            List list = imageList;
            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)buildInfo, (String)"images");
            Names parsedName = Names.parseName((String)this.name);
            DeployKubernetesAtomicOperationDescription deployKubernetesAtomicOperationDescription = this.deployDescription;
            KubernetesDeployment kubernetesDeployment = deployKubernetesAtomicOperationDescription != null ? deployKubernetesAtomicOperationDescription.getDeployment() : null;
            Boolean bl = kubernetesDeployment != null ? Boolean.valueOf(kubernetesDeployment.getEnabled()) : null;
            String string = (bl == null ? false : bl) ? parsedName.getCluster() : null;
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)buildInfo, (String)"createdBy");
        }
        return buildInfo;
    }

    public Boolean isDisabled() {
        if (ScriptBytecodeAdapter.compareEqual((Object)this.replicas, (Object)0)) {
            return true;
        }
        if (DefaultTypeTransformation.booleanUnbox(this.labels)) {
            public class _isDisabled_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _isDisabled_closure5(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object key, Object value) {
                    return KubernetesUtil.isLoadBalancerLabel(ShortTypeHandling.castToString((Object)key));
                }

                public Object call(Object key, Object value) {
                    return this.doCall(key, value);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _isDisabled_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Number lbCount = DefaultGroovyMethods.count(this.labels, (Closure)new _isDisabled_closure5(this, this));
            if (ScriptBytecodeAdapter.compareEqual((Object)lbCount, (Object)0)) {
                Map<String, String> map = this.annotations;
                return ScriptBytecodeAdapter.compareEqual((Object)(map != null ? map.get(KubernetesUtil.getENABLE_DISABLE_ANNOTATION()) : null), (Object)"false");
            }
            public class _isDisabled_closure6
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _isDisabled_closure6(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object key, Object value) {
                    return DefaultTypeTransformation.booleanUnbox((Object)KubernetesUtil.isLoadBalancerLabel(ShortTypeHandling.castToString((Object)key))) && ScriptBytecodeAdapter.compareEqual((Object)value, (Object)"true");
                }

                public Object call(Object key, Object value) {
                    return this.doCall(key, value);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _isDisabled_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Number enabledCount = DefaultGroovyMethods.count(this.labels, (Closure)new _isDisabled_closure6(this, this));
            return ScriptBytecodeAdapter.compareEqual((Object)enabledCount, (Object)0);
        }
        return false;
    }

    public ServerGroup.InstanceCounts getInstanceCounts() {
        ServerGroup.InstanceCounts instanceCounts = new ServerGroup.InstanceCounts();
        Set<KubernetesV1Instance> set = this.instances;
        public class _getInstanceCounts_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getInstanceCounts_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((KubernetesV1Instance)it).getHealthState(), (Object)HealthState.Down);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getInstanceCounts_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Integer n = (Integer)ScriptBytecodeAdapter.castToType(set != null ? (Number)DefaultGroovyMethods.count(set, (Closure)new _getInstanceCounts_closure7(this, this)) : (Number)null, Integer.class);
        Integer n2 = DefaultTypeTransformation.booleanUnbox((Object)n) ? n : Integer.valueOf(0);
        instanceCounts.setDown(n2);
        Set<KubernetesV1Instance> set2 = this.instances;
        public class _getInstanceCounts_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getInstanceCounts_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((KubernetesV1Instance)it).getHealthState(), (Object)HealthState.OutOfService);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getInstanceCounts_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Integer n3 = (Integer)ScriptBytecodeAdapter.castToType(set2 != null ? (Number)DefaultGroovyMethods.count(set2, (Closure)new _getInstanceCounts_closure8(this, this)) : (Number)null, Integer.class);
        Integer n4 = DefaultTypeTransformation.booleanUnbox((Object)n3) ? n3 : Integer.valueOf(0);
        instanceCounts.setOutOfService(n4);
        Set<KubernetesV1Instance> set3 = this.instances;
        public class _getInstanceCounts_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getInstanceCounts_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((KubernetesV1Instance)it).getHealthState(), (Object)HealthState.Up);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getInstanceCounts_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Integer n5 = (Integer)ScriptBytecodeAdapter.castToType(set3 != null ? (Number)DefaultGroovyMethods.count(set3, (Closure)new _getInstanceCounts_closure9(this, this)) : (Number)null, Integer.class);
        Integer n6 = DefaultTypeTransformation.booleanUnbox((Object)n5) ? n5 : Integer.valueOf(0);
        instanceCounts.setUp(n6);
        Set<KubernetesV1Instance> set4 = this.instances;
        public class _getInstanceCounts_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getInstanceCounts_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((KubernetesV1Instance)it).getHealthState(), (Object)HealthState.Starting);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getInstanceCounts_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Integer n7 = (Integer)ScriptBytecodeAdapter.castToType(set4 != null ? (Number)DefaultGroovyMethods.count(set4, (Closure)new _getInstanceCounts_closure10(this, this)) : (Number)null, Integer.class);
        Integer n8 = DefaultTypeTransformation.booleanUnbox((Object)n7) ? n7 : Integer.valueOf(0);
        instanceCounts.setStarting(n8);
        Set<KubernetesV1Instance> set5 = this.instances;
        public class _getInstanceCounts_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getInstanceCounts_closure11(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((KubernetesV1Instance)it).getHealthState(), (Object)HealthState.Unknown);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getInstanceCounts_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Integer n9 = (Integer)ScriptBytecodeAdapter.castToType(set5 != null ? (Number)DefaultGroovyMethods.count(set5, (Closure)new _getInstanceCounts_closure11(this, this)) : (Number)null, Integer.class);
        Integer n10 = DefaultTypeTransformation.booleanUnbox((Object)n9) ? n9 : Integer.valueOf(0);
        instanceCounts.setUnknown(n10);
        Set<KubernetesV1Instance> set6 = this.instances;
        Integer n11 = set6 != null ? Integer.valueOf(set6.size()) : null;
        instanceCounts.setTotal(n11);
        return instanceCounts;
    }

    public ServerGroup.Capacity getCapacity() {
        ServerGroup.Capacity capacity = new ServerGroup.Capacity();
        Integer n = this.replicas;
        capacity.setMin(n);
        Integer n2 = this.replicas;
        capacity.setMax(n2);
        Integer n3 = this.replicas;
        capacity.setDesired(n3);
        return capacity;
    }

    public ServerGroup.ImagesSummary getImagesSummary() {
        Reference bi = new Reference((Object)this.buildInfo);
        return new ServerGroup.ImagesSummary(this, bi){
            public /* synthetic */ Reference bi;
            public /* synthetic */ KubernetesV1ServerGroup this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                KubernetesV1ServerGroup kubernetesV1ServerGroup;
                this.this$0 = kubernetesV1ServerGroup = p0;
                this.bi = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public List<? extends ServerGroup.ImageSummary> getSummaries() {
                public class _getSummaries_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference bi;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _getSummaries_closure1(Object _outerInstance, Object _thisObject, Reference bi) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.bi = reference = bi;
                    }

                    public Object doCall(KubernetesContainerDescription it) {
                        Reference it2 = new Reference((Object)it);
                        return new ServerGroup.ImageSummary(this, this.bi, it2){
                            public /* synthetic */ Reference it;
                            public /* synthetic */ Reference bi;
                            private String serverGroupName;
                            private String imageName;
                            private String imageId;
                            public /* synthetic */ Closure this$0;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private transient /* synthetic */ MetaClass metaClass;
                            {
                                MetaClass metaClass;
                                String string;
                                String string2;
                                String string3;
                                Reference reference;
                                Reference reference2;
                                Closure closure;
                                this.this$0 = closure = p0;
                                this.it = reference2 = p2;
                                this.bi = reference = p1;
                                this.serverGroupName = string3 = (this.this$0.getThisObject()).this$0.getName();
                                this.imageName = string2 = ((KubernetesContainerDescription)this.it.get()).getName();
                                this.imageId = string = KubernetesUtil.getImageId(((KubernetesContainerDescription)this.it.get()).getImageDescription());
                                this.metaClass = metaClass = this.$getStaticMetaClass();
                            }

                            public Map<String, Object> getBuildInfo() {
                                return (Map)ScriptBytecodeAdapter.castToType((Object)this.bi.get(), Map.class);
                            }

                            public Map<String, Object> getImage() {
                                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"container", ((KubernetesContainerDescription)this.it.get()).getName(), "registry", ((KubernetesContainerDescription)this.it.get()).getImageDescription().getRegistry(), "tag", ((KubernetesContainerDescription)this.it.get()).getImageDescription().getTag(), "repository", ((KubernetesContainerDescription)this.it.get()).getImageDescription().getRepository(), "imageId", this.imageId});
                            }

                            public /* synthetic */ Object methodMissing(String name, Object args) {
                                return (this.this$0.getThisObject()).this$dist$invoke$1(name, args);
                            }

                            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                                return ScriptBytecodeAdapter.invokeMethodN(2.class, 1.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                            }

                            public /* synthetic */ void propertyMissing(String name, Object val) {
                                (this.this$0.getThisObject()).this$dist$set$1(name, val);
                            }

                            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                                Object object = val;
                                ScriptBytecodeAdapter.setProperty((Object)object, null, 1.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                            }

                            public /* synthetic */ Object propertyMissing(String name) {
                                return (this.this$0.getThisObject()).this$dist$get$1(name);
                            }

                            public static /* synthetic */ Object $static_propertyMissing(String name) {
                                return ScriptBytecodeAdapter.getProperty(2.class, 1.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != 2.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MetaClass getMetaClass() {
                                MetaClass metaClass = this.metaClass;
                                if (metaClass != null) {
                                    return metaClass;
                                }
                                this.metaClass = this.$getStaticMetaClass();
                                return this.metaClass;
                            }

                            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                                this.metaClass = metaClass;
                            }

                            public /* synthetic */ Object invokeMethod(String string, Object object) {
                                return this.getMetaClass().invokeMethod((Object)this, string, object);
                            }

                            public /* synthetic */ Object getProperty(String string) {
                                return this.getMetaClass().getProperty((Object)this, string);
                            }

                            public /* synthetic */ void setProperty(String string, Object object) {
                                this.getMetaClass().setProperty((Object)this, string, object);
                            }

                            public String getServerGroupName() {
                                return this.serverGroupName;
                            }

                            public void setServerGroupName(String string) {
                                this.serverGroupName = string;
                            }

                            public String getImageName() {
                                return this.imageName;
                            }

                            public void setImageName(String string) {
                                this.imageName = string;
                            }

                            public String getImageId() {
                                return this.imageId;
                            }

                            public void setImageId(String string) {
                                this.imageId = string;
                            }
                        };
                    }

                    public Object call(KubernetesContainerDescription it) {
                        Reference it2 = new Reference((Object)it);
                        return this.doCall((KubernetesContainerDescription)it2.get());
                    }

                    public Object getBi() {
                        return this.bi.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getSummaries_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.collect(this.this$0.getDeployDescription().getContainers(), (Closure)new _getSummaries_closure1(this, this, this.bi));
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, 1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                return ScriptBytecodeAdapter.getGroovyObjectProperty(1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, KubernetesV1ServerGroup.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$1(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, KubernetesV1ServerGroup.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, KubernetesV1ServerGroup.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        };
    }

    public ServerGroup.ImageSummary getImageSummary() {
        ServerGroup.ImagesSummary imagesSummary = this.getImagesSummary();
        List list = imagesSummary != null ? imagesSummary.getSummaries() : null;
        return (ServerGroup.ImageSummary)ScriptBytecodeAdapter.castToType(list != null ? list.get(0) : null, ServerGroup.ImageSummary.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != KubernetesV1ServerGroup.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        if (!(this.getName() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getName());
        }
        if (!(this.getNamespace() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getNamespace());
        }
        if (!(this.getAccount() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getAccount());
        }
        return _result;
    }

    public boolean canEqual(Object other) {
        return other instanceof KubernetesV1ServerGroup;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof KubernetesV1ServerGroup)) {
            return false;
        }
        KubernetesV1ServerGroup otherTyped = (KubernetesV1ServerGroup)other;
        if (!otherTyped.canEqual(this)) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)this.getName(), (Object)otherTyped.getName())) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)this.getNamespace(), (Object)otherTyped.getNamespace())) {
            return false;
        }
        return !(!ScriptBytecodeAdapter.compareEqual((Object)this.getAccount(), (Object)otherTyped.getAccount()));
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(KubernetesV1ServerGroup.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, KubernetesV1ServerGroup.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(KubernetesV1ServerGroup.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ String pfaccess$0(KubernetesV1ServerGroup $that) {
        return $that.getName();
    }

    public static /* synthetic */ DeployKubernetesAtomicOperationDescription pfaccess$1(KubernetesV1ServerGroup $that) {
        return $that.getDeployDescription();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public final String getType() {
        return this.type;
    }

    public final String getCloudProvider() {
        return this.cloudProvider;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String string) {
        this.region = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String string) {
        this.account = string;
    }

    public Long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Long l) {
        this.createdTime = l;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer n) {
        this.replicas = n;
    }

    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    public void setHostNetwork(Boolean bl) {
        this.hostNetwork = bl;
    }

    public Set<String> getZones() {
        return this.zones;
    }

    public void setZones(Set<String> set) {
        this.zones = set;
    }

    public Set<KubernetesV1Instance> getInstances() {
        return this.instances;
    }

    public void setInstances(Set<KubernetesV1Instance> set) {
        this.instances = set;
    }

    public Set<String> getLoadBalancers() {
        return this.loadBalancers;
    }

    public void setLoadBalancers(Set<String> set) {
        this.loadBalancers = set;
    }

    public Set<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Set<String> set) {
        this.securityGroups = set;
    }

    public Map<String, Object> getLaunchConfig() {
        return this.launchConfig;
    }

    public void setLaunchConfig(Map<String, Object> map) {
        this.launchConfig = map;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> map) {
        this.labels = map;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> map) {
        this.annotations = map;
    }

    public DeployKubernetesAtomicOperationDescription getDeployDescription() {
        return this.deployDescription;
    }

    public void setDeployDescription(DeployKubernetesAtomicOperationDescription deployKubernetesAtomicOperationDescription) {
        this.deployDescription = deployKubernetesAtomicOperationDescription;
    }

    public KubernetesAutoscalerStatus getAutoscalerStatus() {
        return this.autoscalerStatus;
    }

    public void setAutoscalerStatus(KubernetesAutoscalerStatus kubernetesAutoscalerStatus) {
        this.autoscalerStatus = kubernetesAutoscalerStatus;
    }

    public KubernetesDeploymentStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public void setDeploymentStatus(KubernetesDeploymentStatus kubernetesDeploymentStatus) {
        this.deploymentStatus = kubernetesDeploymentStatus;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String string) {
        this.kind = string;
    }

    public String getYaml() {
        return this.yaml;
    }

    public void setYaml(String string) {
        this.yaml = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public void setBuildInfo(Map map) {
        this.buildInfo = map;
    }

    public List<KubernetesEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<KubernetesEvent> list) {
        this.events = list;
    }

    public class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return new KubernetesEvent((Event)ScriptBytecodeAdapter.castToType((Object)it, Event.class));
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public class _closure2
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure2(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return new KubernetesEvent((Event)ScriptBytecodeAdapter.castToType((Object)it, Event.class));
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public class _closure3
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure3(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return new KubernetesEvent((Event)ScriptBytecodeAdapter.castToType((Object)it, Event.class));
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure3.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public class _closure4
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure4(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return new KubernetesEvent((Event)ScriptBytecodeAdapter.castToType((Object)it, Event.class));
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure4.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

