/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact;

import com.netflix.spinnaker.clouddriver.artifacts.kubernetes.KubernetesArtifactType;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacer;
import java.util.regex.Pattern;

public class ArtifactReplacerFactory {
    private static final String DOCKER_NAME_COMPONENT = "[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?";
    private static final String DOCKER_OPTIONAL_TAG = "(?::[\\w][\\w.-]{0,127})?";
    private static final String DOCKER_OPTIONAL_DIGEST = "(?:@[A-Za-z][A-Za-z0-9]*(?:[-_+.][A-Za-z][A-Za-z0-9]*)*[:][0-9A-Fa-f]{32,})?";
    private static final String DOCKER_DOMAIN = "(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))+)?";
    private static final String DOCKER_OPTIONAL_PORT = "(?::[0-9]+)?";
    private static final String DOCKER_OPTIONAL_DOMAIN_AND_PORT = "(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))+)?(?::[0-9]+)?/)?";
    private static final String DOCKER_IMAGE_NAME = "((?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))+)?(?::[0-9]+)?/)?[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?(?:/[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?)*)";
    private static final String DOCKER_IMAGE_REFERENCE = "((?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))+)?(?::[0-9]+)?/)?[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?(?:/[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?)*)((?::[\\w][\\w.-]{0,127})?|(?:@[A-Za-z][A-Za-z0-9]*(?:[-_+.][A-Za-z][A-Za-z0-9]*)*[:][0-9A-Fa-f]{32,})?)";
    public static final Pattern DOCKER_IMAGE_REFERENCE_PATTERN = Pattern.compile("^((?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))+)?(?::[0-9]+)?/)?[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?(?:/[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?)*)((?::[\\w][\\w.-]{0,127})?|(?:@[A-Za-z][A-Za-z0-9]*(?:[-_+.][A-Za-z][A-Za-z0-9]*)*[:][0-9A-Fa-f]{32,})?)$");

    public static ArtifactReplacer.Replacer dockerImageReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec['containers', 'initContainers'].[?( @.image == \"{%name%}\" )].image").findPath("$..spec.template.spec['containers', 'initContainers'].*.image").nameFromReference(ref -> {
            int atIndex = ref.indexOf(64);
            if (atIndex >= 0) {
                return ref.substring(0, atIndex);
            }
            int lastColonIndex = ref.lastIndexOf(58);
            if (lastColonIndex < 0) {
                return ref;
            }
            return ref.substring(0, lastColonIndex);
        }).type(KubernetesArtifactType.DockerImage).build();
    }

    public static ArtifactReplacer.Replacer configMapVolumeReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec.volumes.[?( @.configMap.name == \"{%name%}\" )].configMap.name").findPath("$..spec.template.spec.volumes.*.configMap.name").type(KubernetesArtifactType.ConfigMap).build();
    }

    public static ArtifactReplacer.Replacer secretVolumeReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec.volumes.[?( @.secret.secretName == \"{%name%}\" )].secret.secretName").findPath("$..spec.template.spec.volumes.*.secret.secretName").type(KubernetesArtifactType.Secret).build();
    }

    public static ArtifactReplacer.Replacer configMapKeyValueFromReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec['containers', 'initContainers'].*.env.[?( @.valueFrom.configMapKeyRef.name == \"{%name%}\" )].valueFrom.configMapKeyRef.name").findPath("$..spec.template.spec['containers', 'initContainers'].*.env.*.valueFrom.configMapKeyRef.name").type(KubernetesArtifactType.ConfigMap).build();
    }

    public static ArtifactReplacer.Replacer secretKeyValueFromReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec['containers', 'initContainers'].*.env.[?( @.valueFrom.secretKeyRef.name == \"{%name%}\" )].valueFrom.secretKeyRef.name").findPath("$..spec.template.spec['containers', 'initContainers'].*.env.*.valueFrom.secretKeyRef.name").type(KubernetesArtifactType.Secret).build();
    }

    public static ArtifactReplacer.Replacer configMapEnvFromReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec['containers', 'initContainers'].*.envFrom.[?( @.configMapRef.name == \"{%name%}\" )].configMapRef.name").findPath("$..spec.template.spec['containers', 'initContainers'].*.envFrom.*.configMapRef.name").type(KubernetesArtifactType.ConfigMap).build();
    }

    public static ArtifactReplacer.Replacer secretEnvFromReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec['containers', 'initContainers'].*.envFrom.[?( @.secretRef.name == \"{%name%}\" )].secretRef.name").findPath("$..spec.template.spec['containers', 'initContainers'].*.envFrom.*.secretRef.name").type(KubernetesArtifactType.Secret).build();
    }

    public static ArtifactReplacer.Replacer hpaDeploymentReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$[?( (@.spec.scaleTargetRef.kind == \"Deployment\" || @.spec.scaleTargetRef.kind == \"deployment\") && @.spec.scaleTargetRef.name == \"{%name%}\" )].spec.scaleTargetRef.name").findPath("$[?( @.spec.scaleTargetRef.kind == \"Deployment\" || @.spec.scaleTargetRef.kind == \"deployment\" )].spec.scaleTargetRef.name").type(KubernetesArtifactType.Deployment).build();
    }

    public static ArtifactReplacer.Replacer hpaReplicaSetReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$[?( (@.spec.scaleTargetRef.kind == \"ReplicaSet\" || @.spec.scaleTargetRef.kind == \"replicaSet\") && @.spec.scaleTargetRef.name == \"{%name%}\" )].spec.scaleTargetRef.name").findPath("$[?( @.spec.scaleTargetRef.kind == \"ReplicaSet\" || @.spec.scaleTargetRef.kind == \"replicaSet\" )].spec.scaleTargetRef.name").type(KubernetesArtifactType.ReplicaSet).build();
    }
}

