/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching;

import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.provider.Provider;
import com.netflix.spinnaker.cats.provider.ProviderSynchronizerTypeWrapper;
import com.netflix.spinnaker.cats.thread.NamedThreadFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.KubernetesV2Provider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgentDispatcher;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import com.netflix.spinnaker.clouddriver.security.ProviderUtils;
import com.netflix.spinnaker.clouddriver.security.ProviderVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Scope;

@Configuration
class KubernetesV2ProviderConfig {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2ProviderConfig.class);
    private KubernetesV2Provider kubernetesV2Provider;
    private AccountCredentialsRepository accountCredentialsRepository;
    private KubernetesV2CachingAgentDispatcher kubernetesV2CachingAgentDispatcher;
    private KubernetesResourcePropertyRegistry kubernetesResourcePropertyRegistry;

    KubernetesV2ProviderConfig() {
    }

    @Bean
    @DependsOn(value={"kubernetesNamedAccountCredentials"})
    KubernetesV2Provider kubernetesV2Provider(KubernetesCloudProvider kubernetesCloudProvider, AccountCredentialsRepository accountCredentialsRepository, KubernetesV2CachingAgentDispatcher kubernetesV2CachingAgentDispatcher, KubernetesResourcePropertyRegistry kubernetesResourcePropertyRegistry) {
        this.kubernetesV2Provider = new KubernetesV2Provider();
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.kubernetesV2CachingAgentDispatcher = kubernetesV2CachingAgentDispatcher;
        this.kubernetesResourcePropertyRegistry = kubernetesResourcePropertyRegistry;
        ScheduledExecutorService poller = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(KubernetesV2ProviderConfig.class.getSimpleName()));
        this.synchronizeKubernetesV2Provider(this.kubernetesV2Provider, accountCredentialsRepository);
        return this.kubernetesV2Provider;
    }

    @Bean
    KubernetesV2ProviderSynchronizerTypeWrapper kubernetesV2ProviderSynchronizerTypeWrapper() {
        return new KubernetesV2ProviderSynchronizerTypeWrapper();
    }

    @Scope(value="prototype")
    @Bean
    KubernetesV2ProviderSynchronizer synchronizeKubernetesV2Provider(KubernetesV2Provider kubernetesV2Provider, AccountCredentialsRepository accountCredentialsRepository) {
        Set allAccounts = ProviderUtils.buildThreadSafeSetOfAccounts((AccountCredentialsRepository)accountCredentialsRepository, KubernetesNamedAccountCredentials.class, (ProviderVersion)ProviderVersion.v2);
        try {
            for (KubernetesNamedAccountCredentials credentials : allAccounts) {
                KubernetesV2Credentials v2Credentials = (KubernetesV2Credentials)credentials.getCredentials();
                v2Credentials.getCustomResources().forEach(cr -> {
                    try {
                        KubernetesResourceProperties properties = KubernetesResourceProperties.fromCustomResource(cr);
                        this.kubernetesResourcePropertyRegistry.registerAccountProperty(credentials.getName(), properties);
                    }
                    catch (Exception e) {
                        log.warn("Error encountered registering {}: ", cr, (Object)e);
                    }
                });
                v2Credentials.initialize();
                List<Agent> newlyAddedAgents = this.kubernetesV2CachingAgentDispatcher.buildAllCachingAgents(credentials).stream().map(c -> c).collect(Collectors.toList());
                log.info("Adding {} agents for account {}", (Object)newlyAddedAgents.size(), (Object)credentials.getName());
                kubernetesV2Provider.addAllAgents(newlyAddedAgents);
            }
        }
        catch (Exception e) {
            log.warn("Error encountered scheduling new agents -- using old agent set instead", (Throwable)e);
            kubernetesV2Provider.clearNewAgentSet();
            return new KubernetesV2ProviderSynchronizer();
        }
        if (kubernetesV2Provider.getAgentScheduler() != null) {
            ProviderUtils.rescheduleAgents((Provider)kubernetesV2Provider, new ArrayList<Agent>(kubernetesV2Provider.getNextAgentSet()));
        }
        kubernetesV2Provider.switchToNewAgents();
        return new KubernetesV2ProviderSynchronizer();
    }

    class KubernetesV2ProviderSynchronizer {
        KubernetesV2ProviderSynchronizer() {
        }
    }

    class KubernetesV2ProviderSynchronizerTypeWrapper
    implements ProviderSynchronizerTypeWrapper {
        KubernetesV2ProviderSynchronizerTypeWrapper() {
        }

        public Class getSynchronizerType() {
            return KubernetesV2ProviderSynchronizer.class;
        }
    }
}

