/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.converter.job;

import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.converters.KubernetesAtomicOperationConverterHelper;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesV2ArtifactProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.job.KubernetesRunJobOperationDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.job.KubernetesRunJobOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AbstractAtomicOperationsCredentialsSupport;
import com.netflix.spinnaker.clouddriver.security.ProviderVersion;
import java.util.Map;
import org.springframework.stereotype.Component;

@KubernetesOperation(value="runJob")
@Component
public class KubernetesRunJobOperationConverter
extends AbstractAtomicOperationsCredentialsSupport {
    private KubernetesResourcePropertyRegistry registry;
    private KubernetesV2ArtifactProvider artifactProvider;

    public KubernetesRunJobOperationConverter(KubernetesResourcePropertyRegistry registry, KubernetesV2ArtifactProvider artifactProvider) {
        this.registry = registry;
        this.artifactProvider = artifactProvider;
    }

    public AtomicOperation convertOperation(Map input) {
        return new KubernetesRunJobOperation(this.convertDescription(input), this.registry, this.artifactProvider);
    }

    public KubernetesRunJobOperationDescription convertDescription(Map input) {
        return (KubernetesRunJobOperationDescription)KubernetesAtomicOperationConverterHelper.convertDescription(input, this, KubernetesRunJobOperationDescription.class);
    }

    public boolean acceptsVersion(ProviderVersion version) {
        return version == ProviderVersion.v2;
    }
}

