/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesApiGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class KubernetesApiVersion {
    public static KubernetesApiVersion V1 = new KubernetesApiVersion("v1");
    public static KubernetesApiVersion EXTENSIONS_V1BETA1 = new KubernetesApiVersion("extensions/v1beta1");
    public static KubernetesApiVersion NETWORKING_K8S_IO_V1 = new KubernetesApiVersion("network.k8s.io/v1");
    public static KubernetesApiVersion APPS_V1BETA1 = new KubernetesApiVersion("apps/v1beta1");
    public static KubernetesApiVersion APPS_V1BETA2 = new KubernetesApiVersion("apps/v1beta2");
    public static KubernetesApiVersion BATCH_V1 = new KubernetesApiVersion("batch/v1");
    private final String name;
    private static List<KubernetesApiVersion> values;

    protected KubernetesApiVersion(String name) {
        if (values == null) {
            values = Collections.synchronizedList(new ArrayList());
        }
        this.name = name;
        values.add(this);
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public KubernetesApiGroup getApiGroup() {
        String[] split = this.name.split("/");
        if (split.length > 1) {
            return KubernetesApiGroup.fromString(split[0]);
        }
        return KubernetesApiGroup.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static KubernetesApiVersion fromString(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        List<KubernetesApiVersion> list = values;
        synchronized (list) {
            Optional<KubernetesApiVersion> versionOptional = values.stream().filter(v -> v.name.equalsIgnoreCase(name)).findAny();
            return versionOptional.orElseGet(() -> new KubernetesApiVersion(name));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesApiVersion)) {
            return false;
        }
        KubernetesApiVersion other = (KubernetesApiVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesApiVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

