/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.kubernetes.provider.KubernetesModelUtil;
import com.netflix.spinnaker.clouddriver.model.JobState;
import com.netflix.spinnaker.clouddriver.model.JobStatus;
import io.kubernetes.client.models.V1Job;
import io.kubernetes.client.models.V1JobCondition;
import io.kubernetes.client.models.V1JobSpec;
import io.kubernetes.client.models.V1JobStatus;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class KubernetesV2JobStatus
implements JobStatus,
Serializable {
    String name;
    String cluster;
    String account;
    String id;
    String location;
    String provider = "kubernetes";
    Long createdTime;
    Long completedTime;
    String message;
    String reason;
    Integer exitCode;
    Integer signal;
    String logs;
    @JsonIgnore
    V1Job job;

    public KubernetesV2JobStatus(V1Job job, String account) {
        this.job = job;
        this.account = account;
        this.name = job.getMetadata().getName();
        this.location = job.getMetadata().getNamespace();
        this.createdTime = KubernetesModelUtil.translateTime(job.getMetadata().getCreationTimestamp().toString(), "yyyy-MM-dd'T'HH:mm:ss");
    }

    public Map<String, String> getCompletionDetails() {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("exitCode", this.exitCode != null ? this.exitCode.toString() : "");
        details.put("signal", this.signal != null ? this.signal.toString() : "");
        details.put("message", this.message != null ? this.message : "");
        details.put("reason", this.reason != null ? this.reason : "");
        return details;
    }

    public JobState getJobState() {
        V1JobStatus status = this.job.getStatus();
        if (status == null) {
            return JobState.Running;
        }
        int completions = Optional.of(this.job.getSpec()).map(V1JobSpec::getCompletions).orElse(1);
        int succeeded = Optional.of(status).map(V1JobStatus::getSucceeded).orElse(0);
        if (succeeded < completions) {
            List conditions = status.getConditions();
            conditions = conditions != null ? conditions : Collections.emptyList();
            Optional<V1JobCondition> condition = conditions.stream().filter(this::jobFailed).findFirst();
            return condition.isPresent() ? JobState.Failed : JobState.Running;
        }
        return JobState.Succeeded;
    }

    private boolean jobFailed(V1JobCondition condition) {
        return "Failed".equalsIgnoreCase(condition.getType()) && "True".equalsIgnoreCase(condition.getStatus());
    }

    public String getName() {
        return this.name;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getAccount() {
        return this.account;
    }

    public String getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProvider() {
        return this.provider;
    }

    public Long getCreatedTime() {
        return this.createdTime;
    }

    public Long getCompletedTime() {
        return this.completedTime;
    }

    public String getMessage() {
        return this.message;
    }

    public String getReason() {
        return this.reason;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public Integer getSignal() {
        return this.signal;
    }

    public String getLogs() {
        return this.logs;
    }

    public V1Job getJob() {
        return this.job;
    }

    public KubernetesV2JobStatus setName(String name) {
        this.name = name;
        return this;
    }

    public KubernetesV2JobStatus setCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public KubernetesV2JobStatus setAccount(String account) {
        this.account = account;
        return this;
    }

    public KubernetesV2JobStatus setId(String id) {
        this.id = id;
        return this;
    }

    public KubernetesV2JobStatus setLocation(String location) {
        this.location = location;
        return this;
    }

    public KubernetesV2JobStatus setProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public KubernetesV2JobStatus setCreatedTime(Long createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public KubernetesV2JobStatus setCompletedTime(Long completedTime) {
        this.completedTime = completedTime;
        return this;
    }

    public KubernetesV2JobStatus setMessage(String message) {
        this.message = message;
        return this;
    }

    public KubernetesV2JobStatus setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public KubernetesV2JobStatus setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    public KubernetesV2JobStatus setSignal(Integer signal) {
        this.signal = signal;
        return this;
    }

    public KubernetesV2JobStatus setLogs(String logs) {
        this.logs = logs;
        return this;
    }

    public KubernetesV2JobStatus setJob(V1Job job) {
        this.job = job;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesV2JobStatus)) {
            return false;
        }
        KubernetesV2JobStatus other = (KubernetesV2JobStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$cluster = this.getCluster();
        String other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        Long this$createdTime = this.getCreatedTime();
        Long other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Long this$completedTime = this.getCompletedTime();
        Long other$completedTime = other.getCompletedTime();
        if (this$completedTime == null ? other$completedTime != null : !((Object)this$completedTime).equals(other$completedTime)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        Integer this$exitCode = this.getExitCode();
        Integer other$exitCode = other.getExitCode();
        if (this$exitCode == null ? other$exitCode != null : !((Object)this$exitCode).equals(other$exitCode)) {
            return false;
        }
        Integer this$signal = this.getSignal();
        Integer other$signal = other.getSignal();
        if (this$signal == null ? other$signal != null : !((Object)this$signal).equals(other$signal)) {
            return false;
        }
        String this$logs = this.getLogs();
        String other$logs = other.getLogs();
        if (this$logs == null ? other$logs != null : !this$logs.equals(other$logs)) {
            return false;
        }
        V1Job this$job = this.getJob();
        V1Job other$job = other.getJob();
        return !(this$job == null ? other$job != null : !this$job.equals(other$job));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesV2JobStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        Long $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Long $completedTime = this.getCompletedTime();
        result = result * 59 + ($completedTime == null ? 43 : ((Object)$completedTime).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        Integer $exitCode = this.getExitCode();
        result = result * 59 + ($exitCode == null ? 43 : ((Object)$exitCode).hashCode());
        Integer $signal = this.getSignal();
        result = result * 59 + ($signal == null ? 43 : ((Object)$signal).hashCode());
        String $logs = this.getLogs();
        result = result * 59 + ($logs == null ? 43 : $logs.hashCode());
        V1Job $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        return result;
    }

    public String toString() {
        return "KubernetesV2JobStatus(name=" + this.getName() + ", cluster=" + this.getCluster() + ", account=" + this.getAccount() + ", id=" + this.getId() + ", location=" + this.getLocation() + ", provider=" + this.getProvider() + ", createdTime=" + this.getCreatedTime() + ", completedTime=" + this.getCompletedTime() + ", message=" + this.getMessage() + ", reason=" + this.getReason() + ", exitCode=" + this.getExitCode() + ", signal=" + this.getSignal() + ", logs=" + this.getLogs() + ", job=" + this.getJob() + ")";
    }
}

