/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.JsonPatch;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesPatchOptions;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import java.util.HashMap;
import java.util.List;

public interface CanPatch {
    public KubernetesKind kind();

    default public OperationResult patchWithManifest(KubernetesV2Credentials credentials, String namespace, String name, KubernetesPatchOptions options, KubernetesManifest manifest) {
        credentials.patch(this.kind(), namespace, name, options, manifest);
        return this.patch(namespace, name);
    }

    default public OperationResult patchWithJson(KubernetesV2Credentials credentials, String namespace, String name, KubernetesPatchOptions options, List<JsonPatch> patches) {
        credentials.patch(this.kind(), namespace, name, options, patches);
        return this.patch(namespace, name);
    }

    default public OperationResult patch(String namespace, String name) {
        KubernetesManifest patchedManifest = new KubernetesManifest();
        patchedManifest.putIfAbsent("metadata", new HashMap());
        patchedManifest.setNamespace(namespace);
        patchedManifest.setName(name);
        patchedManifest.setKind(this.kind());
        return new OperationResult().addManifest(patchedManifest);
    }
}

