/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.UnsupportedVersionException;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import io.kubernetes.client.models.V1beta1HTTPIngressPath;
import io.kubernetes.client.models.V1beta1HTTPIngressRuleValue;
import io.kubernetes.client.models.V1beta1Ingress;
import io.kubernetes.client.models.V1beta1IngressBackend;
import io.kubernetes.client.models.V1beta1IngressRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KubernetesIngressHandler
extends KubernetesHandler {
    private static final Logger log = LoggerFactory.getLogger(KubernetesIngressHandler.class);

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.NETWORK_RESOURCE_PRIORITY.getValue();
    }

    @Override
    public KubernetesKind kind() {
        return KubernetesKind.INGRESS;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    public KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind() {
        return KubernetesSpinnakerKindMap.SpinnakerKind.LOAD_BALANCERS;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        return new Manifest.Status();
    }

    @Override
    public Class<? extends KubernetesV2CachingAgent> cachingAgentClass() {
        return KubernetesCoreCachingAgent.class;
    }

    @Override
    public void addRelationships(Map<KubernetesKind, List<KubernetesManifest>> allResources, Map<KubernetesManifest, List<KubernetesManifest>> relationshipMap) {
        BiFunction<String, String, String> manifestName = (namespace, name) -> namespace + ":" + name;
        Map<String, KubernetesManifest> services = ((List)allResources.getOrDefault(KubernetesKind.SERVICE, new ArrayList())).stream().collect(Collectors.toMap(m -> (String)manifestName.apply(m.getNamespace(), m.getName()), m -> m));
        for (KubernetesManifest ingress : (List)allResources.getOrDefault(KubernetesKind.INGRESS, new ArrayList())) {
            List<Object> attachedServices = new ArrayList();
            try {
                attachedServices = KubernetesIngressHandler.attachedServices(ingress).stream().map(s -> (KubernetesManifest)services.get(manifestName.apply(ingress.getNamespace(), (String)s))).filter(Objects::nonNull).collect(Collectors.toList());
            }
            catch (Exception e) {
                log.warn("Failure getting services attached to {}", (Object)ingress.getName(), (Object)e);
            }
            relationshipMap.put(ingress, attachedServices);
        }
    }

    public static List<String> attachedServices(KubernetesManifest manifest) {
        if (manifest.getApiVersion().equals(KubernetesApiVersion.EXTENSIONS_V1BETA1)) {
            V1beta1Ingress v1beta1Ingress = KubernetesCacheDataConverter.getResource(manifest, V1beta1Ingress.class);
            return KubernetesIngressHandler.attachedServices(v1beta1Ingress);
        }
        throw new UnsupportedVersionException(manifest);
    }

    private static List<String> attachedServices(V1beta1Ingress ingress) {
        List rules;
        HashSet<String> result = new HashSet<String>();
        V1beta1IngressBackend backend = ingress.getSpec().getBackend();
        if (backend != null) {
            result.add(backend.getServiceName());
        }
        rules = (rules = ingress.getSpec().getRules()) == null ? new ArrayList() : rules;
        for (V1beta1IngressRule rule : rules) {
            V1beta1HTTPIngressRuleValue http = rule.getHttp();
            if (http == null) continue;
            for (V1beta1HTTPIngressPath path : http.getPaths()) {
                backend = path.getBackend();
                if (backend == null) continue;
                result.add(backend.getServiceName());
            }
        }
        return new ArrayList<String>(result);
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key, KubernetesCacheUtils cacheUtils) {
        Map<String, Object> result = super.hydrateSearchResult(key, cacheUtils);
        result.put("loadBalancer", result.get("name"));
        return result;
    }
}

