/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.JsonPatch;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanLoadBalance;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesReplicaSetHandler;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import io.kubernetes.client.models.V1Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class KubernetesServiceHandler
extends KubernetesHandler
implements CanLoadBalance {
    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.NETWORK_RESOURCE_PRIORITY.getValue();
    }

    @Override
    public KubernetesKind kind() {
        return KubernetesKind.SERVICE;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    public KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind() {
        return KubernetesSpinnakerKindMap.SpinnakerKind.LOAD_BALANCERS;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        return new Manifest.Status();
    }

    @Override
    public Class<? extends KubernetesV2CachingAgent> cachingAgentClass() {
        return KubernetesCoreCachingAgent.class;
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key, KubernetesCacheUtils cacheUtils) {
        Map<String, Object> result = super.hydrateSearchResult(key, cacheUtils);
        result.put("loadBalancer", result.get("name"));
        return result;
    }

    @Override
    public void addRelationships(Map<KubernetesKind, List<KubernetesManifest>> allResources, Map<KubernetesManifest, List<KubernetesManifest>> relationshipMap) {
        HashMap<String, Set<KubernetesManifest>> mapLabelToManifest = new HashMap<String, Set<KubernetesManifest>>();
        ((List)allResources.getOrDefault(KubernetesKind.REPLICA_SET, new ArrayList())).forEach(r -> this.addAllReplicaSetLabels((Map<String, Set<KubernetesManifest>>)mapLabelToManifest, (KubernetesManifest)r));
        for (KubernetesManifest service : (List)allResources.getOrDefault(KubernetesKind.SERVICE, new ArrayList())) {
            relationshipMap.put(service, this.getRelatedManifests(service, mapLabelToManifest));
        }
    }

    private Map<String, String> getSelector(KubernetesManifest manifest) {
        if (manifest.getApiVersion().equals(KubernetesApiVersion.V1)) {
            V1Service v1Service = KubernetesCacheDataConverter.getResource(manifest, V1Service.class);
            return v1Service.getSpec().getSelector();
        }
        throw new IllegalArgumentException("No services with version " + manifest.getApiVersion() + " supported");
    }

    private List<KubernetesManifest> getRelatedManifests(KubernetesManifest service, Map<String, Set<KubernetesManifest>> mapLabelToManifest) {
        return new ArrayList<KubernetesManifest>(this.intersectLabels(service, mapLabelToManifest));
    }

    private Set<KubernetesManifest> intersectLabels(KubernetesManifest service, Map<String, Set<KubernetesManifest>> mapLabelToManifest) {
        Map<String, String> selector = this.getSelector(service);
        if (selector == null || selector.isEmpty()) {
            return new HashSet<KubernetesManifest>();
        }
        HashSet result = null;
        String namespace = service.getNamespace();
        for (Map.Entry<String, String> label : selector.entrySet()) {
            String labelKey = this.podLabelKey(namespace, label);
            HashSet manifests = mapLabelToManifest.get(labelKey);
            HashSet hashSet = manifests = manifests == null ? new HashSet() : manifests;
            if (result == null) {
                result = manifests;
                continue;
            }
            result.retainAll(manifests);
        }
        return result;
    }

    private void addAllReplicaSetLabels(Map<String, Set<KubernetesManifest>> entries, KubernetesManifest replicaSet) {
        String namespace = replicaSet.getNamespace();
        Map<String, String> podLabels = KubernetesReplicaSetHandler.getPodTemplateLabels(replicaSet);
        if (podLabels == null) {
            return;
        }
        for (Map.Entry<String, String> label : podLabels.entrySet()) {
            String labelKey = this.podLabelKey(namespace, label);
            this.enterManifest(entries, labelKey, KubernetesCacheDataConverter.convertToManifest(replicaSet));
        }
    }

    private void enterManifest(Map<String, Set<KubernetesManifest>> entries, String label, KubernetesManifest manifest) {
        Set<KubernetesManifest> pods = entries.get(label);
        if (pods == null) {
            pods = new HashSet<KubernetesManifest>();
        }
        pods.add(manifest);
        entries.put(label, pods);
    }

    private String podLabelKey(String namespace, Map.Entry<String, String> label) {
        return namespace + " " + label.getKey() + " " + label.getValue();
    }

    @Override
    public void attach(KubernetesManifest loadBalancer, KubernetesManifest target) {
        Map<String, String> labels = target.getSpecTemplateLabels().orElse(target.getLabels());
        Map<String, String> selector = this.getSelector(loadBalancer);
        labels.putAll(selector);
    }

    private String pathPrefix(KubernetesManifest target) {
        if (target.getSpecTemplateLabels().isPresent()) {
            return "/spec/template/metadata/labels";
        }
        return "/metadata/labels";
    }

    private Map<String, String> labels(KubernetesManifest target) {
        if (target.getSpecTemplateLabels().isPresent()) {
            return target.getSpecTemplateLabels().get();
        }
        return target.getLabels();
    }

    @Override
    public List<JsonPatch> attachPatch(KubernetesManifest loadBalancer, KubernetesManifest target) {
        String pathPrefix = this.pathPrefix(target);
        Map<String, String> labels = this.labels(target);
        return this.getSelector(loadBalancer).entrySet().stream().map(kv -> JsonPatch.builder().op(labels.containsKey(kv.getKey()) ? JsonPatch.Op.replace : JsonPatch.Op.add).path(String.join((CharSequence)"/", pathPrefix, (CharSequence)kv.getKey())).value(kv.getValue()).build()).collect(Collectors.toList());
    }

    @Override
    public List<JsonPatch> detachPatch(KubernetesManifest loadBalancer, KubernetesManifest target) {
        String pathPrefix = this.pathPrefix(target);
        Map<String, String> labels = this.labels(target);
        return this.getSelector(loadBalancer).keySet().stream().filter(labels::containsKey).map(k -> JsonPatch.builder().op(JsonPatch.Op.remove).path(String.join((CharSequence)"/", pathPrefix, k)).build()).collect(Collectors.toList());
    }
}

