/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacerFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanPauseRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanResize;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanResumeRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanScale;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanUndoRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.ServerGroupHandler;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import io.kubernetes.client.models.V1beta2RollingUpdateStatefulSetStrategy;
import io.kubernetes.client.models.V1beta2StatefulSet;
import io.kubernetes.client.models.V1beta2StatefulSetStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class KubernetesStatefulSetHandler
extends KubernetesHandler
implements CanResize,
CanScale,
CanPauseRollout,
CanResumeRollout,
CanUndoRollout,
ServerGroupHandler {
    public KubernetesStatefulSetHandler() {
        this.registerReplacer(ArtifactReplacerFactory.dockerImageReplacer());
        this.registerReplacer(ArtifactReplacerFactory.configMapVolumeReplacer());
        this.registerReplacer(ArtifactReplacerFactory.secretVolumeReplacer());
        this.registerReplacer(ArtifactReplacerFactory.configMapEnvFromReplacer());
        this.registerReplacer(ArtifactReplacerFactory.secretEnvFromReplacer());
        this.registerReplacer(ArtifactReplacerFactory.configMapKeyValueFromReplacer());
        this.registerReplacer(ArtifactReplacerFactory.secretKeyValueFromReplacer());
    }

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.WORKLOAD_CONTROLLER_PRIORITY.getValue();
    }

    @Override
    public KubernetesKind kind() {
        return KubernetesKind.STATEFUL_SET;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    public KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind() {
        return KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUPS;
    }

    @Override
    public Class<? extends KubernetesV2CachingAgent> cachingAgentClass() {
        return KubernetesCoreCachingAgent.class;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        if (manifest.isNewerThanObservedGeneration()) {
            return new Manifest.Status().unknown();
        }
        V1beta2StatefulSet v1beta2StatefulSet = KubernetesCacheDataConverter.getResource(manifest, V1beta2StatefulSet.class);
        return this.status(v1beta2StatefulSet);
    }

    public static String serviceName(KubernetesManifest manifest) {
        Map spec = (Map)manifest.get("spec");
        return (String)spec.get("serviceName");
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key, KubernetesCacheUtils cacheUtils) {
        Map<String, Object> result = super.hydrateSearchResult(key, cacheUtils);
        result.put("serverGroup", result.get("name"));
        return result;
    }

    private Manifest.Status status(V1beta2StatefulSet statefulSet) {
        Manifest.Status result = new Manifest.Status();
        if (statefulSet.getSpec().getUpdateStrategy().getType().equalsIgnoreCase("ondelete")) {
            return result;
        }
        V1beta2StatefulSetStatus status = statefulSet.getStatus();
        if (status == null) {
            result.unstable("No status reported yet").unavailable("No availability reported");
            return result;
        }
        Integer desiredReplicas = statefulSet.getSpec().getReplicas();
        Integer existing = status.getReplicas();
        if (existing == null || desiredReplicas != null && desiredReplicas > existing) {
            return result.unstable("Waiting for at least the desired replica count to be met");
        }
        existing = status.getReadyReplicas();
        if (existing == null || desiredReplicas != null && desiredReplicas > existing) {
            return result.unstable("Waiting for all updated replicas to be ready");
        }
        String updateType = statefulSet.getSpec().getUpdateStrategy().getType();
        V1beta2RollingUpdateStatefulSetStrategy rollingUpdate = statefulSet.getSpec().getUpdateStrategy().getRollingUpdate();
        Integer updated = status.getUpdatedReplicas();
        if (updateType.equalsIgnoreCase("rollingupdate") && updated != null && rollingUpdate != null) {
            Integer partition = rollingUpdate.getPartition();
            Integer replicas = status.getReplicas();
            if (replicas != null && partition != null && updated < replicas - partition) {
                return result.unstable("Waiting for partitioned roll out to finish");
            }
            result.setStable(new Manifest.Status.Condition(true, "Partitioned roll out complete"));
            return result;
        }
        existing = status.getCurrentReplicas();
        if (existing == null || desiredReplicas != null && desiredReplicas > existing) {
            return result.unstable("Waiting for all updated replicas to be scheduled");
        }
        if (!status.getCurrentRevision().equals(status.getUpdateRevision())) {
            return result.unstable("Waiting for the updated revision to match the current revision");
        }
        return result;
    }

    @Override
    public void addRelationships(Map<KubernetesKind, List<KubernetesManifest>> allResources, Map<KubernetesManifest, List<KubernetesManifest>> relationshipMap) {
        BiFunction<String, String, String> manifestName = (namespace, name) -> namespace + ":" + name;
        Map<String, KubernetesManifest> services = ((List)allResources.getOrDefault(KubernetesKind.SERVICE, new ArrayList())).stream().collect(Collectors.toMap(m -> (String)manifestName.apply(m.getNamespace(), m.getName()), m -> m));
        for (KubernetesManifest manifest : (List)allResources.getOrDefault(KubernetesKind.STATEFUL_SET, new ArrayList())) {
            String key;
            String serviceName = KubernetesStatefulSetHandler.serviceName(manifest);
            if (StringUtils.isEmpty((CharSequence)serviceName) || !services.containsKey(key = manifestName.apply(manifest.getNamespace(), serviceName))) continue;
            KubernetesManifest service = services.get(key);
            relationshipMap.put(manifest, Collections.singletonList(service));
        }
    }
}

