/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.config.CustomKubernetesResource;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesCachingPolicy;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.JsonPatch;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesPatchOptions;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesPodMetric;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesApiGroup;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesSelectorList;
import io.kubernetes.client.models.V1DeleteOptions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesV2Credentials
implements KubernetesCredentials {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2Credentials.class);
    private final KubectlJobExecutor jobExecutor;
    private final Registry registry;
    private final Clock clock;
    private final String accountName;
    private final List<String> namespaces;
    private final List<String> omitNamespaces;
    private final List<KubernetesKind> kinds;
    private final Map<KubernetesKind, InvalidKindReason> omitKinds;
    private final boolean serviceAccount;
    private boolean metrics;
    private final List<KubernetesCachingPolicy> cachingPolicies;
    private final boolean onlySpinnakerManaged;
    private final boolean liveManifestCalls;
    private final boolean checkPermissionsOnStartup;
    private static final int namespaceExpirySeconds = 30;
    private final Supplier<List<String>> liveNamespaceSupplier;
    private static final int crdExpirySeconds = 30;
    private final Supplier<List<KubernetesKind>> liveCrdSupplier;
    private final List<CustomKubernetesResource> customResources;
    private final String kubectlExecutable;
    private final Integer kubectlRequestTimeoutSeconds;
    private final String kubeconfigFile;
    private final String context;
    @JsonIgnore
    private final String oAuthServiceAccount;
    @JsonIgnore
    private final List<String> oAuthScopes;
    private final String defaultNamespace = "default";
    private String cachedDefaultNamespace;
    private final Path serviceAccountNamespacePath = Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/namespace", new String[0]);
    private final boolean debug;

    public boolean getOnlySpinnakerManaged() {
        return this.onlySpinnakerManaged;
    }

    public boolean isValidKind(KubernetesKind kind) {
        return this.getInvalidKindReason(kind) == null;
    }

    public InvalidKindReason getInvalidKindReason(KubernetesKind kind) {
        if (kind == KubernetesKind.NONE) {
            return InvalidKindReason.KIND_NONE;
        }
        if (!this.kinds.isEmpty()) {
            return !this.kinds.contains(kind) ? InvalidKindReason.MISSING_FROM_ALLOWED_KINDS : null;
        }
        return this.omitKinds.getOrDefault(kind, null);
    }

    public String getDefaultNamespace() {
        if (StringUtils.isEmpty((CharSequence)this.cachedDefaultNamespace)) {
            this.cachedDefaultNamespace = this.lookupDefaultNamespace();
        }
        return this.cachedDefaultNamespace;
    }

    private Optional<String> serviceAccountNamespace() {
        try {
            return Files.lines(this.serviceAccountNamespacePath, StandardCharsets.UTF_8).findFirst();
        }
        catch (IOException e) {
            log.debug("Failure looking up desired namespace", (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<String> kubectlNamespace() {
        try {
            return Optional.of(this.jobExecutor.defaultNamespace(this));
        }
        catch (KubectlJobExecutor.KubectlException e) {
            log.debug("Failure looking up desired namespace", (Throwable)e);
            return Optional.empty();
        }
    }

    public String lookupDefaultNamespace() {
        try {
            if (this.serviceAccount) {
                return this.serviceAccountNamespace().orElse("default");
            }
            return this.kubectlNamespace().orElse("default");
        }
        catch (Exception e) {
            log.debug("Error encountered looking up default namespace, defaulting to {}", (Object)"default", (Object)e);
            return "default";
        }
    }

    private KubernetesV2Credentials(@NotNull String accountName, @NotNull KubectlJobExecutor jobExecutor, @NotNull List<String> namespaces, @NotNull List<String> omitNamespaces, @NotNull Registry registry, String kubeconfigFile, String kubectlExecutable, Integer kubectlRequestTimeoutSeconds, String context, String oAuthServiceAccount, List<String> oAuthScopes, boolean serviceAccount, @NotNull List<CustomKubernetesResource> customResources, @NotNull List<KubernetesCachingPolicy> cachingPolicies, @NotNull List<KubernetesKind> kinds, @NotNull List<KubernetesKind> omitKinds, boolean metrics, boolean checkPermissionsOnStartup, boolean debug, boolean onlySpinnakerManaged, boolean liveManifestCalls) {
        this.registry = registry;
        this.clock = registry.clock();
        this.accountName = accountName;
        this.namespaces = namespaces;
        this.omitNamespaces = omitNamespaces;
        this.jobExecutor = jobExecutor;
        this.debug = debug;
        this.kubectlExecutable = kubectlExecutable;
        this.kubectlRequestTimeoutSeconds = kubectlRequestTimeoutSeconds;
        this.kubeconfigFile = kubeconfigFile;
        this.context = context;
        this.oAuthServiceAccount = oAuthServiceAccount;
        this.oAuthScopes = oAuthScopes;
        this.serviceAccount = serviceAccount;
        this.customResources = customResources;
        this.cachingPolicies = cachingPolicies;
        this.kinds = kinds;
        this.metrics = metrics;
        this.omitKinds = omitKinds.stream().collect(Collectors.toMap(k -> k, k -> InvalidKindReason.EXPLICITLY_OMITTED_BY_CONFIGURATION));
        this.onlySpinnakerManaged = onlySpinnakerManaged;
        this.liveManifestCalls = liveManifestCalls;
        this.checkPermissionsOnStartup = checkPermissionsOnStartup;
        this.liveNamespaceSupplier = Suppliers.memoizeWithExpiration(() -> jobExecutor.list(this, Collections.singletonList(KubernetesKind.NAMESPACE), "", new KubernetesSelectorList()).stream().map(KubernetesManifest::getName).collect(Collectors.toList()), (long)30L, (TimeUnit)TimeUnit.SECONDS);
        this.liveCrdSupplier = Suppliers.memoizeWithExpiration(() -> {
            try {
                return this.list(KubernetesKind.CUSTOM_RESOURCE_DEFINITION, "").stream().map(c -> {
                    Map spec = c.getOrDefault("spec", new HashMap());
                    String scope = spec.getOrDefault("scope", "");
                    Map names = spec.getOrDefault("names", new HashMap());
                    String name = (String)names.get("kind");
                    String group = spec.getOrDefault("group", "");
                    KubernetesApiGroup kubernetesApiGroup = KubernetesApiGroup.fromString(group);
                    boolean isNamespaced = scope.equalsIgnoreCase("namespaced");
                    return KubernetesKind.getOrRegisterKind(name, false, isNamespaced, kubernetesApiGroup);
                }).collect(Collectors.toList());
            }
            catch (KubectlJobExecutor.KubectlException e) {
                return new ArrayList();
            }
        }, (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }

    public void initialize() {
        this.liveCrdSupplier.get();
        if (this.checkPermissionsOnStartup) {
            this.determineOmitKinds();
        }
    }

    public List<KubernetesKind> getCrds() {
        return (List)this.liveCrdSupplier.get();
    }

    @Override
    public List<String> getDeclaredNamespaces() {
        List result;
        if (!this.namespaces.isEmpty()) {
            result = this.namespaces;
        } else {
            try {
                result = (List)this.liveNamespaceSupplier.get();
            }
            catch (KubectlJobExecutor.KubectlException e) {
                log.warn("Could not list namespaces for account {}: {}", (Object)this.accountName, (Object)e.getMessage());
                return new ArrayList<String>();
            }
        }
        if (!this.omitNamespaces.isEmpty()) {
            result = result.stream().filter(n -> !this.omitNamespaces.contains(n)).collect(Collectors.toList());
        }
        return result;
    }

    private void determineOmitKinds() {
        List<String> namespaces = this.getDeclaredNamespaces();
        if (namespaces.isEmpty()) {
            log.warn("There are no namespaces configured (or loadable) -- please check that the list of 'omitNamespaces' for account '" + this.accountName + "' doesn't prevent access from all namespaces in this cluster, or that the cluster is reachable.");
            return;
        }
        String checkNamespace = namespaces.get(0);
        List<KubernetesKind> allKinds = KubernetesKind.getValues();
        log.info("Checking permissions on configured kinds for account {}... {}", (Object)this.accountName, allKinds);
        Map unreadableKinds = allKinds.parallelStream().filter(k -> k != KubernetesKind.NONE).filter(k -> !this.omitKinds.keySet().contains(k)).filter(k -> !this.canReadKind((KubernetesKind)k, checkNamespace)).collect(Collectors.toConcurrentMap(k -> k, k -> InvalidKindReason.READ_ERROR));
        this.omitKinds.putAll(unreadableKinds);
        if (this.metrics) {
            try {
                log.info("Checking if pod metrics are readable...");
                this.topPod(checkNamespace);
            }
            catch (Exception e) {
                log.warn("Could not read pod metrics in account '{}' for reason: {}", (Object)this.accountName, (Object)e.getMessage());
                log.debug("Reading logs failed with exception: ", (Throwable)e);
                this.metrics = false;
            }
        }
    }

    private boolean canReadKind(KubernetesKind kind, String checkNamespace) {
        try {
            log.info("Checking if {} is readable...", (Object)kind);
            if (kind.isNamespaced()) {
                this.list(kind, checkNamespace);
            } else {
                this.list(kind, null);
            }
            return true;
        }
        catch (Exception e) {
            log.info("Kind '{}' will not be cached in account '{}' for reason: '{}'", new Object[]{kind, this.accountName, e.getMessage()});
            log.debug("Reading kind '{}' failed with exception: ", (Object)kind, (Object)e);
            return false;
        }
    }

    public KubernetesManifest get(KubernetesKind kind, String namespace, String name) {
        return this.runAndRecordMetrics("get", kind, namespace, () -> this.jobExecutor.get(this, kind, namespace, name));
    }

    public List<KubernetesManifest> list(KubernetesKind kind, String namespace) {
        return this.runAndRecordMetrics("list", kind, namespace, () -> this.jobExecutor.list(this, Collections.singletonList(kind), namespace, new KubernetesSelectorList()));
    }

    public List<KubernetesManifest> list(KubernetesKind kind, String namespace, KubernetesSelectorList selectors) {
        return this.runAndRecordMetrics("list", kind, namespace, () -> this.jobExecutor.list(this, Collections.singletonList(kind), namespace, selectors));
    }

    public List<KubernetesManifest> list(List<KubernetesKind> kinds, String namespace) {
        if (kinds.isEmpty()) {
            return new ArrayList<KubernetesManifest>();
        }
        return this.runAndRecordMetrics("list", kinds, namespace, () -> this.jobExecutor.list(this, kinds, namespace, new KubernetesSelectorList()));
    }

    public List<KubernetesManifest> eventsFor(KubernetesKind kind, String namespace, String name) {
        return this.runAndRecordMetrics("list", KubernetesKind.EVENT, namespace, () -> this.jobExecutor.eventsFor(this, kind, namespace, name));
    }

    public String logs(String namespace, String podName, String containerName) {
        return this.runAndRecordMetrics("logs", KubernetesKind.POD, namespace, () -> this.jobExecutor.logs(this, namespace, podName, containerName));
    }

    public String jobLogs(String namespace, String jobName) {
        return this.runAndRecordMetrics("logs", KubernetesKind.JOB, namespace, () -> this.jobExecutor.jobLogs(this, namespace, jobName));
    }

    public void scale(KubernetesKind kind, String namespace, String name, int replicas) {
        this.runAndRecordMetrics("scale", kind, namespace, () -> this.jobExecutor.scale(this, kind, namespace, name, replicas));
    }

    public List<String> delete(KubernetesKind kind, String namespace, String name, KubernetesSelectorList labelSelectors, V1DeleteOptions options) {
        return this.runAndRecordMetrics("delete", kind, namespace, () -> this.jobExecutor.delete(this, kind, namespace, name, labelSelectors, options));
    }

    public Collection<KubernetesPodMetric> topPod(String namespace) {
        return this.runAndRecordMetrics("top", KubernetesKind.POD, namespace, () -> this.jobExecutor.topPod(this, namespace));
    }

    public void deploy(KubernetesManifest manifest) {
        this.runAndRecordMetrics("deploy", manifest.getKind(), manifest.getNamespace(), () -> this.jobExecutor.deploy(this, manifest));
    }

    public List<Integer> historyRollout(KubernetesKind kind, String namespace, String name) {
        return this.runAndRecordMetrics("historyRollout", kind, namespace, () -> this.jobExecutor.historyRollout(this, kind, namespace, name));
    }

    public void undoRollout(KubernetesKind kind, String namespace, String name, int revision) {
        this.runAndRecordMetrics("undoRollout", kind, namespace, () -> this.jobExecutor.undoRollout(this, kind, namespace, name, revision));
    }

    public void pauseRollout(KubernetesKind kind, String namespace, String name) {
        this.runAndRecordMetrics("pauseRollout", kind, namespace, () -> this.jobExecutor.pauseRollout(this, kind, namespace, name));
    }

    public void resumeRollout(KubernetesKind kind, String namespace, String name) {
        this.runAndRecordMetrics("resumeRollout", kind, namespace, () -> this.jobExecutor.resumeRollout(this, kind, namespace, name));
    }

    public void patch(KubernetesKind kind, String namespace, String name, KubernetesPatchOptions options, KubernetesManifest manifest) {
        this.runAndRecordMetrics("patch", kind, namespace, () -> this.jobExecutor.patch(this, kind, namespace, name, options, manifest));
    }

    public void patch(KubernetesKind kind, String namespace, String name, KubernetesPatchOptions options, List<JsonPatch> patches) {
        this.runAndRecordMetrics("patch", kind, namespace, () -> this.jobExecutor.patch(this, kind, namespace, name, options, patches));
    }

    private <T> T runAndRecordMetrics(String action, KubernetesKind kind, String namespace, java.util.function.Supplier<T> op) {
        return this.runAndRecordMetrics(action, Collections.singletonList(kind), namespace, op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private <T> T runAndRecordMetrics(String action, List<KubernetesKind> kinds, String namespace, java.util.function.Supplier<T> op) {
        T result = null;
        Exception failure = null;
        KubectlJobExecutor.KubectlException apiException = null;
        long startTime = this.clock.monotonicTime();
        try {
            result = op.get();
        }
        catch (KubectlJobExecutor.KubectlException e) {
            apiException = e;
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("action", action);
            if (kinds.size() == 1) {
                tags.put("kind", kinds.get(0).toString());
            } else {
                tags.put("kinds", String.join((CharSequence)",", kinds.stream().map(KubernetesKind::toString).collect(Collectors.toList())));
            }
            tags.put("account", this.accountName);
            tags.put("namespace", StringUtils.isEmpty((CharSequence)namespace) ? "none" : namespace);
            if (failure == null) {
                tags.put("success", "true");
            } else {
                tags.put("success", "false");
                tags.put("reason", failure.getClass().getSimpleName() + ": " + failure.getMessage());
            }
            this.registry.timer(this.registry.createId("kubernetes.api", tags)).record(this.clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
            if (failure != null) {
                throw new KubectlJobExecutor.KubectlException("Failure running " + action + " on " + kinds + ": " + failure.getMessage(), failure);
            }
            if (apiException != null) {
                throw apiException;
            }
            return result;
        }
        catch (Exception e2) {
            failure = e2;
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("action", action);
            {
                catch (Throwable throwable) {
                    HashMap<String, String> tags2 = new HashMap<String, String>();
                    tags2.put("action", action);
                    if (kinds.size() == 1) {
                        tags2.put("kind", kinds.get(0).toString());
                    } else {
                        tags2.put("kinds", String.join((CharSequence)",", kinds.stream().map(KubernetesKind::toString).collect(Collectors.toList())));
                    }
                    tags2.put("account", this.accountName);
                    tags2.put("namespace", StringUtils.isEmpty((CharSequence)namespace) ? "none" : namespace);
                    if (failure == null) {
                        tags2.put("success", "true");
                    } else {
                        tags2.put("success", "false");
                        tags2.put("reason", failure.getClass().getSimpleName() + ": " + failure.getMessage());
                    }
                    this.registry.timer(this.registry.createId("kubernetes.api", tags2)).record(this.clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
                    if (failure != null) {
                        throw new KubectlJobExecutor.KubectlException("Failure running " + action + " on " + kinds + ": " + failure.getMessage(), failure);
                    }
                    if (apiException != null) {
                        throw apiException;
                    }
                    return result;
                }
            }
            if (kinds.size() == 1) {
                tags.put("kind", kinds.get(0).toString());
            } else {
                tags.put("kinds", String.join((CharSequence)",", kinds.stream().map(KubernetesKind::toString).collect(Collectors.toList())));
            }
            tags.put("account", this.accountName);
            tags.put("namespace", StringUtils.isEmpty((CharSequence)namespace) ? "none" : namespace);
            if (failure == null) {
                tags.put("success", "true");
            } else {
                tags.put("success", "false");
                tags.put("reason", failure.getClass().getSimpleName() + ": " + failure.getMessage());
            }
            this.registry.timer(this.registry.createId("kubernetes.api", tags)).record(this.clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
            if (failure != null) {
                throw new KubectlJobExecutor.KubectlException("Failure running " + action + " on " + kinds + ": " + failure.getMessage(), failure);
            }
            if (apiException != null) {
                throw apiException;
            }
            return result;
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("action", action);
        if (kinds.size() == 1) {
            tags.put("kind", kinds.get(0).toString());
        } else {
            tags.put("kinds", String.join((CharSequence)",", kinds.stream().map(KubernetesKind::toString).collect(Collectors.toList())));
        }
        tags.put("account", this.accountName);
        tags.put("namespace", StringUtils.isEmpty((CharSequence)namespace) ? "none" : namespace);
        if (failure == null) {
            tags.put("success", "true");
        } else {
            tags.put("success", "false");
            tags.put("reason", failure.getClass().getSimpleName() + ": " + failure.getMessage());
        }
        this.registry.timer(this.registry.createId("kubernetes.api", tags)).record(this.clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
        if (failure != null) {
            throw new KubectlJobExecutor.KubectlException("Failure running " + action + " on " + kinds + ": " + failure.getMessage(), failure);
        }
        if (apiException != null) {
            throw apiException;
        }
        return result;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public List<String> getOmitNamespaces() {
        return this.omitNamespaces;
    }

    public boolean isServiceAccount() {
        return this.serviceAccount;
    }

    public boolean isMetrics() {
        return this.metrics;
    }

    public List<KubernetesCachingPolicy> getCachingPolicies() {
        return this.cachingPolicies;
    }

    public boolean isLiveManifestCalls() {
        return this.liveManifestCalls;
    }

    public List<CustomKubernetesResource> getCustomResources() {
        return this.customResources;
    }

    public String getKubectlExecutable() {
        return this.kubectlExecutable;
    }

    public Integer getKubectlRequestTimeoutSeconds() {
        return this.kubectlRequestTimeoutSeconds;
    }

    public String getKubeconfigFile() {
        return this.kubeconfigFile;
    }

    public String getContext() {
        return this.context;
    }

    public String getOAuthServiceAccount() {
        return this.oAuthServiceAccount;
    }

    public List<String> getOAuthScopes() {
        return this.oAuthScopes;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public static class Builder {
        String accountName;
        String kubeconfigFile;
        String context;
        String kubectlExecutable;
        Integer kubectlRequestTimeoutSeconds;
        String oAuthServiceAccount;
        List<String> oAuthScopes;
        String userAgent;
        List<String> namespaces = new ArrayList<String>();
        List<String> omitNamespaces = new ArrayList<String>();
        Registry registry;
        KubectlJobExecutor jobExecutor;
        List<CustomKubernetesResource> customResources;
        List<KubernetesCachingPolicy> cachingPolicies;
        List<String> kinds;
        List<String> omitKinds;
        boolean debug;
        boolean checkPermissionsOnStartup;
        boolean serviceAccount;
        boolean metrics;
        boolean onlySpinnakerManaged;
        boolean liveManifestCalls;

        public Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public Builder kubeconfigFile(String kubeconfigFile) {
            this.kubeconfigFile = kubeconfigFile;
            return this;
        }

        public Builder kubectlExecutable(String kubectlExecutable) {
            this.kubectlExecutable = kubectlExecutable;
            return this;
        }

        public Builder kubectlRequestTimeoutSeconds(Integer kubectlRequestTimeoutSeconds) {
            this.kubectlRequestTimeoutSeconds = kubectlRequestTimeoutSeconds;
            return this;
        }

        public Builder context(String context) {
            this.context = context;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder namespaces(List<String> namespaces) {
            this.namespaces = namespaces;
            return this;
        }

        public Builder omitNamespaces(List<String> omitNamespaces) {
            this.omitNamespaces = omitNamespaces;
            return this;
        }

        public Builder registry(Registry registry) {
            this.registry = registry;
            return this;
        }

        public Builder jobExecutor(KubectlJobExecutor jobExecutor) {
            this.jobExecutor = jobExecutor;
            return this;
        }

        public Builder cachingPolicies(List<KubernetesCachingPolicy> cachingPolicies) {
            this.cachingPolicies = cachingPolicies;
            return this;
        }

        public Builder customResources(List<CustomKubernetesResource> customResources) {
            this.customResources = customResources;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder checkPermissionsOnStartup(boolean checkPermissionsOnStartup) {
            this.checkPermissionsOnStartup = checkPermissionsOnStartup;
            return this;
        }

        public Builder serviceAccount(boolean serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public Builder oAuthServiceAccount(String oAuthServiceAccount) {
            this.oAuthServiceAccount = oAuthServiceAccount;
            return this;
        }

        public Builder oAuthScopes(List<String> oAuthScopes) {
            this.oAuthScopes = oAuthScopes;
            return this;
        }

        public Builder kinds(List<String> kinds) {
            this.kinds = kinds;
            return this;
        }

        public Builder omitKinds(List<String> omitKinds) {
            this.omitKinds = omitKinds;
            return this;
        }

        public Builder metrics(boolean metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder onlySpinnakerManaged(boolean onlySpinnakerManaged) {
            this.onlySpinnakerManaged = onlySpinnakerManaged;
            return this;
        }

        public Builder liveManifestCalls(boolean liveManifestCalls) {
            this.liveManifestCalls = liveManifestCalls;
            return this;
        }

        public KubernetesV2Credentials build() {
            this.namespaces = this.namespaces == null ? new ArrayList() : this.namespaces;
            this.omitNamespaces = this.omitNamespaces == null ? new ArrayList() : this.omitNamespaces;
            this.customResources = this.customResources == null ? new ArrayList() : this.customResources;
            this.kinds = this.kinds == null ? new ArrayList() : this.kinds;
            this.omitKinds = this.omitKinds == null ? new ArrayList() : this.omitKinds;
            this.cachingPolicies = this.cachingPolicies == null ? new ArrayList() : this.cachingPolicies;
            return new KubernetesV2Credentials(this.accountName, this.jobExecutor, this.namespaces, this.omitNamespaces, this.registry, this.kubeconfigFile, this.kubectlExecutable, this.kubectlRequestTimeoutSeconds, this.context, this.oAuthServiceAccount, this.oAuthScopes, this.serviceAccount, this.customResources, this.cachingPolicies, KubernetesKind.registeredStringList(this.kinds), KubernetesKind.registeredStringList(this.omitKinds), this.metrics, this.checkPermissionsOnStartup, this.debug, this.onlySpinnakerManaged, this.liveManifestCalls);
        }
    }

    public static enum InvalidKindReason {
        KIND_NONE("Kind [%s] is invalid"),
        EXPLICITLY_OMITTED_BY_CONFIGURATION("Kind [%s] included in 'omitKinds' of kubernetes account configuration"),
        MISSING_FROM_ALLOWED_KINDS("Kind [%s] missing in 'kinds' of kubernetes account configuration"),
        READ_ERROR("Error reading kind [%s]. Please check connectivity and access permissions to the cluster");

        private String errorMessage;

        private InvalidKindReason(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String getErrorMessage(KubernetesKind kind) {
            return String.format(this.errorMessage, kind);
        }
    }
}

