/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.validator.manifest;

import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidator;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesEnableDisableManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.validator.KubernetesValidationUtil;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import com.netflix.spinnaker.clouddriver.security.ProviderVersion;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@KubernetesOperation(value="enableManifest")
@Component
public class KubernetesEnableManifestValidator
extends DescriptionValidator<KubernetesEnableDisableManifestDescription> {
    @Autowired
    AccountCredentialsProvider provider;

    public void validate(List priorDescriptions, KubernetesEnableDisableManifestDescription description, Errors errors) {
        KubernetesValidationUtil util = new KubernetesValidationUtil("enableKubernetesManifest", errors);
        if (!util.validateV2Credentials(this.provider, description.getAccount(), description.getPointCoordinates().getKind(), description.getPointCoordinates().getNamespace())) {
            return;
        }
    }

    public boolean acceptsVersion(ProviderVersion version) {
        return version == ProviderVersion.v2;
    }
}

