/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.security;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.config.CustomKubernetesResource;
import com.netflix.spinnaker.clouddriver.kubernetes.config.LinkedDockerRegistryConfiguration;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.security.KubernetesV1Credentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import com.netflix.spinnaker.clouddriver.security.ProviderVersion;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import com.netflix.spinnaker.moniker.Namer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class KubernetesNamedAccountCredentials<C extends KubernetesCredentials>
implements AccountCredentials<C> {
    private final String cloudProvider = "kubernetes";
    private final String name;
    private final ProviderVersion providerVersion;
    private final String environment;
    private final String accountType;
    private final String context;
    private final String cluster;
    private final String user;
    private final String userAgent;
    private final String kubeconfigFile;
    private final String kubectlExecutable;
    private final Boolean serviceAccount;
    private List<String> namespaces;
    private List<String> omitNamespaces;
    private String skin;
    private final int cacheThreads;
    private C credentials;
    private final List<String> requiredGroupMembership;
    private final Permissions permissions;
    private final List<LinkedDockerRegistryConfiguration> dockerRegistries;
    private final Registry spectatorRegistry;
    private final AccountCredentialsRepository accountCredentialsRepository;

    KubernetesNamedAccountCredentials(String name, ProviderVersion providerVersion, AccountCredentialsRepository accountCredentialsRepository, String userAgent, String environment, String accountType, String context, String cluster, String user, String kubeconfigFile, String kubectlExecutable, Boolean serviceAccount, List<String> namespaces, List<String> omitNamespaces, String skin, int cacheThreads, List<LinkedDockerRegistryConfiguration> dockerRegistries, List<String> requiredGroupMembership, Permissions permissions, Registry spectatorRegistry, C credentials) {
        this.name = name;
        this.providerVersion = providerVersion;
        this.environment = environment;
        this.accountType = accountType;
        this.context = context;
        this.cluster = cluster;
        this.user = user;
        this.userAgent = userAgent;
        this.kubeconfigFile = kubeconfigFile;
        this.kubectlExecutable = kubectlExecutable;
        this.serviceAccount = serviceAccount;
        this.namespaces = namespaces;
        this.omitNamespaces = omitNamespaces;
        this.skin = skin;
        this.cacheThreads = cacheThreads;
        this.requiredGroupMembership = requiredGroupMembership;
        this.permissions = permissions;
        this.dockerRegistries = dockerRegistries;
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.spectatorRegistry = spectatorRegistry;
        this.credentials = credentials;
    }

    public List<String> getNamespaces() {
        return this.credentials.getDeclaredNamespaces();
    }

    public String getName() {
        return this.name;
    }

    public ProviderVersion getProviderVersion() {
        return this.providerVersion;
    }

    public String getSkin() {
        return this.skin != null ? this.skin : this.getProviderVersion().toString();
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public C getCredentials() {
        return this.credentials;
    }

    public String getKubectlExecutable() {
        return this.kubectlExecutable;
    }

    public String getCloudProvider() {
        return "kubernetes";
    }

    public int getCacheThreads() {
        return this.cacheThreads;
    }

    public List<LinkedDockerRegistryConfiguration> getDockerRegistries() {
        return this.dockerRegistries;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public List<String> getRequiredGroupMembership() {
        return this.requiredGroupMembership;
    }

    static class Builder<C extends KubernetesCredentials> {
        String name;
        ProviderVersion providerVersion;
        String environment;
        String accountType;
        String context;
        String cluster;
        String oAuthServiceAccount;
        List<String> oAuthScopes;
        String user;
        String userAgent;
        String kubeconfigFile;
        String kubeconfigContents;
        String kubectlExecutable;
        Boolean serviceAccount;
        Boolean configureImagePullSecrets;
        List<String> namespaces;
        List<String> omitNamespaces;
        String skin;
        int cacheThreads;
        C credentials;
        List<String> requiredGroupMembership;
        Permissions permissions;
        List<LinkedDockerRegistryConfiguration> dockerRegistries;
        Registry spectatorRegistry;
        AccountCredentialsRepository accountCredentialsRepository;
        KubectlJobExecutor jobExecutor;
        Namer namer;
        List<CustomKubernetesResource> customResources;
        List<String> kinds;
        List<String> omitKinds;
        boolean debug;

        Builder() {
        }

        Builder name(String name) {
            this.name = name;
            return this;
        }

        Builder providerVersion(ProviderVersion providerVersion) {
            this.providerVersion = providerVersion;
            return this;
        }

        Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        Builder accountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        Builder context(String context) {
            this.context = context;
            return this;
        }

        Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        Builder oAuthServiceAccount(String oAuthServiceAccount) {
            this.oAuthServiceAccount = oAuthServiceAccount;
            return this;
        }

        Builder oAuthScopes(List<String> oAuthScopes) {
            this.oAuthScopes = oAuthScopes;
            return this;
        }

        Builder user(String user) {
            this.user = user;
            return this;
        }

        Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        Builder kubeconfigFile(String kubeconfigFile) {
            this.kubeconfigFile = kubeconfigFile;
            return this;
        }

        Builder kubeconfigContents(String kubeconfigContents) {
            this.kubeconfigContents = kubeconfigContents;
            return this;
        }

        Builder kubectlExecutable(String kubectlExecutable) {
            this.kubectlExecutable = kubectlExecutable;
            return this;
        }

        Builder serviceAccount(Boolean serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        Builder configureImagePullSecrets(Boolean configureImagePullSecrets) {
            this.configureImagePullSecrets = configureImagePullSecrets;
            return this;
        }

        Builder requiredGroupMembership(List<String> requiredGroupMembership) {
            this.requiredGroupMembership = requiredGroupMembership;
            return this;
        }

        Builder permissions(Permissions permissions) {
            if (permissions.isRestricted()) {
                this.requiredGroupMembership = Collections.emptyList();
                this.permissions = permissions;
            }
            return this;
        }

        Builder dockerRegistries(List<LinkedDockerRegistryConfiguration> dockerRegistries) {
            this.dockerRegistries = dockerRegistries;
            return this;
        }

        Builder namespaces(List<String> namespaces) {
            this.namespaces = namespaces;
            return this;
        }

        Builder omitNamespaces(List<String> omitNamespaces) {
            this.omitNamespaces = omitNamespaces;
            return this;
        }

        Builder skin(String skin) {
            this.skin = skin;
            return this;
        }

        Builder cacheThreads(int cacheThreads) {
            this.cacheThreads = cacheThreads;
            return this;
        }

        Builder credentials(C credentials) {
            this.credentials = credentials;
            return this;
        }

        Builder spectatorRegistry(Registry spectatorRegistry) {
            this.spectatorRegistry = spectatorRegistry;
            return this;
        }

        Builder accountCredentialsRepository(AccountCredentialsRepository accountCredentialsRepository) {
            this.accountCredentialsRepository = accountCredentialsRepository;
            return this;
        }

        Builder jobExecutor(KubectlJobExecutor jobExecutor) {
            this.jobExecutor = jobExecutor;
            return this;
        }

        Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        Builder namer(Namer namer) {
            this.namer = namer;
            return this;
        }

        Builder customResources(List<CustomKubernetesResource> customResources) {
            this.customResources = customResources;
            return this;
        }

        Builder kinds(List<String> kinds) {
            this.kinds = kinds;
            return this;
        }

        Builder omitKinds(List<String> omitKinds) {
            this.omitKinds = omitKinds;
            return this;
        }

        private C buildCredentials() {
            switch (this.providerVersion) {
                case v1: {
                    return (C)new KubernetesV1Credentials(this.name, this.kubeconfigFile, this.context, this.cluster, this.user, this.userAgent, this.serviceAccount, this.configureImagePullSecrets, this.namespaces, this.omitNamespaces, this.dockerRegistries, this.spectatorRegistry, this.accountCredentialsRepository);
                }
                case v2: {
                    NamerRegistry.lookup().withProvider(KubernetesCloudProvider.getID()).withAccount(this.name).setNamer(KubernetesManifest.class, this.namer);
                    return (C)new KubernetesV2Credentials.Builder().accountName(this.name).kubeconfigFile(this.kubeconfigFile).kubectlExecutable(this.kubectlExecutable).context(this.context).oAuthServiceAccount(this.oAuthServiceAccount).oAuthScopes(this.oAuthScopes).serviceAccount(this.serviceAccount).userAgent(this.userAgent).namespaces(this.namespaces).omitNamespaces(this.omitNamespaces).registry(this.spectatorRegistry).customResources(this.customResources).kinds(this.kinds).omitKinds(this.omitKinds).debug(this.debug).jobExecutor(this.jobExecutor).build();
                }
            }
            throw new IllegalArgumentException("Unknown provider type: " + this.providerVersion);
        }

        KubernetesNamedAccountCredentials build() {
            if (StringUtils.isEmpty((CharSequence)this.name)) {
                throw new IllegalArgumentException("Account name for Kubernetes provider missing.");
            }
            if (this.omitNamespaces != null && !this.omitNamespaces.isEmpty() && this.namespaces != null && !this.namespaces.isEmpty()) {
                throw new IllegalArgumentException("At most one of 'namespaces' and 'omitNamespaces' can be specified");
            }
            if (this.omitKinds != null && !this.omitKinds.isEmpty() && this.kinds != null && !this.kinds.isEmpty()) {
                throw new IllegalArgumentException("At most one of 'kinds' and 'omitKinds' can be specified");
            }
            if (this.cacheThreads == 0) {
                this.cacheThreads = 1;
            }
            if (this.providerVersion == null) {
                this.providerVersion = ProviderVersion.v1;
            }
            if (StringUtils.isEmpty((CharSequence)this.kubeconfigFile)) {
                if (StringUtils.isEmpty((CharSequence)this.kubeconfigContents)) {
                    this.kubeconfigFile = System.getProperty("user.home") + "/.kube/config";
                } else {
                    try {
                        File temp = File.createTempFile("kube", "config");
                        BufferedWriter writer = new BufferedWriter(new FileWriter(temp));
                        writer.write(this.kubeconfigContents);
                        writer.close();
                        this.kubeconfigFile = temp.getAbsolutePath();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to persist 'kubeconfigContents' parameter to disk: " + e.getMessage(), e);
                    }
                }
            }
            this.requiredGroupMembership = this.requiredGroupMembership != null && !this.requiredGroupMembership.isEmpty() ? Collections.unmodifiableList(this.requiredGroupMembership) : Collections.emptyList();
            if (this.configureImagePullSecrets == null) {
                this.configureImagePullSecrets = true;
            }
            if (this.serviceAccount == null) {
                this.serviceAccount = false;
            }
            if (this.credentials == null) {
                this.credentials = this.buildCredentials();
            }
            return new KubernetesNamedAccountCredentials<C>(this.name, this.providerVersion, this.accountCredentialsRepository, this.userAgent, this.environment, this.accountType, this.context, this.cluster, this.user, this.kubeconfigFile, this.kubectlExecutable, this.serviceAccount, this.namespaces, this.omitNamespaces, this.skin, this.cacheThreads, this.dockerRegistries, this.requiredGroupMembership, this.permissions, this.spectatorRegistry, this.credentials);
        }
    }
}

