/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v1.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.KubernetesUtil;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.exception.KubernetesOperationException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.DoneableHorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.Job;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DoneableDeployment;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesApiAdaptor
implements GroovyObject {
    private Config config;
    private String account;
    private static final int RETRY_COUNT = 20;
    private static final long RETRY_MAX_WAIT_MILLIS;
    private static final long RETRY_INITIAL_WAIT_MILLIS;
    private static final String DEPLOYMENT_ANNOTATION = "deployment.kubernetes.io";
    private final KubernetesClient client;
    private final Registry spectatorRegistry;
    private final Clock spectatorClock;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public KubernetesApiAdaptor(String account, Config config, Registry spectatorRegistry) {
        MetaClass metaClass;
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (!DefaultTypeTransformation.booleanUnbox((Object)config)) {
            throw (Throwable)callSiteArray[0].callConstructor(IllegalArgumentException.class, (Object)"Config may not be null.");
        }
        Config config2 = config;
        this.config = (Config)ScriptBytecodeAdapter.castToType((Object)config2, Config.class);
        String string = account;
        this.account = ShortTypeHandling.castToString((Object)string);
        Object object = callSiteArray[1].callConstructor(DefaultKubernetesClient.class, (Object)this.config);
        this.client = (KubernetesClient)ScriptBytecodeAdapter.castToType((Object)object, KubernetesClient.class);
        Registry registry = spectatorRegistry;
        this.spectatorRegistry = (Registry)ScriptBytecodeAdapter.castToType((Object)registry, Registry.class);
        Object object2 = callSiteArray[2].call((Object)spectatorRegistry);
        this.spectatorClock = (Clock)ScriptBytecodeAdapter.castToType((Object)object2, Clock.class);
    }

    public Object spectatorRegistry() {
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        return this.spectatorRegistry;
    }

    public KubernetesOperationException formatException(String operation, String namespace, KubernetesClientException e) {
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)this.account) ? (KubernetesOperationException)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(KubernetesOperationException.class, (Object)this.account, (Object)new GStringImpl(new Object[]{operation, namespace}, new String[]{"", " in ", ""}), (Object)e), KubernetesOperationException.class) : (KubernetesOperationException)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callConstructor(KubernetesOperationException.class, (Object)new GStringImpl(new Object[]{operation, namespace}, new String[]{"", " in ", ""}), (Object)e), KubernetesOperationException.class);
    }

    public KubernetesOperationException formatException(String operation, KubernetesClientException e) {
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)this.account) ? (KubernetesOperationException)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callConstructor(KubernetesOperationException.class, (Object)this.account, (Object)new GStringImpl(new Object[]{operation}, new String[]{"", ""}), (Object)e), KubernetesOperationException.class) : (KubernetesOperationException)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callConstructor(KubernetesOperationException.class, (Object)new GStringImpl(new Object[]{operation}, new String[]{"", ""}), (Object)e), KubernetesOperationException.class);
    }

    public Boolean blockUntilResourceConsistent(Object desired, Closure<Long> getGeneration, Closure getResource) {
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        Object current = callSiteArray[7].call((Object)getResource);
        Object wait = RETRY_INITIAL_WAIT_MILLIS;
        Integer attempts = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[8].call(getGeneration, current), (Object)callSiteArray[9].call(getGeneration, desired))) {
            Object object;
            Object object2;
            callSiteArray[10].call((Object)attempts, (Object)1);
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)attempts, (Object)RETRY_COUNT)) {
                return false;
            }
            callSiteArray[11].callCurrent((GroovyObject)this, wait);
            wait = object2 = callSiteArray[12].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[13].call(wait, (Object)2), RETRY_MAX_WAIT_MILLIS}));
            current = object = callSiteArray[14].call((Object)getResource);
        }
        return true;
    }

    private <T> T exceptionWrapper(String methodName, String operationMessage, String namespace, Closure<T> doOperation) {
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        Object result = null;
        Exception failure = null;
        long startTime = DefaultTypeTransformation.longUnbox((Object)callSiteArray[15].call((Object)this.spectatorClock));
        try {
            try {
                Object object;
                result = object = callSiteArray[16].call(doOperation);
            }
            catch (KubernetesClientException e) {
                if (DefaultTypeTransformation.booleanUnbox((Object)namespace)) {
                    Object object = callSiteArray[17].callCurrent((GroovyObject)this, (Object)operationMessage, (Object)namespace, (Object)e);
                    failure = (Exception)ScriptBytecodeAdapter.castToType((Object)object, Exception.class);
                } else {
                    Object object = callSiteArray[18].callCurrent((GroovyObject)this, (Object)operationMessage, (Object)e);
                    failure = (Exception)ScriptBytecodeAdapter.castToType((Object)object, Exception.class);
                }
            }
            catch (Exception e) {
                Exception exception;
                failure = exception = e;
            }
        }
        catch (Throwable throwable) {
            Map tags = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"method", methodName, "account", this.account, "namespace", DefaultTypeTransformation.booleanUnbox((Object)namespace) ? namespace : "none", "success", DefaultTypeTransformation.booleanUnbox((Object)failure) ? "false" : "true"});
            if (DefaultTypeTransformation.booleanUnbox((Object)failure)) {
                Object object = callSiteArray[28].callGetProperty(callSiteArray[29].callGetProperty((Object)failure));
                callSiteArray[30].call((Object)tags, (Object)"reason", object);
            }
            callSiteArray[31].call(callSiteArray[32].call((Object)this.spectatorRegistry, callSiteArray[33].call((Object)this.spectatorRegistry, (Object)"kubernetes.api", (Object)tags)), callSiteArray[34].call(callSiteArray[35].call((Object)this.spectatorClock), (Object)startTime), callSiteArray[36].callGetProperty(TimeUnit.class));
            if (DefaultTypeTransformation.booleanUnbox((Object)failure)) {
                throw (Throwable)failure;
            }
            return (T)result;
        }
        Map tags = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"method", methodName, "account", this.account, "namespace", DefaultTypeTransformation.booleanUnbox((Object)namespace) ? namespace : "none", "success", DefaultTypeTransformation.booleanUnbox((Object)failure) ? "false" : "true"});
        if (DefaultTypeTransformation.booleanUnbox((Object)failure)) {
            Object object = callSiteArray[19].callGetProperty(callSiteArray[20].callGetProperty((Object)failure));
            callSiteArray[21].call((Object)tags, (Object)"reason", object);
        }
        callSiteArray[22].call(callSiteArray[23].call((Object)this.spectatorRegistry, callSiteArray[24].call((Object)this.spectatorRegistry, (Object)"kubernetes.api", (Object)tags)), callSiteArray[25].call(callSiteArray[26].call((Object)this.spectatorClock), (Object)startTime), callSiteArray[27].callGetProperty(TimeUnit.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)failure)) {
            throw (Throwable)failure;
        }
        return (T)result;
    }

    /*
     * WARNING - void declaration
     */
    public List<Event> getEvents(String namespace, HasMetadata object) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference object2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getEvents_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference object;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getEvents_closure1(Object _outerInstance, Object _thisObject, Reference namespace, Reference object) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getEvents_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.object = reference = object;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getEvents_closure1.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), (Object)"involvedObject.uid", callSiteArray[6].callGetProperty(callSiteArray[7].callGetProperty(this.object.get())))));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getEvents_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public HasMetadata getObject() {
                CallSite[] callSiteArray = _getEvents_closure1.$getCallSiteArray();
                return (HasMetadata)ScriptBytecodeAdapter.castToType((Object)this.object.get(), HasMetadata.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getEvents_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getEvents_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "withField";
                stringArray[3] = "inNamespace";
                stringArray[4] = "events";
                stringArray[5] = "client";
                stringArray[6] = "uid";
                stringArray[7] = "metadata";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _getEvents_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getEvents_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getEvents_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].callCurrent((GroovyObject)this, (Object)"events.list", (Object)"Get Events", (Object)((String)namespace2.get()), (Object)new _getEvents_closure1(this, this, namespace2, object2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, List<Event>> getEvents(String namespace, String type) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference type2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getEvents_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference type;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getEvents_closure2(Object _outerInstance, Object _thisObject, Reference namespace, Reference type) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getEvents_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.type = reference = type;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getEvents_closure2.$getCallSiteArray();
                Object events = callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), (Object)"involvedObject.kind", this.type.get())));
                public class _closure63
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure63(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure63.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object _) {
                        CallSite[] callSiteArray = _closure63.$getCallSiteArray();
                        return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure63.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_closure63.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure63.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Reference eventMap = new Reference(callSiteArray[6].call((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (Object)new _closure63((Object)this, this.getThisObject())));
                public class _closure64
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference eventMap;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure64(Object _outerInstance, Object _thisObject, Reference eventMap) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure64.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.eventMap = reference = eventMap;
                    }

                    public Object doCall(Event event) {
                        CallSite[] callSiteArray = _closure64.$getCallSiteArray();
                        Object object = this.eventMap.get();
                        Object object2 = callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty((Object)event));
                        Object object3 = callSiteArray[3].call(callSiteArray[4].call(object, object2), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{event}));
                        callSiteArray[0].call(object, object2, object3);
                        return object3;
                    }

                    public Object call(Event event) {
                        CallSite[] callSiteArray = _closure64.$getCallSiteArray();
                        return callSiteArray[5].callCurrent((GroovyObject)this, (Object)event);
                    }

                    public Object getEventMap() {
                        CallSite[] callSiteArray = _closure64.$getCallSiteArray();
                        return this.eventMap.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure64.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "putAt";
                        stringArray[1] = "name";
                        stringArray[2] = "involvedObject";
                        stringArray[3] = "plus";
                        stringArray[4] = "getAt";
                        stringArray[5] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[6];
                        _closure64.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure64.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure64.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[7].call(events, (Object)new _closure64((Object)this, this.getThisObject(), eventMap));
                return eventMap.get();
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getEvents_closure2.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getType() {
                CallSite[] callSiteArray = _getEvents_closure2.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.type.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getEvents_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getEvents_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "withField";
                stringArray[3] = "inNamespace";
                stringArray[4] = "events";
                stringArray[5] = "client";
                stringArray[6] = "withDefault";
                stringArray[7] = "each";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _getEvents_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getEvents_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getEvents_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].callCurrent((GroovyObject)this, (Object)"events.list", (Object)"Get Events", (Object)((String)namespace2.get()), (Object)new _getEvents_closure2(this, this, namespace2, type2)), Map.class);
    }

    /*
     * WARNING - void declaration
     */
    public Ingress createIngress(String namespace, Ingress ingress) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference ingress2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _createIngress_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference ingress;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createIngress_closure3(Object _outerInstance, Object _thisObject, Reference namespace, Reference ingress) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createIngress_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.ingress = reference = ingress;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createIngress_closure3.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.ingress.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _createIngress_closure3.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Ingress getIngress() {
                CallSite[] callSiteArray = _createIngress_closure3.$getCallSiteArray();
                return (Ingress)ScriptBytecodeAdapter.castToType((Object)this.ingress.get(), Ingress.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createIngress_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createIngress_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "create";
                stringArray[1] = "inNamespace";
                stringArray[2] = "ingresses";
                stringArray[3] = "extensions";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _createIngress_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createIngress_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createIngress_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Ingress)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].callCurrent((GroovyObject)this, (Object)"ingresses.create", (Object)new GStringImpl(new Object[]{callSiteArray[40].callGetPropertySafe(callSiteArray[41].callGetPropertySafe((Object)((Ingress)ingress2.get())))}, new String[]{"Create Ingress ", ""}), (Object)((String)namespace2.get()), (Object)new _createIngress_closure3(this, this, namespace2, ingress2)), Ingress.class);
    }

    /*
     * WARNING - void declaration
     */
    public Ingress replaceIngress(String namespace, String name, Ingress ingress) {
        void var3_3;
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        Reference ingress2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _replaceIngress_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference ingress;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _replaceIngress_closure4(Object _outerInstance, Object _thisObject, Reference namespace, Reference name, Reference ingress) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _replaceIngress_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference3 = namespace;
                this.name = reference2 = name;
                this.ingress = reference = ingress;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _replaceIngress_closure4.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()), this.ingress.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _replaceIngress_closure4.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _replaceIngress_closure4.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Ingress getIngress() {
                CallSite[] callSiteArray = _replaceIngress_closure4.$getCallSiteArray();
                return (Ingress)ScriptBytecodeAdapter.castToType((Object)this.ingress.get(), Ingress.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _replaceIngress_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _replaceIngress_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "replace";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "ingresses";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _replaceIngress_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_replaceIngress_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _replaceIngress_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Ingress)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].callCurrent((GroovyObject)this, (Object)"ingresses.replace", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Replace Ingress ", ""}), (Object)((String)namespace2.get()), (Object)new _replaceIngress_closure4(this, this, namespace2, name2, ingress2)), Ingress.class);
    }

    /*
     * WARNING - void declaration
     */
    public Ingress getIngress(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getIngress_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getIngress_closure5(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getIngress_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getIngress_closure5.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getIngress_closure5.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _getIngress_closure5.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getIngress_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getIngress_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "ingresses";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getIngress_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getIngress_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getIngress_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Ingress)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].callCurrent((GroovyObject)this, (Object)"ingresses.get", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Get Ingress ", ""}), (Object)((String)namespace2.get()), (Object)new _getIngress_closure5(this, this, namespace2, name2)), Ingress.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean deleteIngress(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _deleteIngress_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deleteIngress_closure6(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _deleteIngress_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _deleteIngress_closure6.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _deleteIngress_closure6.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _deleteIngress_closure6.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _deleteIngress_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteIngress_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "delete";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "ingresses";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _deleteIngress_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deleteIngress_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deleteIngress_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[44].callCurrent((GroovyObject)this, (Object)"ingresses.delete", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Delete Ingress ", ""}), (Object)((String)namespace2.get()), (Object)new _deleteIngress_closure6(this, this, namespace2, name2)));
    }

    public List<Ingress> getIngresses(String namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getIngresses_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getIngresses_closure7(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _getIngresses_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getIngresses_closure7.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getIngresses_closure7.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getIngresses_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getIngresses_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "inNamespace";
                stringArray[3] = "ingresses";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getIngresses_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getIngresses_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getIngresses_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].callCurrent((GroovyObject)this, (Object)"ingresses.list", (Object)"Get Ingresses", (Object)((String)namespace2.get()), (Object)new _getIngresses_closure7(this, this, namespace2)), List.class);
    }

    public List<ReplicaSet> getReplicaSets(String namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getReplicaSets_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getReplicaSets_closure8(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _getReplicaSets_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getReplicaSets_closure8.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getReplicaSets_closure8.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getReplicaSets_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getReplicaSets_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "inNamespace";
                stringArray[3] = "replicaSets";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getReplicaSets_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getReplicaSets_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getReplicaSets_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].callCurrent((GroovyObject)this, (Object)"replicaSets.list", (Object)"Get Replica Sets", (Object)((String)namespace2.get()), (Object)new _getReplicaSets_closure8(this, this, namespace2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public List<ReplicaSet> getReplicaSets(String namespace, Map<String, String> labels) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference labels2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getReplicaSets_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference labels;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getReplicaSets_closure9(Object _outerInstance, Object _thisObject, Reference namespace, Reference labels) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getReplicaSets_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.labels = reference = labels;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getReplicaSets_closure9.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.labels.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getReplicaSets_closure9.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Map getLabels() {
                CallSite[] callSiteArray = _getReplicaSets_closure9.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.labels.get(), Map.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getReplicaSets_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getReplicaSets_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "withLabels";
                stringArray[3] = "inNamespace";
                stringArray[4] = "replicaSets";
                stringArray[5] = "extensions";
                stringArray[6] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _getReplicaSets_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getReplicaSets_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getReplicaSets_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].callCurrent((GroovyObject)this, (Object)"replicaSets.list", (Object)"Get Replica Sets", (Object)((String)namespace2.get()), (Object)new _getReplicaSets_closure9(this, this, namespace2, labels2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hardDestroyReplicaSet(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _hardDestroyReplicaSet_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _hardDestroyReplicaSet_closure10(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _hardDestroyReplicaSet_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _hardDestroyReplicaSet_closure10.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _hardDestroyReplicaSet_closure10.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _hardDestroyReplicaSet_closure10.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _hardDestroyReplicaSet_closure10.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _hardDestroyReplicaSet_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "delete";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "replicaSets";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _hardDestroyReplicaSet_closure10.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_hardDestroyReplicaSet_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _hardDestroyReplicaSet_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].callCurrent((GroovyObject)this, (Object)"replicaSets.delete", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Hard Destroy Replica Set ", ""}), (Object)((String)namespace2.get()), (Object)new _hardDestroyReplicaSet_closure10(this, this, namespace2, name2)));
    }

    /*
     * WARNING - void declaration
     */
    public List<Pod> getReplicaSetPods(String namespace, String replicaSetName) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference replicaSetName2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getReplicaSetPods_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference replicaSetName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getReplicaSetPods_closure11(Object _outerInstance, Object _thisObject, Reference namespace, Reference replicaSetName) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getReplicaSetPods_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.replicaSetName = reference = replicaSetName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getReplicaSetPods_closure11.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), callSiteArray[6].callGetProperty(KubernetesUtil.class), this.replicaSetName.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getReplicaSetPods_closure11.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getReplicaSetName() {
                CallSite[] callSiteArray = _getReplicaSetPods_closure11.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.replicaSetName.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getReplicaSetPods_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getReplicaSetPods_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "withLabel";
                stringArray[3] = "inNamespace";
                stringArray[4] = "pods";
                stringArray[5] = "client";
                stringArray[6] = "SERVER_GROUP_LABEL";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _getReplicaSetPods_closure11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getReplicaSetPods_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getReplicaSetPods_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].callCurrent((GroovyObject)this, (Object)"pods.list", (Object)new GStringImpl(new Object[]{(String)replicaSetName2.get()}, new String[]{"Get Replica Set Pods for ", ""}), (Object)((String)namespace2.get()), (Object)new _getReplicaSetPods_closure11(this, this, namespace2, replicaSetName2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaSet getReplicaSet(String namespace, String serverGroupName) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference serverGroupName2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getReplicaSet_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference serverGroupName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getReplicaSet_closure12(Object _outerInstance, Object _thisObject, Reference namespace, Reference serverGroupName) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getReplicaSet_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.serverGroupName = reference = serverGroupName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getReplicaSet_closure12.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.serverGroupName.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getReplicaSet_closure12.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getServerGroupName() {
                CallSite[] callSiteArray = _getReplicaSet_closure12.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.serverGroupName.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getReplicaSet_closure12.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getReplicaSet_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "replicaSets";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getReplicaSet_closure12.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getReplicaSet_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getReplicaSet_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (ReplicaSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].callCurrent((GroovyObject)this, (Object)"replicaSets.get", (Object)new GStringImpl(new Object[]{(String)serverGroupName2.get()}, new String[]{"Get Replica Set ", ""}), (Object)((String)namespace2.get()), (Object)new _getReplicaSet_closure12(this, this, namespace2, serverGroupName2)), ReplicaSet.class);
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaSet resizeReplicaSet(String namespace, String name, int size) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        Reference size2 = new Reference((Object)size);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _resizeReplicaSet_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference size;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _resizeReplicaSet_closure13(Object _outerInstance, Object _thisObject, Reference namespace, Reference name, Reference size) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _resizeReplicaSet_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference3 = namespace;
                this.name = reference2 = name;
                this.size = reference = size;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _resizeReplicaSet_closure13.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()), this.size.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _resizeReplicaSet_closure13.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _resizeReplicaSet_closure13.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public int getSize() {
                CallSite[] callSiteArray = _resizeReplicaSet_closure13.$getCallSiteArray();
                return DefaultTypeTransformation.intUnbox((Object)this.size.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _resizeReplicaSet_closure13.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resizeReplicaSet_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "scale";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "replicaSets";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _resizeReplicaSet_closure13.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_resizeReplicaSet_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resizeReplicaSet_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (ReplicaSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callCurrent((GroovyObject)this, (Object)"replicaSets.scale", (Object)new GStringImpl(new Object[]{(String)name2.get(), DefaultTypeTransformation.intUnbox((Object)size2.get())}, new String[]{"Resize Replica Set ", " to ", ""}), (Object)((String)namespace2.get()), (Object)new _resizeReplicaSet_closure13(this, this, namespace2, name2, size2)), ReplicaSet.class);
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaSet createReplicaSet(String namespace, ReplicaSet replicaSet) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference replicaSet2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _createReplicaSet_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference replicaSet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createReplicaSet_closure14(Object _outerInstance, Object _thisObject, Reference namespace, Reference replicaSet) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createReplicaSet_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.replicaSet = reference = replicaSet;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createReplicaSet_closure14.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.replicaSet.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _createReplicaSet_closure14.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public ReplicaSet getReplicaSet() {
                CallSite[] callSiteArray = _createReplicaSet_closure14.$getCallSiteArray();
                return (ReplicaSet)ScriptBytecodeAdapter.castToType((Object)this.replicaSet.get(), ReplicaSet.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createReplicaSet_closure14.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createReplicaSet_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "create";
                stringArray[1] = "inNamespace";
                stringArray[2] = "replicaSets";
                stringArray[3] = "extensions";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _createReplicaSet_closure14.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createReplicaSet_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createReplicaSet_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (ReplicaSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].callCurrent((GroovyObject)this, (Object)"replicaSets.create", (Object)new GStringImpl(new Object[]{callSiteArray[53].callGetPropertySafe(callSiteArray[54].callGetPropertySafe((Object)((ReplicaSet)replicaSet2.get())))}, new String[]{"Create Replica Set ", ""}), (Object)((String)namespace2.get()), (Object)new _createReplicaSet_closure14(this, this, namespace2, replicaSet2)), ReplicaSet.class);
    }

    /*
     * WARNING - void declaration
     */
    public List<Pod> getJobPods(String namespace, String jobName) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference jobName2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getJobPods_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference jobName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getJobPods_closure15(Object _outerInstance, Object _thisObject, Reference namespace, Reference jobName) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getJobPods_closure15.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.jobName = reference = jobName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getJobPods_closure15.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), callSiteArray[6].callGetProperty(KubernetesUtil.class), this.jobName.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getJobPods_closure15.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getJobName() {
                CallSite[] callSiteArray = _getJobPods_closure15.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.jobName.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getJobPods_closure15.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getJobPods_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "withLabel";
                stringArray[3] = "inNamespace";
                stringArray[4] = "pods";
                stringArray[5] = "client";
                stringArray[6] = "JOB_LABEL";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _getJobPods_closure15.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getJobPods_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getJobPods_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].callCurrent((GroovyObject)this, (Object)"pods.list", (Object)new GStringImpl(new Object[]{(String)jobName2.get()}, new String[]{"Get JobStatus Pods for ", ""}), (Object)((String)namespace2.get()), (Object)new _getJobPods_closure15(this, this, namespace2, jobName2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public Pod getPod(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getPod_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getPod_closure16(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getPod_closure16.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getPod_closure16.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getPod_closure16.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _getPod_closure16.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getPod_closure16.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPod_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "pods";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getPod_closure16.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getPod_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getPod_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Pod)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].callCurrent((GroovyObject)this, (Object)"pods.get", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Get Pod ", ""}), (Object)((String)namespace2.get()), (Object)new _getPod_closure16(this, this, namespace2, name2)), Pod.class);
    }

    /*
     * WARNING - void declaration
     */
    public List<Pod> getPods(String namespace, Map<String, String> labels) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference labels2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getPods_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference labels;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getPods_closure17(Object _outerInstance, Object _thisObject, Reference namespace, Reference labels) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getPods_closure17.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.labels = reference = labels;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getPods_closure17.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.labels.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getPods_closure17.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Map getLabels() {
                CallSite[] callSiteArray = _getPods_closure17.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.labels.get(), Map.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getPods_closure17.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPods_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "withLabels";
                stringArray[3] = "inNamespace";
                stringArray[4] = "pods";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getPods_closure17.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getPods_closure17.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getPods_closure17.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].callCurrent((GroovyObject)this, (Object)"pods.list", (Object)new GStringImpl(new Object[]{(Map)labels2.get()}, new String[]{"Get Pods matching ", ""}), (Object)((String)namespace2.get()), (Object)new _getPods_closure17(this, this, namespace2, labels2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean deletePod(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _deletePod_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deletePod_closure18(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _deletePod_closure18.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _deletePod_closure18.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _deletePod_closure18.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _deletePod_closure18.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _deletePod_closure18.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deletePod_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "delete";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "pods";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _deletePod_closure18.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deletePod_closure18.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deletePod_closure18.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].callCurrent((GroovyObject)this, (Object)"pods.delete", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Delete Pod ", ""}), (Object)((String)namespace2.get()), (Object)new _deletePod_closure18(this, this, namespace2, name2)));
    }

    public List<Pod> getPods(String namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getPods_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getPods_closure19(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _getPods_closure19.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getPods_closure19.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getPods_closure19.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getPods_closure19.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPods_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "inNamespace";
                stringArray[3] = "pods";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getPods_closure19.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getPods_closure19.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getPods_closure19.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].callCurrent((GroovyObject)this, (Object)"pods.list", (Object)"Get Pods", (Object)((String)namespace2.get()), (Object)new _getPods_closure19(this, this, namespace2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public String getLog(String namespace, String name, String containerId) {
        void var3_3;
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        Reference containerId2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getLog_closure20
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference containerId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getLog_closure20(Object _outerInstance, Object _thisObject, Reference namespace, Reference name, Reference containerId) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _getLog_closure20.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference3 = namespace;
                this.name = reference2 = name;
                this.containerId = reference = containerId;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getLog_closure20.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.name.get()), this.containerId.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getLog_closure20.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _getLog_closure20.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getContainerId() {
                CallSite[] callSiteArray = _getLog_closure20.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.containerId.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getLog_closure20.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getLog_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getLog";
                stringArray[1] = "inContainer";
                stringArray[2] = "withName";
                stringArray[3] = "inNamespace";
                stringArray[4] = "pods";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getLog_closure20.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getLog_closure20.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getLog_closure20.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[60].callCurrent((GroovyObject)this, (Object)"pod.logs", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Get Logs ", ""}), (Object)((String)namespace2.get()), (Object)new _getLog_closure20(this, this, namespace2, name2, containerId2)));
    }

    public List<ReplicationController> getReplicationControllers(String namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getReplicationControllers_closure21
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getReplicationControllers_closure21(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _getReplicationControllers_closure21.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getReplicationControllers_closure21.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getReplicationControllers_closure21.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getReplicationControllers_closure21.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getReplicationControllers_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "inNamespace";
                stringArray[3] = "replicationControllers";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getReplicationControllers_closure21.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getReplicationControllers_closure21.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getReplicationControllers_closure21.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callCurrent((GroovyObject)this, (Object)"replicationControllers.list", (Object)"Get Replication Controllers", (Object)((String)namespace2.get()), (Object)new _getReplicationControllers_closure21(this, this, namespace2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public List<Pod> getReplicationControllerPods(String namespace, String replicationControllerName) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference replicationControllerName2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getReplicationControllerPods_closure22
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference replicationControllerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getReplicationControllerPods_closure22(Object _outerInstance, Object _thisObject, Reference namespace, Reference replicationControllerName) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getReplicationControllerPods_closure22.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.replicationControllerName = reference = replicationControllerName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getReplicationControllerPods_closure22.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), callSiteArray[6].callGetProperty(KubernetesUtil.class), this.replicationControllerName.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getReplicationControllerPods_closure22.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getReplicationControllerName() {
                CallSite[] callSiteArray = _getReplicationControllerPods_closure22.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.replicationControllerName.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getReplicationControllerPods_closure22.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getReplicationControllerPods_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "withLabel";
                stringArray[3] = "inNamespace";
                stringArray[4] = "pods";
                stringArray[5] = "client";
                stringArray[6] = "SERVER_GROUP_LABEL";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _getReplicationControllerPods_closure22.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getReplicationControllerPods_closure22.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getReplicationControllerPods_closure22.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].callCurrent((GroovyObject)this, (Object)"pods.list", (Object)new GStringImpl(new Object[]{(String)replicationControllerName2.get()}, new String[]{"Get Replication Controller Pods for ", ""}), (Object)((String)namespace2.get()), (Object)new _getReplicationControllerPods_closure22(this, this, namespace2, replicationControllerName2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public ReplicationController getReplicationController(String namespace, String serverGroupName) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference serverGroupName2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getReplicationController_closure23
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference serverGroupName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getReplicationController_closure23(Object _outerInstance, Object _thisObject, Reference namespace, Reference serverGroupName) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getReplicationController_closure23.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.serverGroupName = reference = serverGroupName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getReplicationController_closure23.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.serverGroupName.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getReplicationController_closure23.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getServerGroupName() {
                CallSite[] callSiteArray = _getReplicationController_closure23.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.serverGroupName.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getReplicationController_closure23.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getReplicationController_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "replicationControllers";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getReplicationController_closure23.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getReplicationController_closure23.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getReplicationController_closure23.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (ReplicationController)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].callCurrent((GroovyObject)this, (Object)"replicationControllers.get", (Object)new GStringImpl(new Object[]{(String)serverGroupName2.get()}, new String[]{"Get Replication Controller ", ""}), (Object)((String)namespace2.get()), (Object)new _getReplicationController_closure23(this, this, namespace2, serverGroupName2)), ReplicationController.class);
    }

    /*
     * WARNING - void declaration
     */
    public ReplicationController createReplicationController(String namespace, ReplicationController replicationController) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference replicationController2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _createReplicationController_closure24
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference replicationController;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createReplicationController_closure24(Object _outerInstance, Object _thisObject, Reference namespace, Reference replicationController) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createReplicationController_closure24.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.replicationController = reference = replicationController;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createReplicationController_closure24.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.replicationController.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _createReplicationController_closure24.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public ReplicationController getReplicationController() {
                CallSite[] callSiteArray = _createReplicationController_closure24.$getCallSiteArray();
                return (ReplicationController)ScriptBytecodeAdapter.castToType((Object)this.replicationController.get(), ReplicationController.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createReplicationController_closure24.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createReplicationController_closure24.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "create";
                stringArray[1] = "inNamespace";
                stringArray[2] = "replicationControllers";
                stringArray[3] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _createReplicationController_closure24.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createReplicationController_closure24.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createReplicationController_closure24.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (ReplicationController)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].callCurrent((GroovyObject)this, (Object)"replicationControllers.create", (Object)new GStringImpl(new Object[]{callSiteArray[65].callGetPropertySafe(callSiteArray[66].callGetPropertySafe((Object)((ReplicationController)replicationController2.get())))}, new String[]{"Create Replication Controller ", ""}), (Object)((String)namespace2.get()), (Object)new _createReplicationController_closure24(this, this, namespace2, replicationController2)), ReplicationController.class);
    }

    /*
     * WARNING - void declaration
     */
    public ReplicationController resizeReplicationController(String namespace, String name, int size) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        Reference size2 = new Reference((Object)size);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _resizeReplicationController_closure25
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference size;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _resizeReplicationController_closure25(Object _outerInstance, Object _thisObject, Reference namespace, Reference name, Reference size) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _resizeReplicationController_closure25.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference3 = namespace;
                this.name = reference2 = name;
                this.size = reference = size;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _resizeReplicationController_closure25.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.name.get()), this.size.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _resizeReplicationController_closure25.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _resizeReplicationController_closure25.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public int getSize() {
                CallSite[] callSiteArray = _resizeReplicationController_closure25.$getCallSiteArray();
                return DefaultTypeTransformation.intUnbox((Object)this.size.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _resizeReplicationController_closure25.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resizeReplicationController_closure25.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "scale";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "replicationControllers";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _resizeReplicationController_closure25.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_resizeReplicationController_closure25.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resizeReplicationController_closure25.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (ReplicationController)ScriptBytecodeAdapter.castToType((Object)callSiteArray[67].callCurrent((GroovyObject)this, (Object)"replicationControllers.scale", (Object)new GStringImpl(new Object[]{(String)name2.get(), DefaultTypeTransformation.intUnbox((Object)size2.get())}, new String[]{"Resize Replication Controller ", " to ", ""}), (Object)((String)namespace2.get()), (Object)new _resizeReplicationController_closure25(this, this, namespace2, name2, size2)), ReplicationController.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hardDestroyReplicationController(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _hardDestroyReplicationController_closure26
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _hardDestroyReplicationController_closure26(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _hardDestroyReplicationController_closure26.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _hardDestroyReplicationController_closure26.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _hardDestroyReplicationController_closure26.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _hardDestroyReplicationController_closure26.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _hardDestroyReplicationController_closure26.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _hardDestroyReplicationController_closure26.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "delete";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "replicationControllers";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _hardDestroyReplicationController_closure26.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_hardDestroyReplicationController_closure26.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _hardDestroyReplicationController_closure26.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[68].callCurrent((GroovyObject)this, (Object)"replicationControllers.delete", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Hard Destroy Replication Controller ", ""}), (Object)((String)namespace2.get()), (Object)new _hardDestroyReplicationController_closure26(this, this, namespace2, name2)));
    }

    /*
     * WARNING - void declaration
     */
    public void togglePodLabels(String namespace, String name, List<String> keys, String value) {
        void var3_3;
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        Reference keys2 = new Reference((Object)var3_3);
        Reference value2 = new Reference((Object)value);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _togglePodLabels_closure27
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference keys;
            private /* synthetic */ Reference value;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _togglePodLabels_closure27(Object _outerInstance, Object _thisObject, Reference namespace, Reference name, Reference keys, Reference value) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _togglePodLabels_closure27.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference4 = namespace;
                this.name = reference3 = name;
                this.keys = reference2 = keys;
                this.value = reference = value;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _togglePodLabels_closure27.$getCallSiteArray();
                Reference edit = new Reference(callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.name.get()))));
                public class _closure65
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference edit;
                    private /* synthetic */ Reference value;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure65(Object _outerInstance, Object _thisObject, Reference edit, Reference value) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure65.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.edit = reference2 = edit;
                        this.value = reference = value;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure65.$getCallSiteArray();
                        callSiteArray[0].call(this.edit.get(), callSiteArray[1].call(it));
                        return callSiteArray[2].call(this.edit.get(), callSiteArray[3].call(it), callSiteArray[4].call(this.value.get()));
                    }

                    public Object getEdit() {
                        CallSite[] callSiteArray = _closure65.$getCallSiteArray();
                        return this.edit.get();
                    }

                    public String getValue() {
                        CallSite[] callSiteArray = _closure65.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.value.get());
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure65.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure65.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "removeFromLabels";
                        stringArray[1] = "toString";
                        stringArray[2] = "addToLabels";
                        stringArray[3] = "toString";
                        stringArray[4] = "toString";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _closure65.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure65.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure65.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[6].call(this.keys.get(), (Object)new _closure65((Object)this, this.getThisObject(), edit, this.value));
                return callSiteArray[7].call(callSiteArray[8].call(edit.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _togglePodLabels_closure27.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _togglePodLabels_closure27.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public List getKeys() {
                CallSite[] callSiteArray = _togglePodLabels_closure27.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.keys.get(), List.class);
            }

            public String getValue() {
                CallSite[] callSiteArray = _togglePodLabels_closure27.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.value.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _togglePodLabels_closure27.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _togglePodLabels_closure27.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "editMetadata";
                stringArray[1] = "edit";
                stringArray[2] = "withName";
                stringArray[3] = "inNamespace";
                stringArray[4] = "pods";
                stringArray[5] = "client";
                stringArray[6] = "each";
                stringArray[7] = "done";
                stringArray[8] = "endMetadata";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[9];
                _togglePodLabels_closure27.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_togglePodLabels_closure27.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _togglePodLabels_closure27.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[69].callCurrent((GroovyObject)this, (Object)"pods.edit", (Object)new GStringImpl(new Object[]{(String)value2.get(), (String)name2.get()}, new String[]{"Toggle Pod Labels to ", " for ", ""}), (Object)((String)namespace2.get()), (Object)new _togglePodLabels_closure27(this, this, namespace2, name2, keys2, value2));
    }

    /*
     * WARNING - void declaration
     */
    public ReplicationController toggleReplicationControllerSpecLabels(String namespace, String name, List<String> keys, String value) {
        void var3_3;
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        Reference keys2 = new Reference((Object)var3_3);
        Reference value2 = new Reference((Object)value);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _toggleReplicationControllerSpecLabels_closure28
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference keys;
            private /* synthetic */ Reference value;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _toggleReplicationControllerSpecLabels_closure28(Object _outerInstance, Object _thisObject, Reference namespace, Reference name, Reference keys, Reference value) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _toggleReplicationControllerSpecLabels_closure28.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference4 = namespace;
                this.name = reference3 = name;
                this.keys = reference2 = keys;
                this.value = reference = value;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _toggleReplicationControllerSpecLabels_closure28.$getCallSiteArray();
                Reference edit = new Reference(callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.name.get()), (Object)false))))));
                public class _closure66
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference edit;
                    private /* synthetic */ Reference value;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure66(Object _outerInstance, Object _thisObject, Reference edit, Reference value) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure66.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.edit = reference2 = edit;
                        this.value = reference = value;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure66.$getCallSiteArray();
                        callSiteArray[0].call(this.edit.get(), callSiteArray[1].call(it));
                        return callSiteArray[2].call(this.edit.get(), callSiteArray[3].call(it), callSiteArray[4].call(this.value.get()));
                    }

                    public Object getEdit() {
                        CallSite[] callSiteArray = _closure66.$getCallSiteArray();
                        return this.edit.get();
                    }

                    public String getValue() {
                        CallSite[] callSiteArray = _closure66.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.value.get());
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure66.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure66.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "removeFromLabels";
                        stringArray[1] = "toString";
                        stringArray[2] = "addToLabels";
                        stringArray[3] = "toString";
                        stringArray[4] = "toString";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _closure66.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure66.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure66.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[9].call(this.keys.get(), (Object)new _closure66((Object)this, this.getThisObject(), edit, this.value));
                return callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(edit.get()))));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _toggleReplicationControllerSpecLabels_closure28.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _toggleReplicationControllerSpecLabels_closure28.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public List getKeys() {
                CallSite[] callSiteArray = _toggleReplicationControllerSpecLabels_closure28.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.keys.get(), List.class);
            }

            public String getValue() {
                CallSite[] callSiteArray = _toggleReplicationControllerSpecLabels_closure28.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.value.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _toggleReplicationControllerSpecLabels_closure28.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toggleReplicationControllerSpecLabels_closure28.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "editMetadata";
                stringArray[1] = "editTemplate";
                stringArray[2] = "editSpec";
                stringArray[3] = "edit";
                stringArray[4] = "cascading";
                stringArray[5] = "withName";
                stringArray[6] = "inNamespace";
                stringArray[7] = "replicationControllers";
                stringArray[8] = "client";
                stringArray[9] = "each";
                stringArray[10] = "done";
                stringArray[11] = "endSpec";
                stringArray[12] = "endTemplate";
                stringArray[13] = "endMetadata";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[14];
                _toggleReplicationControllerSpecLabels_closure28.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_toggleReplicationControllerSpecLabels_closure28.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _toggleReplicationControllerSpecLabels_closure28.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (ReplicationController)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].callCurrent((GroovyObject)this, (Object)"replicationControllers.edit", (Object)new GStringImpl(new Object[]{(String)value2.get(), (String)name2.get()}, new String[]{"Toggle Replication Controller Labels to ", " for ", ""}), (Object)((String)namespace2.get()), (Object)new _toggleReplicationControllerSpecLabels_closure28(this, this, namespace2, name2, keys2, value2)), ReplicationController.class);
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaSet toggleReplicaSetSpecLabels(String namespace, String name, List<String> keys, String value) {
        void var3_3;
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        Reference keys2 = new Reference((Object)var3_3);
        Reference value2 = new Reference((Object)value);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _toggleReplicaSetSpecLabels_closure29
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference keys;
            private /* synthetic */ Reference value;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _toggleReplicaSetSpecLabels_closure29(Object _outerInstance, Object _thisObject, Reference namespace, Reference name, Reference keys, Reference value) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _toggleReplicaSetSpecLabels_closure29.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference4 = namespace;
                this.name = reference3 = name;
                this.keys = reference2 = keys;
                this.value = reference = value;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _toggleReplicaSetSpecLabels_closure29.$getCallSiteArray();
                Reference edit = new Reference(callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()), (Object)false))))));
                public class _closure67
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference edit;
                    private /* synthetic */ Reference value;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure67(Object _outerInstance, Object _thisObject, Reference edit, Reference value) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure67.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.edit = reference2 = edit;
                        this.value = reference = value;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure67.$getCallSiteArray();
                        callSiteArray[0].call(this.edit.get(), callSiteArray[1].call(it));
                        return callSiteArray[2].call(this.edit.get(), callSiteArray[3].call(it), callSiteArray[4].call(this.value.get()));
                    }

                    public Object getEdit() {
                        CallSite[] callSiteArray = _closure67.$getCallSiteArray();
                        return this.edit.get();
                    }

                    public String getValue() {
                        CallSite[] callSiteArray = _closure67.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.value.get());
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure67.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure67.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "removeFromLabels";
                        stringArray[1] = "toString";
                        stringArray[2] = "addToLabels";
                        stringArray[3] = "toString";
                        stringArray[4] = "toString";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _closure67.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure67.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure67.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[10].call(this.keys.get(), (Object)new _closure67((Object)this, this.getThisObject(), edit, this.value));
                return callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call(edit.get()))));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _toggleReplicaSetSpecLabels_closure29.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _toggleReplicaSetSpecLabels_closure29.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public List getKeys() {
                CallSite[] callSiteArray = _toggleReplicaSetSpecLabels_closure29.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.keys.get(), List.class);
            }

            public String getValue() {
                CallSite[] callSiteArray = _toggleReplicaSetSpecLabels_closure29.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.value.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _toggleReplicaSetSpecLabels_closure29.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toggleReplicaSetSpecLabels_closure29.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "editMetadata";
                stringArray[1] = "editTemplate";
                stringArray[2] = "editSpec";
                stringArray[3] = "edit";
                stringArray[4] = "cascading";
                stringArray[5] = "withName";
                stringArray[6] = "inNamespace";
                stringArray[7] = "replicaSets";
                stringArray[8] = "extensions";
                stringArray[9] = "client";
                stringArray[10] = "each";
                stringArray[11] = "done";
                stringArray[12] = "endSpec";
                stringArray[13] = "endTemplate";
                stringArray[14] = "endMetadata";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[15];
                _toggleReplicaSetSpecLabels_closure29.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_toggleReplicaSetSpecLabels_closure29.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _toggleReplicaSetSpecLabels_closure29.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (ReplicaSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].callCurrent((GroovyObject)this, (Object)"replicaSets.edit", (Object)new GStringImpl(new Object[]{(String)value2.get(), (String)name2.get()}, new String[]{"Toggle Replica Set Labels to ", " for ", ""}), (Object)((String)namespace2.get()), (Object)new _toggleReplicaSetSpecLabels_closure29(this, this, namespace2, name2, keys2, value2)), ReplicaSet.class);
    }

    /*
     * WARNING - void declaration
     */
    public Service getService(String namespace, String service) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference service2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getService_closure30
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference service;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getService_closure30(Object _outerInstance, Object _thisObject, Reference namespace, Reference service) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getService_closure30.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.service = reference = service;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getService_closure30.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.service.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getService_closure30.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getService() {
                CallSite[] callSiteArray = _getService_closure30.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.service.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getService_closure30.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getService_closure30.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "services";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getService_closure30.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getService_closure30.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getService_closure30.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Service)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].callCurrent((GroovyObject)this, (Object)"services.get", (Object)new GStringImpl(new Object[]{(String)service2.get()}, new String[]{"Get Service ", ""}), (Object)((String)namespace2.get()), (Object)new _getService_closure30(this, this, namespace2, service2)), Service.class);
    }

    /*
     * WARNING - void declaration
     */
    public Service createService(String namespace, Service service) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference service2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _createService_closure31
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference service;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createService_closure31(Object _outerInstance, Object _thisObject, Reference namespace, Reference service) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createService_closure31.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.service = reference = service;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createService_closure31.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.service.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _createService_closure31.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Service getService() {
                CallSite[] callSiteArray = _createService_closure31.$getCallSiteArray();
                return (Service)ScriptBytecodeAdapter.castToType((Object)this.service.get(), Service.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createService_closure31.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createService_closure31.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "create";
                stringArray[1] = "inNamespace";
                stringArray[2] = "services";
                stringArray[3] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _createService_closure31.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createService_closure31.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createService_closure31.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Service)ScriptBytecodeAdapter.castToType((Object)callSiteArray[73].callCurrent((GroovyObject)this, (Object)"services.create", (Object)new GStringImpl(new Object[]{(Service)service2.get()}, new String[]{"Create Service ", ""}), (Object)((String)namespace2.get()), (Object)new _createService_closure31(this, this, namespace2, service2)), Service.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean deleteService(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _deleteService_closure32
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deleteService_closure32(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _deleteService_closure32.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _deleteService_closure32.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _deleteService_closure32.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _deleteService_closure32.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _deleteService_closure32.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteService_closure32.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "delete";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "services";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _deleteService_closure32.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deleteService_closure32.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deleteService_closure32.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[74].callCurrent((GroovyObject)this, (Object)"services.delete", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Delete Service ", ""}), (Object)((String)namespace2.get()), (Object)new _deleteService_closure32(this, this, namespace2, name2)));
    }

    public List<Service> getServices(String namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getServices_closure33
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getServices_closure33(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _getServices_closure33.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getServices_closure33.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getServices_closure33.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getServices_closure33.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getServices_closure33.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "inNamespace";
                stringArray[3] = "services";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getServices_closure33.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getServices_closure33.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getServices_closure33.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[75].callCurrent((GroovyObject)this, (Object)"services.list", (Object)"Get Services", (Object)((String)namespace2.get()), (Object)new _getServices_closure33(this, this, namespace2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public Service replaceService(String namespace, String name, Service service) {
        void var3_3;
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        Reference service2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _replaceService_closure34
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference service;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _replaceService_closure34(Object _outerInstance, Object _thisObject, Reference namespace, Reference name, Reference service) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _replaceService_closure34.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference3 = namespace;
                this.name = reference2 = name;
                this.service = reference = service;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _replaceService_closure34.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.name.get()), this.service.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _replaceService_closure34.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _replaceService_closure34.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Service getService() {
                CallSite[] callSiteArray = _replaceService_closure34.$getCallSiteArray();
                return (Service)ScriptBytecodeAdapter.castToType((Object)this.service.get(), Service.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _replaceService_closure34.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _replaceService_closure34.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "replace";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "services";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _replaceService_closure34.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_replaceService_closure34.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _replaceService_closure34.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Service)ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].callCurrent((GroovyObject)this, (Object)"services.replace", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Replace Service ", ""}), (Object)((String)namespace2.get()), (Object)new _replaceService_closure34(this, this, namespace2, name2, service2)), Service.class);
    }

    /*
     * WARNING - void declaration
     */
    public Secret getSecret(String namespace, String secret) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference secret2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getSecret_closure35
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference secret;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getSecret_closure35(Object _outerInstance, Object _thisObject, Reference namespace, Reference secret) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getSecret_closure35.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.secret = reference = secret;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getSecret_closure35.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.secret.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getSecret_closure35.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getSecret() {
                CallSite[] callSiteArray = _getSecret_closure35.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.secret.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getSecret_closure35.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSecret_closure35.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "secrets";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getSecret_closure35.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getSecret_closure35.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getSecret_closure35.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Secret)ScriptBytecodeAdapter.castToType((Object)callSiteArray[77].callCurrent((GroovyObject)this, (Object)"secrets.get", (Object)new GStringImpl(new Object[]{(String)secret2.get()}, new String[]{"Get Secret ", ""}), (Object)((String)namespace2.get()), (Object)new _getSecret_closure35(this, this, namespace2, secret2)), Secret.class);
    }

    /*
     * WARNING - void declaration
     */
    public DoneableSecret editSecret(String namespace, String secret) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference secret2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _editSecret_closure36
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference secret;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _editSecret_closure36(Object _outerInstance, Object _thisObject, Reference namespace, Reference secret) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _editSecret_closure36.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.secret = reference = secret;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _editSecret_closure36.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.secret.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _editSecret_closure36.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getSecret() {
                CallSite[] callSiteArray = _editSecret_closure36.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.secret.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _editSecret_closure36.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _editSecret_closure36.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "edit";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "secrets";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _editSecret_closure36.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_editSecret_closure36.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _editSecret_closure36.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (DoneableSecret)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].callCurrent((GroovyObject)this, (Object)"secrets.edit", (Object)new GStringImpl(new Object[]{(String)secret2.get()}, new String[]{"Edit Secret ", ""}), (Object)((String)namespace2.get()), (Object)new _editSecret_closure36(this, this, namespace2, secret2)), DoneableSecret.class);
    }

    /*
     * WARNING - void declaration
     */
    public Secret createSecret(String namespace, Secret secret) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference secret2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _createSecret_closure37
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference secret;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createSecret_closure37(Object _outerInstance, Object _thisObject, Reference namespace, Reference secret) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createSecret_closure37.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.secret = reference = secret;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createSecret_closure37.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.secret.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _createSecret_closure37.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Secret getSecret() {
                CallSite[] callSiteArray = _createSecret_closure37.$getCallSiteArray();
                return (Secret)ScriptBytecodeAdapter.castToType((Object)this.secret.get(), Secret.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createSecret_closure37.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createSecret_closure37.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "create";
                stringArray[1] = "inNamespace";
                stringArray[2] = "secrets";
                stringArray[3] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _createSecret_closure37.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createSecret_closure37.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createSecret_closure37.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Secret)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].callCurrent((GroovyObject)this, (Object)"secrets.create", (Object)new GStringImpl(new Object[]{(Secret)secret2.get()}, new String[]{"Create Secret ", ""}), (Object)((String)namespace2.get()), (Object)new _createSecret_closure37(this, this, namespace2, secret2)), Secret.class);
    }

    public List<Secret> getSecrets(String namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getSecrets_closure38
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getSecrets_closure38(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _getSecrets_closure38.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getSecrets_closure38.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getSecrets_closure38.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getSecrets_closure38.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSecrets_closure38.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "inNamespace";
                stringArray[3] = "secrets";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getSecrets_closure38.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getSecrets_closure38.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getSecrets_closure38.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].callCurrent((GroovyObject)this, (Object)"secrets.list", (Object)"Get Secrets", (Object)((String)namespace2.get()), (Object)new _getSecrets_closure38(this, this, namespace2)), List.class);
    }

    public List<ServiceAccount> getServiceAccounts(String namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getServiceAccounts_closure39
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getServiceAccounts_closure39(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _getServiceAccounts_closure39.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getServiceAccounts_closure39.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getServiceAccounts_closure39.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getServiceAccounts_closure39.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getServiceAccounts_closure39.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "inNamespace";
                stringArray[3] = "serviceAccounts";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getServiceAccounts_closure39.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getServiceAccounts_closure39.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getServiceAccounts_closure39.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].callCurrent((GroovyObject)this, (Object)"serviceAccounts.list", (Object)"Get Service Accounts", (Object)((String)namespace2.get()), (Object)new _getServiceAccounts_closure39(this, this, namespace2)), List.class);
    }

    public List<ConfigMap> getConfigMaps(String namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getConfigMaps_closure40
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getConfigMaps_closure40(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _getConfigMaps_closure40.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getConfigMaps_closure40.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getConfigMaps_closure40.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getConfigMaps_closure40.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getConfigMaps_closure40.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "inNamespace";
                stringArray[3] = "configMaps";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getConfigMaps_closure40.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getConfigMaps_closure40.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getConfigMaps_closure40.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].callCurrent((GroovyObject)this, (Object)"configMaps.list", (Object)"Get Config Maps", (Object)((String)namespace2.get()), (Object)new _getConfigMaps_closure40(this, this, namespace2)), List.class);
    }

    public Namespace getNamespace(String namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getNamespace_closure41
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getNamespace_closure41(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _getNamespace_closure41.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getNamespace_closure41.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this)), this.namespace.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getNamespace_closure41.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getNamespace_closure41.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getNamespace_closure41.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "withName";
                stringArray[2] = "namespaces";
                stringArray[3] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _getNamespace_closure41.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getNamespace_closure41.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getNamespace_closure41.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Namespace)ScriptBytecodeAdapter.castToType((Object)callSiteArray[83].callCurrent((GroovyObject)this, (Object)"namespaces.get", (Object)new GStringImpl(new Object[]{(String)namespace2.get()}, new String[]{"Get Namespace ", ""}), null, (Object)new _getNamespace_closure41(this, this, namespace2)), Namespace.class);
    }

    public List<Namespace> getNamespaces() {
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getNamespaces_closure42
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getNamespaces_closure42(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getNamespaces_closure42.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getNamespaces_closure42.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this))));
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getNamespaces_closure42.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getNamespaces_closure42.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "namespaces";
                stringArray[3] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _getNamespaces_closure42.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getNamespaces_closure42.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getNamespaces_closure42.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[84].callCurrent((GroovyObject)this, (Object)"namespaces.list", (Object)"Get Namespaces", null, (Object)new _getNamespaces_closure42(this, this)), List.class);
    }

    public List<String> getNamespacesByName() {
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getNamespacesByName_closure43
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getNamespacesByName_closure43(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getNamespacesByName_closure43.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getNamespacesByName_closure43.$getCallSiteArray();
                public class _closure68
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure68(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure68.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure68.$getCallSiteArray();
                        return callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(it));
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure68.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure68.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "name";
                        stringArray[1] = "metadata";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure68.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure68.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure68.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)))), (Object)new _closure68((Object)this, this.getThisObject()));
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getNamespacesByName_closure43.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getNamespacesByName_closure43.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "collect";
                stringArray[1] = "items";
                stringArray[2] = "list";
                stringArray[3] = "namespaces";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getNamespacesByName_closure43.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getNamespacesByName_closure43.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getNamespacesByName_closure43.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[85].callCurrent((GroovyObject)this, (Object)"namespaces.list", (Object)"Get Namespaces", null, (Object)new _getNamespacesByName_closure43(this, this)), List.class);
    }

    public Namespace createNamespace(Namespace namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _createNamespace_closure44
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createNamespace_closure44(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _createNamespace_closure44.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createNamespace_closure44.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this)), this.namespace.get());
            }

            public Namespace getNamespace() {
                CallSite[] callSiteArray = _createNamespace_closure44.$getCallSiteArray();
                return (Namespace)ScriptBytecodeAdapter.castToType((Object)this.namespace.get(), Namespace.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createNamespace_closure44.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createNamespace_closure44.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "create";
                stringArray[1] = "namespaces";
                stringArray[2] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _createNamespace_closure44.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createNamespace_closure44.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createNamespace_closure44.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Namespace)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].callCurrent((GroovyObject)this, (Object)"namespaces.create", (Object)new GStringImpl(new Object[]{(Namespace)namespace2.get()}, new String[]{"Create Namespace ", ""}), null, (Object)new _createNamespace_closure44(this, this, namespace2)), Namespace.class);
    }

    /*
     * WARNING - void declaration
     */
    public Pod createPod(String namespace, Pod pod) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference pod2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _createPod_closure45
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference pod;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createPod_closure45(Object _outerInstance, Object _thisObject, Reference namespace, Reference pod) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createPod_closure45.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.pod = reference = pod;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createPod_closure45.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.pod.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _createPod_closure45.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Pod getPod() {
                CallSite[] callSiteArray = _createPod_closure45.$getCallSiteArray();
                return (Pod)ScriptBytecodeAdapter.castToType((Object)this.pod.get(), Pod.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createPod_closure45.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createPod_closure45.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "create";
                stringArray[1] = "inNamespace";
                stringArray[2] = "pods";
                stringArray[3] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _createPod_closure45.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createPod_closure45.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createPod_closure45.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Pod)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].callCurrent((GroovyObject)this, (Object)"pods.create", (Object)new GStringImpl(new Object[]{callSiteArray[88].callGetPropertySafe(callSiteArray[89].callGetPropertySafe((Object)((Pod)pod2.get())))}, new String[]{"Create Pod ", ""}), (Object)((String)namespace2.get()), (Object)new _createPod_closure45(this, this, namespace2, pod2)), Pod.class);
    }

    public List<Job> getJobs(String namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getJobs_closure46
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getJobs_closure46(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _getJobs_closure46.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getJobs_closure46.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getJobs_closure46.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getJobs_closure46.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getJobs_closure46.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "inNamespace";
                stringArray[3] = "jobs";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getJobs_closure46.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getJobs_closure46.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getJobs_closure46.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[90].callCurrent((GroovyObject)this, (Object)"jobs.list", (Object)"Get Jobs", (Object)((String)namespace2.get()), (Object)new _getJobs_closure46(this, this, namespace2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public Job getJob(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getJob_closure47
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getJob_closure47(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getJob_closure47.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getJob_closure47.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getJob_closure47.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _getJob_closure47.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getJob_closure47.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getJob_closure47.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "jobs";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getJob_closure47.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getJob_closure47.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getJob_closure47.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Job)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].callCurrent((GroovyObject)this, (Object)"jobs.get", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Get JobStatus ", ""}), (Object)((String)namespace2.get()), (Object)new _getJob_closure47(this, this, namespace2, name2)), Job.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hardDestroyPod(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _hardDestroyPod_closure48
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _hardDestroyPod_closure48(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _hardDestroyPod_closure48.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _hardDestroyPod_closure48.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _hardDestroyPod_closure48.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _hardDestroyPod_closure48.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _hardDestroyPod_closure48.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _hardDestroyPod_closure48.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "delete";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "pods";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _hardDestroyPod_closure48.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_hardDestroyPod_closure48.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _hardDestroyPod_closure48.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[92].callCurrent((GroovyObject)this, (Object)"pods.delete", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Hard Destroy Pod ", ""}), (Object)((String)namespace2.get()), (Object)new _hardDestroyPod_closure48(this, this, namespace2, name2)));
    }

    /*
     * WARNING - void declaration
     */
    public HorizontalPodAutoscaler createAutoscaler(String namespace, HorizontalPodAutoscaler autoscaler) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference autoscaler2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _createAutoscaler_closure49
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference autoscaler;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createAutoscaler_closure49(Object _outerInstance, Object _thisObject, Reference namespace, Reference autoscaler) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createAutoscaler_closure49.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.autoscaler = reference = autoscaler;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createAutoscaler_closure49.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.autoscaler.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _createAutoscaler_closure49.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public HorizontalPodAutoscaler getAutoscaler() {
                CallSite[] callSiteArray = _createAutoscaler_closure49.$getCallSiteArray();
                return (HorizontalPodAutoscaler)ScriptBytecodeAdapter.castToType((Object)this.autoscaler.get(), HorizontalPodAutoscaler.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createAutoscaler_closure49.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createAutoscaler_closure49.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "create";
                stringArray[1] = "inNamespace";
                stringArray[2] = "horizontalPodAutoscalers";
                stringArray[3] = "autoscaling";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _createAutoscaler_closure49.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createAutoscaler_closure49.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createAutoscaler_closure49.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (HorizontalPodAutoscaler)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].callCurrent((GroovyObject)this, (Object)"horizontalPodAutoscalers.create", (Object)new GStringImpl(new Object[]{callSiteArray[94].callGetPropertySafe(callSiteArray[95].callGetPropertySafe((Object)((HorizontalPodAutoscaler)autoscaler2.get())))}, new String[]{"Create Autoscaler ", ""}), (Object)((String)namespace2.get()), (Object)new _createAutoscaler_closure49(this, this, namespace2, autoscaler2)), HorizontalPodAutoscaler.class);
    }

    /*
     * WARNING - void declaration
     */
    public DoneableHorizontalPodAutoscaler editAutoscaler(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _editAutoscaler_closure50
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _editAutoscaler_closure50(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _editAutoscaler_closure50.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _editAutoscaler_closure50.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _editAutoscaler_closure50.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _editAutoscaler_closure50.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _editAutoscaler_closure50.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _editAutoscaler_closure50.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "edit";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "horizontalPodAutoscalers";
                stringArray[4] = "autoscaling";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _editAutoscaler_closure50.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_editAutoscaler_closure50.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _editAutoscaler_closure50.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (DoneableHorizontalPodAutoscaler)ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].callCurrent((GroovyObject)this, (Object)"horizontalPodAutoscalers.edit", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Edit Autoscaler ", ""}), (Object)((String)namespace2.get()), (Object)new _editAutoscaler_closure50(this, this, namespace2, name2)), DoneableHorizontalPodAutoscaler.class);
    }

    /*
     * WARNING - void declaration
     */
    public HorizontalPodAutoscaler getAutoscaler(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getAutoscaler_closure51
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getAutoscaler_closure51(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getAutoscaler_closure51.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getAutoscaler_closure51.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getAutoscaler_closure51.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _getAutoscaler_closure51.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getAutoscaler_closure51.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAutoscaler_closure51.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "horizontalPodAutoscalers";
                stringArray[4] = "autoscaling";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getAutoscaler_closure51.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getAutoscaler_closure51.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getAutoscaler_closure51.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (HorizontalPodAutoscaler)ScriptBytecodeAdapter.castToType((Object)callSiteArray[97].callCurrent((GroovyObject)this, (Object)"horizontalPodAutoscalers.get", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Get Autoscaler ", ""}), (Object)((String)namespace2.get()), (Object)new _getAutoscaler_closure51(this, this, namespace2, name2)), HorizontalPodAutoscaler.class);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, HorizontalPodAutoscaler> getAutoscalers(String namespace, String kind) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference kind2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getAutoscalers_closure52
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference kind;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getAutoscalers_closure52(Object _outerInstance, Object _thisObject, Reference namespace, Reference kind) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getAutoscalers_closure52.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.kind = reference = kind;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getAutoscalers_closure52.$getCallSiteArray();
                Object object = callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get())));
                Object items = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                public class _closure69
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference kind;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure69(Object _outerInstance, Object _thisObject, Reference kind) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure69.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.kind = reference = kind;
                    }

                    public Object doCall(Object autoscaler) {
                        CallSite[] callSiteArray = _closure69.$getCallSiteArray();
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(autoscaler))), (Object)this.kind.get()) ? ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(autoscaler)), autoscaler}) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                    }

                    public String getKind() {
                        CallSite[] callSiteArray = _closure69.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.kind.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure69.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "kind";
                        stringArray[1] = "scaleTargetRef";
                        stringArray[2] = "spec";
                        stringArray[3] = "name";
                        stringArray[4] = "metadata";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _closure69.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure69.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure69.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[6].call(items, (Object)new _closure69((Object)this, this.getThisObject(), this.kind));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getAutoscalers_closure52.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getKind() {
                CallSite[] callSiteArray = _getAutoscalers_closure52.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.kind.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getAutoscalers_closure52.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAutoscalers_closure52.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "inNamespace";
                stringArray[3] = "horizontalPodAutoscalers";
                stringArray[4] = "autoscaling";
                stringArray[5] = "client";
                stringArray[6] = "collectEntries";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _getAutoscalers_closure52.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getAutoscalers_closure52.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getAutoscalers_closure52.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[98].callCurrent((GroovyObject)this, (Object)"horizontalPodAutoscalers.list", (Object)"Get Autoscalers", (Object)((String)namespace2.get()), (Object)new _getAutoscalers_closure52(this, this, namespace2, kind2)), Map.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean deleteAutoscaler(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _deleteAutoscaler_closure53
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deleteAutoscaler_closure53(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _deleteAutoscaler_closure53.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _deleteAutoscaler_closure53.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _deleteAutoscaler_closure53.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _deleteAutoscaler_closure53.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _deleteAutoscaler_closure53.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteAutoscaler_closure53.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "delete";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "horizontalPodAutoscalers";
                stringArray[4] = "autoscaling";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _deleteAutoscaler_closure53.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deleteAutoscaler_closure53.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deleteAutoscaler_closure53.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[99].callCurrent((GroovyObject)this, (Object)"horizontalPodAutoscalers.delete", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Destroy Autoscaler ", ""}), (Object)((String)namespace2.get()), (Object)new _deleteAutoscaler_closure53(this, this, namespace2, name2)));
    }

    /*
     * WARNING - void declaration
     */
    public Deployment getDeployment(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getDeployment_closure54
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getDeployment_closure54(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getDeployment_closure54.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getDeployment_closure54.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getDeployment_closure54.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _getDeployment_closure54.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getDeployment_closure54.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDeployment_closure54.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "deployments";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getDeployment_closure54.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getDeployment_closure54.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getDeployment_closure54.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Deployment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[100].callCurrent((GroovyObject)this, (Object)"deployments.get", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Get Deployment ", ""}), (Object)((String)namespace2.get()), (Object)new _getDeployment_closure54(this, this, namespace2, name2)), Deployment.class);
    }

    public List<Deployment> getDeployments(String namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _getDeployments_closure55
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getDeployments_closure55(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _getDeployments_closure55.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getDeployments_closure55.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getDeployments_closure55.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getDeployments_closure55.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDeployments_closure55.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "items";
                stringArray[1] = "list";
                stringArray[2] = "inNamespace";
                stringArray[3] = "deployments";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getDeployments_closure55.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getDeployments_closure55.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getDeployments_closure55.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[101].callCurrent((GroovyObject)this, (Object)"deployments.list", (Object)"Get Deployments", (Object)((String)namespace2.get()), (Object)new _getDeployments_closure55(this, this, namespace2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public Deployment resizeDeployment(String namespace, String name, int size) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        Reference size2 = new Reference((Object)size);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _resizeDeployment_closure56
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference size;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _resizeDeployment_closure56(Object _outerInstance, Object _thisObject, Reference namespace, Reference name, Reference size) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _resizeDeployment_closure56.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference3 = namespace;
                this.name = reference2 = name;
                this.size = reference = size;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _resizeDeployment_closure56.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()), this.size.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _resizeDeployment_closure56.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _resizeDeployment_closure56.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public int getSize() {
                CallSite[] callSiteArray = _resizeDeployment_closure56.$getCallSiteArray();
                return DefaultTypeTransformation.intUnbox((Object)this.size.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _resizeDeployment_closure56.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resizeDeployment_closure56.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "scale";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "deployments";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _resizeDeployment_closure56.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_resizeDeployment_closure56.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resizeDeployment_closure56.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Deployment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[102].callCurrent((GroovyObject)this, (Object)"deployments.scale", (Object)new GStringImpl(new Object[]{(String)name2.get(), DefaultTypeTransformation.intUnbox((Object)size2.get())}, new String[]{"Resize Deployment ", " to ", ""}), (Object)((String)namespace2.get()), (Object)new _resizeDeployment_closure56(this, this, namespace2, name2, size2)), Deployment.class);
    }

    /*
     * WARNING - void declaration
     */
    public Deployment createDeployment(String namespace, Deployment deployment) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference deployment2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _createDeployment_closure57
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference deployment;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createDeployment_closure57(Object _outerInstance, Object _thisObject, Reference namespace, Reference deployment) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createDeployment_closure57.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.deployment = reference = deployment;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createDeployment_closure57.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.deployment.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _createDeployment_closure57.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Deployment getDeployment() {
                CallSite[] callSiteArray = _createDeployment_closure57.$getCallSiteArray();
                return (Deployment)ScriptBytecodeAdapter.castToType((Object)this.deployment.get(), Deployment.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createDeployment_closure57.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createDeployment_closure57.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "create";
                stringArray[1] = "inNamespace";
                stringArray[2] = "deployments";
                stringArray[3] = "extensions";
                stringArray[4] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _createDeployment_closure57.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createDeployment_closure57.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createDeployment_closure57.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Deployment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[103].callCurrent((GroovyObject)this, (Object)"deployments.create", (Object)new GStringImpl(new Object[]{callSiteArray[104].callGetProperty(callSiteArray[105].callGetProperty((Object)((Deployment)deployment2.get())))}, new String[]{"Create Deployment ", ""}), (Object)((String)namespace2.get()), (Object)new _createDeployment_closure57(this, this, namespace2, deployment2)), Deployment.class);
    }

    /*
     * WARNING - void declaration
     */
    public DoneableDeployment editDeployment(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _editDeployment_closure58
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _editDeployment_closure58(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _editDeployment_closure58.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _editDeployment_closure58.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _editDeployment_closure58.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _editDeployment_closure58.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _editDeployment_closure58.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _editDeployment_closure58.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "edit";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "deployments";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _editDeployment_closure58.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_editDeployment_closure58.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _editDeployment_closure58.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (DoneableDeployment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[106].callCurrent((GroovyObject)this, (Object)"deployments.edit", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Edit deployment ", ""}), (Object)((String)namespace2.get()), (Object)new _editDeployment_closure58(this, this, namespace2, name2)), DoneableDeployment.class);
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaSet annotateReplicaSet(String namespace, String name, String key, String value) {
        void var3_3;
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        Reference key2 = new Reference((Object)var3_3);
        Reference value2 = new Reference((Object)value);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _annotateReplicaSet_closure59
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference key;
            private /* synthetic */ Reference value;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _annotateReplicaSet_closure59(Object _outerInstance, Object _thisObject, Reference namespace, Reference name, Reference key, Reference value) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _annotateReplicaSet_closure59.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference4 = namespace;
                this.name = reference3 = name;
                this.key = reference2 = key;
                this.value = reference = value;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _annotateReplicaSet_closure59.$getCallSiteArray();
                Object rs = callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()), (Object)false));
                return callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(rs), this.key.get(), this.value.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _annotateReplicaSet_closure59.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _annotateReplicaSet_closure59.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getKey() {
                CallSite[] callSiteArray = _annotateReplicaSet_closure59.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.key.get());
            }

            public String getValue() {
                CallSite[] callSiteArray = _annotateReplicaSet_closure59.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.value.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _annotateReplicaSet_closure59.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _annotateReplicaSet_closure59.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "edit";
                stringArray[1] = "cascading";
                stringArray[2] = "withName";
                stringArray[3] = "inNamespace";
                stringArray[4] = "replicaSets";
                stringArray[5] = "extensions";
                stringArray[6] = "client";
                stringArray[7] = "done";
                stringArray[8] = "endMetadata";
                stringArray[9] = "addToAnnotations";
                stringArray[10] = "editMetadata";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[11];
                _annotateReplicaSet_closure59.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_annotateReplicaSet_closure59.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _annotateReplicaSet_closure59.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (ReplicaSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[107].callCurrent((GroovyObject)this, (Object)"replicaSets.annotate", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Annotate replica set ", ""}), (Object)((String)namespace2.get()), (Object)new _annotateReplicaSet_closure59(this, this, namespace2, name2, key2, value2)), ReplicaSet.class);
    }

    /*
     * WARNING - void declaration
     */
    public ReplicationController annotateReplicationController(String namespace, String name, String key, String value) {
        void var3_3;
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        Reference key2 = new Reference((Object)var3_3);
        Reference value2 = new Reference((Object)value);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _annotateReplicationController_closure60
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference key;
            private /* synthetic */ Reference value;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _annotateReplicationController_closure60(Object _outerInstance, Object _thisObject, Reference namespace, Reference name, Reference key, Reference value) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _annotateReplicationController_closure60.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference4 = namespace;
                this.name = reference3 = name;
                this.key = reference2 = key;
                this.value = reference = value;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _annotateReplicationController_closure60.$getCallSiteArray();
                Object rc = callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this)), this.namespace.get()), this.name.get()), (Object)false));
                return callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(rc), this.key.get(), this.value.get())));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _annotateReplicationController_closure60.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _annotateReplicationController_closure60.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getKey() {
                CallSite[] callSiteArray = _annotateReplicationController_closure60.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.key.get());
            }

            public String getValue() {
                CallSite[] callSiteArray = _annotateReplicationController_closure60.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.value.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _annotateReplicationController_closure60.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _annotateReplicationController_closure60.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "edit";
                stringArray[1] = "cascading";
                stringArray[2] = "withName";
                stringArray[3] = "inNamespace";
                stringArray[4] = "replicationControllers";
                stringArray[5] = "client";
                stringArray[6] = "done";
                stringArray[7] = "endMetadata";
                stringArray[8] = "addToAnnotations";
                stringArray[9] = "editMetadata";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[10];
                _annotateReplicationController_closure60.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_annotateReplicationController_closure60.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _annotateReplicationController_closure60.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (ReplicationController)ScriptBytecodeAdapter.castToType((Object)callSiteArray[108].callCurrent((GroovyObject)this, (Object)"replicationControllers.annotate", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Annotate replication controller ", ""}), (Object)((String)namespace2.get()), (Object)new _annotateReplicationController_closure60(this, this, namespace2, name2, key2, value2)), ReplicationController.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean deleteDeployment(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _deleteDeployment_closure61
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deleteDeployment_closure61(Object _outerInstance, Object _thisObject, Reference namespace, Reference name) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _deleteDeployment_closure61.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _deleteDeployment_closure61.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), this.namespace.get()), this.name.get()));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _deleteDeployment_closure61.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _deleteDeployment_closure61.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _deleteDeployment_closure61.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteDeployment_closure61.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "delete";
                stringArray[1] = "withName";
                stringArray[2] = "inNamespace";
                stringArray[3] = "deployments";
                stringArray[4] = "extensions";
                stringArray[5] = "client";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _deleteDeployment_closure61.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deleteDeployment_closure61.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deleteDeployment_closure61.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[109].callCurrent((GroovyObject)this, (Object)"deployments.delete", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Delete Deployment ", ""}), (Object)((String)namespace2.get()), (Object)new _deleteDeployment_closure61(this, this, namespace2, name2)));
    }

    public static boolean hasDeployment(ReplicaSet replicaSet) {
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        public class _hasDeployment_closure62
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _hasDeployment_closure62(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _hasDeployment_closure62.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                CallSite[] callSiteArray = _hasDeployment_closure62.$getCallSiteArray();
                return callSiteArray[0].call(k, callSiteArray[1].callGetProperty(KubernetesApiAdaptor.class));
            }

            public Object call(Object k, Object v) {
                CallSite[] callSiteArray = _hasDeployment_closure62.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _hasDeployment_closure62.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "startsWith";
                stringArray[1] = "DEPLOYMENT_ANNOTATION";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _hasDeployment_closure62.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_hasDeployment_closure62.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _hasDeployment_closure62.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[110].callSafe(callSiteArray[111].callGetPropertySafe(callSiteArray[112].callGetPropertySafe((Object)replicaSet)), (Object)new _hasDeployment_closure62(KubernetesApiAdaptor.class, KubernetesApiAdaptor.class)));
    }

    public static String getDeploymentRevision(Deployment deployment) {
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[113].callSafe(callSiteArray[114].callGetPropertySafe(callSiteArray[115].callGetPropertySafe((Object)deployment)), callSiteArray[116].call((Object)new GStringImpl(new Object[]{DEPLOYMENT_ANNOTATION}, new String[]{"", "/revision"}))));
    }

    public static String getDeploymentRevision(ReplicaSet replicaSet) {
        CallSite[] callSiteArray = KubernetesApiAdaptor.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[117].callSafe(callSiteArray[118].callGetPropertySafe(callSiteArray[119].callGetPropertySafe((Object)replicaSet)), callSiteArray[120].call((Object)new GStringImpl(new Object[]{DEPLOYMENT_ANNOTATION}, new String[]{"", "/revision"}))));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != KubernetesApiAdaptor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        int n = 100;
        RETRY_INITIAL_WAIT_MILLIS = n;
        Object object = KubernetesApiAdaptor.$getCallSiteArray()[121].call(KubernetesApiAdaptor.$getCallSiteArray()[122].callGetProperty(TimeUnit.class), (Object)10);
        RETRY_MAX_WAIT_MILLIS = DefaultTypeTransformation.longUnbox((Object)object);
        Object object2 = KubernetesApiAdaptor.$getCallSiteArray()[123].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.kubernetes.v1.api.KubernetesApiAdaptor");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object2, Logger.class);
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String string) {
        this.account = string;
    }

    public static int getRETRY_COUNT() {
        return RETRY_COUNT;
    }

    public static long getRETRY_MAX_WAIT_MILLIS() {
        return RETRY_MAX_WAIT_MILLIS;
    }

    public static long getRETRY_INITIAL_WAIT_MILLIS() {
        return RETRY_INITIAL_WAIT_MILLIS;
    }

    public static String getDEPLOYMENT_ANNOTATION() {
        return DEPLOYMENT_ANNOTATION;
    }

    public final KubernetesClient getClient() {
        return this.client;
    }

    public final Registry getSpectatorRegistry() {
        return this.spectatorRegistry;
    }

    public final Clock getSpectatorClock() {
        return this.spectatorClock;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "clock";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "call";
        stringArray[8] = "call";
        stringArray[9] = "call";
        stringArray[10] = "plus";
        stringArray[11] = "sleep";
        stringArray[12] = "min";
        stringArray[13] = "multiply";
        stringArray[14] = "call";
        stringArray[15] = "monotonicTime";
        stringArray[16] = "call";
        stringArray[17] = "formatException";
        stringArray[18] = "formatException";
        stringArray[19] = "simpleName";
        stringArray[20] = "class";
        stringArray[21] = "putAt";
        stringArray[22] = "record";
        stringArray[23] = "timer";
        stringArray[24] = "createId";
        stringArray[25] = "minus";
        stringArray[26] = "monotonicTime";
        stringArray[27] = "NANOSECONDS";
        stringArray[28] = "simpleName";
        stringArray[29] = "class";
        stringArray[30] = "putAt";
        stringArray[31] = "record";
        stringArray[32] = "timer";
        stringArray[33] = "createId";
        stringArray[34] = "minus";
        stringArray[35] = "monotonicTime";
        stringArray[36] = "NANOSECONDS";
        stringArray[37] = "exceptionWrapper";
        stringArray[38] = "exceptionWrapper";
        stringArray[39] = "exceptionWrapper";
        stringArray[40] = "name";
        stringArray[41] = "metadata";
        stringArray[42] = "exceptionWrapper";
        stringArray[43] = "exceptionWrapper";
        stringArray[44] = "exceptionWrapper";
        stringArray[45] = "exceptionWrapper";
        stringArray[46] = "exceptionWrapper";
        stringArray[47] = "exceptionWrapper";
        stringArray[48] = "exceptionWrapper";
        stringArray[49] = "exceptionWrapper";
        stringArray[50] = "exceptionWrapper";
        stringArray[51] = "exceptionWrapper";
        stringArray[52] = "exceptionWrapper";
        stringArray[53] = "name";
        stringArray[54] = "metadata";
        stringArray[55] = "exceptionWrapper";
        stringArray[56] = "exceptionWrapper";
        stringArray[57] = "exceptionWrapper";
        stringArray[58] = "exceptionWrapper";
        stringArray[59] = "exceptionWrapper";
        stringArray[60] = "exceptionWrapper";
        stringArray[61] = "exceptionWrapper";
        stringArray[62] = "exceptionWrapper";
        stringArray[63] = "exceptionWrapper";
        stringArray[64] = "exceptionWrapper";
        stringArray[65] = "name";
        stringArray[66] = "metadata";
        stringArray[67] = "exceptionWrapper";
        stringArray[68] = "exceptionWrapper";
        stringArray[69] = "exceptionWrapper";
        stringArray[70] = "exceptionWrapper";
        stringArray[71] = "exceptionWrapper";
        stringArray[72] = "exceptionWrapper";
        stringArray[73] = "exceptionWrapper";
        stringArray[74] = "exceptionWrapper";
        stringArray[75] = "exceptionWrapper";
        stringArray[76] = "exceptionWrapper";
        stringArray[77] = "exceptionWrapper";
        stringArray[78] = "exceptionWrapper";
        stringArray[79] = "exceptionWrapper";
        stringArray[80] = "exceptionWrapper";
        stringArray[81] = "exceptionWrapper";
        stringArray[82] = "exceptionWrapper";
        stringArray[83] = "exceptionWrapper";
        stringArray[84] = "exceptionWrapper";
        stringArray[85] = "exceptionWrapper";
        stringArray[86] = "exceptionWrapper";
        stringArray[87] = "exceptionWrapper";
        stringArray[88] = "name";
        stringArray[89] = "metadata";
        stringArray[90] = "exceptionWrapper";
        stringArray[91] = "exceptionWrapper";
        stringArray[92] = "exceptionWrapper";
        stringArray[93] = "exceptionWrapper";
        stringArray[94] = "name";
        stringArray[95] = "metadata";
        stringArray[96] = "exceptionWrapper";
        stringArray[97] = "exceptionWrapper";
        stringArray[98] = "exceptionWrapper";
        stringArray[99] = "exceptionWrapper";
        stringArray[100] = "exceptionWrapper";
        stringArray[101] = "exceptionWrapper";
        stringArray[102] = "exceptionWrapper";
        stringArray[103] = "exceptionWrapper";
        stringArray[104] = "name";
        stringArray[105] = "metadata";
        stringArray[106] = "exceptionWrapper";
        stringArray[107] = "exceptionWrapper";
        stringArray[108] = "exceptionWrapper";
        stringArray[109] = "exceptionWrapper";
        stringArray[110] = "any";
        stringArray[111] = "annotations";
        stringArray[112] = "metadata";
        stringArray[113] = "get";
        stringArray[114] = "annotations";
        stringArray[115] = "metadata";
        stringArray[116] = "toString";
        stringArray[117] = "get";
        stringArray[118] = "annotations";
        stringArray[119] = "metadata";
        stringArray[120] = "toString";
        stringArray[121] = "toMillis";
        stringArray[122] = "SECONDS";
        stringArray[123] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[124];
        KubernetesApiAdaptor.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(KubernetesApiAdaptor.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = KubernetesApiAdaptor.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

