/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.ops.servergroup;

import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.KubernetesUtil;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.description.servergroup.KubernetesServerGroupDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.exception.KubernetesOperationException;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.security.KubernetesV1Credentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestroyKubernetesAtomicOperation
implements AtomicOperation<Void>,
GroovyObject {
    private static final String BASE_PHASE = "DESTROY";
    private final KubernetesServerGroupDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public DestroyKubernetesAtomicOperation(KubernetesServerGroupDescription description) {
        MetaClass metaClass;
        CallSite[] callSiteArray = DestroyKubernetesAtomicOperation.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        KubernetesServerGroupDescription kubernetesServerGroupDescription = description;
        this.description = (KubernetesServerGroupDescription)ScriptBytecodeAdapter.castToType((Object)kubernetesServerGroupDescription, KubernetesServerGroupDescription.class);
    }

    private static Task getTask() {
        CallSite[] callSiteArray = DestroyKubernetesAtomicOperation.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(TaskRepository.class)), Task.class);
    }

    public Void operate(List priorOutputs) {
        CallSite[] callSiteArray = DestroyKubernetesAtomicOperation.$getCallSiteArray();
        callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Initializing destroy of server group.");
        callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Looking up provided namespace...");
        Object credentials = callSiteArray[6].callGetProperty(callSiteArray[7].callGroovyObjectGetProperty((Object)this.description));
        Object namespace = callSiteArray[8].call(KubernetesUtil.class, credentials, callSiteArray[9].callGroovyObjectGetProperty((Object)this.description));
        Object autoscalerName = callSiteArray[10].callGroovyObjectGetProperty((Object)this.description);
        Object parsedName = callSiteArray[11].call(Names.class, callSiteArray[12].callGroovyObjectGetProperty((Object)this.description));
        Object deploymentName = callSiteArray[13].callGetProperty(parsedName);
        Object deployment = callSiteArray[14].call(callSiteArray[15].callGetProperty(credentials), namespace, deploymentName);
        Object replicaSet = callSiteArray[16].call(callSiteArray[17].callGetProperty(credentials), namespace, callSiteArray[18].callGroovyObjectGetProperty((Object)this.description));
        Boolean destroyAutoscalerIfExists = true;
        if (DefaultTypeTransformation.booleanUnbox((Object)deployment) && DefaultTypeTransformation.booleanUnbox((Object)replicaSet)) {
            callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{deploymentName}, new String[]{"Checking if deployment ", " needs to be destroyed..."}));
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[21].call(callSiteArray[22].callGetProperty(credentials), deployment), (Object)callSiteArray[23].call(callSiteArray[24].callGetProperty(credentials), replicaSet))) {
                callSiteArray[25].call(callSiteArray[26].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{deploymentName}, new String[]{"Destroying deployment ", "..."}));
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].call(callSiteArray[28].callGetProperty(credentials), namespace, deploymentName))) {
                    throw (Throwable)callSiteArray[29].callConstructor(KubernetesOperationException.class, (Object)new GStringImpl(new Object[]{deploymentName, namespace}, new String[]{"Failed to delete deployment ", " in ", ""}));
                }
                callSiteArray[30].call(callSiteArray[31].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{deploymentName}, new String[]{"Successfully destroyed deployment ", "..."}));
            } else {
                boolean bl = false;
                destroyAutoscalerIfExists = bl;
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[32].call(callSiteArray[33].callGetProperty(credentials), namespace, autoscalerName)) && DefaultTypeTransformation.booleanUnbox((Object)destroyAutoscalerIfExists)) {
            callSiteArray[34].call(callSiteArray[35].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Destroying autoscaler...");
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[36].call(callSiteArray[37].callGetProperty(credentials), namespace, autoscalerName))) {
                throw (Throwable)callSiteArray[38].callConstructor(KubernetesOperationException.class, (Object)new GStringImpl(new Object[]{autoscalerName, namespace}, new String[]{"Failed to delete associated autoscaler ", " in ", "."}));
            }
        }
        callSiteArray[39].call(callSiteArray[40].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Destroying server group...");
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[41].call(callSiteArray[42].callGetProperty(credentials), namespace, callSiteArray[43].callGroovyObjectGetProperty((Object)this.description)))) {
            callSiteArray[44].call(callSiteArray[45].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Underlying kind is 'ReplicationController'...");
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[46].call(callSiteArray[47].callGetProperty(credentials), namespace, callSiteArray[48].callGroovyObjectGetProperty((Object)this.description)))) {
                throw (Throwable)callSiteArray[49].callConstructor(KubernetesOperationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[50].callGroovyObjectGetProperty((Object)this.description), namespace}, new String[]{"Failed to delete ", " in ", "."}));
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)replicaSet)) {
            callSiteArray[51].call(callSiteArray[52].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Underlying kind is 'ReplicaSet'...");
            callSiteArray[53].call(callSiteArray[54].callGetProperty(credentials), namespace, callSiteArray[55].callGroovyObjectGetProperty((Object)this.description));
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].callGroovyObjectGetProperty((Object)this.description))) {
            callSiteArray[57].callCurrent((GroovyObject)this, credentials, namespace, callSiteArray[58].callGroovyObjectGetProperty((Object)this.description), autoscalerName);
        } else {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].call((Object)log)) ? callSiteArray[60].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[61].callGroovyObjectGetProperty((Object)this.description), callSiteArray[62].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Unable delete ", " in ", " because kind has been presented in the request."})) : null;
        }
        return (Void)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].call(callSiteArray[64].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[65].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Successfully destroyed server group ", "."})), Void.class);
    }

    public void destroyController(KubernetesV1Credentials credentials, String namespace, String controllerName, String autoscalerName) {
        block3: {
            Object object;
            CallSite[] callSiteArray;
            block2: {
                callSiteArray = DestroyKubernetesAtomicOperation.$getCallSiteArray();
                Object controllerKind = callSiteArray[66].callGroovyObjectGetProperty((Object)this.description);
                object = controllerKind;
                if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[67].callGetProperty(KubernetesUtil.class))) break block2;
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[68].call(callSiteArray[69].callGetProperty((Object)credentials), (Object)namespace, (Object)autoscalerName))) {
                    callSiteArray[70].call(callSiteArray[71].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Destroying autoscaler...");
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[72].call(callSiteArray[73].callGetProperty((Object)credentials), ArrayUtil.createArray((Object)namespace, (Object)autoscalerName, null, null, null)))) {
                        throw (Throwable)callSiteArray[74].callConstructor(KubernetesOperationException.class, (Object)new GStringImpl(new Object[]{autoscalerName, namespace}, new String[]{"Failed to delete associated autoscaler ", " in ", "."}));
                    }
                }
                callSiteArray[75].call(callSiteArray[76].callGetProperty((Object)credentials), ArrayUtil.createArray((Object)controllerName, (Object)namespace, null, null, null));
                break block3;
            }
            if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[77].callGetProperty(KubernetesUtil.class))) break block3;
            callSiteArray[78].call(callSiteArray[79].callGetProperty((Object)credentials), ArrayUtil.createArray((Object)controllerName, (Object)namespace, null, null, null));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DestroyKubernetesAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = DestroyKubernetesAtomicOperation.$getCallSiteArray()[80].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.ops.servergroup.DestroyKubernetesAtomicOperation");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "threadLocalTask";
        stringArray[2] = "updateStatus";
        stringArray[3] = "task";
        stringArray[4] = "updateStatus";
        stringArray[5] = "task";
        stringArray[6] = "credentials";
        stringArray[7] = "credentials";
        stringArray[8] = "validateNamespace";
        stringArray[9] = "namespace";
        stringArray[10] = "serverGroupName";
        stringArray[11] = "parseName";
        stringArray[12] = "serverGroupName";
        stringArray[13] = "cluster";
        stringArray[14] = "getDeployment";
        stringArray[15] = "apiAdaptor";
        stringArray[16] = "getReplicaSet";
        stringArray[17] = "apiAdaptor";
        stringArray[18] = "serverGroupName";
        stringArray[19] = "updateStatus";
        stringArray[20] = "task";
        stringArray[21] = "getDeploymentRevision";
        stringArray[22] = "apiAdaptor";
        stringArray[23] = "getDeploymentRevision";
        stringArray[24] = "apiAdaptor";
        stringArray[25] = "updateStatus";
        stringArray[26] = "task";
        stringArray[27] = "deleteDeployment";
        stringArray[28] = "apiAdaptor";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "updateStatus";
        stringArray[31] = "task";
        stringArray[32] = "getAutoscaler";
        stringArray[33] = "apiAdaptor";
        stringArray[34] = "updateStatus";
        stringArray[35] = "task";
        stringArray[36] = "deleteAutoscaler";
        stringArray[37] = "apiAdaptor";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "updateStatus";
        stringArray[40] = "task";
        stringArray[41] = "getReplicationController";
        stringArray[42] = "apiAdaptor";
        stringArray[43] = "serverGroupName";
        stringArray[44] = "updateStatus";
        stringArray[45] = "task";
        stringArray[46] = "hardDestroyReplicationController";
        stringArray[47] = "apiAdaptor";
        stringArray[48] = "serverGroupName";
        stringArray[49] = "<$constructor$>";
        stringArray[50] = "serverGroupName";
        stringArray[51] = "updateStatus";
        stringArray[52] = "task";
        stringArray[53] = "hardDestroyReplicaSet";
        stringArray[54] = "apiAdaptor";
        stringArray[55] = "serverGroupName";
        stringArray[56] = "kind";
        stringArray[57] = "destroyController";
        stringArray[58] = "serverGroupName";
        stringArray[59] = "isErrorEnabled";
        stringArray[60] = "error";
        stringArray[61] = "serverGroupName";
        stringArray[62] = "namespace";
        stringArray[63] = "updateStatus";
        stringArray[64] = "task";
        stringArray[65] = "serverGroupName";
        stringArray[66] = "kind";
        stringArray[67] = "CONTROLLERS_STATEFULSET_KIND";
        stringArray[68] = "getAutoscaler";
        stringArray[69] = "apiClientAdaptor";
        stringArray[70] = "updateStatus";
        stringArray[71] = "task";
        stringArray[72] = "deleteAutoscaler";
        stringArray[73] = "clientApiAdaptor";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "hardDestroyStatefulSet";
        stringArray[76] = "apiClientAdaptor";
        stringArray[77] = "CONTROLLERS_DAEMONSET_KIND";
        stringArray[78] = "hardDestroyDaemonSet";
        stringArray[79] = "apiClientAdaptor";
        stringArray[80] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[81];
        DestroyKubernetesAtomicOperation.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DestroyKubernetesAtomicOperation.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DestroyKubernetesAtomicOperation.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

