/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.provider.KubernetesModelUtil;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2Health;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.ManifestBasedModel;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.Instance;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerInstance;
import io.kubernetes.client.models.V1Pod;
import io.kubernetes.client.models.V1PodStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesV2Instance
extends ManifestBasedModel
implements Instance {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2Instance.class);
    Long launchTime;
    List<Map<String, String>> health = new ArrayList<Map<String, String>>();
    KubernetesManifest manifest;
    Keys.InfrastructureCacheKey key;

    private KubernetesV2Instance(KubernetesManifest manifest, String key) {
        this.manifest = manifest;
        this.key = (Keys.InfrastructureCacheKey)Keys.parseKey(key).get();
        V1Pod pod = KubernetesCacheDataConverter.getResource(this.manifest, V1Pod.class);
        V1PodStatus status = pod.getStatus();
        if (status != null) {
            this.health.add(new KubernetesV2Health(status).toMap());
            if (status.getContainerStatuses() != null) {
                this.health.addAll(status.getContainerStatuses().stream().map(KubernetesV2Health::new).map(KubernetesV2Health::toMap).collect(Collectors.toList()));
            }
        }
    }

    public static KubernetesV2Instance fromCacheData(CacheData cd) {
        if (cd == null) {
            return null;
        }
        KubernetesManifest manifest = KubernetesCacheDataConverter.getManifest(cd);
        if (manifest == null) {
            log.warn("Cache data {} inserted without a manifest", (Object)cd.getId());
            return null;
        }
        return new KubernetesV2Instance(manifest, cd.getId());
    }

    public LoadBalancerInstance toLoadBalancerInstance() {
        return LoadBalancerInstance.builder().health((Map)this.health.stream().reduce(new HashMap(), (a, b) -> {
            HashMap result = new HashMap();
            result.putAll(a);
            result.putAll(b);
            return result;
        })).id(this.getName()).zone(this.getZone()).build();
    }

    public HealthState getHealthState() {
        return KubernetesModelUtil.getHealthState(this.health);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesV2Instance)) {
            return false;
        }
        KubernetesV2Instance other = (KubernetesV2Instance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$launchTime = this.getLaunchTime();
        Long other$launchTime = other.getLaunchTime();
        if (this$launchTime == null ? other$launchTime != null : !((Object)this$launchTime).equals(other$launchTime)) {
            return false;
        }
        List<Map<String, String>> this$health = this.getHealth();
        List<Map<String, String>> other$health = other.getHealth();
        if (this$health == null ? other$health != null : !((Object)this$health).equals(other$health)) {
            return false;
        }
        KubernetesManifest this$manifest = this.getManifest();
        KubernetesManifest other$manifest = other.getManifest();
        if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
            return false;
        }
        Keys.InfrastructureCacheKey this$key = this.getKey();
        Keys.InfrastructureCacheKey other$key = other.getKey();
        return !(this$key == null ? other$key != null : !((Object)this$key).equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesV2Instance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Long $launchTime = this.getLaunchTime();
        result = result * 59 + ($launchTime == null ? 43 : ((Object)$launchTime).hashCode());
        List<Map<String, String>> $health = this.getHealth();
        result = result * 59 + ($health == null ? 43 : ((Object)$health).hashCode());
        KubernetesManifest $manifest = this.getManifest();
        result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
        Keys.InfrastructureCacheKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        return result;
    }

    public Long getLaunchTime() {
        return this.launchTime;
    }

    public List<Map<String, String>> getHealth() {
        return this.health;
    }

    @Override
    public KubernetesManifest getManifest() {
        return this.manifest;
    }

    @Override
    public Keys.InfrastructureCacheKey getKey() {
        return this.key;
    }

    public KubernetesV2Instance setLaunchTime(Long launchTime) {
        this.launchTime = launchTime;
        return this;
    }

    public KubernetesV2Instance setHealth(List<Map<String, String>> health) {
        this.health = health;
        return this;
    }

    public KubernetesV2Instance setManifest(KubernetesManifest manifest) {
        this.manifest = manifest;
        return this;
    }

    public KubernetesV2Instance setKey(Keys.InfrastructureCacheKey key) {
        this.key = key;
        return this;
    }

    public String toString() {
        return "KubernetesV2Instance(launchTime=" + this.getLaunchTime() + ", health=" + this.getHealth() + ", manifest=" + this.getManifest() + ", key=" + this.getKey() + ")";
    }

    public KubernetesV2Instance() {
    }
}

