/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider;

import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.ManifestBasedModel;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.data.KubernetesV2CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.ModelHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesCacheUtils {
    private static final Logger log = LoggerFactory.getLogger(KubernetesCacheUtils.class);
    private final Cache cache;
    private final KubernetesSpinnakerKindMap kindMap;
    private final KubernetesResourcePropertyRegistry registry;

    @Autowired
    public KubernetesCacheUtils(Cache cache, KubernetesSpinnakerKindMap kindMap, KubernetesResourcePropertyRegistry resourcePropertyRegistry) {
        this.cache = cache;
        this.kindMap = kindMap;
        this.registry = resourcePropertyRegistry;
    }

    public Collection<CacheData> getAllKeys(String type) {
        return this.cleanupCollection(this.cache.getAll(type));
    }

    public Collection<String> getAllKeysMatchingPattern(String type, String key) {
        return this.cleanupCollection(this.cache.filterIdentifiers(type, key));
    }

    public Collection<CacheData> getAllDataMatchingPattern(String type, String key) {
        return this.cleanupCollection(this.cache.getAll(type, this.getAllKeysMatchingPattern(type, key)));
    }

    public Optional<CacheData> getSingleEntry(String type, String key) {
        CacheData result = this.cache.get(type, key);
        return result == null ? Optional.empty() : Optional.of(result);
    }

    public Optional<CacheData> getSingleEntryWithRelationships(String type, String key, String ... to) {
        CacheData result = this.cache.get(type, key, (CacheFilter)RelationshipCacheFilter.include((String[])to));
        return Optional.ofNullable(result);
    }

    public Collection<String> aggregateRelationshipsBySpinnakerKind(CacheData source, KubernetesSpinnakerKindMap.SpinnakerKind kind) {
        return this.kindMap.translateSpinnakerKind(kind).stream().map(g -> (Collection)source.getRelationships().get(g.toString())).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Collection<CacheData> getTransitiveRelationship(String from, List<String> sourceKeys, String to) {
        Collection sourceData = this.cleanupCollection(this.cache.getAll(from, sourceKeys, (CacheFilter)RelationshipCacheFilter.include((String[])new String[]{to})));
        return this.cleanupCollection(this.cache.getAll(to, (Collection)sourceData.stream().map(CacheData::getRelationships).filter(Objects::nonNull).map(r -> (Collection)r.get(to)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList())));
    }

    public Collection<CacheData> getAllRelationshipsOfSpinnakerKind(Collection<CacheData> cacheData, KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind) {
        return this.kindMap.translateSpinnakerKind(spinnakerKind).stream().map(kind -> this.loadRelationshipsFromCache(cacheData, kind.toString())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Collection<CacheData> loadRelationshipsFromCache(Collection<CacheData> sources, String relationshipType) {
        List keys = this.cleanupCollection(sources).stream().map(CacheData::getRelationships).filter(Objects::nonNull).map(r -> (Collection)r.get(relationshipType)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        return this.cleanupCollection(this.cache.getAll(relationshipType, keys));
    }

    private <T> Collection<T> cleanupCollection(Collection<T> items) {
        if (items == null) {
            return new ArrayList();
        }
        return items.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Map<String, List<CacheData>> mapByRelationship(Collection<CacheData> targetData, KubernetesSpinnakerKindMap.SpinnakerKind sourceKind) {
        HashMap<String, List<CacheData>> result = new HashMap<String, List<CacheData>>();
        for (CacheData datum : targetData) {
            Collection<String> sourceKeys = this.aggregateRelationshipsBySpinnakerKind(datum, sourceKind);
            for (String sourceKey : sourceKeys) {
                List storedData = result.getOrDefault(sourceKey, new ArrayList());
                storedData.add(datum);
                result.put(sourceKey, storedData);
            }
        }
        return result;
    }

    public <T extends ManifestBasedModel> T resourceModelFromCacheData(KubernetesV2CacheData cacheData) {
        Keys.InfrastructureCacheKey key = (Keys.InfrastructureCacheKey)Keys.parseKey(cacheData.primaryData().getId()).get();
        KubernetesManifest manifest = KubernetesCacheDataConverter.getManifest(cacheData.primaryData());
        KubernetesResourceProperties properties = this.registry.get(key.getAccount(), manifest.getKind());
        KubernetesHandler handler = properties.getHandler();
        if (handler instanceof ModelHandler) {
            return (T)((ModelHandler)((Object)handler)).fromCacheData(cacheData);
        }
        return null;
    }
}

