/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2Cluster;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2LoadBalancer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2ServerGroup;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.data.KubernetesV2ServerGroupCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.model.ClusterProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2ClusterProvider
implements ClusterProvider<KubernetesV2Cluster> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2ClusterProvider.class);
    private final KubernetesCacheUtils cacheUtils;
    private final KubernetesSpinnakerKindMap kindMap;

    @Autowired
    KubernetesV2ClusterProvider(KubernetesCacheUtils cacheUtils, KubernetesSpinnakerKindMap kindMap) {
        this.cacheUtils = cacheUtils;
        this.kindMap = kindMap;
    }

    public Map<String, Set<KubernetesV2Cluster>> getClusters() {
        return this.groupByAccountName(this.translateClustersWithRelationships(this.cacheUtils.getAllKeys(Keys.LogicalKind.CLUSTERS.toString())));
    }

    public Map<String, Set<KubernetesV2Cluster>> getClusterSummaries(String application) {
        String applicationKey = Keys.application(application);
        return this.groupByAccountName(this.translateClusters(this.cacheUtils.getTransitiveRelationship(Keys.LogicalKind.APPLICATIONS.toString(), Collections.singletonList(applicationKey), Keys.LogicalKind.CLUSTERS.toString())));
    }

    public Map<String, Set<KubernetesV2Cluster>> getClusterDetails(String application) {
        String clusterGlobKey = Keys.cluster("*", application, "*");
        return this.groupByAccountName(this.translateClustersWithRelationships(this.cacheUtils.getAllDataMatchingPattern(Keys.LogicalKind.CLUSTERS.toString(), clusterGlobKey)));
    }

    public Set<KubernetesV2Cluster> getClusters(String application, String account) {
        String globKey = Keys.cluster(account, application, "*");
        return this.translateClustersWithRelationships(this.cacheUtils.getAllDataMatchingPattern(Keys.LogicalKind.CLUSTERS.toString(), globKey));
    }

    public KubernetesV2Cluster getCluster(String application, String account, String name) {
        return this.getCluster(application, account, name, true);
    }

    public KubernetesV2Cluster getCluster(String application, String account, String name, boolean includeDetails) {
        return this.cacheUtils.getSingleEntry(Keys.LogicalKind.CLUSTERS.toString(), Keys.cluster(account, application, name)).map(entry -> {
            List<CacheData> clusterData = Collections.singletonList(entry);
            Set<KubernetesV2Cluster> result = includeDetails ? this.translateClustersWithRelationships(clusterData) : this.translateClusters(clusterData);
            return result.iterator().next();
        }).orElse(null);
    }

    public KubernetesV2ServerGroup getServerGroup(String account, String namespace, String name, boolean includeDetails) {
        Pair<KubernetesKind, String> parsedName;
        try {
            parsedName = KubernetesManifest.fromFullResourceName(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        KubernetesKind kind = (KubernetesKind)parsedName.getLeft();
        String shortName = (String)parsedName.getRight();
        String key = Keys.infrastructure(kind, account, namespace, shortName);
        List<String> relatedTypes = this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.INSTANCES).stream().map(KubernetesKind::toString).collect(Collectors.toList());
        relatedTypes.addAll(this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.LOAD_BALANCERS).stream().map(KubernetesKind::toString).collect(Collectors.toList()));
        Optional<CacheData> serverGroupData = this.cacheUtils.getSingleEntryWithRelationships(kind.toString(), key, relatedTypes.toArray(new String[relatedTypes.size()]));
        return serverGroupData.map(cd -> {
            List<CacheData> instanceData = this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.INSTANCES).stream().map(k -> this.cacheUtils.loadRelationshipsFromCache(Collections.singletonList(cd), k.toString())).flatMap(Collection::stream).collect(Collectors.toList());
            List<CacheData> loadBalancerData = this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.LOAD_BALANCERS).stream().map(k -> this.cacheUtils.loadRelationshipsFromCache(Collections.singletonList(cd), k.toString())).flatMap(Collection::stream).collect(Collectors.toList());
            return (KubernetesV2ServerGroup)this.cacheUtils.resourceModelFromCacheData(KubernetesV2ServerGroupCacheData.builder().serverGroupData((CacheData)cd).instanceData(instanceData).loadBalancerData(loadBalancerData).build());
        }).orElse(null);
    }

    public KubernetesV2ServerGroup getServerGroup(String account, String namespace, String name) {
        return this.getServerGroup(account, namespace, name, true);
    }

    public String getCloudProviderId() {
        return KubernetesCloudProvider.getID();
    }

    public boolean supportsMinimalClusters() {
        return true;
    }

    private Map<String, Set<KubernetesV2Cluster>> groupByAccountName(Collection<KubernetesV2Cluster> clusters) {
        HashMap<String, Set<KubernetesV2Cluster>> result = new HashMap<String, Set<KubernetesV2Cluster>>();
        for (KubernetesV2Cluster cluster : clusters) {
            String accountName = cluster.getAccountName();
            HashSet<KubernetesV2Cluster> grouping = (HashSet<KubernetesV2Cluster>)result.get(accountName);
            if (grouping == null) {
                grouping = new HashSet<KubernetesV2Cluster>();
            }
            grouping.add(cluster);
            result.put(accountName, grouping);
        }
        return result;
    }

    private Set<KubernetesV2Cluster> translateClusters(Collection<CacheData> clusterData) {
        return clusterData.stream().map(this::translateCluster).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Set<KubernetesV2Cluster> translateClustersWithRelationships(Collection<CacheData> clusterData) {
        List<CacheData> serverGroupData = this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUPS).stream().map(kind -> this.cacheUtils.loadRelationshipsFromCache(clusterData, kind.toString())).flatMap(Collection::stream).collect(Collectors.toList());
        List<CacheData> loadBalancerData = this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.LOAD_BALANCERS).stream().map(kind -> this.cacheUtils.loadRelationshipsFromCache(serverGroupData, kind.toString())).flatMap(Collection::stream).collect(Collectors.toList());
        List<CacheData> instanceData = this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.INSTANCES).stream().map(kind -> this.cacheUtils.loadRelationshipsFromCache(serverGroupData, kind.toString())).flatMap(Collection::stream).collect(Collectors.toList());
        HashMap<String, List> clusterToServerGroups = new HashMap<String, List>();
        for (CacheData serverGroupDatum : serverGroupData) {
            Collection clusterKeys = (Collection)serverGroupDatum.getRelationships().get(Keys.LogicalKind.CLUSTERS.toString());
            if (clusterKeys == null || clusterKeys.size() != 1) {
                log.warn("Malformed cache, server group stored without cluster");
                continue;
            }
            String clusterKey = (String)clusterKeys.iterator().next();
            List storedData = clusterToServerGroups.getOrDefault(clusterKey, new ArrayList());
            storedData.add(serverGroupDatum);
            clusterToServerGroups.put(clusterKey, storedData);
        }
        Map<String, List<CacheData>> serverGroupToLoadBalancers = this.cacheUtils.mapByRelationship(loadBalancerData, KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUPS);
        Map<String, List<CacheData>> serverGroupToInstances = this.cacheUtils.mapByRelationship(instanceData, KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUPS);
        Map<String, List<CacheData>> loadBalancerToServerGroups = this.cacheUtils.mapByRelationship(serverGroupData, KubernetesSpinnakerKindMap.SpinnakerKind.LOAD_BALANCERS);
        HashSet<KubernetesV2Cluster> result = new HashSet<KubernetesV2Cluster>();
        for (CacheData clusterDatum : clusterData) {
            List clusterServerGroups = clusterToServerGroups.getOrDefault(clusterDatum.getId(), new ArrayList());
            List<CacheData> clusterLoadBalancers = clusterServerGroups.stream().map(CacheData::getId).map(id -> serverGroupToLoadBalancers.getOrDefault(id, new ArrayList())).flatMap(Collection::stream).collect(Collectors.toList());
            result.add(this.translateCluster(clusterDatum, clusterServerGroups, clusterLoadBalancers, serverGroupToInstances, loadBalancerToServerGroups, serverGroupToLoadBalancers));
        }
        return result.stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private KubernetesV2Cluster translateCluster(CacheData clusterDatum) {
        if (clusterDatum == null) {
            return null;
        }
        return new KubernetesV2Cluster(clusterDatum.getId());
    }

    private KubernetesV2Cluster translateCluster(CacheData clusterDatum, List<CacheData> serverGroupData, List<CacheData> loadBalancerData, Map<String, List<CacheData>> instanceDataByServerGroup, Map<String, List<CacheData>> serverGroupDataByLoadBalancer, Map<String, List<CacheData>> loadBalancerDataByServerGroup) {
        if (clusterDatum == null) {
            return null;
        }
        List<KubernetesV2ServerGroup> serverGroups = serverGroupData.stream().map(cd -> (KubernetesV2ServerGroup)this.cacheUtils.resourceModelFromCacheData(KubernetesV2ServerGroupCacheData.builder().serverGroupData((CacheData)cd).instanceData(instanceDataByServerGroup.getOrDefault(cd.getId(), new ArrayList())).loadBalancerData(loadBalancerDataByServerGroup.getOrDefault(cd.getId(), new ArrayList())).build())).filter(Objects::nonNull).collect(Collectors.toList());
        List<KubernetesV2LoadBalancer> loadBalancers = loadBalancerData.stream().map(cd -> KubernetesV2LoadBalancer.fromCacheData(cd, serverGroupDataByLoadBalancer.getOrDefault(cd.getId(), new ArrayList()), instanceDataByServerGroup)).filter(Objects::nonNull).collect(Collectors.toList());
        return new KubernetesV2Cluster(clusterDatum.getId(), serverGroups, loadBalancers);
    }
}

