/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesCachingProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestSpinnakerRelationships;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestStrategy;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesManifestAnnotater {
    private static final Logger log = LoggerFactory.getLogger(KubernetesManifestAnnotater.class);
    private static final String SPINNAKER_ANNOTATION = "spinnaker.io";
    private static final String RELATIONSHIP_ANNOTATION_PREFIX = "relationships.spinnaker.io";
    private static final String ARTIFACT_ANNOTATION_PREFIX = "artifact.spinnaker.io";
    private static final String MONIKER_ANNOTATION_PREFIX = "moniker.spinnaker.io";
    private static final String CACHING_ANNOTATION_PREFIX = "caching.spinnaker.io";
    private static final String STRATEGY_ANNOTATION_PREFIX = "strategy.spinnaker.io";
    private static final String LOAD_BALANCERS = "relationships.spinnaker.io/loadBalancers";
    private static final String SECURITY_GROUPS = "relationships.spinnaker.io/securityGroups";
    private static final String CLUSTER = "moniker.spinnaker.io/cluster";
    private static final String APPLICATION = "moniker.spinnaker.io/application";
    private static final String STACK = "moniker.spinnaker.io/stack";
    private static final String DETAIL = "moniker.spinnaker.io/detail";
    private static final String TYPE = "artifact.spinnaker.io/type";
    private static final String NAME = "artifact.spinnaker.io/name";
    private static final String LOCATION = "artifact.spinnaker.io/location";
    private static final String VERSION = "artifact.spinnaker.io/version";
    private static final String IGNORE_CACHING = "caching.spinnaker.io/ignore";
    private static final String VERSIONED = "strategy.spinnaker.io/versioned";
    private static final String KUBERNETES_ANNOTATION = "kubernetes.io";
    private static final String KUBECTL_ANNOTATION_PREFIX = "kubectl.kubernetes.io";
    private static final String DEPLOYMENT_ANNOTATION_PREFIX = "deployment.kubernetes.io";
    private static final String DEPLOYMENT_REVISION = "deployment.kubernetes.io/revision";
    private static final String KUBECTL_LAST_APPLIED_CONFIGURATION = "kubectl.kubernetes.io/last-applied-configuration";
    private static ObjectMapper objectMapper = new ObjectMapper();

    private static void storeAnnotation(Map<String, String> annotations, String key, Object value) {
        if (value == null) {
            return;
        }
        if (annotations.containsKey(key)) {
            return;
        }
        try {
            if (value instanceof String) {
                annotations.put(key, (String)value);
            } else {
                annotations.put(key, objectMapper.writeValueAsString(value));
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Illegal annotation value for '" + key + "': " + (Object)((Object)e));
        }
    }

    private static <T> T getAnnotation(Map<String, String> annotations, String key, TypeReference<T> typeReference) {
        return KubernetesManifestAnnotater.getAnnotation(annotations, key, typeReference, null);
    }

    private static boolean stringTypeReference(TypeReference typeReference) {
        if (typeReference.getType() == null || typeReference.getType().getTypeName() == null) {
            log.warn("Malformed type reference {}", (Object)typeReference);
            return false;
        }
        return typeReference.getType().getTypeName().equals(String.class.getName());
    }

    private static boolean looksLikeSerializedString(String value) {
        if (StringUtils.isEmpty((CharSequence)value) || value.length() == 1) {
            return false;
        }
        return value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    private static <T> T getAnnotation(Map<String, String> annotations, String key, TypeReference<T> typeReference, T defaultValue) {
        String value = annotations.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            boolean wantsString = KubernetesManifestAnnotater.stringTypeReference(typeReference);
            if (wantsString && !KubernetesManifestAnnotater.looksLikeSerializedString(value)) {
                return (T)value;
            }
            return (T)objectMapper.readValue(value, typeReference);
        }
        catch (Exception e) {
            log.warn("Illegally annotated resource for '" + key + "': " + e);
            return null;
        }
    }

    public static void annotateManifest(KubernetesManifest manifest, KubernetesManifestSpinnakerRelationships relationships) {
        Map<String, String> annotations = manifest.getAnnotations();
        KubernetesManifestAnnotater.storeAnnotations(annotations, relationships);
        manifest.getSpecTemplateAnnotations().flatMap(a -> {
            KubernetesManifestAnnotater.storeAnnotations((Map<String, String>)a, relationships);
            return Optional.empty();
        });
    }

    public static void annotateManifest(KubernetesManifest manifest, Moniker moniker) {
        Map<String, String> annotations = manifest.getAnnotations();
        KubernetesManifestAnnotater.storeAnnotations(annotations, moniker);
        manifest.getSpecTemplateAnnotations().flatMap(a -> {
            KubernetesManifestAnnotater.storeAnnotations((Map<String, String>)a, moniker);
            return Optional.empty();
        });
    }

    public static void annotateManifest(KubernetesManifest manifest, Artifact artifact) {
        Map<String, String> annotations = manifest.getAnnotations();
        KubernetesManifestAnnotater.storeAnnotations(annotations, artifact);
        manifest.getSpecTemplateAnnotations().flatMap(a -> {
            KubernetesManifestAnnotater.storeAnnotations((Map<String, String>)a, artifact);
            return Optional.empty();
        });
    }

    private static void storeAnnotations(Map<String, String> annotations, Moniker moniker) {
        if (moniker == null) {
            throw new IllegalArgumentException("Every resource deployed via spinnaker must be assigned a moniker");
        }
        KubernetesManifestAnnotater.storeAnnotation(annotations, CLUSTER, moniker.getCluster());
        KubernetesManifestAnnotater.storeAnnotation(annotations, APPLICATION, moniker.getApp());
        KubernetesManifestAnnotater.storeAnnotation(annotations, STACK, moniker.getStack());
        KubernetesManifestAnnotater.storeAnnotation(annotations, DETAIL, moniker.getDetail());
    }

    private static void storeAnnotations(Map<String, String> annotations, KubernetesManifestSpinnakerRelationships relationships) {
        if (relationships == null) {
            return;
        }
        KubernetesManifestAnnotater.storeAnnotation(annotations, LOAD_BALANCERS, relationships.getLoadBalancers());
        KubernetesManifestAnnotater.storeAnnotation(annotations, SECURITY_GROUPS, relationships.getSecurityGroups());
    }

    private static void storeAnnotations(Map<String, String> annotations, Artifact artifact) {
        if (artifact == null) {
            return;
        }
        KubernetesManifestAnnotater.storeAnnotation(annotations, TYPE, artifact.getType());
        KubernetesManifestAnnotater.storeAnnotation(annotations, NAME, artifact.getName());
        KubernetesManifestAnnotater.storeAnnotation(annotations, LOCATION, artifact.getLocation());
        KubernetesManifestAnnotater.storeAnnotation(annotations, VERSION, artifact.getVersion());
    }

    public static KubernetesManifestSpinnakerRelationships getManifestRelationships(KubernetesManifest manifest) {
        Map<String, String> annotations = manifest.getAnnotations();
        return new KubernetesManifestSpinnakerRelationships().setLoadBalancers(KubernetesManifestAnnotater.getAnnotation(annotations, LOAD_BALANCERS, new TypeReference<List<String>>(){})).setSecurityGroups(KubernetesManifestAnnotater.getAnnotation(annotations, SECURITY_GROUPS, new TypeReference<List<String>>(){}));
    }

    public static Artifact getArtifact(KubernetesManifest manifest) {
        Map<String, String> annotations = manifest.getAnnotations();
        return Artifact.builder().type(KubernetesManifestAnnotater.getAnnotation(annotations, TYPE, new TypeReference<String>(){})).name(KubernetesManifestAnnotater.getAnnotation(annotations, NAME, new TypeReference<String>(){})).location(KubernetesManifestAnnotater.getAnnotation(annotations, LOCATION, new TypeReference<String>(){})).version(KubernetesManifestAnnotater.getAnnotation(annotations, VERSION, new TypeReference<String>(){})).build();
    }

    public static Moniker getMoniker(KubernetesManifest manifest) {
        Names parsed = Names.parseName((String)manifest.getName());
        Map<String, String> annotations = manifest.getAnnotations();
        return Moniker.builder().cluster(KubernetesManifestAnnotater.getAnnotation(annotations, CLUSTER, new TypeReference<String>(){}, parsed.getCluster())).app(KubernetesManifestAnnotater.getAnnotation(annotations, APPLICATION, new TypeReference<String>(){}, parsed.getApp())).stack((String)KubernetesManifestAnnotater.getAnnotation(annotations, STACK, new TypeReference<String>(){}, null)).detail((String)KubernetesManifestAnnotater.getAnnotation(annotations, DETAIL, new TypeReference<String>(){}, null)).sequence((Integer)KubernetesManifestAnnotater.getAnnotation(annotations, DEPLOYMENT_REVISION, new TypeReference<Integer>(){}, null)).build();
    }

    public static KubernetesCachingProperties getCachingProperties(KubernetesManifest manifest) {
        Map<String, String> annotations = manifest.getAnnotations();
        return KubernetesCachingProperties.builder().ignore(KubernetesManifestAnnotater.getAnnotation(annotations, IGNORE_CACHING, new TypeReference<Boolean>(){}, false)).build();
    }

    public static KubernetesManifestStrategy getStrategy(KubernetesManifest manifest) {
        Map<String, String> annotations = manifest.getAnnotations();
        return KubernetesManifestStrategy.builder().versioned(KubernetesManifestAnnotater.getAnnotation(annotations, VERSIONED, new TypeReference<Boolean>(){})).build();
    }

    public static KubernetesManifest getLastAppliedConfiguration(KubernetesManifest manifest) {
        Map<String, String> annotations = manifest.getAnnotations();
        return KubernetesManifestAnnotater.getAnnotation(annotations, KUBECTL_LAST_APPLIED_CONFIGURATION, new TypeReference<KubernetesManifest>(){}, null);
    }
}

