/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesAtomicOperationDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesSelectorList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class KubernetesMultiManifestOperationDescription
extends KubernetesAtomicOperationDescription {
    private String manifestName;
    private String location;
    private List<String> kinds = new ArrayList<String>();
    private KubernetesSelectorList labelSelectors = new KubernetesSelectorList();

    @JsonIgnore
    public boolean isDynamic() {
        return StringUtils.isEmpty((String)this.manifestName);
    }

    public List<KubernetesCoordinates> getAllCoordinates() {
        return this.kinds.stream().map(k -> KubernetesCoordinates.builder().namespace(this.location).kind(KubernetesKind.fromString(k)).build()).collect(Collectors.toList());
    }

    @JsonIgnore
    @Deprecated
    public KubernetesCoordinates getPointCoordinates() {
        Pair<KubernetesKind, String> parsedName = KubernetesManifest.fromFullResourceName(this.manifestName);
        return KubernetesCoordinates.builder().namespace(this.location).kind((KubernetesKind)parsedName.getLeft()).name((String)parsedName.getRight()).build();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesMultiManifestOperationDescription)) {
            return false;
        }
        KubernetesMultiManifestOperationDescription other = (KubernetesMultiManifestOperationDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$manifestName = this.getManifestName();
        String other$manifestName = other.getManifestName();
        if (this$manifestName == null ? other$manifestName != null : !this$manifestName.equals(other$manifestName)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        List<String> this$kinds = this.getKinds();
        List<String> other$kinds = other.getKinds();
        if (this$kinds == null ? other$kinds != null : !((Object)this$kinds).equals(other$kinds)) {
            return false;
        }
        KubernetesSelectorList this$labelSelectors = this.getLabelSelectors();
        KubernetesSelectorList other$labelSelectors = other.getLabelSelectors();
        return !(this$labelSelectors == null ? other$labelSelectors != null : !((Object)this$labelSelectors).equals(other$labelSelectors));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesMultiManifestOperationDescription;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $manifestName = this.getManifestName();
        result = result * 59 + ($manifestName == null ? 43 : $manifestName.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        List<String> $kinds = this.getKinds();
        result = result * 59 + ($kinds == null ? 43 : ((Object)$kinds).hashCode());
        KubernetesSelectorList $labelSelectors = this.getLabelSelectors();
        result = result * 59 + ($labelSelectors == null ? 43 : ((Object)$labelSelectors).hashCode());
        return result;
    }

    public String getManifestName() {
        return this.manifestName;
    }

    public String getLocation() {
        return this.location;
    }

    public List<String> getKinds() {
        return this.kinds;
    }

    public KubernetesSelectorList getLabelSelectors() {
        return this.labelSelectors;
    }

    public KubernetesMultiManifestOperationDescription setManifestName(String manifestName) {
        this.manifestName = manifestName;
        return this;
    }

    public KubernetesMultiManifestOperationDescription setLocation(String location) {
        this.location = location;
        return this;
    }

    public KubernetesMultiManifestOperationDescription setKinds(List<String> kinds) {
        this.kinds = kinds;
        return this;
    }

    public KubernetesMultiManifestOperationDescription setLabelSelectors(KubernetesSelectorList labelSelectors) {
        this.labelSelectors = labelSelectors;
        return this;
    }

    @Override
    public String toString() {
        return "KubernetesMultiManifestOperationDescription(manifestName=" + this.getManifestName() + ", location=" + this.getLocation() + ", kinds=" + this.getKinds() + ", labelSelectors=" + this.getLabelSelectors() + ")";
    }
}

