/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.RegistryUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OperationResult {
    Map<String, Set<String>> manifestNamesByNamespace = new HashMap<String, Set<String>>();
    Set<KubernetesManifest> manifests = new HashSet<KubernetesManifest>();
    Set<Artifact> createdArtifacts = new HashSet<Artifact>();
    Set<Artifact> boundArtifacts = new HashSet<Artifact>();

    public void removeSensitiveKeys(KubernetesResourcePropertyRegistry propertyRegistry, String accountName) {
        this.manifests.forEach(m -> RegistryUtils.removeSensitiveKeys(propertyRegistry, accountName, m));
    }

    public OperationResult addManifest(KubernetesManifest manifest) {
        this.manifests.add(manifest);
        Set addedNames = this.manifestNamesByNamespace.getOrDefault(manifest.getNamespace(), new HashSet());
        addedNames.add(manifest.getFullResourceName());
        this.manifestNamesByNamespace.put(manifest.getNamespace(), addedNames);
        return this;
    }

    public void merge(OperationResult other) {
        for (Map.Entry<String, Set<String>> entry : other.manifestNamesByNamespace.entrySet()) {
            Set thisManifests = this.manifestNamesByNamespace.getOrDefault(entry.getKey(), new HashSet());
            thisManifests.addAll((Collection)entry.getValue());
            this.manifestNamesByNamespace.put(entry.getKey(), thisManifests);
        }
        this.manifests.addAll(other.manifests);
        this.createdArtifacts.addAll(other.createdArtifacts);
        this.boundArtifacts.addAll(other.boundArtifacts);
    }

    public static OperationResultBuilder builder() {
        return new OperationResultBuilder();
    }

    public Map<String, Set<String>> getManifestNamesByNamespace() {
        return this.manifestNamesByNamespace;
    }

    public Set<KubernetesManifest> getManifests() {
        return this.manifests;
    }

    public Set<Artifact> getCreatedArtifacts() {
        return this.createdArtifacts;
    }

    public Set<Artifact> getBoundArtifacts() {
        return this.boundArtifacts;
    }

    public OperationResult setManifestNamesByNamespace(Map<String, Set<String>> manifestNamesByNamespace) {
        this.manifestNamesByNamespace = manifestNamesByNamespace;
        return this;
    }

    public OperationResult setManifests(Set<KubernetesManifest> manifests) {
        this.manifests = manifests;
        return this;
    }

    public OperationResult setCreatedArtifacts(Set<Artifact> createdArtifacts) {
        this.createdArtifacts = createdArtifacts;
        return this;
    }

    public OperationResult setBoundArtifacts(Set<Artifact> boundArtifacts) {
        this.boundArtifacts = boundArtifacts;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationResult)) {
            return false;
        }
        OperationResult other = (OperationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Set<String>> this$manifestNamesByNamespace = this.getManifestNamesByNamespace();
        Map<String, Set<String>> other$manifestNamesByNamespace = other.getManifestNamesByNamespace();
        if (this$manifestNamesByNamespace == null ? other$manifestNamesByNamespace != null : !((Object)this$manifestNamesByNamespace).equals(other$manifestNamesByNamespace)) {
            return false;
        }
        Set<KubernetesManifest> this$manifests = this.getManifests();
        Set<KubernetesManifest> other$manifests = other.getManifests();
        if (this$manifests == null ? other$manifests != null : !((Object)this$manifests).equals(other$manifests)) {
            return false;
        }
        Set<Artifact> this$createdArtifacts = this.getCreatedArtifacts();
        Set<Artifact> other$createdArtifacts = other.getCreatedArtifacts();
        if (this$createdArtifacts == null ? other$createdArtifacts != null : !((Object)this$createdArtifacts).equals(other$createdArtifacts)) {
            return false;
        }
        Set<Artifact> this$boundArtifacts = this.getBoundArtifacts();
        Set<Artifact> other$boundArtifacts = other.getBoundArtifacts();
        return !(this$boundArtifacts == null ? other$boundArtifacts != null : !((Object)this$boundArtifacts).equals(other$boundArtifacts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OperationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Set<String>> $manifestNamesByNamespace = this.getManifestNamesByNamespace();
        result = result * 59 + ($manifestNamesByNamespace == null ? 43 : ((Object)$manifestNamesByNamespace).hashCode());
        Set<KubernetesManifest> $manifests = this.getManifests();
        result = result * 59 + ($manifests == null ? 43 : ((Object)$manifests).hashCode());
        Set<Artifact> $createdArtifacts = this.getCreatedArtifacts();
        result = result * 59 + ($createdArtifacts == null ? 43 : ((Object)$createdArtifacts).hashCode());
        Set<Artifact> $boundArtifacts = this.getBoundArtifacts();
        result = result * 59 + ($boundArtifacts == null ? 43 : ((Object)$boundArtifacts).hashCode());
        return result;
    }

    public String toString() {
        return "OperationResult(manifestNamesByNamespace=" + this.getManifestNamesByNamespace() + ", manifests=" + this.getManifests() + ", createdArtifacts=" + this.getCreatedArtifacts() + ", boundArtifacts=" + this.getBoundArtifacts() + ")";
    }

    public OperationResult() {
    }

    @ConstructorProperties(value={"manifestNamesByNamespace", "manifests", "createdArtifacts", "boundArtifacts"})
    public OperationResult(Map<String, Set<String>> manifestNamesByNamespace, Set<KubernetesManifest> manifests, Set<Artifact> createdArtifacts, Set<Artifact> boundArtifacts) {
        this.manifestNamesByNamespace = manifestNamesByNamespace;
        this.manifests = manifests;
        this.createdArtifacts = createdArtifacts;
        this.boundArtifacts = boundArtifacts;
    }

    public static class OperationResultBuilder {
        private Map<String, Set<String>> manifestNamesByNamespace;
        private Set<KubernetesManifest> manifests;
        private Set<Artifact> createdArtifacts;
        private Set<Artifact> boundArtifacts;

        OperationResultBuilder() {
        }

        public OperationResultBuilder manifestNamesByNamespace(Map<String, Set<String>> manifestNamesByNamespace) {
            this.manifestNamesByNamespace = manifestNamesByNamespace;
            return this;
        }

        public OperationResultBuilder manifests(Set<KubernetesManifest> manifests) {
            this.manifests = manifests;
            return this;
        }

        public OperationResultBuilder createdArtifacts(Set<Artifact> createdArtifacts) {
            this.createdArtifacts = createdArtifacts;
            return this;
        }

        public OperationResultBuilder boundArtifacts(Set<Artifact> boundArtifacts) {
            this.boundArtifacts = boundArtifacts;
            return this;
        }

        public OperationResult build() {
            return new OperationResult(this.manifestNamesByNamespace, this.manifests, this.createdArtifacts, this.boundArtifacts);
        }

        public String toString() {
            return "OperationResult.OperationResultBuilder(manifestNamesByNamespace=" + this.manifestNamesByNamespace + ", manifests=" + this.manifests + ", createdArtifacts=" + this.createdArtifacts + ", boundArtifacts=" + this.boundArtifacts + ")";
        }
    }
}

