/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacerFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanDelete;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.ServerGroupHandler;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import io.kubernetes.client.models.V1Job;
import io.kubernetes.client.models.V1JobCondition;
import io.kubernetes.client.models.V1JobSpec;
import io.kubernetes.client.models.V1JobStatus;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class KubernetesJobHandler
extends KubernetesHandler
implements CanDelete,
ServerGroupHandler {
    public KubernetesJobHandler() {
        this.registerReplacer(ArtifactReplacerFactory.dockerImageReplacer());
        this.registerReplacer(ArtifactReplacerFactory.configMapVolumeReplacer());
        this.registerReplacer(ArtifactReplacerFactory.secretVolumeReplacer());
        this.registerReplacer(ArtifactReplacerFactory.configMapEnvFromReplacer());
        this.registerReplacer(ArtifactReplacerFactory.secretEnvFromReplacer());
        this.registerReplacer(ArtifactReplacerFactory.configMapKeyValueFromReplacer());
        this.registerReplacer(ArtifactReplacerFactory.secretKeyValueFromReplacer());
    }

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.WORKLOAD_CONTROLLER_PRIORITY.getValue();
    }

    @Override
    public KubernetesKind kind() {
        return KubernetesKind.JOB;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    public KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind() {
        return KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUPS;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        V1Job v1Job = KubernetesCacheDataConverter.getResource(manifest, V1Job.class);
        return this.status(v1Job);
    }

    @Override
    public Class<? extends KubernetesV2CachingAgent> cachingAgentClass() {
        return KubernetesCoreCachingAgent.class;
    }

    private Manifest.Status status(V1Job job) {
        Manifest.Status result = new Manifest.Status();
        V1JobStatus status = job.getStatus();
        if (status == null) {
            result.unstable("No status reported yet").unavailable("No availability reported");
            return result;
        }
        int completions = 1;
        V1JobSpec spec = job.getSpec();
        if (spec != null && spec.getCompletions() != null) {
            completions = spec.getCompletions();
        }
        int succeeded = 0;
        if (status.getSucceeded() != null) {
            succeeded = status.getSucceeded();
        }
        if (succeeded < completions) {
            List conditions = status.getConditions();
            conditions = conditions != null ? conditions : Collections.emptyList();
            Optional<V1JobCondition> condition = conditions.stream().filter(this::jobFailed).findAny();
            if (condition.isPresent()) {
                return result.failed(condition.get().getMessage());
            }
            return result.unstable("Waiting for jobs to finish");
        }
        return result;
    }

    private boolean jobFailed(V1JobCondition condition) {
        return "Failed".equalsIgnoreCase(condition.getType()) && "True".equalsIgnoreCase(condition.getStatus());
    }
}

