/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactTypes;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanDelete;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import io.kubernetes.client.models.V1Pod;
import io.kubernetes.client.models.V1PodStatus;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class KubernetesPodHandler
extends KubernetesHandler
implements CanDelete {
    public KubernetesPodHandler() {
        this.registerReplacer(ArtifactReplacer.Replacer.builder().replacePath("$.spec.containers.[?( @.image == \"{%name%}\" )].image").findPath("$.spec.containers.*.image").type(ArtifactTypes.DOCKER_IMAGE).build());
    }

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.WORKLOAD_PRIORITY.getValue();
    }

    @Override
    public KubernetesKind kind() {
        return KubernetesKind.POD;
    }

    @Override
    public boolean versioned() {
        return true;
    }

    @Override
    public KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind() {
        return KubernetesSpinnakerKindMap.SpinnakerKind.INSTANCES;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        Manifest.Status result = new Manifest.Status();
        V1Pod pod = KubernetesCacheDataConverter.getResource(manifest, V1Pod.class);
        V1PodStatus status = pod.getStatus();
        if (status == null) {
            result.unstable("No status reported yet").unavailable("No availability reported");
            return result;
        }
        String phase = status.getPhase();
        if (phase == null) {
            result.unstable("No phase reported yet").unavailable("No availability reported");
        } else if (phase.equals("pending")) {
            result.unstable("Pod is 'pending'").unavailable("Pod has not been scheduled yet");
        } else if (phase.equals("unknown")) {
            result.unstable("Pod has 'unknown' phase").unavailable("No availability reported");
        } else if (phase.equals("failed")) {
            result.failed("Pod has 'failed'").unavailable("Pod is not running");
        }
        return result;
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key, KubernetesCacheUtils cacheUtils) {
        Map<String, Object> result = super.hydrateSearchResult(key, cacheUtils);
        result.put("instanceId", result.get("name"));
        return result;
    }

    @Override
    public Class<? extends KubernetesV2CachingAgent> cachingAgentClass() {
        return KubernetesCoreCachingAgent.class;
    }
}

