/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.manifest;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.KubernetesArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesDeployManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestStrategy;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.model.ArtifactProvider;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.moniker.Moniker;
import com.netflix.spinnaker.moniker.Namer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesDeployManifestOperation
implements AtomicOperation<OperationResult> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesDeployManifestOperation.class);
    private final KubernetesDeployManifestDescription description;
    private final KubernetesV2Credentials credentials;
    private final ArtifactProvider provider;
    private final Namer namer;
    private final KubernetesResourcePropertyRegistry registry;
    private final String accountName;
    private static final String OP_NAME = "DEPLOY_KUBERNETES_MANIFEST";

    public KubernetesDeployManifestOperation(KubernetesDeployManifestDescription description, KubernetesResourcePropertyRegistry registry, ArtifactProvider provider) {
        this.description = description;
        this.credentials = (KubernetesV2Credentials)description.getCredentials().getCredentials();
        this.registry = registry;
        this.provider = provider;
        this.accountName = description.getCredentials().getName();
        this.namer = NamerRegistry.lookup().withProvider(KubernetesCloudProvider.getID()).withAccount(this.accountName).withResource(KubernetesManifest.class);
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public OperationResult operate(List _unused) {
        List<Artifact> optionalArtifacts;
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Beginning deployment of manifest...");
        List<KubernetesManifest> inputManifests = this.description.getManifests();
        ArrayList<KubernetesManifest> deployManifests = new ArrayList<KubernetesManifest>();
        if (inputManifests == null || inputManifests.isEmpty()) {
            log.warn("Relying on deprecated single manifest input: " + this.description.getManifest());
            inputManifests = Collections.singletonList(this.description.getManifest());
        }
        inputManifests = inputManifests.stream().filter(Objects::nonNull).collect(Collectors.toList());
        List<Artifact> requiredArtifacts = this.description.getRequiredArtifacts();
        if (requiredArtifacts == null) {
            requiredArtifacts = new ArrayList<Artifact>();
        }
        if ((optionalArtifacts = this.description.getOptionalArtifacts()) == null) {
            optionalArtifacts = new ArrayList<Artifact>();
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        artifacts.addAll(requiredArtifacts);
        artifacts.addAll(optionalArtifacts);
        HashSet<Artifact> boundArtifacts = new HashSet<Artifact>();
        for (KubernetesManifest manifest : inputManifests) {
            KubernetesResourceProperties properties;
            if (StringUtils.isEmpty((String)manifest.getNamespace()) && manifest.getKind().isNamespaced()) {
                manifest.setNamespace(this.credentials.getDefaultNamespace());
            }
            if ((properties = this.findResourceProperties(manifest)) == null) {
                throw new IllegalArgumentException("Unsupported Kubernetes object kind '" + manifest.getKind().toString() + "', unable to continue.");
            }
            KubernetesHandler deployer = properties.getHandler();
            if (deployer == null) {
                throw new IllegalArgumentException("No deployer available for Kubernetes object kind '" + manifest.getKind().toString() + "', unable to continue.");
            }
            KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Swapping out artifacts in " + manifest.getFullResourceName() + " from context...");
            ArtifactReplacer.ReplaceResult replaceResult = deployer.replaceArtifacts(manifest, artifacts);
            deployManifests.add(replaceResult.getManifest());
            boundArtifacts.addAll(replaceResult.getBoundArtifacts());
        }
        HashSet<Artifact> unboundArtifacts = new HashSet<Artifact>(requiredArtifacts);
        unboundArtifacts.removeAll(boundArtifacts);
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Checking if all requested artifacts were bound...");
        if (!unboundArtifacts.isEmpty()) {
            throw new IllegalArgumentException("The following artifacts could not be bound: '" + unboundArtifacts + "' . Failing the stage as this is likely a configuration error.");
        }
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Sorting manifests by priority...");
        deployManifests.sort(Comparator.comparingInt(m -> this.findResourceProperties((KubernetesManifest)m).getHandler().deployPriority()));
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Deploy order is: " + String.join((CharSequence)", ", deployManifests.stream().map(KubernetesManifest::getFullResourceName).collect(Collectors.toList())));
        OperationResult result = new OperationResult();
        for (KubernetesManifest manifest : deployManifests) {
            KubernetesManifestStrategy strategy;
            KubernetesResourceProperties properties = this.findResourceProperties(manifest);
            boolean versioned = this.isVersioned(properties, strategy = KubernetesManifestAnnotater.getStrategy(manifest));
            KubernetesArtifactConverter converter = versioned ? properties.getVersionedConverter() : properties.getUnversionedConverter();
            KubernetesHandler deployer = properties.getHandler();
            Moniker moniker = KubernetesDeployManifestOperation.cloneMoniker(this.description.getMoniker());
            if (StringUtils.isEmpty((String)moniker.getCluster())) {
                moniker.setCluster(manifest.getFullResourceName());
            }
            Artifact artifact = converter.toArtifact(this.provider, manifest);
            KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Annotating manifest " + manifest.getFullResourceName() + " with artifact, relationships & moniker...");
            KubernetesManifestAnnotater.annotateManifest(manifest, artifact);
            this.namer.applyMoniker((Object)manifest, moniker);
            manifest.setName(converter.getDeployedName(artifact));
            KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Swapping out artifacts in " + manifest.getFullResourceName() + " from other deployments...");
            ArtifactReplacer.ReplaceResult replaceResult = deployer.replaceArtifacts(manifest, new ArrayList<Artifact>(result.getCreatedArtifacts()));
            boundArtifacts.addAll(replaceResult.getBoundArtifacts());
            manifest = replaceResult.getManifest();
            KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Submitting manifest " + manifest.getFullResourceName() + " to kubernetes master...");
            result.merge(deployer.deploy(this.credentials, manifest));
            result.getCreatedArtifacts().add(artifact);
        }
        result.getBoundArtifacts().addAll(boundArtifacts);
        result.removeSensitiveKeys(this.registry, this.accountName);
        return result;
    }

    private boolean isVersioned(KubernetesResourceProperties properties, KubernetesManifestStrategy strategy) {
        if (strategy.getVersioned() != null) {
            return strategy.getVersioned();
        }
        if (this.description.getVersioned() != null) {
            return this.description.getVersioned();
        }
        return properties.isVersioned();
    }

    private static Moniker cloneMoniker(Moniker inp) {
        return Moniker.builder().app(inp.getApp()).cluster(inp.getCluster()).stack(inp.getStack()).detail(inp.getDetail()).sequence(inp.getSequence()).build();
    }

    private KubernetesResourceProperties findResourceProperties(KubernetesManifest manifest) {
        KubernetesKind kind = manifest.getKind();
        KubernetesDeployManifestOperation.getTask().updateStatus(OP_NAME, "Finding deployer for " + kind + "...");
        return this.registry.get(this.accountName, kind);
    }
}

