/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.security;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.KubeConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class KubernetesApiClientConfig
extends Config
implements GroovyObject {
    private String kubeconfigFile;
    private String context;
    private String cluster;
    private String user;
    private String userAgent;
    private Boolean serviceAccount;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public KubernetesApiClientConfig(String kubeconfigFile, String context, String cluster, String user, String userAgent, Boolean serviceAccount) {
        MetaClass metaClass;
        CallSite[] callSiteArray = KubernetesApiClientConfig.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        String string = kubeconfigFile;
        this.kubeconfigFile = ShortTypeHandling.castToString((Object)string);
        String string2 = context;
        this.context = ShortTypeHandling.castToString((Object)string2);
        String string3 = user;
        this.user = ShortTypeHandling.castToString((Object)string3);
        String string4 = userAgent;
        this.userAgent = ShortTypeHandling.castToString((Object)string4);
        Boolean bl = serviceAccount;
        this.serviceAccount = (Boolean)ScriptBytecodeAdapter.castToType((Object)bl, Boolean.class);
    }

    public ApiClient getApiCient() throws Exception {
        CallSite[] callSiteArray = KubernetesApiClientConfig.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)this.serviceAccount)) {
                return (ApiClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callCurrent((GroovyObject)this), ApiClient.class);
            }
            return (ApiClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callCurrent((GroovyObject)this), ApiClient.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.serviceAccount)) {
            return this.withServiceAccount();
        }
        return this.withKubeConfig();
    }

    public ApiClient withServiceAccount() {
        CallSite[] callSiteArray = KubernetesApiClientConfig.$getCallSiteArray();
        ApiClient client = (ApiClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(ApiClient.class), ApiClient.class);
        try {
            boolean serviceAccountCaCertExists = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(Files.class, callSiteArray[4].call(callSiteArray[5].callConstructor(File.class, callSiteArray[6].callGetProperty(io.fabric8.kubernetes.client.Config.class)))));
            if (!serviceAccountCaCertExists) {
                throw (Throwable)callSiteArray[10].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[11].callGetProperty(io.fabric8.kubernetes.client.Config.class)}, new String[]{"Could not find CA cert for service account at ", ""}));
            }
            callSiteArray[7].call((Object)client, callSiteArray[8].callConstructor(FileInputStream.class, callSiteArray[9].callGetProperty(io.fabric8.kubernetes.client.Config.class)));
        }
        catch (IOException e) {
            throw (Throwable)callSiteArray[12].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[13].callGetProperty(io.fabric8.kubernetes.client.Config.class)}, new String[]{"Could not find CA cert for service account at ", ""}), (Object)e);
        }
        try {
            String serviceTokenCandidate = ShortTypeHandling.castToString((Object)callSiteArray[14].callConstructor(String.class, callSiteArray[15].call(Files.class, callSiteArray[16].call(callSiteArray[17].callConstructor(File.class, callSiteArray[18].callGetProperty(io.fabric8.kubernetes.client.Config.class))))));
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)serviceTokenCandidate, null)) {
                throw (Throwable)callSiteArray[21].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[22].callGetProperty(io.fabric8.kubernetes.client.Config.class)}, new String[]{"Did not find service account token at ", ""}));
            }
            callSiteArray[19].call((Object)client, callSiteArray[20].call((Object)"Bearer ", (Object)serviceTokenCandidate));
        }
        catch (IOException e) {
            throw (Throwable)callSiteArray[23].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[24].callGetProperty(io.fabric8.kubernetes.client.Config.class)}, new String[]{"Could not read service account token at ", ""}), (Object)e);
        }
        return client;
    }

    public ApiClient withKubeConfig() {
        CallSite[] callSiteArray = KubernetesApiClientConfig.$getCallSiteArray();
        KubeConfig kubeconfig = null;
        try {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[25].call(StringUtils.class, (Object)this.kubeconfigFile))) {
                Object object = callSiteArray[26].call(KubeConfig.class);
                kubeconfig = (KubeConfig)ScriptBytecodeAdapter.castToType((Object)object, KubeConfig.class);
            } else {
                Object object = callSiteArray[27].call(KubeConfig.class, callSiteArray[28].callConstructor(FileReader.class, (Object)this.kubeconfigFile));
                kubeconfig = (KubeConfig)ScriptBytecodeAdapter.castToType((Object)object, KubeConfig.class);
            }
        }
        catch (FileNotFoundException e) {
            throw (Throwable)callSiteArray[29].callConstructor(RuntimeException.class, callSiteArray[30].call((Object)"Unable to create credentials from kubeconfig file: ", (Object)e), (Object)e);
        }
        catch (Exception e2) {
            throw (Throwable)callSiteArray[31].callConstructor(RuntimeException.class, (Object)"Missing required field(s) in kubenetes configuration file.");
        }
        InputStream is = (InputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].callConstructor(FileInputStream.class, (Object)this.kubeconfigFile), InputStream.class);
        Reader input = (Reader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].callConstructor(InputStreamReader.class, (Object)is), Reader.class);
        Yaml yaml = (Yaml)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].callConstructor(Yaml.class, callSiteArray[35].callConstructor(SafeConstructor.class)), Yaml.class);
        Object config = callSiteArray[36].call((Object)yaml, (Object)input);
        Map configMap = (Map)ScriptBytecodeAdapter.castToType((Object)config, Map.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[37].call(StringUtils.class, (Object)this.context)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[38].call((Object)configMap, (Object)"current-context"))) {
            throw (Throwable)callSiteArray[39].callConstructor(RuntimeException.class, (Object)new GStringImpl(new Object[]{this.context}, new String[]{"Missing required field ", " in kubeconfig file and clouddriver configuration."}));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[40].call(StringUtils.class, (Object)this.context))) {
            callSiteArray[41].call((Object)kubeconfig, (Object)this.context);
        }
        ApiClient client = (ApiClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].call(Config.class, (Object)kubeconfig), ApiClient.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].call(StringUtils.class, (Object)this.userAgent))) {
            callSiteArray[44].call((Object)client, (Object)this.userAgent);
        }
        callSiteArray[45].call((Object)is);
        callSiteArray[46].call((Object)input);
        return client;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != KubernetesApiClientConfig.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = KubernetesApiClientConfig.$getCallSiteArray()[47].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesApiClientConfig");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    public String getKubeconfigFile() {
        return this.kubeconfigFile;
    }

    public void setKubeconfigFile(String string) {
        this.kubeconfigFile = string;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String string) {
        this.context = string;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String string) {
        this.cluster = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public Boolean getServiceAccount() {
        return this.serviceAccount;
    }

    public void setServiceAccount(Boolean bl) {
        this.serviceAccount = bl;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "withServiceAccount";
        stringArray[1] = "withKubeConfig";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "isRegularFile";
        stringArray[4] = "toPath";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[7] = "setSslCaCert";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "readAllBytes";
        stringArray[16] = "toPath";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH";
        stringArray[19] = "setApiKey";
        stringArray[20] = "plus";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH";
        stringArray[25] = "isEmpty";
        stringArray[26] = "loadDefaultKubeConfig";
        stringArray[27] = "loadKubeConfig";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "plus";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "load";
        stringArray[37] = "isEmpty";
        stringArray[38] = "get";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "isEmpty";
        stringArray[41] = "setContext";
        stringArray[42] = "fromConfig";
        stringArray[43] = "isEmpty";
        stringArray[44] = "setUserAgent";
        stringArray[45] = "close";
        stringArray[46] = "close";
        stringArray[47] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[48];
        KubernetesApiClientConfig.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(KubernetesApiClientConfig.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = KubernetesApiClientConfig.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

