/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.validators;

import com.netflix.spinnaker.clouddriver.kubernetes.v1.security.KubernetesV1Credentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import java.util.List;
import org.apache.http.conn.util.InetAddressUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.validation.Errors;

public class StandardKubernetesAttributeValidator
implements GroovyObject {
    private static final Object namePattern;
    private static final Object dnsSubdomainPattern;
    private static final Object credentialsPattern;
    private static final Object prefixPattern;
    private static final Object pathPattern;
    private static final Object relativePathPattern;
    private static final Object quantityPattern;
    private static final Object protocolList;
    private static final Object serviceTypeList;
    private static final Object sessionAffinityList;
    private static final Object restartPolicyList;
    private static final Object uriSchemeList;
    private static final Object maxPort;
    private String context;
    private Errors errors;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public StandardKubernetesAttributeValidator(String context, Errors errors) {
        MetaClass metaClass;
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        String string = context;
        this.context = ShortTypeHandling.castToString((Object)string);
        Errors errors2 = errors;
        this.errors = (Errors)ScriptBytecodeAdapter.castToType((Object)errors2, Errors.class);
    }

    public Object validateByRegex(String value, String attribute, String regex) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (ScriptBytecodeAdapter.matchRegex((Object)value, (Object)regex)) {
            boolean bl = true;
            result = bl;
        } else {
            callSiteArray[0].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, regex}, new String[]{"", ".", ".invalid (Must match ", ")"}));
            boolean bl = false;
            result = bl;
        }
        return result;
    }

    public Object validateByContainment(Object value, String attribute, List<Object> list) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(list, value))) {
            boolean bl = true;
            result = bl;
        } else {
            callSiteArray[2].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, list}, new String[]{"", ".", ".invalid (Must be one of ", ")"}));
            boolean bl = false;
            result = bl;
        }
        return result;
    }

    public Object reject(String attribute, String reason) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        return callSiteArray[3].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, reason}, new String[]{"", ".", ".invalid (", ")"}));
    }

    public Object validateDetails(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return true;
        }
        return callSiteArray[4].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, namePattern);
    }

    public Object validateName(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            return callSiteArray[6].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, namePattern);
        }
        return false;
    }

    public Object validateSecretName(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            return callSiteArray[8].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, dnsSubdomainPattern);
        }
        return false;
    }

    public Object validatePath(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            return callSiteArray[10].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, pathPattern);
        }
        return false;
    }

    public Object validateRelativePath(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            return callSiteArray[12].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, relativePathPattern);
        }
        return false;
    }

    public Object validateProtocol(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            return callSiteArray[14].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, protocolList);
        }
        return false;
    }

    public Object validateSessionAffinity(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)value) ? callSiteArray[15].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, sessionAffinityList) : null;
    }

    public Object validateUriScheme(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)value) ? callSiteArray[16].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, uriSchemeList) : null;
    }

    public Object validateIpv4(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Object result = callSiteArray[17].call(InetAddressUtils.class, (Object)value);
        if (!DefaultTypeTransformation.booleanUnbox((Object)result)) {
            callSiteArray[18].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid (Not valid IPv4 address)"}));
        }
        return result;
    }

    public Object validateServiceType(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)value) ? callSiteArray[19].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, serviceTypeList) : Boolean.valueOf(true);
    }

    public Object validatePort(int port, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            boolean bl = port >= 1 && ScriptBytecodeAdapter.compareLessThanEqual((Object)port, (Object)maxPort);
            result = bl;
        } else {
            boolean bl = port >= 1 && ScriptBytecodeAdapter.compareLessThanEqual((Object)port, (Object)maxPort);
            result = bl;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)result)) {
            callSiteArray[20].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, maxPort}, new String[]{"", ".", ".invalid (Must be in range [1, ", "])"}));
        }
        return result;
    }

    public Object validateApplication(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            return callSiteArray[22].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, prefixPattern);
        }
        return false;
    }

    public Object validateStack(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return true;
        }
        return callSiteArray[23].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, prefixPattern);
    }

    public Object validateCpu(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return true;
        }
        return callSiteArray[24].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, quantityPattern);
    }

    public Object validateMemory(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return true;
        }
        return callSiteArray[25].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, quantityPattern);
    }

    public Object validateImagePullSecret(KubernetesV1Credentials credentials, String value, String namespace, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].call((Object)credentials, (Object)value, (Object)namespace))) {
            callSiteArray[27].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".notRegistered"}));
            return false;
        }
        return callSiteArray[28].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, namePattern);
    }

    public Object validateNamespace(KubernetesV1Credentials credentials, String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return true;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[29].call((Object)credentials, (Object)value))) {
            callSiteArray[30].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".notRegistered"}));
            return false;
        }
        return callSiteArray[31].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, namePattern);
    }

    public Object validateNotEmpty(Object value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)"") && ScriptBytecodeAdapter.compareNotEqual((Object)value, null) && ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]))) {
                boolean bl = true;
                result = bl;
            } else {
                callSiteArray[32].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
                boolean bl = false;
                result = bl;
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)"") && ScriptBytecodeAdapter.compareNotEqual((Object)value, null) && ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]))) {
            boolean bl = true;
            result = bl;
        } else {
            callSiteArray[33].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
            boolean bl = false;
            result = bl;
        }
        return result;
    }

    public Object validateCredentials(String credentials, AccountCredentialsProvider accountCredentialsProvider) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Object result = callSiteArray[34].callCurrent((GroovyObject)this, (Object)credentials, (Object)"account");
        if (DefaultTypeTransformation.booleanUnbox((Object)result)) {
            Object kubernetesCredentials = callSiteArray[35].call((Object)accountCredentialsProvider, (Object)credentials);
            if (!(callSiteArray[36].callGetPropertySafe(kubernetesCredentials) instanceof KubernetesV1Credentials)) {
                callSiteArray[37].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".account"}), (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".account.notFound"}));
                boolean bl = false;
                result = bl;
            }
        }
        return result;
    }

    public Object validateNonNegative(int value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (value >= 0) {
                boolean bl = true;
                result = bl;
            } else {
                callSiteArray[38].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".negative"}));
                boolean bl = false;
                result = bl;
            }
        } else if (value >= 0) {
            boolean bl = true;
            result = bl;
        } else {
            callSiteArray[39].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".negative"}));
            boolean bl = false;
            result = bl;
        }
        return result;
    }

    public Object validatePositive(int value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        Boolean result = null;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (value > 0) {
                boolean bl = true;
                result = bl;
            } else {
                callSiteArray[40].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".notPositive"}));
                boolean bl = false;
                result = bl;
            }
        } else if (value > 0) {
            boolean bl = true;
            result = bl;
        } else {
            callSiteArray[41].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".notPositive"}));
            boolean bl = false;
            result = bl;
        }
        return result;
    }

    public Object validateRestartPolicy(String value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)value) ? callSiteArray[42].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, restartPolicyList) : null;
    }

    public Object validateJobCloneSource(Object value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            callSiteArray[43].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
            return false;
        }
        return callSiteArray[44].callCurrent((GroovyObject)this, callSiteArray[45].callGetProperty(value), (Object)attribute);
    }

    public Object validateServerGroupCloneSource(Object value, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            callSiteArray[46].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
            return false;
        }
        return callSiteArray[47].callCurrent((GroovyObject)this, callSiteArray[48].callGetProperty(value), (Object)attribute);
    }

    public Object validateNotLessThan(Integer value1, Integer value2, String attribute1, String attribute2) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareLessThan((Object)value1, (Object)value2)) {
            return callSiteArray[49].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute1}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute1, this.context, attribute2}, new String[]{"", ".", ".lessThan ", ".", ""}));
        }
        return null;
    }

    public Object validateInRangeInclusive(Integer value, int min, int max, String attribute) {
        CallSite[] callSiteArray = StandardKubernetesAttributeValidator.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)min, (Object)value)) {
            callSiteArray[50].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, min}, new String[]{"", ".", ".greaterThan ", ""}));
        }
        if (ScriptBytecodeAdapter.compareLessThan((Object)max, (Object)value)) {
            return callSiteArray[51].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, max}, new String[]{"", ".", ".lessThan ", ""}));
        }
        return null;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StandardKubernetesAttributeValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string = "^([+-]?[0-9.]+)([eEimkKMGTP]*[-+]?[0-9]*)$";
        quantityPattern = string;
        String string2 = "^[^/].*$";
        relativePathPattern = string2;
        String string3 = "^/.*$";
        pathPattern = string3;
        String string4 = "^[a-z0-9]+$";
        prefixPattern = string4;
        String string5 = "^[a-z0-9]+([-a-z0-9_]*[a-z0-9])?$";
        credentialsPattern = string5;
        String string6 = "^[a-z0-9]+([-\\.a-z0-9]*[a-z0-9])?$";
        dnsSubdomainPattern = string6;
        String string7 = "^[a-z0-9]+([-a-z0-9]*[a-z0-9])?$";
        namePattern = string7;
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"TCP", "UDP"});
        protocolList = list;
        List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"ClusterIP", "NodePort", "LoadBalancer"});
        serviceTypeList = list2;
        List list3 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"None", "ClientIP"});
        sessionAffinityList = list3;
        List list4 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"Always", "OnFailure", "Never"});
        restartPolicyList = list4;
        List list5 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"HTTP", "HTTPS"});
        uriSchemeList = list5;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            maxPort = object = StandardKubernetesAttributeValidator.$getCallSiteArray()[52].call(StandardKubernetesAttributeValidator.$getCallSiteArray()[53].call((Object)1, (Object)16), (Object)1);
        } else {
            int n = (1 << 16) - 1;
            maxPort = n;
        }
    }

    public static Object getNamePattern() {
        return namePattern;
    }

    public static Object getDnsSubdomainPattern() {
        return dnsSubdomainPattern;
    }

    public static Object getCredentialsPattern() {
        return credentialsPattern;
    }

    public static Object getPrefixPattern() {
        return prefixPattern;
    }

    public static Object getPathPattern() {
        return pathPattern;
    }

    public static Object getRelativePathPattern() {
        return relativePathPattern;
    }

    public static Object getQuantityPattern() {
        return quantityPattern;
    }

    public static Object getProtocolList() {
        return protocolList;
    }

    public static Object getServiceTypeList() {
        return serviceTypeList;
    }

    public static Object getSessionAffinityList() {
        return sessionAffinityList;
    }

    public static Object getRestartPolicyList() {
        return restartPolicyList;
    }

    public static Object getUriSchemeList() {
        return uriSchemeList;
    }

    public static Object getMaxPort() {
        return maxPort;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String string) {
        this.context = string;
    }

    public Errors getErrors() {
        return this.errors;
    }

    public void setErrors(Errors errors) {
        this.errors = errors;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "rejectValue";
        stringArray[1] = "contains";
        stringArray[2] = "rejectValue";
        stringArray[3] = "rejectValue";
        stringArray[4] = "validateByRegex";
        stringArray[5] = "validateNotEmpty";
        stringArray[6] = "validateByRegex";
        stringArray[7] = "validateNotEmpty";
        stringArray[8] = "validateByRegex";
        stringArray[9] = "validateNotEmpty";
        stringArray[10] = "validateByRegex";
        stringArray[11] = "validateNotEmpty";
        stringArray[12] = "validateByRegex";
        stringArray[13] = "validateNotEmpty";
        stringArray[14] = "validateByContainment";
        stringArray[15] = "validateByContainment";
        stringArray[16] = "validateByContainment";
        stringArray[17] = "isIPv4Address";
        stringArray[18] = "rejectValue";
        stringArray[19] = "validateByContainment";
        stringArray[20] = "rejectValue";
        stringArray[21] = "validateNotEmpty";
        stringArray[22] = "validateByRegex";
        stringArray[23] = "validateByRegex";
        stringArray[24] = "validateByRegex";
        stringArray[25] = "validateByRegex";
        stringArray[26] = "isRegisteredImagePullSecret";
        stringArray[27] = "rejectValue";
        stringArray[28] = "validateByRegex";
        stringArray[29] = "isRegisteredNamespace";
        stringArray[30] = "rejectValue";
        stringArray[31] = "validateByRegex";
        stringArray[32] = "rejectValue";
        stringArray[33] = "rejectValue";
        stringArray[34] = "validateNotEmpty";
        stringArray[35] = "getCredentials";
        stringArray[36] = "credentials";
        stringArray[37] = "rejectValue";
        stringArray[38] = "rejectValue";
        stringArray[39] = "rejectValue";
        stringArray[40] = "rejectValue";
        stringArray[41] = "rejectValue";
        stringArray[42] = "validateByContainment";
        stringArray[43] = "rejectValue";
        stringArray[44] = "validateNotEmpty";
        stringArray[45] = "jobName";
        stringArray[46] = "rejectValue";
        stringArray[47] = "validateNotEmpty";
        stringArray[48] = "serverGroupName";
        stringArray[49] = "rejectValue";
        stringArray[50] = "rejectValue";
        stringArray[51] = "rejectValue";
        stringArray[52] = "minus";
        stringArray[53] = "leftShift";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[54];
        StandardKubernetesAttributeValidator.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(StandardKubernetesAttributeValidator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = StandardKubernetesAttributeValidator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

