/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactTypes;
import java.util.regex.Pattern;

public class ArtifactReplacerFactory {
    private static final String DOCKER_NAME_COMPONENT = "[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?";
    private static final String DOCKER_OPTIONAL_TAG = "(?::[\\w][\\w.-]{0,127})?";
    private static final String DOCKER_OPTIONAL_DIGEST = "(?:@[A-Za-z][A-Za-z0-9]*(?:[-_+.][A-Za-z][A-Za-z0-9]*)*[:][0-9A-Fa-f]{32,})?";
    private static final String DOCKER_DOMAIN = "(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))+)?";
    private static final String DOCKER_OPTIONAL_PORT = "(?::[0-9]+)?";
    private static final String DOCKER_OPTIONAL_DOMAIN_AND_PORT = "(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))+)?(?::[0-9]+)?/)?";
    private static final String DOCKER_IMAGE_NAME = "((?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))+)?(?::[0-9]+)?/)?[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?(?:/[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?)*)";
    private static final String DOCKER_IMAGE_REFERENCE = "((?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))+)?(?::[0-9]+)?/)?[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?(?:/[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?)*)((?::[\\w][\\w.-]{0,127})?|(?:@[A-Za-z][A-Za-z0-9]*(?:[-_+.][A-Za-z][A-Za-z0-9]*)*[:][0-9A-Fa-f]{32,})?)";
    public static final Pattern DOCKER_IMAGE_REFERENCE_PATTERN = Pattern.compile("^((?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))+)?(?::[0-9]+)?/)?[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?(?:/[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?)*)((?::[\\w][\\w.-]{0,127})?|(?:@[A-Za-z][A-Za-z0-9]*(?:[-_+.][A-Za-z][A-Za-z0-9]*)*[:][0-9A-Fa-f]{32,})?)$");

    public static ArtifactReplacer.Replacer dockerImageReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec.containers.[?( @.image == \"{%name%}\" )].image").findPath("$..spec.template.spec.containers.*.image").nameFromReference(ref -> {
            int atIndex = ref.indexOf(64);
            if (atIndex >= 0) {
                return ref.substring(0, atIndex);
            }
            int lastColonIndex = ref.lastIndexOf(58);
            if (lastColonIndex < 0) {
                return ref;
            }
            return ref.substring(0, lastColonIndex);
        }).type(ArtifactTypes.DOCKER_IMAGE).build();
    }

    public static ArtifactReplacer.Replacer configMapVolumeReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec.volumes.[?( @.configMap.name == \"{%name%}\" )].configMap.name").findPath("$..spec.template.spec.volumes.*.configMap.name").type(ArtifactTypes.KUBERNETES_CONFIG_MAP).build();
    }

    public static ArtifactReplacer.Replacer secretVolumeReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec.volumes.[?( @.secret.secretName == \"{%name%}\" )].secret.secretName").findPath("$..spec.template.spec.volumes.*.secret.secretName").type(ArtifactTypes.KUBERNETES_SECRET).build();
    }

    public static ArtifactReplacer.Replacer configMapKeyValueFromReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec.containers.*.env.[?( @.valueFrom.configMapKeyRef.name == \"{%name%}\" )].valueFrom.configMapKeyRef.name").findPath("$..spec.template.spec.containers.*.env.*.valueFrom.configMapKeyRef.name").type(ArtifactTypes.KUBERNETES_CONFIG_MAP).build();
    }

    public static ArtifactReplacer.Replacer secretKeyValueFromReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec.containers.*.env.[?( @.valueFrom.secretKeyRef.name == \"{%name%}\" )].valueFrom.secretKeyRef.name").findPath("$..spec.template.spec.containers.*.env.*.valueFrom.secretKeyRef.name").type(ArtifactTypes.KUBERNETES_SECRET).build();
    }

    public static ArtifactReplacer.Replacer configMapEnvFromReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec.containers.*.envFrom.[?( @.configMapRef.name == \"{%name%}\" )].configMapRef.name").findPath("$..spec.template.spec.containers.*.envFrom.*.configMapRef.name").type(ArtifactTypes.KUBERNETES_CONFIG_MAP).build();
    }

    public static ArtifactReplacer.Replacer secretEnvFromReplacer() {
        return ArtifactReplacer.Replacer.builder().replacePath("$..spec.template.spec.containers.*.envFrom.[?( @.secretRef.name == \"{%name%}\" )].secretRef.name").findPath("$..spec.template.spec.containers.*.envFrom.*.secretRef.name").type(ArtifactTypes.KUBERNETES_SECRET).build();
    }
}

