/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Keys {
    private static final Logger log = LoggerFactory.getLogger(Keys.class);
    private static final String provider = "kubernetes.v2";

    private static String createKey(Object ... elems) {
        List components = Arrays.stream(elems).map(s -> s == null ? "" : s.toString()).map(s -> s.replaceAll(":", ";")).collect(Collectors.toList());
        components.add(0, provider);
        return String.join((CharSequence)":", components);
    }

    public static String artifact(String type, String name, String location, String version) {
        return Keys.createKey(new Object[]{Kind.ARTIFACT, type, name, location, version});
    }

    public static String application(String name) {
        return Keys.createKey(new Object[]{Kind.LOGICAL, LogicalKind.APPLICATIONS, name});
    }

    public static String cluster(String account, String application, String name) {
        return Keys.createKey(new Object[]{Kind.LOGICAL, LogicalKind.CLUSTERS, account, application, name});
    }

    public static String infrastructure(KubernetesKind kind, String account, String namespace, String name) {
        return Keys.createKey(new Object[]{Kind.INFRASTRUCTURE, kind, account, namespace, name});
    }

    public static String infrastructure(KubernetesManifest manifest, String account) {
        return Keys.infrastructure(manifest.getKind(), account, manifest.getNamespace(), manifest.getName());
    }

    public static Optional<CacheKey> parseKey(String key) {
        String[] parts = key.split(":", -1);
        if (parts.length < 3 || !parts[0].equals(provider)) {
            return Optional.empty();
        }
        for (String part : parts) {
            part.replaceAll(";", ":");
        }
        try {
            Kind kind = Kind.fromString(parts[1]);
            switch (kind) {
                case LOGICAL: {
                    return Optional.of(Keys.parseLogicalKey(parts));
                }
                case ARTIFACT: {
                    return Optional.of(new ArtifactCacheKey(parts));
                }
                case INFRASTRUCTURE: {
                    return Optional.of(new InfrastructureCacheKey(parts));
                }
            }
            throw new IllegalArgumentException("Unknown kind " + (Object)((Object)kind));
        }
        catch (IllegalArgumentException e) {
            log.warn("Kubernetes owned kind with unknown key structure '{}': {} (perhaps try flushing all clouddriver:* redis keys)", new Object[]{key, parts, e});
            return Optional.empty();
        }
    }

    private static CacheKey parseLogicalKey(String[] parts) {
        assert (parts.length >= 3);
        LogicalKind logicalKind = LogicalKind.fromString(parts[2]);
        switch (logicalKind) {
            case APPLICATIONS: {
                return new ApplicationCacheKey(parts);
            }
            case CLUSTERS: {
                return new ClusterCacheKey(parts);
            }
        }
        throw new IllegalArgumentException("Unknown kind " + (Object)((Object)logicalKind));
    }

    public static class InfrastructureCacheKey
    extends CacheKey {
        private Kind kind = Kind.INFRASTRUCTURE;
        private KubernetesKind kubernetesKind;
        private String account;
        private String namespace;
        private String name;

        public InfrastructureCacheKey(String[] parts) {
            if (parts.length != 6) {
                throw new IllegalArgumentException("Malformed infrastructure key " + Arrays.toString(parts));
            }
            this.kubernetesKind = KubernetesKind.fromString(parts[2]);
            this.account = parts[3];
            this.namespace = parts[4];
            this.name = parts[5];
        }

        @Override
        public String toString() {
            return Keys.createKey(new Object[]{this.kind, this.kubernetesKind, this.account, this.namespace, this.name});
        }

        @Override
        public String getGroup() {
            return this.kubernetesKind.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InfrastructureCacheKey)) {
                return false;
            }
            InfrastructureCacheKey other = (InfrastructureCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
                return false;
            }
            KubernetesKind this$kubernetesKind = this.getKubernetesKind();
            KubernetesKind other$kubernetesKind = other.getKubernetesKind();
            if (this$kubernetesKind == null ? other$kubernetesKind != null : !this$kubernetesKind.equals(other$kubernetesKind)) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof InfrastructureCacheKey;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            KubernetesKind $kubernetesKind = this.getKubernetesKind();
            result = result * 59 + ($kubernetesKind == null ? 43 : $kubernetesKind.hashCode());
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Override
        public Kind getKind() {
            return this.kind;
        }

        public KubernetesKind getKubernetesKind() {
            return this.kubernetesKind;
        }

        public String getAccount() {
            return this.account;
        }

        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InfrastructureCacheKey setKind(Kind kind) {
            this.kind = kind;
            return this;
        }

        public InfrastructureCacheKey setKubernetesKind(KubernetesKind kubernetesKind) {
            this.kubernetesKind = kubernetesKind;
            return this;
        }

        public InfrastructureCacheKey setAccount(String account) {
            this.account = account;
            return this;
        }

        public InfrastructureCacheKey setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public InfrastructureCacheKey setName(String name) {
            this.name = name;
            return this;
        }
    }

    public static class ClusterCacheKey
    extends LogicalKey {
        private LogicalKind logicalKind = LogicalKind.CLUSTERS;
        private String account;
        private String application;
        private String name;

        public ClusterCacheKey(String[] parts) {
            if (parts.length != 6) {
                throw new IllegalArgumentException("Malformed cluster key " + Arrays.toString(parts));
            }
            this.account = parts[3];
            this.application = parts[4];
            this.name = parts[5];
        }

        @Override
        public String toString() {
            return Keys.createKey(new Object[]{this.getKind(), this.logicalKind, this.account, this.name});
        }

        @Override
        public String getGroup() {
            return this.logicalKind.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClusterCacheKey)) {
                return false;
            }
            ClusterCacheKey other = (ClusterCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LogicalKind this$logicalKind = this.getLogicalKind();
            LogicalKind other$logicalKind = other.getLogicalKind();
            if (this$logicalKind == null ? other$logicalKind != null : !((Object)((Object)this$logicalKind)).equals((Object)other$logicalKind)) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            String this$application = this.getApplication();
            String other$application = other.getApplication();
            if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ClusterCacheKey;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LogicalKind $logicalKind = this.getLogicalKind();
            result = result * 59 + ($logicalKind == null ? 43 : ((Object)((Object)$logicalKind)).hashCode());
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            String $application = this.getApplication();
            result = result * 59 + ($application == null ? 43 : $application.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Override
        public LogicalKind getLogicalKind() {
            return this.logicalKind;
        }

        public String getAccount() {
            return this.account;
        }

        public String getApplication() {
            return this.application;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public ClusterCacheKey setLogicalKind(LogicalKind logicalKind) {
            this.logicalKind = logicalKind;
            return this;
        }

        public ClusterCacheKey setAccount(String account) {
            this.account = account;
            return this;
        }

        public ClusterCacheKey setApplication(String application) {
            this.application = application;
            return this;
        }

        public ClusterCacheKey setName(String name) {
            this.name = name;
            return this;
        }
    }

    public static class ApplicationCacheKey
    extends LogicalKey {
        private LogicalKind logicalKind = LogicalKind.APPLICATIONS;
        private String name;

        public ApplicationCacheKey(String[] parts) {
            if (parts.length != 4) {
                throw new IllegalArgumentException("Malformed application key" + Arrays.toString(parts));
            }
            this.name = parts[3];
        }

        @Override
        public String toString() {
            return Keys.createKey(new Object[]{this.getKind(), this.logicalKind, this.name});
        }

        @Override
        public String getGroup() {
            return this.logicalKind.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplicationCacheKey)) {
                return false;
            }
            ApplicationCacheKey other = (ApplicationCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LogicalKind this$logicalKind = this.getLogicalKind();
            LogicalKind other$logicalKind = other.getLogicalKind();
            if (this$logicalKind == null ? other$logicalKind != null : !((Object)((Object)this$logicalKind)).equals((Object)other$logicalKind)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ApplicationCacheKey;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LogicalKind $logicalKind = this.getLogicalKind();
            result = result * 59 + ($logicalKind == null ? 43 : ((Object)((Object)$logicalKind)).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Override
        public LogicalKind getLogicalKind() {
            return this.logicalKind;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public ApplicationCacheKey setLogicalKind(LogicalKind logicalKind) {
            this.logicalKind = logicalKind;
            return this;
        }

        public ApplicationCacheKey setName(String name) {
            this.name = name;
            return this;
        }
    }

    public static class ArtifactCacheKey
    extends CacheKey {
        private Kind kind = Kind.ARTIFACT;
        private String type;
        private String name;
        private String location;
        private String version;

        public ArtifactCacheKey(String[] parts) {
            if (parts.length != 6) {
                throw new IllegalArgumentException("Malformed artifact key" + Arrays.toString(parts));
            }
            this.type = parts[2];
            this.name = parts[3];
            this.location = parts[4];
            this.version = parts[5];
        }

        @Override
        public String toString() {
            return Keys.createKey(new Object[]{this.kind, this.type, this.name, this.version});
        }

        @Override
        public String getGroup() {
            return this.kind.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArtifactCacheKey)) {
                return false;
            }
            ArtifactCacheKey other = (ArtifactCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$location = this.getLocation();
            String other$location = other.getLocation();
            if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ArtifactCacheKey;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : $location.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @Override
        public Kind getKind() {
            return this.kind;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVersion() {
            return this.version;
        }

        @Override
        public ArtifactCacheKey setKind(Kind kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public ArtifactCacheKey setType(String type) {
            this.type = type;
            return this;
        }

        public ArtifactCacheKey setName(String name) {
            this.name = name;
            return this;
        }

        public ArtifactCacheKey setLocation(String location) {
            this.location = location;
            return this;
        }

        public ArtifactCacheKey setVersion(String version) {
            this.version = version;
            return this;
        }
    }

    public static abstract class LogicalKey
    extends CacheKey {
        private Kind kind = Kind.LOGICAL;

        public abstract LogicalKind getLogicalKind();

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogicalKey)) {
                return false;
            }
            LogicalKey other = (LogicalKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            return !(this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof LogicalKey;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            return result;
        }

        @Override
        public Kind getKind() {
            return this.kind;
        }

        @Override
        public LogicalKey setKind(Kind kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public String toString() {
            return "Keys.LogicalKey(kind=" + (Object)((Object)this.getKind()) + ")";
        }
    }

    public static abstract class CacheKey {
        private Kind kind;
        private String provider = KubernetesCloudProvider.getID();
        private String type;

        public abstract String getGroup();

        public abstract String getName();

        public Kind getKind() {
            return this.kind;
        }

        public String getProvider() {
            return this.provider;
        }

        public String getType() {
            return this.type;
        }

        public CacheKey setKind(Kind kind) {
            this.kind = kind;
            return this;
        }

        public CacheKey setProvider(String provider) {
            this.provider = provider;
            return this;
        }

        public CacheKey setType(String type) {
            this.type = type;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
                return false;
            }
            String this$provider = this.getProvider();
            String other$provider = other.getProvider();
            if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            String $provider = this.getProvider();
            result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "Keys.CacheKey(kind=" + (Object)((Object)this.getKind()) + ", provider=" + this.getProvider() + ", type=" + this.getType() + ")";
        }
    }

    public static enum LogicalKind {
        APPLICATIONS,
        CLUSTERS;


        public static boolean isLogicalGroup(String group) {
            return group.equals(APPLICATIONS.toString()) || group.equals(CLUSTERS.toString());
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String singular() {
            String name = this.toString();
            return name.substring(0, name.length() - 1);
        }

        @JsonCreator
        public static LogicalKind fromString(String name) {
            return Arrays.stream(LogicalKind.values()).filter(k -> k.toString().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No matching kind with name " + name + " exists"));
        }
    }

    public static enum Kind {
        LOGICAL,
        ARTIFACT,
        INFRASTRUCTURE;


        public String toString() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static Kind fromString(String name) {
            return Arrays.stream(Kind.values()).filter(k -> k.toString().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No matching kind with name " + name + " exists"));
        }
    }
}

