/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.model.ManifestProvider;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2ManifestProvider
implements ManifestProvider<KubernetesV2Manifest> {
    private final KubernetesResourcePropertyRegistry registry;
    private final KubernetesCacheUtils cacheUtils;

    @Autowired
    public KubernetesV2ManifestProvider(KubernetesResourcePropertyRegistry registry, KubernetesCacheUtils cacheUtils) {
        this.registry = registry;
        this.cacheUtils = cacheUtils;
    }

    public KubernetesV2Manifest getManifest(String account, String location, String name) {
        Pair<KubernetesKind, String> parsedName;
        try {
            parsedName = KubernetesManifest.fromFullResourceName(name);
        }
        catch (Exception e) {
            return null;
        }
        KubernetesKind kind = (KubernetesKind)parsedName.getLeft();
        String key = Keys.infrastructure(kind, account, location, (String)parsedName.getRight());
        Optional<CacheData> dataOptional = this.cacheUtils.getSingleEntry(kind.toString(), key);
        if (!dataOptional.isPresent()) {
            return null;
        }
        CacheData data = dataOptional.get();
        KubernetesResourceProperties properties = this.registry.get(account, kind);
        if (properties == null) {
            return null;
        }
        Function<KubernetesManifest, String> lastEventTimestamp = m -> m.getOrDefault("lastTimestamp", m.getOrDefault("firstTimestamp", "n/a"));
        List<KubernetesManifest> events = this.cacheUtils.getTransitiveRelationship(kind.toString(), Collections.singletonList(key), KubernetesKind.EVENT.toString()).stream().map(KubernetesCacheDataConverter::getManifest).sorted(Comparator.comparing(lastEventTimestamp)).collect(Collectors.toList());
        KubernetesHandler handler = properties.getHandler();
        KubernetesManifest manifest = KubernetesCacheDataConverter.getManifest(data);
        Moniker moniker = KubernetesCacheDataConverter.getMoniker(data);
        new KubernetesV2Manifest();
        return KubernetesV2Manifest.builder().account(account).location(location).manifest(manifest).moniker(moniker).status(handler.status(manifest)).artifacts(handler.listArtifacts(manifest)).events(events).build();
    }
}

