/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesKind {
    private static final Logger log = LoggerFactory.getLogger(KubernetesKind.class);
    public static KubernetesKind CLUSTER_ROLE = new KubernetesKind("clusterRole", false);
    public static KubernetesKind CLUSTER_ROLE_BINDING = new KubernetesKind("clusterRoleBinding", false);
    public static KubernetesKind CONFIG_MAP = new KubernetesKind("configMap", "cm");
    public static KubernetesKind CONTROLLER_REVISION = new KubernetesKind("controllerRevision");
    public static KubernetesKind CUSTOM_RESOURCE_DEFINITION = new KubernetesKind("customResourceDefinition", "crd", false, false);
    public static KubernetesKind CRON_JOB = new KubernetesKind("cronJob");
    public static KubernetesKind DAEMON_SET = new KubernetesKind("daemonSet", "ds", true, true);
    public static KubernetesKind DEPLOYMENT = new KubernetesKind("deployment", "deploy", true, true);
    public static KubernetesKind EVENT = new KubernetesKind("event");
    public static KubernetesKind HORIZONTAL_POD_AUTOSCALER = new KubernetesKind("horizontalpodautoscaler", "hpa");
    public static KubernetesKind INGRESS = new KubernetesKind("ingress", "ing");
    public static KubernetesKind JOB = new KubernetesKind("job");
    public static KubernetesKind POD = new KubernetesKind("pod", "po", true, true);
    public static KubernetesKind REPLICA_SET = new KubernetesKind("replicaSet", "rs", true, true);
    public static KubernetesKind ROLE = new KubernetesKind("role", false);
    public static KubernetesKind ROLE_BINDING = new KubernetesKind("roleBinding", false);
    public static KubernetesKind NAMESPACE = new KubernetesKind("namespace", "ns", false, false);
    public static KubernetesKind NETWORK_POLICY = new KubernetesKind("networkPolicy", "netpol");
    public static KubernetesKind PERSISTENT_VOLUME = new KubernetesKind("persistentVolume", "pv", false, false);
    public static KubernetesKind PERSISTENT_VOLUME_CLAIM = new KubernetesKind("persistentVolumeClaim", "pvc");
    public static KubernetesKind SECRET = new KubernetesKind("secret");
    public static KubernetesKind SERVICE = new KubernetesKind("service", "svc");
    public static KubernetesKind SERVICE_ACCOUNT = new KubernetesKind("serviceAccount", "sa");
    public static KubernetesKind STATEFUL_SET = new KubernetesKind("statefulSet", null, true, true);
    public static KubernetesKind NONE = new KubernetesKind("none", null, true, false);
    private final String name;
    private final String alias;
    private final boolean isNamespaced;
    private final boolean hasClusterRelationship;
    private boolean isDynamic;
    private boolean isRegistered;
    private static List<KubernetesKind> values;

    protected KubernetesKind(String name, String alias, boolean isNamespaced, boolean hasClusterRelationship) {
        if (values == null) {
            values = Collections.synchronizedList(new ArrayList());
        }
        this.name = name;
        this.alias = alias;
        this.isNamespaced = isNamespaced;
        this.hasClusterRelationship = hasClusterRelationship;
        this.isDynamic = false;
        this.isRegistered = true;
        values.add(this);
    }

    protected KubernetesKind(String name) {
        this(name, null, true, false);
    }

    protected KubernetesKind(String name, String alias) {
        this(name, alias, true, false);
    }

    protected KubernetesKind(String name, boolean isNamespaced) {
        this(name, null, isNamespaced, false);
    }

    public boolean isNamespaced() {
        return this.isNamespaced;
    }

    public boolean hasClusterRelationship() {
        return this.hasClusterRelationship;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    @JsonCreator
    public static KubernetesKind fromString(String name) {
        return KubernetesKind.fromString(name, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KubernetesKind fromString(String name, boolean registered, boolean namespaced) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        if (name.equalsIgnoreCase(NONE.toString())) {
            throw new IllegalArgumentException("The 'NONE' kind cannot be read.");
        }
        List<KubernetesKind> list = values;
        synchronized (list) {
            Optional<KubernetesKind> kindOptional = values.stream().filter(v -> v.name.equalsIgnoreCase(name) || v.alias != null && v.alias.equalsIgnoreCase(name)).findAny();
            return kindOptional.orElseGet(() -> {
                log.info("Dynamically registering {}", (Object)name);
                KubernetesKind result = new KubernetesKind(name);
                result.isDynamic = true;
                result.isRegistered = registered;
                return result;
            });
        }
    }

    public static List<KubernetesKind> registeredStringList(List<String> names) {
        return names.stream().map(KubernetesKind::fromString).collect(Collectors.toList());
    }

    public static List<KubernetesKind> getValues() {
        return values;
    }
}

