/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.MalformedManifestException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class KubernetesManifest
extends HashMap<String, Object> {
    private static ObjectMapper mapper = new ObjectMapper();

    @Override
    public KubernetesManifest clone() {
        return (KubernetesManifest)super.clone();
    }

    private static <T> T getRequiredField(KubernetesManifest manifest, String field) {
        Object res = manifest.get(field);
        if (res == null) {
            throw MalformedManifestException.missingField(manifest, field);
        }
        return (T)res;
    }

    @JsonIgnore
    public KubernetesKind getKind() {
        return KubernetesKind.fromString((String)KubernetesManifest.getRequiredField(this, "kind"));
    }

    @JsonIgnore
    public void setKind(KubernetesKind kind) {
        this.put("kind", kind.toString());
    }

    @JsonIgnore
    public KubernetesApiVersion getApiVersion() {
        return KubernetesApiVersion.fromString((String)KubernetesManifest.getRequiredField(this, "apiVersion"));
    }

    @JsonIgnore
    public void setApiVersion(KubernetesApiVersion apiVersion) {
        this.put("apiVersion", apiVersion.toString());
    }

    @JsonIgnore
    private Map<String, Object> getMetadata() {
        return (Map)KubernetesManifest.getRequiredField(this, "metadata");
    }

    @JsonIgnore
    public String getName() {
        return (String)this.getMetadata().get("name");
    }

    @JsonIgnore
    public void setName(String name) {
        this.getMetadata().put("name", name);
    }

    @JsonIgnore
    public String getNamespace() {
        String namespace = (String)this.getMetadata().get("namespace");
        return StringUtils.isEmpty((CharSequence)namespace) ? "" : namespace;
    }

    @JsonIgnore
    public void setNamespace(String namespace) {
        this.getMetadata().put("namespace", namespace);
    }

    @JsonIgnore
    public String getCreationTimestamp() {
        return this.getMetadata().containsKey("creationTimestamp") ? this.getMetadata().get("creationTimestamp").toString() : null;
    }

    @JsonIgnore
    public List<OwnerReference> getOwnerReferences() {
        Map<String, Object> metadata = this.getMetadata();
        Object ownerReferences = metadata.get("ownerReferences");
        if (ownerReferences == null) {
            return new ArrayList<OwnerReference>();
        }
        return (List)mapper.convertValue(ownerReferences, (TypeReference)new TypeReference<List<OwnerReference>>(){});
    }

    @JsonIgnore
    public Map<String, String> getLabels() {
        HashMap result = (HashMap)this.getMetadata().get("labels");
        if (result == null) {
            result = new HashMap();
            this.getMetadata().put("labels", result);
        }
        return result;
    }

    @JsonIgnore
    public Map<String, String> getAnnotations() {
        HashMap result = (HashMap)this.getMetadata().get("annotations");
        if (result == null) {
            result = new HashMap();
            this.getMetadata().put("annotations", result);
        }
        return result;
    }

    @JsonIgnore
    public Optional<Map<String, String>> getSpecTemplateLabels() {
        if (!this.containsKey("spec")) {
            return Optional.empty();
        }
        Map spec = (Map)this.get("spec");
        if (!spec.containsKey("template")) {
            return Optional.empty();
        }
        Map template = (Map)spec.get("template");
        if (!template.containsKey("metadata")) {
            return Optional.empty();
        }
        Map metadata = (Map)template.get("metadata");
        HashMap result = (HashMap)metadata.get("labels");
        if (result == null) {
            result = new HashMap();
            metadata.put("labels", result);
        }
        return Optional.of(result);
    }

    @JsonIgnore
    public Optional<Map<String, String>> getSpecTemplateAnnotations() {
        if (!this.containsKey("spec")) {
            return Optional.empty();
        }
        Map spec = (Map)this.get("spec");
        if (!spec.containsKey("template")) {
            return Optional.empty();
        }
        Map template = (Map)spec.get("template");
        if (!template.containsKey("metadata")) {
            return Optional.empty();
        }
        Map metadata = (Map)template.get("metadata");
        HashMap result = (HashMap)metadata.get("annotations");
        if (result == null) {
            result = new HashMap();
            metadata.put("annotations", result);
        }
        return Optional.of(result);
    }

    @JsonIgnore
    public Object getStatus() {
        return this.get("status");
    }

    @JsonIgnore
    public String getFullResourceName() {
        return KubernetesManifest.getFullResourceName(this.getKind(), this.getName());
    }

    public static String getFullResourceName(KubernetesKind kind, String name) {
        return String.join((CharSequence)" ", kind.toString(), name);
    }

    public boolean isNewerThanObservedGeneration() {
        try {
            Long generation = (Long)this.getMetadata().get("generation");
            Long observedGeneration = (Long)((Map)this.getStatus()).get("observedGeneration");
            if (observedGeneration == null || generation != null && generation > observedGeneration) {
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return true;
    }

    public boolean nonMetadataEquals(KubernetesManifest other) {
        if (other == null) {
            return false;
        }
        KubernetesManifest cloneThis = this.clone();
        KubernetesManifest cloneOther = other.clone();
        cloneThis.remove("metadata");
        cloneOther.remove("metadata");
        return cloneThis.equals(cloneOther);
    }

    public static Pair<KubernetesKind, String> fromFullResourceName(String fullResourceName) {
        String[] split = fullResourceName.split(" ");
        if (split.length != 2) {
            throw new IllegalArgumentException("Expected a full resource name of the form <kind> <name>");
        }
        KubernetesKind kind = KubernetesKind.fromString(split[0]);
        String name = split[1];
        return new ImmutablePair((Object)kind, (Object)name);
    }

    public static class OwnerReference {
        KubernetesApiVersion apiVersion;
        KubernetesKind kind;
        String name;
        String uid;
        boolean blockOwnerDeletion;
        boolean controller;

        public KubernetesApiVersion getApiVersion() {
            return this.apiVersion;
        }

        public KubernetesKind getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public String getUid() {
            return this.uid;
        }

        public boolean isBlockOwnerDeletion() {
            return this.blockOwnerDeletion;
        }

        public boolean isController() {
            return this.controller;
        }

        public OwnerReference setApiVersion(KubernetesApiVersion apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public OwnerReference setKind(KubernetesKind kind) {
            this.kind = kind;
            return this;
        }

        public OwnerReference setName(String name) {
            this.name = name;
            return this;
        }

        public OwnerReference setUid(String uid) {
            this.uid = uid;
            return this;
        }

        public OwnerReference setBlockOwnerDeletion(boolean blockOwnerDeletion) {
            this.blockOwnerDeletion = blockOwnerDeletion;
            return this;
        }

        public OwnerReference setController(boolean controller) {
            this.controller = controller;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OwnerReference)) {
                return false;
            }
            OwnerReference other = (OwnerReference)o;
            if (!other.canEqual(this)) {
                return false;
            }
            KubernetesApiVersion this$apiVersion = this.getApiVersion();
            KubernetesApiVersion other$apiVersion = other.getApiVersion();
            if (this$apiVersion == null ? other$apiVersion != null : !((Object)this$apiVersion).equals(other$apiVersion)) {
                return false;
            }
            KubernetesKind this$kind = this.getKind();
            KubernetesKind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$uid = this.getUid();
            String other$uid = other.getUid();
            if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
                return false;
            }
            if (this.isBlockOwnerDeletion() != other.isBlockOwnerDeletion()) {
                return false;
            }
            return this.isController() == other.isController();
        }

        protected boolean canEqual(Object other) {
            return other instanceof OwnerReference;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            KubernetesApiVersion $apiVersion = this.getApiVersion();
            result = result * 59 + ($apiVersion == null ? 43 : ((Object)$apiVersion).hashCode());
            KubernetesKind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $uid = this.getUid();
            result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
            result = result * 59 + (this.isBlockOwnerDeletion() ? 79 : 97);
            result = result * 59 + (this.isController() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "KubernetesManifest.OwnerReference(apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", name=" + this.getName() + ", uid=" + this.getUid() + ", blockOwnerDeletion=" + this.isBlockOwnerDeletion() + ", controller=" + this.isController() + ")";
        }
    }
}

