/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.artifact;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.artifact.KubernetesCleanupArtifactsDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestStrategy;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.model.ArtifactProvider;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import io.kubernetes.client.models.V1DeleteOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCleanupArtifactsOperation
implements AtomicOperation<Void> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesCleanupArtifactsOperation.class);
    private final KubernetesCleanupArtifactsDescription description;
    private final KubernetesV2Credentials credentials;
    private final String accountName;
    private final ArtifactProvider artifactProvider;
    private final KubernetesResourcePropertyRegistry registry;
    private static final String OP_NAME = "CLEANUP_KUBERNETES_ARTIFACTS";

    public KubernetesCleanupArtifactsOperation(KubernetesCleanupArtifactsDescription description, ArtifactProvider artifactProvider, KubernetesResourcePropertyRegistry registry) {
        this.description = description;
        this.credentials = (KubernetesV2Credentials)description.getCredentials().getCredentials();
        this.accountName = description.getCredentials().getName();
        this.artifactProvider = artifactProvider;
        this.registry = registry;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        List<Artifact> artifacts = this.description.getManifests().stream().map(this::artifactsToDelete).flatMap(Collection::stream).collect(Collectors.toList());
        artifacts.forEach(a -> {
            String type = a.getType();
            if (!type.startsWith("kubernetes/")) {
                log.warn("Non-kubernetes type deletion requested...");
                return;
            }
            String kind = type.substring("kubernetes/".length());
            KubernetesResourceProperties properties = this.registry.get(this.accountName, KubernetesKind.fromString(kind));
            if (properties == null) {
                log.warn("No properties for artifact {}, ignoring", a);
                return;
            }
            KubernetesCleanupArtifactsOperation.getTask().updateStatus(OP_NAME, "Deleting artifact '" + a + '\"');
            KubernetesHandler handler = properties.getHandler();
            String name = a.getName();
            if (StringUtils.isNotEmpty((String)a.getVersion())) {
                name = String.join((CharSequence)"-", name, a.getVersion());
            }
            handler.delete(this.credentials, a.getLocation(), name, null, new V1DeleteOptions());
        });
        return null;
    }

    private List<Artifact> artifactsToDelete(KubernetesManifest manifest) {
        Artifact artifact;
        List artifacts;
        KubernetesManifestStrategy strategy = KubernetesManifestAnnotater.getStrategy(manifest);
        if (strategy.getMaxVersionHistory() == null) {
            return new ArrayList<Artifact>();
        }
        int maxVersionHistory = strategy.getMaxVersionHistory();
        if (maxVersionHistory >= (artifacts = this.artifactProvider.getArtifacts((artifact = KubernetesManifestAnnotater.getArtifact(manifest)).getType(), artifact.getName(), artifact.getLocation()).stream().filter(a -> a.getMetadata() != null && this.accountName.equals(a.getMetadata().get("account"))).collect(Collectors.toList())).size()) {
            return new ArrayList<Artifact>();
        }
        return artifacts.subList(0, artifacts.size() - maxVersionHistory);
    }
}

