/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesSelectorList;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import io.kubernetes.client.models.V1DeleteOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public interface CanDelete {
    public KubernetesKind kind();

    default public OperationResult delete(KubernetesV2Credentials credentials, String namespace, String name, KubernetesSelectorList labelSelectors, V1DeleteOptions options) {
        options = options == null ? new V1DeleteOptions() : options;
        List<String> deletedNames = credentials.delete(this.kind(), namespace, name, labelSelectors, options);
        OperationResult result = new OperationResult();
        Set fullNames = deletedNames.stream().map(n -> KubernetesManifest.getFullResourceName(this.kind(), n)).collect(Collectors.toSet());
        result.setManifestNamesByNamespace(new HashMap<String, Set<String>>(Collections.singletonMap(namespace, fullNames)));
        return result;
    }
}

