/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.CustomKubernetesCachingAgentFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2ServerGroup;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2ServerGroupManager;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.ManifestBasedModel;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.data.KubernetesV2CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.data.KubernetesV2ServerGroupCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.data.KubernetesV2ServerGroupManagerCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.ModelHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomKubernetesHandlerFactory {
    public static KubernetesHandler create(KubernetesKind kubernetesKind, KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind, boolean versioned, int deployPriority) {
        return new Handler(kubernetesKind, spinnakerKind, versioned, deployPriority);
    }

    private static class Handler
    extends KubernetesHandler
    implements ModelHandler {
        private static final Logger log = LoggerFactory.getLogger(Handler.class);
        private final KubernetesKind kubernetesKind;
        private final KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind;
        private final boolean versioned;
        private final int deployPriority;

        Handler(KubernetesKind kubernetesKind, KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind, boolean versioned, int deployPriority) {
            this.kubernetesKind = kubernetesKind;
            this.spinnakerKind = spinnakerKind;
            this.versioned = versioned;
            this.deployPriority = deployPriority;
        }

        @Override
        public int deployPriority() {
            return this.deployPriority;
        }

        @Override
        public KubernetesKind kind() {
            return this.kubernetesKind;
        }

        @Override
        public boolean versioned() {
            return this.versioned;
        }

        @Override
        public KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind() {
            return this.spinnakerKind;
        }

        @Override
        public Manifest.Status status(KubernetesManifest manifest) {
            return new Manifest.Status();
        }

        @Override
        public KubernetesV2CachingAgent buildCachingAgent(KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, KubernetesResourcePropertyRegistry propertyRegistry, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount) {
            return CustomKubernetesCachingAgentFactory.create(this.kubernetesKind, namedAccountCredentials, propertyRegistry, objectMapper, registry, agentIndex, agentCount);
        }

        public ManifestBasedModel fromCacheData(KubernetesV2CacheData cacheData) {
            switch (this.spinnakerKind()) {
                case SERVER_GROUPS: {
                    return KubernetesV2ServerGroup.fromCacheData((KubernetesV2ServerGroupCacheData)cacheData);
                }
                case SERVER_GROUP_MANAGERS: {
                    return KubernetesV2ServerGroupManager.fromCacheData((KubernetesV2ServerGroupManagerCacheData)cacheData);
                }
            }
            log.warn("No default cache data model mapping for Spinnaker kind " + (Object)((Object)this.spinnakerKind()));
            return null;
        }
    }
}

