/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v1.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.diff.JsonDiff;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesApiClientConfig;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.KubernetesUtil;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.exception.KubernetesClientOperationException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.apis.AppsV1beta1Api;
import io.kubernetes.client.apis.AutoscalingV1Api;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.apis.ExtensionsV1beta1Api;
import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.models.V1HorizontalPodAutoscaler;
import io.kubernetes.client.models.V1NamespaceList;
import io.kubernetes.client.models.V1Pod;
import io.kubernetes.client.models.V1PodList;
import io.kubernetes.client.models.V1Status;
import io.kubernetes.client.models.V1beta1DaemonSet;
import io.kubernetes.client.models.V1beta1DaemonSetList;
import io.kubernetes.client.models.V1beta1StatefulSet;
import io.kubernetes.client.models.V1beta1StatefulSetList;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClientApiAdapter
implements GroovyObject {
    private String account;
    private static final int RETRY_COUNT = 20;
    private static final long RETRY_MAX_WAIT_MILLIS;
    private static final long RETRY_INITIAL_WAIT_MILLIS;
    private static final int API_CALL_TIMEOUT_SECONDS = 60;
    private static final int TERMINATION_GRACE_PERIOD_SECONDS = 30;
    private static final String API_CALL_RESULT_FORMAT = "";
    private static final int SHUTDOWN_ALL_PODS = 0;
    private static final String DEPLOYMENT_ANNOTATION = "deployment.kubernetes.io";
    private final ObjectMapper mapper;
    private final Registry spectatorRegistry;
    private final Clock spectatorClock;
    private final ApiClient client;
    private final AppsV1beta1Api apiInstance;
    private final ExtensionsV1beta1Api extApi;
    private final AutoscalingV1Api scalerApi;
    private final CoreV1Api coreApi;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public KubernetesClientApiAdapter(String account, KubernetesApiClientConfig config, Registry spectatorRegistry) {
        MetaClass metaClass;
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(ObjectMapper.class);
        this.mapper = (ObjectMapper)ScriptBytecodeAdapter.castToType((Object)object, ObjectMapper.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (!DefaultTypeTransformation.booleanUnbox((Object)((Object)config))) {
            throw (Throwable)callSiteArray[1].callConstructor(IllegalArgumentException.class, (Object)"Config may not be null.");
        }
        String string = account;
        this.account = ShortTypeHandling.castToString((Object)string);
        Registry registry = spectatorRegistry;
        this.spectatorRegistry = (Registry)ScriptBytecodeAdapter.castToType((Object)registry, Registry.class);
        Object object2 = callSiteArray[2].call((Object)spectatorRegistry);
        this.spectatorClock = (Clock)ScriptBytecodeAdapter.castToType((Object)object2, Clock.class);
        Object object3 = callSiteArray[3].call((Object)config);
        this.client = (ApiClient)ScriptBytecodeAdapter.castToType((Object)object3, ApiClient.class);
        callSiteArray[4].call(Configuration.class, (Object)this.client);
        Object object4 = callSiteArray[5].callConstructor(AppsV1beta1Api.class);
        this.apiInstance = (AppsV1beta1Api)ScriptBytecodeAdapter.castToType((Object)object4, AppsV1beta1Api.class);
        Object object5 = callSiteArray[6].callConstructor(ExtensionsV1beta1Api.class);
        this.extApi = (ExtensionsV1beta1Api)ScriptBytecodeAdapter.castToType((Object)object5, ExtensionsV1beta1Api.class);
        Object object6 = callSiteArray[7].callConstructor(AutoscalingV1Api.class);
        this.scalerApi = (AutoscalingV1Api)ScriptBytecodeAdapter.castToType((Object)object6, AutoscalingV1Api.class);
        Object object7 = callSiteArray[8].callConstructor(CoreV1Api.class);
        this.coreApi = (CoreV1Api)ScriptBytecodeAdapter.castToType((Object)object7, CoreV1Api.class);
    }

    public Object spectatorRegistry() {
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        return this.spectatorRegistry;
    }

    public KubernetesClientOperationException formatException(String operation, String namespace, ApiException e) {
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)this.account) ? (KubernetesClientOperationException)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callConstructor(KubernetesClientOperationException.class, (Object)this.account, (Object)new GStringImpl(new Object[]{operation, namespace}, new String[]{API_CALL_RESULT_FORMAT, " in ", API_CALL_RESULT_FORMAT}), (Object)e), KubernetesClientOperationException.class) : (KubernetesClientOperationException)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].callConstructor(KubernetesClientOperationException.class, (Object)new GStringImpl(new Object[]{operation, namespace}, new String[]{API_CALL_RESULT_FORMAT, " in ", API_CALL_RESULT_FORMAT}), (Object)e), KubernetesClientOperationException.class);
    }

    public KubernetesClientOperationException formatException(String operation, ApiException e) {
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)this.account) ? (KubernetesClientOperationException)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callConstructor(KubernetesClientOperationException.class, (Object)this.account, (Object)new GStringImpl(new Object[]{operation}, new String[]{API_CALL_RESULT_FORMAT, API_CALL_RESULT_FORMAT}), (Object)e), KubernetesClientOperationException.class) : (KubernetesClientOperationException)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callConstructor(KubernetesClientOperationException.class, (Object)new GStringImpl(new Object[]{operation}, new String[]{API_CALL_RESULT_FORMAT, API_CALL_RESULT_FORMAT}), (Object)e), KubernetesClientOperationException.class);
    }

    public Boolean blockUntilResourceConsistent(Closure getResource) {
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        Boolean isPodRunning = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].call((Object)getResource), Boolean.class);
        Object wait = RETRY_INITIAL_WAIT_MILLIS;
        Integer attempts = 0;
        while (!DefaultTypeTransformation.booleanUnbox((Object)isPodRunning)) {
            Object object;
            callSiteArray[14].call((Object)attempts, (Object)1);
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)attempts, (Object)RETRY_COUNT)) {
                return false;
            }
            callSiteArray[15].callCurrent((GroovyObject)this, wait);
            wait = object = callSiteArray[16].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[17].call(wait, (Object)2), RETRY_MAX_WAIT_MILLIS}));
            Object object2 = callSiteArray[18].call((Object)getResource);
            isPodRunning = (Boolean)ScriptBytecodeAdapter.castToType((Object)object2, Boolean.class);
        }
        return true;
    }

    private <T> T exceptionWrapper(String methodName, String operationMessage, String namespace, Closure<T> doOperation) {
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        Object result = null;
        Exception failure = null;
        long startTime = DefaultTypeTransformation.longUnbox((Object)callSiteArray[19].call((Object)this.spectatorClock));
        try {
            try {
                Object object;
                result = object = callSiteArray[20].call(doOperation);
            }
            catch (ApiException e) {
                if (DefaultTypeTransformation.booleanUnbox((Object)namespace)) {
                    Object object = callSiteArray[21].callCurrent((GroovyObject)this, (Object)operationMessage, (Object)namespace, (Object)e);
                    failure = (Exception)ScriptBytecodeAdapter.castToType((Object)object, Exception.class);
                } else {
                    Object object = callSiteArray[22].callCurrent((GroovyObject)this, (Object)operationMessage, (Object)e);
                    failure = (Exception)ScriptBytecodeAdapter.castToType((Object)object, Exception.class);
                }
            }
            catch (Exception e) {
                Exception exception;
                failure = exception = e;
            }
        }
        catch (Throwable throwable) {
            Map tags = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"method", methodName, "account", this.account, "namespace", DefaultTypeTransformation.booleanUnbox((Object)namespace) ? namespace : "none", "success", DefaultTypeTransformation.booleanUnbox((Object)failure) ? "false" : "true"});
            if (DefaultTypeTransformation.booleanUnbox((Object)failure)) {
                Object object = callSiteArray[32].callGetProperty(callSiteArray[33].callGetProperty((Object)failure));
                callSiteArray[34].call((Object)tags, (Object)"reason", object);
            }
            callSiteArray[35].call(callSiteArray[36].call((Object)this.spectatorRegistry, callSiteArray[37].call((Object)this.spectatorRegistry, (Object)"kubernetes.api", (Object)tags)), callSiteArray[38].call(callSiteArray[39].call((Object)this.spectatorClock), (Object)startTime), callSiteArray[40].callGetProperty(TimeUnit.class));
            if (DefaultTypeTransformation.booleanUnbox((Object)failure)) {
                throw (Throwable)failure;
            }
            return (T)result;
        }
        Map tags = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"method", methodName, "account", this.account, "namespace", DefaultTypeTransformation.booleanUnbox((Object)namespace) ? namespace : "none", "success", DefaultTypeTransformation.booleanUnbox((Object)failure) ? "false" : "true"});
        if (DefaultTypeTransformation.booleanUnbox((Object)failure)) {
            Object object = callSiteArray[23].callGetProperty(callSiteArray[24].callGetProperty((Object)failure));
            callSiteArray[25].call((Object)tags, (Object)"reason", object);
        }
        callSiteArray[26].call(callSiteArray[27].call((Object)this.spectatorRegistry, callSiteArray[28].call((Object)this.spectatorRegistry, (Object)"kubernetes.api", (Object)tags)), callSiteArray[29].call(callSiteArray[30].call((Object)this.spectatorClock), (Object)startTime), callSiteArray[31].callGetProperty(TimeUnit.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)failure)) {
            throw (Throwable)failure;
        }
        return (T)result;
    }

    public List<V1beta1StatefulSet> getStatefulSets(String namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _getStatefulSets_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getStatefulSets_closure1(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _getStatefulSets_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getStatefulSets_closure1.$getCallSiteArray();
                V1beta1StatefulSetList list = (V1beta1StatefulSetList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.namespace.get(), null, null, null, (Object)true, null, null, null, (Object)callSiteArray[2].callGetProperty(KubernetesClientApiAdapter.class), (Object)false)), V1beta1StatefulSetList.class);
                String apiVersion = ShortTypeHandling.castToString((Object)callSiteArray[3].call((Object)list));
                V1beta1StatefulSet item = null;
                Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(callSiteArray[5].call((Object)list)), Iterator.class);
                while (iterator.hasNext()) {
                    item = (V1beta1StatefulSet)ScriptBytecodeAdapter.castToType(iterator.next(), V1beta1StatefulSet.class);
                    callSiteArray[6].call((Object)item, (Object)apiVersion);
                    callSiteArray[7].call((Object)item, (Object)"StatefulSet");
                }
                Object object = callSiteArray[8].callGetProperty((Object)list);
                try {
                    return object;
                }
                catch (Exception e) {
                    Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call(callSiteArray[10].callGetProperty(KubernetesClientApiAdapter.class))) ? callSiteArray[11].call(callSiteArray[12].callGetProperty(KubernetesClientApiAdapter.class), callSiteArray[13].call(callSiteArray[14].callGetProperty((Object)e))) : null;
                    return object2;
                }
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getStatefulSets_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getStatefulSets_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getStatefulSets_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "listNamespacedStatefulSet";
                stringArray[1] = "apiInstance";
                stringArray[2] = "API_CALL_TIMEOUT_SECONDS";
                stringArray[3] = "getApiVersion";
                stringArray[4] = "iterator";
                stringArray[5] = "getItems";
                stringArray[6] = "setApiVersion";
                stringArray[7] = "setKind";
                stringArray[8] = "items";
                stringArray[9] = "isDebugEnabled";
                stringArray[10] = "log";
                stringArray[11] = "debug";
                stringArray[12] = "log";
                stringArray[13] = "toString";
                stringArray[14] = "message";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[15];
                _getStatefulSets_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getStatefulSets_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getStatefulSets_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].callCurrent((GroovyObject)this, (Object)"statefulSets.list", (Object)"Get Stateful Sets", (Object)((String)namespace2.get()), (Object)new _getStatefulSets_closure1(this, this, namespace2)), List.class);
    }

    public List<V1beta1DaemonSet> getDaemonSets(String namespace) {
        Reference namespace2 = new Reference((Object)namespace);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _getDaemonSets_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getDaemonSets_closure2(Object _outerInstance, Object _thisObject, Reference namespace) {
                Reference reference;
                CallSite[] callSiteArray = _getDaemonSets_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getDaemonSets_closure2.$getCallSiteArray();
                V1beta1DaemonSetList list = (V1beta1DaemonSetList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.namespace.get(), null, null, null, null, null, null, null, (Object)callSiteArray[2].callGetProperty(KubernetesClientApiAdapter.class), (Object)false)), V1beta1DaemonSetList.class);
                String apiVersion = ShortTypeHandling.castToString((Object)callSiteArray[3].call((Object)list));
                V1beta1DaemonSet item = null;
                Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(callSiteArray[5].call((Object)list)), Iterator.class);
                while (iterator.hasNext()) {
                    item = (V1beta1DaemonSet)ScriptBytecodeAdapter.castToType(iterator.next(), V1beta1DaemonSet.class);
                    callSiteArray[6].call((Object)item, (Object)apiVersion);
                    callSiteArray[7].call((Object)item, (Object)"DaemonSet");
                }
                Object object = callSiteArray[8].callGetProperty((Object)list);
                try {
                    return object;
                }
                catch (ApiException e) {
                    Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call(callSiteArray[10].callGetProperty(KubernetesClientApiAdapter.class))) ? callSiteArray[11].call(callSiteArray[12].callGetProperty(KubernetesClientApiAdapter.class), callSiteArray[13].call(callSiteArray[14].callGetProperty((Object)e))) : null;
                    return object2;
                }
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getDaemonSets_closure2.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getDaemonSets_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDaemonSets_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "listNamespacedDaemonSet";
                stringArray[1] = "extApi";
                stringArray[2] = "API_CALL_TIMEOUT_SECONDS";
                stringArray[3] = "getApiVersion";
                stringArray[4] = "iterator";
                stringArray[5] = "getItems";
                stringArray[6] = "setApiVersion";
                stringArray[7] = "setKind";
                stringArray[8] = "items";
                stringArray[9] = "isDebugEnabled";
                stringArray[10] = "log";
                stringArray[11] = "debug";
                stringArray[12] = "log";
                stringArray[13] = "toString";
                stringArray[14] = "message";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[15];
                _getDaemonSets_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getDaemonSets_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getDaemonSets_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].callCurrent((GroovyObject)this, (Object)"daemonSets.list", (Object)"Get Daemon Sets", (Object)((String)namespace2.get()), (Object)new _getDaemonSets_closure2(this, this, namespace2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public V1beta1StatefulSet createStatfulSet(String namespace, V1beta1StatefulSet statefulSet) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference statefulSet2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _createStatfulSet_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference statefulSet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createStatfulSet_closure3(Object _outerInstance, Object _thisObject, Reference namespace, Reference statefulSet) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createStatfulSet_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.statefulSet = reference = statefulSet;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createStatfulSet_closure3.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.namespace.get(), this.statefulSet.get(), callSiteArray[2].callGetProperty(KubernetesClientApiAdapter.class));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _createStatfulSet_closure3.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public V1beta1StatefulSet getStatefulSet() {
                CallSite[] callSiteArray = _createStatfulSet_closure3.$getCallSiteArray();
                return (V1beta1StatefulSet)ScriptBytecodeAdapter.castToType((Object)this.statefulSet.get(), V1beta1StatefulSet.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createStatfulSet_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createStatfulSet_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "createNamespacedStatefulSet";
                stringArray[1] = "apiInstance";
                stringArray[2] = "API_CALL_RESULT_FORMAT";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _createStatfulSet_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createStatfulSet_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createStatfulSet_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (V1beta1StatefulSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].callCurrent((GroovyObject)this, (Object)"statefulSets.create", (Object)new GStringImpl(new Object[]{callSiteArray[44].callGetPropertySafe(callSiteArray[45].callGetPropertySafe((Object)((V1beta1StatefulSet)statefulSet2.get())))}, new String[]{"Create Stateful Set ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _createStatfulSet_closure3(this, this, namespace2, statefulSet2)), V1beta1StatefulSet.class);
    }

    /*
     * WARNING - void declaration
     */
    public V1beta1StatefulSet replaceStatfulSet(String name, String namespace, V1beta1StatefulSet statefulSet) {
        void var3_3;
        void var2_2;
        Reference name2 = new Reference((Object)name);
        Reference namespace2 = new Reference((Object)var2_2);
        Reference statefulSet2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _replaceStatfulSet_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference statefulSet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _replaceStatfulSet_closure4(Object _outerInstance, Object _thisObject, Reference name, Reference namespace, Reference statefulSet) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _replaceStatfulSet_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.name = reference3 = name;
                this.namespace = reference2 = namespace;
                this.statefulSet = reference = statefulSet;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _replaceStatfulSet_closure4.$getCallSiteArray();
                Object deployedControllerSet = callSiteArray[0].callCurrent((GroovyObject)this, this.name.get(), this.namespace.get());
                Object object = callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(this.statefulSet.get()));
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[3].callGetProperty(deployedControllerSet), (String)"replicas");
                Object object2 = callSiteArray[4].callGetProperty(callSiteArray[5].callGetProperty(this.statefulSet.get()));
                ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)callSiteArray[6].callGetProperty(deployedControllerSet), (String)"template");
                Object object3 = callSiteArray[7].callGetProperty(callSiteArray[8].callGetProperty(this.statefulSet.get()));
                ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)callSiteArray[9].callGetProperty(deployedControllerSet), (String)"updateStrategy");
                return callSiteArray[10].call(callSiteArray[11].callGroovyObjectGetProperty((Object)this), this.name.get(), this.namespace.get(), deployedControllerSet, callSiteArray[12].callGetProperty(KubernetesClientApiAdapter.class));
            }

            public String getName() {
                CallSite[] callSiteArray = _replaceStatfulSet_closure4.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _replaceStatfulSet_closure4.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public V1beta1StatefulSet getStatefulSet() {
                CallSite[] callSiteArray = _replaceStatfulSet_closure4.$getCallSiteArray();
                return (V1beta1StatefulSet)ScriptBytecodeAdapter.castToType((Object)this.statefulSet.get(), V1beta1StatefulSet.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _replaceStatfulSet_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _replaceStatfulSet_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getStatefulSet";
                stringArray[1] = "replicas";
                stringArray[2] = "spec";
                stringArray[3] = "spec";
                stringArray[4] = "template";
                stringArray[5] = "spec";
                stringArray[6] = "spec";
                stringArray[7] = "updateStrategy";
                stringArray[8] = "spec";
                stringArray[9] = "spec";
                stringArray[10] = "replaceNamespacedStatefulSet";
                stringArray[11] = "apiInstance";
                stringArray[12] = "API_CALL_RESULT_FORMAT";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[13];
                _replaceStatfulSet_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_replaceStatfulSet_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _replaceStatfulSet_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (V1beta1StatefulSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].callCurrent((GroovyObject)this, (Object)"statefulSets.replace", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Replace Stateful Set ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _replaceStatfulSet_closure4(this, this, name2, namespace2, statefulSet2)), V1beta1StatefulSet.class);
    }

    private Map[] determineJsonPatch(Object current, Object desired) {
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        JsonNode desiredNode = (JsonNode)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].call((Object)this.mapper, desired, JsonNode.class), JsonNode.class);
        JsonNode currentNode = (JsonNode)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].call((Object)this.mapper, current, JsonNode.class), JsonNode.class);
        return (Map[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].call((Object)this.mapper, callSiteArray[50].call(JsonDiff.class, (Object)currentNode, (Object)desiredNode), Map[].class), Map[].class);
    }

    /*
     * WARNING - void declaration
     */
    public V1beta1StatefulSet resizeStatefulSet(String name, String namespace, int targetSize) {
        void var2_2;
        Reference name2 = new Reference((Object)name);
        Reference namespace2 = new Reference((Object)var2_2);
        Reference targetSize2 = new Reference((Object)targetSize);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _resizeStatefulSet_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference targetSize;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _resizeStatefulSet_closure5(Object _outerInstance, Object _thisObject, Reference name, Reference namespace, Reference targetSize) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _resizeStatefulSet_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.name = reference3 = name;
                this.namespace = reference2 = namespace;
                this.targetSize = reference = targetSize;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _resizeStatefulSet_closure5.$getCallSiteArray();
                V1beta1StatefulSet current = (V1beta1StatefulSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callCurrent((GroovyObject)this, this.name.get(), this.namespace.get()), V1beta1StatefulSet.class);
                V1beta1StatefulSet desired = (V1beta1StatefulSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callCurrent((GroovyObject)this, this.name.get(), this.namespace.get()), V1beta1StatefulSet.class);
                Object object = this.targetSize.get();
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[2].callGetProperty((Object)desired), (String)"replicas");
                Map[] jsonPatch = (Map[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callCurrent((GroovyObject)this, (Object)current, (Object)desired), Map[].class);
                V1beta1StatefulSet statefulSet = (V1beta1StatefulSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), this.name.get(), this.namespace.get(), (Object)jsonPatch, null), V1beta1StatefulSet.class);
                return statefulSet;
            }

            public String getName() {
                CallSite[] callSiteArray = _resizeStatefulSet_closure5.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _resizeStatefulSet_closure5.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public int getTargetSize() {
                CallSite[] callSiteArray = _resizeStatefulSet_closure5.$getCallSiteArray();
                return DefaultTypeTransformation.intUnbox((Object)this.targetSize.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _resizeStatefulSet_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resizeStatefulSet_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getStatefulSet";
                stringArray[1] = "getStatefulSet";
                stringArray[2] = "spec";
                stringArray[3] = "determineJsonPatch";
                stringArray[4] = "patchNamespacedStatefulSet";
                stringArray[5] = "apiInstance";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _resizeStatefulSet_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_resizeStatefulSet_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _resizeStatefulSet_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (V1beta1StatefulSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callCurrent((GroovyObject)this, (Object)"statefulSets.resize", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Resize Stateful Set ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _resizeStatefulSet_closure5(this, this, name2, namespace2, targetSize2)), V1beta1StatefulSet.class);
    }

    /*
     * WARNING - void declaration
     */
    public void hardDestroyStatefulSet(String name, String namespace, V1DeleteOptions deleteOptions, Boolean orphanDependents, String propagationPolicy) {
        void var3_3;
        void var2_2;
        Reference name2 = new Reference((Object)name);
        Reference namespace2 = new Reference((Object)var2_2);
        Reference deleteOptions2 = new Reference((Object)var3_3);
        Reference orphanDependents2 = new Reference((Object)orphanDependents);
        Reference propagationPolicy2 = new Reference((Object)propagationPolicy);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _hardDestroyStatefulSet_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference deleteOptions;
            private /* synthetic */ Reference orphanDependents;
            private /* synthetic */ Reference propagationPolicy;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _hardDestroyStatefulSet_closure6(Object _outerInstance, Object _thisObject, Reference name, Reference namespace, Reference deleteOptions, Reference orphanDependents, Reference propagationPolicy) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _hardDestroyStatefulSet_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.name = reference5 = name;
                this.namespace = reference4 = namespace;
                this.deleteOptions = reference3 = deleteOptions;
                this.orphanDependents = reference2 = orphanDependents;
                this.propagationPolicy = reference = propagationPolicy;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _hardDestroyStatefulSet_closure6.$getCallSiteArray();
                V1beta1StatefulSet statefulSet = (V1beta1StatefulSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callCurrent((GroovyObject)this, this.name.get(), this.namespace.get()), V1beta1StatefulSet.class);
                callSiteArray[1].callCurrent((GroovyObject)this, this.name.get(), this.namespace.get(), (Object)0);
                public class _closure20
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference namespace;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure20(Object _outerInstance, Object _thisObject, Reference namespace) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure20.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.namespace = reference = namespace;
                    }

                    public Object doCall(Object item) {
                        CallSite[] callSiteArray = _closure20.$getCallSiteArray();
                        return callSiteArray[0].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(item)), (Object)this.namespace.get(), null, null, null, (Object)true));
                    }

                    public String getNamespace() {
                        CallSite[] callSiteArray = _closure20.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.namespace.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure20.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "deletePod";
                        stringArray[1] = "name";
                        stringArray[2] = "metadata";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[3];
                        _closure20.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure20.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure20.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[2].call(callSiteArray[3].callGetProperty(callSiteArray[4].callCurrent((GroovyObject)this, this.namespace.get(), callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty((Object)statefulSet)))), (Object)new _closure20((Object)this, this.getThisObject(), this.namespace));
                Object object = this.deleteOptions.get();
                V1DeleteOptions v1DeleteOptions = (V1DeleteOptions)ScriptBytecodeAdapter.castToType((Object)object, V1DeleteOptions.class);
                Object object2 = callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.name.get(), (Object)this.namespace.get(), (Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? v1DeleteOptions : (V1DeleteOptions)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callConstructor(V1DeleteOptions.class), V1DeleteOptions.class)), (Object)callSiteArray[10].callGetProperty(KubernetesClientApiAdapter.class), (Object)callSiteArray[11].callGetProperty(KubernetesClientApiAdapter.class), (Object)this.orphanDependents.get(), (Object)this.propagationPolicy.get()));
                try {
                    return object2;
                }
                catch (Exception e) {
                    Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].call(callSiteArray[13].callGetProperty(KubernetesClientApiAdapter.class))) ? callSiteArray[14].call(callSiteArray[15].callGetProperty(KubernetesClientApiAdapter.class), callSiteArray[16].callGetProperty((Object)e)) : null;
                    return object3;
                }
            }

            public String getName() {
                CallSite[] callSiteArray = _hardDestroyStatefulSet_closure6.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _hardDestroyStatefulSet_closure6.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public V1DeleteOptions getDeleteOptions() {
                CallSite[] callSiteArray = _hardDestroyStatefulSet_closure6.$getCallSiteArray();
                return (V1DeleteOptions)ScriptBytecodeAdapter.castToType((Object)this.deleteOptions.get(), V1DeleteOptions.class);
            }

            public Boolean getOrphanDependents() {
                CallSite[] callSiteArray = _hardDestroyStatefulSet_closure6.$getCallSiteArray();
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.orphanDependents.get(), Boolean.class);
            }

            public String getPropagationPolicy() {
                CallSite[] callSiteArray = _hardDestroyStatefulSet_closure6.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.propagationPolicy.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _hardDestroyStatefulSet_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _hardDestroyStatefulSet_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getStatefulSet";
                stringArray[1] = "resizeStatefulSet";
                stringArray[2] = "forEach";
                stringArray[3] = "items";
                stringArray[4] = "getPods";
                stringArray[5] = "labels";
                stringArray[6] = "metadata";
                stringArray[7] = "deleteNamespacedStatefulSet";
                stringArray[8] = "apiInstance";
                stringArray[9] = "<$constructor$>";
                stringArray[10] = "API_CALL_RESULT_FORMAT";
                stringArray[11] = "TERMINATION_GRACE_PERIOD_SECONDS";
                stringArray[12] = "isDebugEnabled";
                stringArray[13] = "log";
                stringArray[14] = "debug";
                stringArray[15] = "log";
                stringArray[16] = "message";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[17];
                _hardDestroyStatefulSet_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_hardDestroyStatefulSet_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _hardDestroyStatefulSet_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[52].callCurrent((GroovyObject)this, (Object)"statefulSets.delete", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Delete Stateful Set ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _hardDestroyStatefulSet_closure6(this, this, name2, namespace2, deleteOptions2, orphanDependents2, propagationPolicy2));
    }

    /*
     * WARNING - void declaration
     */
    public V1HorizontalPodAutoscaler getAutoscaler(String namespace, String name) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _getAutoscaler_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getAutoscaler_closure7(Object _outerInstance, Object _thisObject, Reference name, Reference namespace) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getAutoscaler_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.name = reference2 = name;
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getAutoscaler_closure7.$getCallSiteArray();
                V1HorizontalPodAutoscaler result = null;
                try {
                    Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.name.get(), this.namespace.get(), callSiteArray[2].callGetProperty(KubernetesClientApiAdapter.class));
                    result = (V1HorizontalPodAutoscaler)ScriptBytecodeAdapter.castToType((Object)object, V1HorizontalPodAutoscaler.class);
                }
                catch (Exception ex) {
                    Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(callSiteArray[4].callGetProperty(KubernetesClientApiAdapter.class))) ? callSiteArray[5].call(callSiteArray[6].callGetProperty(KubernetesClientApiAdapter.class), (Object)new GStringImpl(new Object[]{this.name.get(), this.namespace.get(), ex}, new String[]{"Unable to find autoscaler {", " in ", "}: ", "."})) : null;
                }
                return result;
            }

            public String getName() {
                CallSite[] callSiteArray = _getAutoscaler_closure7.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getAutoscaler_closure7.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getAutoscaler_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAutoscaler_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "readNamespacedHorizontalPodAutoscalerStatus";
                stringArray[1] = "scalerApi";
                stringArray[2] = "API_CALL_RESULT_FORMAT";
                stringArray[3] = "isInfoEnabled";
                stringArray[4] = "log";
                stringArray[5] = "info";
                stringArray[6] = "log";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _getAutoscaler_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getAutoscaler_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getAutoscaler_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (V1HorizontalPodAutoscaler)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].callCurrent((GroovyObject)this, (Object)"horizontalPodAutoscalers.get", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Get Autoscaler ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _getAutoscaler_closure7(this, this, name2, namespace2)), V1HorizontalPodAutoscaler.class);
    }

    /*
     * WARNING - void declaration
     */
    public V1HorizontalPodAutoscaler createAutoscaler(String namespace, V1HorizontalPodAutoscaler autoscaler) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference autoscaler2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _createAutoscaler_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference autoscaler;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createAutoscaler_closure8(Object _outerInstance, Object _thisObject, Reference namespace, Reference autoscaler) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createAutoscaler_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.autoscaler = reference = autoscaler;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createAutoscaler_closure8.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.namespace.get(), this.autoscaler.get(), callSiteArray[2].callGetProperty(KubernetesClientApiAdapter.class));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _createAutoscaler_closure8.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public V1HorizontalPodAutoscaler getAutoscaler() {
                CallSite[] callSiteArray = _createAutoscaler_closure8.$getCallSiteArray();
                return (V1HorizontalPodAutoscaler)ScriptBytecodeAdapter.castToType((Object)this.autoscaler.get(), V1HorizontalPodAutoscaler.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createAutoscaler_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createAutoscaler_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "createNamespacedHorizontalPodAutoscaler";
                stringArray[1] = "scalerApi";
                stringArray[2] = "API_CALL_RESULT_FORMAT";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _createAutoscaler_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createAutoscaler_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createAutoscaler_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (V1HorizontalPodAutoscaler)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].callCurrent((GroovyObject)this, (Object)"horizontalPodAutoscalers.create", (Object)new GStringImpl(new Object[]{callSiteArray[55].callGetPropertySafe(callSiteArray[56].callGetPropertySafe((Object)((V1HorizontalPodAutoscaler)autoscaler2.get())))}, new String[]{"Create Autoscaler ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _createAutoscaler_closure8(this, this, namespace2, autoscaler2)), V1HorizontalPodAutoscaler.class);
    }

    /*
     * WARNING - void declaration
     */
    public V1beta1StatefulSet getStatefulSet(String statefulSetName, String namespace) {
        void var2_2;
        Reference statefulSetName2 = new Reference((Object)statefulSetName);
        Reference namespace2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _getStatefulSet_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference statefulSetName;
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getStatefulSet_closure9(Object _outerInstance, Object _thisObject, Reference statefulSetName, Reference namespace) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getStatefulSet_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.statefulSetName = reference2 = statefulSetName;
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getStatefulSet_closure9.$getCallSiteArray();
                Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.statefulSetName.get(), (Object)this.namespace.get(), (Object)callSiteArray[2].callGetProperty(KubernetesClientApiAdapter.class), null, null));
                try {
                    return object;
                }
                catch (Exception e) {
                    Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(callSiteArray[4].callGetProperty(KubernetesClientApiAdapter.class))) ? callSiteArray[5].call(callSiteArray[6].callGetProperty(KubernetesClientApiAdapter.class), callSiteArray[7].callGetProperty((Object)e)) : null;
                    Object var5_5 = null;
                    return var5_5;
                }
            }

            public String getStatefulSetName() {
                CallSite[] callSiteArray = _getStatefulSet_closure9.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.statefulSetName.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getStatefulSet_closure9.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getStatefulSet_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getStatefulSet_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "readNamespacedStatefulSet";
                stringArray[1] = "apiInstance";
                stringArray[2] = "API_CALL_RESULT_FORMAT";
                stringArray[3] = "isDebugEnabled";
                stringArray[4] = "log";
                stringArray[5] = "debug";
                stringArray[6] = "log";
                stringArray[7] = "message";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _getStatefulSet_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getStatefulSet_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getStatefulSet_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (V1beta1StatefulSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].callCurrent((GroovyObject)this, (Object)"statefulSets.create", (Object)new GStringImpl(new Object[]{(String)statefulSetName2.get()}, new String[]{"Get Stateful Set ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _getStatefulSet_closure9(this, this, statefulSetName2, namespace2)), V1beta1StatefulSet.class);
    }

    /*
     * WARNING - void declaration
     */
    public V1PodList getPods(String namespace, Map<String, String> labels) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference labels2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _getPods_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference labels;
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getPods_closure10(Object _outerInstance, Object _thisObject, Reference labels, Reference namespace) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getPods_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.labels = reference2 = labels;
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getPods_closure10.$getCallSiteArray();
                String label = null;
                if (ScriptBytecodeAdapter.compareNotEqual((Object)this.labels.get(), null)) {
                    Map.Entry entry = (Map.Entry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(this.labels.get()))), Map.Entry.class);
                    String key = ShortTypeHandling.castToString((Object)callSiteArray[3].call((Object)entry));
                    String value = ShortTypeHandling.castToString((Object)callSiteArray[4].call((Object)entry));
                    Object object = callSiteArray[5].call(callSiteArray[6].call((Object)key, (Object)"="), (Object)value);
                    label = ShortTypeHandling.castToString((Object)object);
                }
                return callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.namespace.get(), null, null, null, (Object)false, label, null, null, (Object)callSiteArray[9].callGetProperty(KubernetesClientApiAdapter.class), (Object)false));
            }

            public Map getLabels() {
                CallSite[] callSiteArray = _getPods_closure10.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.labels.get(), Map.class);
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getPods_closure10.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getPods_closure10.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPods_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "next";
                stringArray[1] = "iterator";
                stringArray[2] = "entrySet";
                stringArray[3] = "getKey";
                stringArray[4] = "getValue";
                stringArray[5] = "plus";
                stringArray[6] = "plus";
                stringArray[7] = "listNamespacedPod";
                stringArray[8] = "coreApi";
                stringArray[9] = "API_CALL_TIMEOUT_SECONDS";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[10];
                _getPods_closure10.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getPods_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getPods_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (V1PodList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].callCurrent((GroovyObject)this, (Object)"pods.list", (Object)new GStringImpl(new Object[]{(Map)labels2.get()}, new String[]{"Get Pods matching ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _getPods_closure10(this, this, labels2, namespace2)), V1PodList.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean deleteAutoscaler(String namespace, String name, V1DeleteOptions deleteOptions, Boolean orphanDependents, String propagationPolicy) {
        void var3_3;
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference name2 = new Reference((Object)var2_2);
        Reference deleteOptions2 = new Reference((Object)var3_3);
        Reference orphanDependents2 = new Reference((Object)orphanDependents);
        Reference propagationPolicy2 = new Reference((Object)propagationPolicy);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _deleteAutoscaler_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference deleteOptions;
            private /* synthetic */ Reference orphanDependents;
            private /* synthetic */ Reference propagationPolicy;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deleteAutoscaler_closure11(Object _outerInstance, Object _thisObject, Reference name, Reference namespace, Reference deleteOptions, Reference orphanDependents, Reference propagationPolicy) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _deleteAutoscaler_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.name = reference5 = name;
                this.namespace = reference4 = namespace;
                this.deleteOptions = reference3 = deleteOptions;
                this.orphanDependents = reference2 = orphanDependents;
                this.propagationPolicy = reference = propagationPolicy;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _deleteAutoscaler_closure11.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.name.get(), (Object)this.namespace.get(), (Object)this.deleteOptions.get(), (Object)callSiteArray[2].callGetProperty(KubernetesClientApiAdapter.class), (Object)callSiteArray[3].callGetProperty(KubernetesClientApiAdapter.class), (Object)this.orphanDependents.get(), (Object)this.propagationPolicy.get()));
            }

            public String getName() {
                CallSite[] callSiteArray = _deleteAutoscaler_closure11.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _deleteAutoscaler_closure11.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public V1DeleteOptions getDeleteOptions() {
                CallSite[] callSiteArray = _deleteAutoscaler_closure11.$getCallSiteArray();
                return (V1DeleteOptions)ScriptBytecodeAdapter.castToType((Object)this.deleteOptions.get(), V1DeleteOptions.class);
            }

            public Boolean getOrphanDependents() {
                CallSite[] callSiteArray = _deleteAutoscaler_closure11.$getCallSiteArray();
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.orphanDependents.get(), Boolean.class);
            }

            public String getPropagationPolicy() {
                CallSite[] callSiteArray = _deleteAutoscaler_closure11.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.propagationPolicy.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _deleteAutoscaler_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteAutoscaler_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "deleteNamespacedHorizontalPodAutoscaler";
                stringArray[1] = "scalerApi";
                stringArray[2] = "API_CALL_RESULT_FORMAT";
                stringArray[3] = "TERMINATION_GRACE_PERIOD_SECONDS";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _deleteAutoscaler_closure11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deleteAutoscaler_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deleteAutoscaler_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].callCurrent((GroovyObject)this, (Object)"horizontalPodAutoscalers.delete", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Destroy Autoscaler ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _deleteAutoscaler_closure11(this, this, name2, namespace2, deleteOptions2, orphanDependents2, propagationPolicy2)));
    }

    /*
     * WARNING - void declaration
     */
    public V1beta1DaemonSet createDaemonSet(String namespace, V1beta1DaemonSet daemonSet) {
        void var2_2;
        Reference namespace2 = new Reference((Object)namespace);
        Reference daemonSet2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _createDaemonSet_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference daemonSet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createDaemonSet_closure12(Object _outerInstance, Object _thisObject, Reference namespace, Reference daemonSet) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createDaemonSet_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.namespace = reference2 = namespace;
                this.daemonSet = reference = daemonSet;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createDaemonSet_closure12.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.namespace.get(), this.daemonSet.get(), callSiteArray[2].callGetProperty(KubernetesClientApiAdapter.class));
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _createDaemonSet_closure12.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public V1beta1DaemonSet getDaemonSet() {
                CallSite[] callSiteArray = _createDaemonSet_closure12.$getCallSiteArray();
                return (V1beta1DaemonSet)ScriptBytecodeAdapter.castToType((Object)this.daemonSet.get(), V1beta1DaemonSet.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createDaemonSet_closure12.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createDaemonSet_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "createNamespacedDaemonSet";
                stringArray[1] = "extApi";
                stringArray[2] = "API_CALL_RESULT_FORMAT";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _createDaemonSet_closure12.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createDaemonSet_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createDaemonSet_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (V1beta1DaemonSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callCurrent((GroovyObject)this, (Object)"DaemonSet.create", (Object)new GStringImpl(new Object[]{callSiteArray[61].callGetPropertySafe(callSiteArray[62].callGetPropertySafe((Object)((V1beta1DaemonSet)daemonSet2.get())))}, new String[]{"Create Daemon Set ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _createDaemonSet_closure12(this, this, namespace2, daemonSet2)), V1beta1DaemonSet.class);
    }

    /*
     * WARNING - void declaration
     */
    public V1beta1DaemonSet replaceDaemonSet(String name, String namespace, V1beta1DaemonSet daemonSet) {
        void var3_3;
        void var2_2;
        Reference name2 = new Reference((Object)name);
        Reference namespace2 = new Reference((Object)var2_2);
        Reference daemonSet2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _replaceDaemonSet_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference daemonSet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _replaceDaemonSet_closure13(Object _outerInstance, Object _thisObject, Reference name, Reference namespace, Reference daemonSet) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _replaceDaemonSet_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.name = reference3 = name;
                this.namespace = reference2 = namespace;
                this.daemonSet = reference = daemonSet;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _replaceDaemonSet_closure13.$getCallSiteArray();
                Object deployedControllerSet = callSiteArray[0].callCurrent((GroovyObject)this, this.name.get(), this.namespace.get());
                Object object = callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(this.daemonSet.get()));
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[3].callGetProperty(deployedControllerSet), (String)"template");
                Object object2 = callSiteArray[4].callGetProperty(callSiteArray[5].callGetProperty(this.daemonSet.get()));
                ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)callSiteArray[6].callGetProperty(deployedControllerSet), (String)"updateStrategy");
                return callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this), this.name.get(), this.namespace.get(), deployedControllerSet, callSiteArray[9].callGetProperty(KubernetesClientApiAdapter.class));
            }

            public String getName() {
                CallSite[] callSiteArray = _replaceDaemonSet_closure13.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _replaceDaemonSet_closure13.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public V1beta1DaemonSet getDaemonSet() {
                CallSite[] callSiteArray = _replaceDaemonSet_closure13.$getCallSiteArray();
                return (V1beta1DaemonSet)ScriptBytecodeAdapter.castToType((Object)this.daemonSet.get(), V1beta1DaemonSet.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _replaceDaemonSet_closure13.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _replaceDaemonSet_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getDaemonSet";
                stringArray[1] = "template";
                stringArray[2] = "spec";
                stringArray[3] = "spec";
                stringArray[4] = "updateStrategy";
                stringArray[5] = "spec";
                stringArray[6] = "spec";
                stringArray[7] = "replaceNamespacedDaemonSet";
                stringArray[8] = "extApi";
                stringArray[9] = "API_CALL_RESULT_FORMAT";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[10];
                _replaceDaemonSet_closure13.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_replaceDaemonSet_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _replaceDaemonSet_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (V1beta1DaemonSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].callCurrent((GroovyObject)this, (Object)"DaemonSet.replace", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Replace Daemon Set ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _replaceDaemonSet_closure13(this, this, name2, namespace2, daemonSet2)), V1beta1DaemonSet.class);
    }

    /*
     * WARNING - void declaration
     */
    public V1beta1DaemonSet getDaemonSet(String name, String namespace) {
        void var2_2;
        Reference name2 = new Reference((Object)name);
        Reference namespace2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _getDaemonSet_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getDaemonSet_closure14(Object _outerInstance, Object _thisObject, Reference name, Reference namespace) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getDaemonSet_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.name = reference2 = name;
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getDaemonSet_closure14.$getCallSiteArray();
                Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.name.get(), (Object)this.namespace.get(), (Object)callSiteArray[2].callGetProperty(KubernetesClientApiAdapter.class), (Object)true, (Object)false));
                try {
                    return object;
                }
                catch (Exception e) {
                    Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(callSiteArray[4].callGetProperty(KubernetesClientApiAdapter.class))) ? callSiteArray[5].call(callSiteArray[6].callGetProperty(KubernetesClientApiAdapter.class), callSiteArray[7].callGetProperty((Object)e)) : null;
                    Object var5_5 = null;
                    return var5_5;
                }
            }

            public String getName() {
                CallSite[] callSiteArray = _getDaemonSet_closure14.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getDaemonSet_closure14.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getDaemonSet_closure14.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDaemonSet_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "readNamespacedDaemonSet";
                stringArray[1] = "extApi";
                stringArray[2] = "API_CALL_RESULT_FORMAT";
                stringArray[3] = "isDebugEnabled";
                stringArray[4] = "log";
                stringArray[5] = "debug";
                stringArray[6] = "log";
                stringArray[7] = "message";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _getDaemonSet_closure14.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getDaemonSet_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getDaemonSet_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (V1beta1DaemonSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].callCurrent((GroovyObject)this, (Object)"DaemonSet.get", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Get Daemon Set ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _getDaemonSet_closure14(this, this, name2, namespace2)), V1beta1DaemonSet.class);
    }

    /*
     * WARNING - void declaration
     */
    public void hardDestroyDaemonSet(String name, String namespace, V1DeleteOptions deleteoptions, Boolean orphanDependents, String propagationPolicy) {
        void var3_3;
        void var2_2;
        Reference name2 = new Reference((Object)name);
        Reference namespace2 = new Reference((Object)var2_2);
        Reference deleteoptions2 = new Reference((Object)var3_3);
        Reference orphanDependents2 = new Reference((Object)orphanDependents);
        Reference propagationPolicy2 = new Reference((Object)propagationPolicy);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _hardDestroyDaemonSet_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference deleteoptions;
            private /* synthetic */ Reference orphanDependents;
            private /* synthetic */ Reference propagationPolicy;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _hardDestroyDaemonSet_closure15(Object _outerInstance, Object _thisObject, Reference name, Reference namespace, Reference deleteoptions, Reference orphanDependents, Reference propagationPolicy) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _hardDestroyDaemonSet_closure15.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.name = reference5 = name;
                this.namespace = reference4 = namespace;
                this.deleteoptions = reference3 = deleteoptions;
                this.orphanDependents = reference2 = orphanDependents;
                this.propagationPolicy = reference = propagationPolicy;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _hardDestroyDaemonSet_closure15.$getCallSiteArray();
                Object deployedControllerSet = callSiteArray[0].callCurrent((GroovyObject)this, this.name.get(), this.namespace.get());
                V1Status status = null;
                try {
                    Object object = this.deleteoptions.get();
                    V1DeleteOptions v1DeleteOptions = (V1DeleteOptions)ScriptBytecodeAdapter.castToType((Object)object, V1DeleteOptions.class);
                    Object object2 = callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.name.get(), (Object)this.namespace.get(), (Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? v1DeleteOptions : (V1DeleteOptions)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(V1DeleteOptions.class), V1DeleteOptions.class)), (Object)callSiteArray[4].callGetProperty(KubernetesClientApiAdapter.class), (Object)callSiteArray[5].callGetProperty(KubernetesClientApiAdapter.class), (Object)this.orphanDependents.get(), (Object)this.propagationPolicy.get()));
                    status = (V1Status)ScriptBytecodeAdapter.castToType((Object)object2, V1Status.class);
                }
                catch (Exception e) {
                    Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call(callSiteArray[7].callGetProperty(KubernetesClientApiAdapter.class))) ? callSiteArray[8].call(callSiteArray[9].callGetProperty(KubernetesClientApiAdapter.class), callSiteArray[10].callGetProperty((Object)e)) : null;
                }
                public class _closure21
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference namespace;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure21(Object _outerInstance, Object _thisObject, Reference namespace) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure21.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.namespace = reference = namespace;
                    }

                    public Object doCall(Object item) {
                        CallSite[] callSiteArray = _closure21.$getCallSiteArray();
                        return callSiteArray[0].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(item)), (Object)this.namespace.get(), null, null, null, (Object)true));
                    }

                    public String getNamespace() {
                        CallSite[] callSiteArray = _closure21.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.namespace.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure21.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "deletePod";
                        stringArray[1] = "name";
                        stringArray[2] = "metadata";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[3];
                        _closure21.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure21.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure21.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[11].call(callSiteArray[12].callGetProperty(callSiteArray[13].callCurrent((GroovyObject)this, this.namespace.get(), callSiteArray[14].callGetProperty(callSiteArray[15].callGetProperty(deployedControllerSet)))), (Object)new _closure21((Object)this, this.getThisObject(), this.namespace));
            }

            public String getName() {
                CallSite[] callSiteArray = _hardDestroyDaemonSet_closure15.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _hardDestroyDaemonSet_closure15.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public V1DeleteOptions getDeleteoptions() {
                CallSite[] callSiteArray = _hardDestroyDaemonSet_closure15.$getCallSiteArray();
                return (V1DeleteOptions)ScriptBytecodeAdapter.castToType((Object)this.deleteoptions.get(), V1DeleteOptions.class);
            }

            public Boolean getOrphanDependents() {
                CallSite[] callSiteArray = _hardDestroyDaemonSet_closure15.$getCallSiteArray();
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.orphanDependents.get(), Boolean.class);
            }

            public String getPropagationPolicy() {
                CallSite[] callSiteArray = _hardDestroyDaemonSet_closure15.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.propagationPolicy.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _hardDestroyDaemonSet_closure15.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _hardDestroyDaemonSet_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getDaemonSet";
                stringArray[1] = "deleteNamespacedDaemonSet";
                stringArray[2] = "extApi";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "API_CALL_RESULT_FORMAT";
                stringArray[5] = "TERMINATION_GRACE_PERIOD_SECONDS";
                stringArray[6] = "isDebugEnabled";
                stringArray[7] = "log";
                stringArray[8] = "debug";
                stringArray[9] = "log";
                stringArray[10] = "message";
                stringArray[11] = "forEach";
                stringArray[12] = "items";
                stringArray[13] = "getPods";
                stringArray[14] = "labels";
                stringArray[15] = "metadata";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[16];
                _hardDestroyDaemonSet_closure15.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_hardDestroyDaemonSet_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _hardDestroyDaemonSet_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[65].callCurrent((GroovyObject)this, (Object)"daemonSets.delete", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Hard Destroy Daemon Set ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _hardDestroyDaemonSet_closure15(this, this, name2, namespace2, deleteoptions2, orphanDependents2, propagationPolicy2));
    }

    public List<String> getNamespacesByName() {
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _getNamespacesByName_closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getNamespacesByName_closure16(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getNamespacesByName_closure16.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getNamespacesByName_closure16.$getCallSiteArray();
                V1NamespaceList result = (V1NamespaceList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)callSiteArray[2].callGetProperty(KubernetesClientApiAdapter.class), null, null, null, null, null, null, (Object)30, null)), V1NamespaceList.class);
                public class _closure22
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure22(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure22.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object n) {
                        CallSite[] callSiteArray = _closure22.$getCallSiteArray();
                        return callSiteArray[0].call(callSiteArray[1].call(n));
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure22.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getName";
                        stringArray[1] = "getMetadata";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure22.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure22.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure22.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[3].call(callSiteArray[4].callGetProperty((Object)result), (Object)new _closure22((Object)this, this.getThisObject()));
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getNamespacesByName_closure16.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getNamespacesByName_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "listNamespace";
                stringArray[1] = "coreApi";
                stringArray[2] = "API_CALL_RESULT_FORMAT";
                stringArray[3] = "collect";
                stringArray[4] = "items";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getNamespacesByName_closure16.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getNamespacesByName_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getNamespacesByName_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].callCurrent((GroovyObject)this, (Object)"namespaces.list", (Object)"Get Namespaces", null, (Object)new _getNamespacesByName_closure16(this, this)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public void deletePod(String name, String namespace, V1DeleteOptions deleteOptions, Boolean orphanDependents, String propagationPolicy, Boolean force) {
        void var3_3;
        void var2_2;
        Reference name2 = new Reference((Object)name);
        Reference namespace2 = new Reference((Object)var2_2);
        Reference deleteOptions2 = new Reference((Object)var3_3);
        Reference force2 = new Reference((Object)force);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _deletePod_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference force;
            private /* synthetic */ Reference deleteOptions;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deletePod_closure17(Object _outerInstance, Object _thisObject, Reference force, Reference deleteOptions, Reference name, Reference namespace) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _deletePod_closure17.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.force = reference4 = force;
                this.deleteOptions = reference3 = deleteOptions;
                this.name = reference2 = name;
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _deletePod_closure17.$getCallSiteArray();
                V1Status status = null;
                if (DefaultTypeTransformation.booleanUnbox((Object)this.force.get())) {
                    Object object = callSiteArray[0].callConstructor(V1DeleteOptions.class);
                    this.deleteOptions.set((Object)((V1DeleteOptions)ScriptBytecodeAdapter.castToType((Object)object, V1DeleteOptions.class)));
                    String string = "DeleteOptions";
                    ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)this.deleteOptions.get(), (String)"kind");
                    callSiteArray[1].call(this.deleteOptions.get(), (Object)"v1");
                    int n = 0;
                    ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)this.deleteOptions.get(), (String)"gracePeriodSeconds");
                }
                Object object = this.deleteOptions.get();
                V1DeleteOptions v1DeleteOptions = (V1DeleteOptions)ScriptBytecodeAdapter.castToType((Object)object, V1DeleteOptions.class);
                Object object2 = callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)this.name.get(), (Object)this.namespace.get(), (Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? v1DeleteOptions : (V1DeleteOptions)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callConstructor(V1DeleteOptions.class), V1DeleteOptions.class)), (Object)callSiteArray[5].callGetProperty(KubernetesClientApiAdapter.class), (Object)callSiteArray[6].callGetProperty(KubernetesClientApiAdapter.class), null, null));
                status = (V1Status)ScriptBytecodeAdapter.castToType((Object)object2, V1Status.class);
                Object object3 = object2;
                try {
                    return object3;
                }
                catch (Exception e) {
                    Object object4 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call(callSiteArray[8].callGetProperty(KubernetesClientApiAdapter.class))) ? callSiteArray[9].call(callSiteArray[10].callGetProperty(KubernetesClientApiAdapter.class), callSiteArray[11].callGetProperty((Object)e)) : null;
                    return object4;
                }
            }

            public Boolean getForce() {
                CallSite[] callSiteArray = _deletePod_closure17.$getCallSiteArray();
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.force.get(), Boolean.class);
            }

            public V1DeleteOptions getDeleteOptions() {
                CallSite[] callSiteArray = _deletePod_closure17.$getCallSiteArray();
                return (V1DeleteOptions)ScriptBytecodeAdapter.castToType((Object)this.deleteOptions.get(), V1DeleteOptions.class);
            }

            public String getName() {
                CallSite[] callSiteArray = _deletePod_closure17.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _deletePod_closure17.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _deletePod_closure17.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deletePod_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "apiVersion";
                stringArray[2] = "deleteNamespacedPod";
                stringArray[3] = "coreApi";
                stringArray[4] = "<$constructor$>";
                stringArray[5] = "API_CALL_RESULT_FORMAT";
                stringArray[6] = "TERMINATION_GRACE_PERIOD_SECONDS";
                stringArray[7] = "isDebugEnabled";
                stringArray[8] = "log";
                stringArray[9] = "debug";
                stringArray[10] = "log";
                stringArray[11] = "message";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[12];
                _deletePod_closure17.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deletePod_closure17.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deletePod_closure17.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[67].callCurrent((GroovyObject)this, (Object)"pod.delete", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Destroy Pod ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _deletePod_closure17(this, this, force2, deleteOptions2, name2, namespace2));
    }

    /*
     * WARNING - void declaration
     */
    public V1Pod getPodStatus(String name, String namespace) {
        void var2_2;
        Reference name2 = new Reference((Object)name);
        Reference namespace2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _getPodStatus_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getPodStatus_closure18(Object _outerInstance, Object _thisObject, Reference name, Reference namespace) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getPodStatus_closure18.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.name = reference2 = name;
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getPodStatus_closure18.$getCallSiteArray();
                V1Pod pod = null;
                Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.name.get(), this.namespace.get(), callSiteArray[2].callGetProperty(KubernetesClientApiAdapter.class));
                pod = (V1Pod)ScriptBytecodeAdapter.castToType((Object)object, V1Pod.class);
                Object object2 = object;
                try {
                    return object2;
                }
                catch (Exception e) {
                    Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(callSiteArray[4].callGetProperty(KubernetesClientApiAdapter.class))) ? callSiteArray[5].call(callSiteArray[6].callGetProperty(KubernetesClientApiAdapter.class), callSiteArray[7].callGetProperty((Object)e)) : null;
                    return object3;
                }
            }

            public String getName() {
                CallSite[] callSiteArray = _getPodStatus_closure18.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getPodStatus_closure18.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getPodStatus_closure18.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPodStatus_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "readNamespacedPodStatus";
                stringArray[1] = "coreApi";
                stringArray[2] = "API_CALL_RESULT_FORMAT";
                stringArray[3] = "isDebugEnabled";
                stringArray[4] = "log";
                stringArray[5] = "debug";
                stringArray[6] = "log";
                stringArray[7] = "message";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _getPodStatus_closure18.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getPodStatus_closure18.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getPodStatus_closure18.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (V1Pod)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].callCurrent((GroovyObject)this, (Object)"pods.status", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Get pod status ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _getPodStatus_closure18(this, this, name2, namespace2)), V1Pod.class);
    }

    /*
     * WARNING - void declaration
     */
    public String getControllerKind(String name, String namespace, String controllerKind) {
        void var3_3;
        void var2_2;
        Reference name2 = new Reference((Object)name);
        Reference namespace2 = new Reference((Object)var2_2);
        Reference controllerKind2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = KubernetesClientApiAdapter.$getCallSiteArray();
        public class _getControllerKind_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference controllerKind;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference namespace;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getControllerKind_closure19(Object _outerInstance, Object _thisObject, Reference controllerKind, Reference name, Reference namespace) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _getControllerKind_closure19.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.controllerKind = reference3 = controllerKind;
                this.name = reference2 = name;
                this.namespace = reference = namespace;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getControllerKind_closure19.$getCallSiteArray();
                Object deployedControllerSet = null;
                if (ScriptBytecodeAdapter.compareEqual((Object)this.controllerKind.get(), (Object)callSiteArray[0].callGetProperty(KubernetesUtil.class))) {
                    Object object;
                    deployedControllerSet = object = callSiteArray[1].callCurrent((GroovyObject)this, this.name.get(), this.namespace.get());
                } else if (ScriptBytecodeAdapter.compareEqual((Object)this.controllerKind.get(), (Object)callSiteArray[2].callGetProperty(KubernetesUtil.class))) {
                    Object object;
                    deployedControllerSet = object = callSiteArray[3].callCurrent((GroovyObject)this, this.name.get(), this.namespace.get());
                } else {
                    Object object;
                    deployedControllerSet = object = callSiteArray[4].callCurrent((GroovyObject)this, this.name.get(), this.namespace.get());
                    if (!DefaultTypeTransformation.booleanUnbox((Object)deployedControllerSet)) {
                        Object object2;
                        deployedControllerSet = object2 = callSiteArray[5].callCurrent((GroovyObject)this, this.name.get(), this.namespace.get());
                    }
                }
                return callSiteArray[6].callGetPropertySafe(deployedControllerSet);
            }

            public String getControllerKind() {
                CallSite[] callSiteArray = _getControllerKind_closure19.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.controllerKind.get());
            }

            public String getName() {
                CallSite[] callSiteArray = _getControllerKind_closure19.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _getControllerKind_closure19.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getControllerKind_closure19.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getControllerKind_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "CONTROLLERS_STATEFULSET_KIND";
                stringArray[1] = "getStatefulSet";
                stringArray[2] = "CONTROLLERS_DAEMONSET_KIND";
                stringArray[3] = "getDaemonSet";
                stringArray[4] = "getStatefulSet";
                stringArray[5] = "getDaemonSet";
                stringArray[6] = "kind";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _getControllerKind_closure19.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getControllerKind_closure19.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getControllerKind_closure19.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[69].callCurrent((GroovyObject)this, (Object)"getControllerType", (Object)new GStringImpl(new Object[]{(String)name2.get()}, new String[]{"Get controller type ", API_CALL_RESULT_FORMAT}), (Object)((String)namespace2.get()), (Object)new _getControllerKind_closure19(this, this, controllerKind2, name2, namespace2)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != KubernetesClientApiAdapter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        int n = 100;
        RETRY_INITIAL_WAIT_MILLIS = n;
        Object object = KubernetesClientApiAdapter.$getCallSiteArray()[70].call(KubernetesClientApiAdapter.$getCallSiteArray()[71].callGetProperty(TimeUnit.class), (Object)10);
        RETRY_MAX_WAIT_MILLIS = DefaultTypeTransformation.longUnbox((Object)object);
        Object object2 = KubernetesClientApiAdapter.$getCallSiteArray()[72].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.kubernetes.v1.api.KubernetesClientApiAdapter");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object2, Logger.class);
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String string) {
        this.account = string;
    }

    public static int getRETRY_COUNT() {
        return RETRY_COUNT;
    }

    public static long getRETRY_MAX_WAIT_MILLIS() {
        return RETRY_MAX_WAIT_MILLIS;
    }

    public static long getRETRY_INITIAL_WAIT_MILLIS() {
        return RETRY_INITIAL_WAIT_MILLIS;
    }

    public static int getAPI_CALL_TIMEOUT_SECONDS() {
        return API_CALL_TIMEOUT_SECONDS;
    }

    public static int getTERMINATION_GRACE_PERIOD_SECONDS() {
        return TERMINATION_GRACE_PERIOD_SECONDS;
    }

    public static String getAPI_CALL_RESULT_FORMAT() {
        return API_CALL_RESULT_FORMAT;
    }

    public static int getSHUTDOWN_ALL_PODS() {
        return SHUTDOWN_ALL_PODS;
    }

    public static String getDEPLOYMENT_ANNOTATION() {
        return DEPLOYMENT_ANNOTATION;
    }

    public final Registry getSpectatorRegistry() {
        return this.spectatorRegistry;
    }

    public final Clock getSpectatorClock() {
        return this.spectatorClock;
    }

    public final ApiClient getClient() {
        return this.client;
    }

    public final AppsV1beta1Api getApiInstance() {
        return this.apiInstance;
    }

    public final ExtensionsV1beta1Api getExtApi() {
        return this.extApi;
    }

    public final AutoscalingV1Api getScalerApi() {
        return this.scalerApi;
    }

    public final CoreV1Api getCoreApi() {
        return this.coreApi;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "clock";
        stringArray[3] = "getApiCient";
        stringArray[4] = "setDefaultApiClient";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "call";
        stringArray[14] = "plus";
        stringArray[15] = "sleep";
        stringArray[16] = "min";
        stringArray[17] = "multiply";
        stringArray[18] = "call";
        stringArray[19] = "monotonicTime";
        stringArray[20] = "call";
        stringArray[21] = "formatException";
        stringArray[22] = "formatException";
        stringArray[23] = "simpleName";
        stringArray[24] = "class";
        stringArray[25] = "putAt";
        stringArray[26] = "record";
        stringArray[27] = "timer";
        stringArray[28] = "createId";
        stringArray[29] = "minus";
        stringArray[30] = "monotonicTime";
        stringArray[31] = "NANOSECONDS";
        stringArray[32] = "simpleName";
        stringArray[33] = "class";
        stringArray[34] = "putAt";
        stringArray[35] = "record";
        stringArray[36] = "timer";
        stringArray[37] = "createId";
        stringArray[38] = "minus";
        stringArray[39] = "monotonicTime";
        stringArray[40] = "NANOSECONDS";
        stringArray[41] = "exceptionWrapper";
        stringArray[42] = "exceptionWrapper";
        stringArray[43] = "exceptionWrapper";
        stringArray[44] = "name";
        stringArray[45] = "metadata";
        stringArray[46] = "exceptionWrapper";
        stringArray[47] = "convertValue";
        stringArray[48] = "convertValue";
        stringArray[49] = "convertValue";
        stringArray[50] = "asJson";
        stringArray[51] = "exceptionWrapper";
        stringArray[52] = "exceptionWrapper";
        stringArray[53] = "exceptionWrapper";
        stringArray[54] = "exceptionWrapper";
        stringArray[55] = "name";
        stringArray[56] = "metadata";
        stringArray[57] = "exceptionWrapper";
        stringArray[58] = "exceptionWrapper";
        stringArray[59] = "exceptionWrapper";
        stringArray[60] = "exceptionWrapper";
        stringArray[61] = "name";
        stringArray[62] = "metadata";
        stringArray[63] = "exceptionWrapper";
        stringArray[64] = "exceptionWrapper";
        stringArray[65] = "exceptionWrapper";
        stringArray[66] = "exceptionWrapper";
        stringArray[67] = "exceptionWrapper";
        stringArray[68] = "exceptionWrapper";
        stringArray[69] = "exceptionWrapper";
        stringArray[70] = "toMillis";
        stringArray[71] = "SECONDS";
        stringArray[72] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[73];
        KubernetesClientApiAdapter.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(KubernetesClientApiAdapter.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = KubernetesClientApiAdapter.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

