/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesApiVersion;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesCachingProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestMetadata;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestSpinnakerRelationships;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.names.KubernetesManifestNamer;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.moniker.Moniker;
import io.kubernetes.client.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCacheDataConverter {
    private static final Logger log = LoggerFactory.getLogger(KubernetesCacheDataConverter.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static final JSON json = new JSON();
    private static final int logicalTtlSeconds = Math.toIntExact(TimeUnit.MINUTES.toSeconds(10L));
    private static final int infrastructureTtlSeconds = -1;

    public static CacheData convertAsArtifact(String account, KubernetesManifest manifest) {
        KubernetesCachingProperties cachingProperties = KubernetesManifestAnnotater.getCachingProperties(manifest);
        if (cachingProperties.isIgnore()) {
            return null;
        }
        KubernetesCacheDataConverter.logMalformedManifest(() -> "Converting " + manifest + " to a cached artifact", manifest);
        String namespace = manifest.getNamespace();
        Optional<Artifact> optional = KubernetesManifestAnnotater.getArtifact(manifest);
        if (!optional.isPresent()) {
            return null;
        }
        Artifact artifact = optional.get();
        try {
            KubernetesManifest lastAppliedConfiguration = KubernetesManifestAnnotater.getLastAppliedConfiguration(manifest);
            if (artifact.getMetadata() == null) {
                artifact.setMetadata(new HashMap());
            }
            artifact.getMetadata().put("lastAppliedConfiguration", lastAppliedConfiguration);
            artifact.getMetadata().put("account", account);
        }
        catch (Exception e) {
            log.warn("Unable to get last applied configuration from {}: ", (Object)manifest, (Object)e);
        }
        if (artifact.getType() == null) {
            log.debug("No assigned artifact type for resource " + namespace + ":" + manifest.getFullResourceName());
            return null;
        }
        ImmutableMap attributes = new ImmutableMap.Builder().put((Object)"artifact", (Object)artifact).put((Object)"creationTimestamp", (Object)Optional.ofNullable(manifest.getCreationTimestamp()).orElse("")).build();
        HashMap<String, List<String>> cacheRelationships = new HashMap<String, List<String>>();
        String key = Keys.artifact(artifact.getType(), artifact.getName(), artifact.getLocation(), artifact.getVersion());
        String owner = Keys.infrastructure(manifest, account);
        cacheRelationships.put(manifest.getKind().toString(), Collections.singletonList(owner));
        return new DefaultCacheData(key, logicalTtlSeconds, (Map)attributes, cacheRelationships);
    }

    public static Collection<CacheData> dedupCacheData(Collection<CacheData> input) {
        HashMap<String, CacheData> cacheDataById = new HashMap<String, CacheData>();
        for (CacheData cd : input) {
            String id = cd.getId();
            if (cacheDataById.containsKey(id)) {
                CacheData other = (CacheData)cacheDataById.get(id);
                cd = KubernetesCacheDataConverter.mergeCacheData(cd, other);
            }
            cacheDataById.put(id, cd);
        }
        return cacheDataById.values();
    }

    public static CacheData mergeCacheData(CacheData current, CacheData added) {
        String id = current.getId();
        HashMap attributes = new HashMap(current.getAttributes());
        attributes.putAll(added.getAttributes());
        int ttl = Math.min(current.getTtlSeconds(), added.getTtlSeconds());
        HashMap relationships = new HashMap(current.getRelationships());
        added.getRelationships().entrySet().forEach(entry -> relationships.merge(entry.getKey(), entry.getValue(), (a, b) -> {
            HashSet res = new HashSet(Math.max(a.size(), b.size()));
            res.addAll(a);
            res.addAll(b);
            return res;
        }));
        return new DefaultCacheData(id, ttl, attributes, relationships);
    }

    public static CacheData convertAsResource(String account, KubernetesManifest manifest, List<KubernetesManifest> resourceRelationships) {
        KubernetesCachingProperties cachingProperties = KubernetesManifestAnnotater.getCachingProperties(manifest);
        if (cachingProperties.isIgnore()) {
            return null;
        }
        KubernetesCacheDataConverter.logMalformedManifest(() -> "Converting " + manifest + " to a cached resource", manifest);
        KubernetesKind kind = manifest.getKind();
        boolean hasClusterRelationship = false;
        boolean isNamespaced = true;
        if (kind != null) {
            hasClusterRelationship = kind.hasClusterRelationship();
            isNamespaced = kind.isNamespaced();
        }
        KubernetesApiVersion apiVersion = manifest.getApiVersion();
        String name = manifest.getName();
        String namespace = manifest.getNamespace();
        KubernetesManifestNamer namer = account == null ? new KubernetesManifestNamer() : NamerRegistry.lookup().withProvider(KubernetesCloudProvider.getID()).withAccount(account).withResource(KubernetesManifest.class);
        Moniker moniker = namer.deriveMoniker(manifest);
        ImmutableMap attributes = new ImmutableMap.Builder().put((Object)"kind", (Object)kind).put((Object)"apiVersion", (Object)apiVersion).put((Object)"name", (Object)name).put((Object)"namespace", (Object)namespace).put((Object)"fullResourceName", (Object)manifest.getFullResourceName()).put((Object)"manifest", (Object)manifest).put((Object)"moniker", (Object)moniker).build();
        KubernetesManifestSpinnakerRelationships relationships = KubernetesManifestAnnotater.getManifestRelationships(manifest);
        Optional<Artifact> optional = KubernetesManifestAnnotater.getArtifact(manifest);
        KubernetesManifestMetadata metadata = KubernetesManifestMetadata.builder().relationships(relationships).moniker(moniker).artifact(optional).build();
        HashMap<String, Collection<String>> cacheRelationships = new HashMap<String, Collection<String>>();
        String application = moniker.getApp();
        if (StringUtils.isEmpty((CharSequence)application)) {
            log.debug("Encountered not-spinnaker-owned resource " + namespace + ":" + manifest.getFullResourceName());
        } else {
            cacheRelationships.putAll(KubernetesCacheDataConverter.annotatedRelationships(account, metadata, hasClusterRelationship));
        }
        cacheRelationships.putAll(KubernetesCacheDataConverter.ownerReferenceRelationships(account, namespace, manifest.getOwnerReferences()));
        cacheRelationships.putAll(KubernetesCacheDataConverter.implicitRelationships(manifest, account, resourceRelationships));
        String key = Keys.infrastructure(kind, account, namespace, name);
        return new DefaultCacheData(key, -1, (Map)attributes, cacheRelationships);
    }

    public static KubernetesManifest getManifest(CacheData cacheData) {
        return (KubernetesManifest)mapper.convertValue(cacheData.getAttributes().get("manifest"), KubernetesManifest.class);
    }

    public static Moniker getMoniker(CacheData cacheData) {
        return (Moniker)mapper.convertValue(cacheData.getAttributes().get("moniker"), Moniker.class);
    }

    public static KubernetesManifest convertToManifest(Object o) {
        return (KubernetesManifest)mapper.convertValue(o, KubernetesManifest.class);
    }

    public static <T> T getResource(KubernetesManifest manifest, Class<T> clazz) {
        return (T)json.deserialize(json.serialize((Object)manifest), clazz);
    }

    static Map<String, Collection<String>> annotatedRelationships(String account, KubernetesManifestMetadata metadata, boolean hasClusterRelationship) {
        Moniker moniker = metadata.getMoniker();
        String application = moniker.getApp();
        Optional<Artifact> optional = metadata.getArtifact();
        HashMap<String, Collection<String>> cacheRelationships = new HashMap<String, Collection<String>>();
        if (optional.isPresent()) {
            Artifact artifact = optional.get();
            cacheRelationships.put(Keys.Kind.ARTIFACT.toString(), Collections.singletonList(Keys.artifact(artifact.getType(), artifact.getName(), artifact.getLocation(), artifact.getVersion())));
        }
        if (hasClusterRelationship) {
            cacheRelationships.put(Keys.LogicalKind.APPLICATIONS.toString(), Collections.singletonList(Keys.application(application)));
            String cluster = moniker.getCluster();
            if (StringUtils.isNotEmpty((CharSequence)cluster)) {
                cacheRelationships.put(Keys.LogicalKind.CLUSTERS.toString(), Collections.singletonList(Keys.cluster(account, application, cluster)));
            }
        }
        return cacheRelationships;
    }

    static void addSingleRelationship(Map<String, Collection<String>> relationships, String account, String namespace, String fullName) {
        Pair<KubernetesKind, String> triple = KubernetesManifest.fromFullResourceName(fullName);
        KubernetesKind kind = (KubernetesKind)triple.getLeft();
        String name = (String)triple.getRight();
        Collection<String> keys = relationships.get(kind.toString());
        if (keys == null) {
            keys = new ArrayList<String>();
        }
        keys.add(Keys.infrastructure(kind, account, namespace, name));
        relationships.put(kind.toString(), keys);
    }

    static Map<String, Collection<String>> implicitRelationships(KubernetesManifest source, String account, List<KubernetesManifest> manifests) {
        String namespace = source.getNamespace();
        HashMap<String, Collection<String>> relationships = new HashMap<String, Collection<String>>();
        manifests = manifests == null ? new ArrayList<KubernetesManifest>() : manifests;
        KubernetesCacheDataConverter.logMalformedManifests(() -> "Determining implicit relationships for " + source + " in " + account, manifests);
        for (KubernetesManifest manifest : manifests) {
            KubernetesKind kind = manifest.getKind();
            String name = manifest.getName();
            ArrayList<String> keys = (ArrayList<String>)relationships.get(kind.toString());
            if (keys == null) {
                keys = new ArrayList<String>();
            }
            keys.add(Keys.infrastructure(kind, account, namespace, name));
            relationships.put(kind.toString(), keys);
        }
        return relationships;
    }

    static Map<String, Collection<String>> ownerReferenceRelationships(String account, String namespace, List<KubernetesManifest.OwnerReference> references) {
        HashMap<String, Collection<String>> relationships = new HashMap<String, Collection<String>>();
        references = references == null ? new ArrayList() : references;
        for (KubernetesManifest.OwnerReference reference : references) {
            KubernetesKind kind = reference.getKind();
            String name = reference.getName();
            ArrayList<String> keys = (ArrayList<String>)relationships.get(kind.toString());
            if (keys == null) {
                keys = new ArrayList<String>();
            }
            keys.add(Keys.infrastructure(kind, account, namespace, name));
            relationships.put(kind.toString(), keys);
        }
        return relationships;
    }

    static List<CacheData> invertRelationships(CacheData cacheData) {
        String key = cacheData.getId();
        Keys.CacheKey parsedKey = Keys.parseKey(key).orElseThrow(() -> new IllegalStateException("Cache data produced with illegal key format " + key));
        String group = parsedKey.getGroup();
        Map relationshipGroupings = cacheData.getRelationships();
        ArrayList<CacheData> result = new ArrayList<CacheData>();
        for (Collection relationships : relationshipGroupings.values()) {
            for (String relationship : relationships) {
                KubernetesCacheDataConverter.invertSingleRelationship(group, key, relationship).flatMap(cd -> {
                    result.add((CacheData)cd);
                    return Optional.empty();
                });
            }
        }
        return result;
    }

    static void logStratifiedCacheData(String agentType, Map<String, Collection<CacheData>> stratifiedCacheData) {
        for (Map.Entry<String, Collection<CacheData>> entry : stratifiedCacheData.entrySet()) {
            log.info(agentType + ": grouping " + entry.getKey() + " has " + entry.getValue().size() + " entries and " + KubernetesCacheDataConverter.relationshipCount(entry.getValue()) + " relationships");
        }
    }

    static void logMalformedManifests(Supplier<String> contextMessage, List<KubernetesManifest> relationships) {
        for (KubernetesManifest relationship : relationships) {
            KubernetesCacheDataConverter.logMalformedManifest(contextMessage, relationship);
        }
    }

    static void logMalformedManifest(Supplier<String> contextMessage, KubernetesManifest manifest) {
        if (manifest == null) {
            log.warn("{}: manifest may not be null", (Object)contextMessage.get());
            return;
        }
        if (manifest.getKind() == null) {
            log.warn("{}: manifest kind may not be null, {}", (Object)contextMessage.get(), (Object)manifest);
        }
        if (StringUtils.isEmpty((CharSequence)manifest.getName())) {
            log.warn("{}: manifest name may not be null, {}", (Object)contextMessage.get(), (Object)manifest);
        }
        if (StringUtils.isEmpty((CharSequence)manifest.getNamespace()) && manifest.getKind().isNamespaced()) {
            log.warn("{}: manifest namespace may not be null, {}", (Object)contextMessage.get(), (Object)manifest);
        }
    }

    static int relationshipCount(Collection<CacheData> data) {
        return data.stream().map(d -> KubernetesCacheDataConverter.relationshipCount(d)).reduce(0, (a, b) -> a + b);
    }

    static int relationshipCount(CacheData data) {
        return data.getRelationships().values().stream().map(Collection::size).reduce(0, (a, b) -> a + b);
    }

    static Map<String, Collection<CacheData>> stratifyCacheDataByGroup(Collection<CacheData> ungroupedCacheData) {
        return ungroupedCacheData.stream().map(cd -> CacheDataKeyPair.builder().cacheData((CacheData)cd).key(Keys.parseKey(cd.getId()).orElseThrow(() -> new IllegalStateException("Cache data produced with illegal key format " + cd.getId()))).build()).filter(kp -> {
            if (kp.key instanceof Keys.InfrastructureCacheKey) {
                return kp.cacheData.getAttributes() != null && !kp.cacheData.getAttributes().isEmpty();
            }
            return true;
        }).collect(Collectors.groupingBy(kp -> kp.key.getGroup(), Collectors.mapping(kp -> kp.cacheData, Collectors.toCollection(ArrayList::new))));
    }

    private static Optional<CacheData> invertSingleRelationship(String group, String key, String relationship) {
        HashMap<String, List<String>> relationships = new HashMap<String, List<String>>();
        relationships.put(group, Collections.singletonList(key));
        return Keys.parseKey(relationship).map(k -> {
            ImmutableMap attributes;
            int ttl;
            if (Keys.LogicalKind.isLogicalGroup(k.getGroup())) {
                ttl = logicalTtlSeconds;
                attributes = new ImmutableMap.Builder().put((Object)"name", (Object)k.getName()).build();
            } else {
                ttl = -1;
                attributes = new HashMap();
            }
            return new DefaultCacheData(relationship, ttl, (Map)attributes, relationships);
        });
    }

    private static class CacheDataKeyPair {
        Keys.CacheKey key;
        CacheData cacheData;

        CacheDataKeyPair(Keys.CacheKey key, CacheData cacheData) {
            this.key = key;
            this.cacheData = cacheData;
        }

        public static CacheDataKeyPairBuilder builder() {
            return new CacheDataKeyPairBuilder();
        }

        public static class CacheDataKeyPairBuilder {
            private Keys.CacheKey key;
            private CacheData cacheData;

            CacheDataKeyPairBuilder() {
            }

            public CacheDataKeyPairBuilder key(Keys.CacheKey key) {
                this.key = key;
                return this;
            }

            public CacheDataKeyPairBuilder cacheData(CacheData cacheData) {
                this.cacheData = cacheData;
                return this;
            }

            public CacheDataKeyPair build() {
                return new CacheDataKeyPair(this.key, this.cacheData);
            }

            public String toString() {
                return "KubernetesCacheDataConverter.CacheDataKeyPair.CacheDataKeyPairBuilder(key=" + this.key + ", cacheData=" + this.cacheData + ")";
            }
        }
    }
}

