/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2OnDemandCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCoreCachingAgent
extends KubernetesV2OnDemandCachingAgent {
    private static final Logger log = LoggerFactory.getLogger(KubernetesCoreCachingAgent.class);

    KubernetesCoreCachingAgent(KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, KubernetesResourcePropertyRegistry propertyRegistry, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount) {
        super(namedAccountCredentials, propertyRegistry, objectMapper, registry, agentIndex, agentCount);
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        ArrayList<AgentDataType> types = new ArrayList<AgentDataType>();
        types.add(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.LogicalKind.APPLICATIONS.toString()));
        types.add(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.LogicalKind.CLUSTERS.toString()));
        types.addAll(this.primaryKinds().stream().map(k -> AgentDataType.Authority.AUTHORITATIVE.forType(k.toString())).collect(Collectors.toList()));
        return Collections.unmodifiableSet(new HashSet(types));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<KubernetesKind> primaryKinds() {
        List<KubernetesKind> list = KubernetesKind.getValues();
        synchronized (list) {
            return KubernetesKind.getValues().stream().filter(((KubernetesV2Credentials)this.credentials)::isValidKind).filter(k -> !k.isDynamic()).collect(Collectors.toList());
        }
    }
}

