/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesApplicationProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesManifestLabeler {
    private static final Logger log = LoggerFactory.getLogger(KubernetesManifestLabeler.class);
    private static final String KUBERNETES_LABEL = "kubernetes.io";
    private static final String APP_LABEL_PREFIX = "app.kubernetes.io";
    private static final String APP_NAME = "app.kubernetes.io/name";
    private static final String APP_VERSION = "app.kubernetes.io/version";
    private static final String APP_COMPONENT = "app.kubernetes.io/component";
    private static final String APP_PART_OF = "app.kubernetes.io/part-of";
    private static final String APP_MANAGED_BY = "app.kubernetes.io/managed-by";
    private static ObjectMapper objectMapper = new ObjectMapper();

    private static void storeLabelAndOverwrite(Map<String, String> labels, String key, String value) {
        if (value == null) {
            return;
        }
        labels.put(key, value);
    }

    private static void storeLabel(Map<String, String> labels, String key, String value) {
        if (value == null) {
            return;
        }
        if (labels.containsKey(key)) {
            return;
        }
        labels.put(key, value);
    }

    public static void labelManifest(KubernetesManifest manifest, Moniker moniker) {
        Map<String, String> labels = manifest.getLabels();
        KubernetesManifestLabeler.storeLabels(labels, moniker);
        manifest.getSpecTemplateLabels().flatMap(l -> {
            KubernetesManifestLabeler.storeLabels(l, moniker);
            return Optional.empty();
        });
    }

    private static void storeLabels(Map<String, String> labels, Moniker moniker) {
        if (moniker == null) {
            return;
        }
        KubernetesManifestLabeler.storeLabel(labels, APP_NAME, moniker.getApp());
        KubernetesManifestLabeler.storeLabelAndOverwrite(labels, APP_MANAGED_BY, "spinnaker");
    }

    public static KubernetesApplicationProperties getApplicationProperties(KubernetesManifest manifest) {
        Map<String, String> labels = manifest.getLabels();
        return new KubernetesApplicationProperties().setName(labels.get(APP_NAME)).setVersion(labels.get(APP_VERSION)).setComponent(labels.get(APP_COMPONENT)).setPartOf(labels.get(APP_PART_OF)).setManagedBy(labels.get(APP_MANAGED_BY));
    }
}

