/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.kubernetes.description.KubernetesAtomicOperationDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesPatchOptions;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class KubernetesPatchManifestDescription
extends KubernetesAtomicOperationDescription {
    private String manifestName;
    private String location;
    private KubernetesManifest patchBody;
    private List<Artifact> requiredArtifacts;
    private List<Artifact> allArtifacts;
    private Artifact manifestArtifact;
    private KubernetesPatchOptions options;

    @JsonIgnore
    public KubernetesCoordinates getPointCoordinates() {
        Pair<KubernetesKind, String> parsedName = KubernetesManifest.fromFullResourceName(this.manifestName);
        return KubernetesCoordinates.builder().namespace(this.location).kind((KubernetesKind)parsedName.getLeft()).name((String)parsedName.getRight()).build();
    }

    public String getManifestName() {
        return this.manifestName;
    }

    public String getLocation() {
        return this.location;
    }

    public KubernetesManifest getPatchBody() {
        return this.patchBody;
    }

    public List<Artifact> getRequiredArtifacts() {
        return this.requiredArtifacts;
    }

    public List<Artifact> getAllArtifacts() {
        return this.allArtifacts;
    }

    public Artifact getManifestArtifact() {
        return this.manifestArtifact;
    }

    public KubernetesPatchOptions getOptions() {
        return this.options;
    }

    public KubernetesPatchManifestDescription setManifestName(String manifestName) {
        this.manifestName = manifestName;
        return this;
    }

    public KubernetesPatchManifestDescription setLocation(String location) {
        this.location = location;
        return this;
    }

    public KubernetesPatchManifestDescription setPatchBody(KubernetesManifest patchBody) {
        this.patchBody = patchBody;
        return this;
    }

    public KubernetesPatchManifestDescription setRequiredArtifacts(List<Artifact> requiredArtifacts) {
        this.requiredArtifacts = requiredArtifacts;
        return this;
    }

    public KubernetesPatchManifestDescription setAllArtifacts(List<Artifact> allArtifacts) {
        this.allArtifacts = allArtifacts;
        return this;
    }

    public KubernetesPatchManifestDescription setManifestArtifact(Artifact manifestArtifact) {
        this.manifestArtifact = manifestArtifact;
        return this;
    }

    public KubernetesPatchManifestDescription setOptions(KubernetesPatchOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public String toString() {
        return "KubernetesPatchManifestDescription(manifestName=" + this.getManifestName() + ", location=" + this.getLocation() + ", patchBody=" + this.getPatchBody() + ", requiredArtifacts=" + this.getRequiredArtifacts() + ", allArtifacts=" + this.getAllArtifacts() + ", manifestArtifact=" + this.getManifestArtifact() + ", options=" + this.getOptions() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesPatchManifestDescription)) {
            return false;
        }
        KubernetesPatchManifestDescription other = (KubernetesPatchManifestDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$manifestName = this.getManifestName();
        String other$manifestName = other.getManifestName();
        if (this$manifestName == null ? other$manifestName != null : !this$manifestName.equals(other$manifestName)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        KubernetesManifest this$patchBody = this.getPatchBody();
        KubernetesManifest other$patchBody = other.getPatchBody();
        if (this$patchBody == null ? other$patchBody != null : !((Object)this$patchBody).equals(other$patchBody)) {
            return false;
        }
        List<Artifact> this$requiredArtifacts = this.getRequiredArtifacts();
        List<Artifact> other$requiredArtifacts = other.getRequiredArtifacts();
        if (this$requiredArtifacts == null ? other$requiredArtifacts != null : !((Object)this$requiredArtifacts).equals(other$requiredArtifacts)) {
            return false;
        }
        List<Artifact> this$allArtifacts = this.getAllArtifacts();
        List<Artifact> other$allArtifacts = other.getAllArtifacts();
        if (this$allArtifacts == null ? other$allArtifacts != null : !((Object)this$allArtifacts).equals(other$allArtifacts)) {
            return false;
        }
        Artifact this$manifestArtifact = this.getManifestArtifact();
        Artifact other$manifestArtifact = other.getManifestArtifact();
        if (this$manifestArtifact == null ? other$manifestArtifact != null : !this$manifestArtifact.equals(other$manifestArtifact)) {
            return false;
        }
        KubernetesPatchOptions this$options = this.getOptions();
        KubernetesPatchOptions other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesPatchManifestDescription;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $manifestName = this.getManifestName();
        result = result * 59 + ($manifestName == null ? 43 : $manifestName.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        KubernetesManifest $patchBody = this.getPatchBody();
        result = result * 59 + ($patchBody == null ? 43 : ((Object)$patchBody).hashCode());
        List<Artifact> $requiredArtifacts = this.getRequiredArtifacts();
        result = result * 59 + ($requiredArtifacts == null ? 43 : ((Object)$requiredArtifacts).hashCode());
        List<Artifact> $allArtifacts = this.getAllArtifacts();
        result = result * 59 + ($allArtifacts == null ? 43 : ((Object)$allArtifacts).hashCode());
        Artifact $manifestArtifact = this.getManifestArtifact();
        result = result * 59 + ($manifestArtifact == null ? 43 : $manifestArtifact.hashCode());
        KubernetesPatchOptions $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }
}

