/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.manifest;

import com.google.common.collect.Sets;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesPatchManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesPatchManifestOperation
implements AtomicOperation<OperationResult> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesPatchManifestOperation.class);
    private final KubernetesPatchManifestDescription description;
    private final KubernetesV2Credentials credentials;
    private final KubernetesResourcePropertyRegistry registry;
    private final String accountName;
    private static final String OP_NAME = "PATCH_KUBERNETES_MANIFEST";

    public KubernetesPatchManifestOperation(KubernetesPatchManifestDescription description, KubernetesResourcePropertyRegistry registry) {
        this.description = description;
        this.credentials = (KubernetesV2Credentials)description.getCredentials().getCredentials();
        this.registry = registry;
        this.accountName = description.getCredentials().getName();
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public OperationResult operate(List _unused) {
        this.updateStatus("Beginning patching of manifest");
        KubernetesCoordinates objToPatch = this.description.getPointCoordinates();
        this.updateStatus("Finding patch handler for " + objToPatch + "...");
        KubernetesHandler patchHandler = this.findPatchHandler(objToPatch);
        this.updateStatus("Swapping out artifacts in " + objToPatch + " from context...");
        ArtifactReplacer.ReplaceResult replaceResult = this.replaceArtifacts(objToPatch, patchHandler);
        this.updateStatus("Submitting manifest " + this.description.getManifestName() + " to Kubernetes master...");
        OperationResult result = new OperationResult();
        result.merge(patchHandler.patch(this.credentials, objToPatch.getNamespace(), objToPatch.getName(), this.description.getOptions(), replaceResult.getManifest()));
        result.getBoundArtifacts().addAll(replaceResult.getBoundArtifacts());
        result.removeSensitiveKeys(this.registry, this.accountName);
        return result;
    }

    private void updateStatus(String status) {
        KubernetesPatchManifestOperation.getTask().updateStatus(OP_NAME, status);
    }

    private ArtifactReplacer.ReplaceResult replaceArtifacts(KubernetesCoordinates objToPatch, KubernetesHandler patchHandler) {
        Sets.SetView unboundArtifacts;
        ArrayList<Artifact> allArtifacts = this.description.getAllArtifacts() == null ? new ArrayList() : this.description.getAllArtifacts();
        ArtifactReplacer.ReplaceResult replaceResult = patchHandler.replaceArtifacts(this.description.getPatchBody(), allArtifacts, objToPatch.getNamespace(), this.description.getAccount());
        if (this.description.getRequiredArtifacts() != null && !(unboundArtifacts = Sets.difference(new HashSet<Artifact>(this.description.getRequiredArtifacts()), replaceResult.getBoundArtifacts())).isEmpty()) {
            throw new IllegalArgumentException("The following required artifacts could not be bound: '" + unboundArtifacts + "' . Failing the stage as this is likely a configuration error.");
        }
        return replaceResult;
    }

    private KubernetesHandler findPatchHandler(KubernetesCoordinates objToPatch) {
        KubernetesResourceProperties properties = this.registry.get(this.accountName, objToPatch.getKind());
        if (properties == null) {
            throw new IllegalArgumentException("Unsupported Kubernetes object kind '" + objToPatch.getKind() + "', unable to continue");
        }
        KubernetesHandler patchHandler = properties.getHandler();
        if (patchHandler == null) {
            throw new IllegalArgumentException("No patch handler available for Kubernetes object kind ' " + objToPatch.getKind() + "', unable to continue");
        }
        return patchHandler;
    }
}

