/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.validator.manifest;

import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidator;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesPatchManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.validator.KubernetesValidationUtil;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import com.netflix.spinnaker.clouddriver.security.ProviderVersion;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@KubernetesOperation(value="patchManifest")
@Component
public class KubernetesPatchManifestValidator
extends DescriptionValidator<KubernetesPatchManifestDescription> {
    @Autowired
    AccountCredentialsProvider provider;

    public void validate(List priorDescriptions, KubernetesPatchManifestDescription description, Errors errors) {
        KubernetesValidationUtil util = new KubernetesValidationUtil("patchKubernetesManifest", errors);
        if (!util.validateNotEmpty("patchBody", description.getPatchBody())) {
            return;
        }
        if (!util.validateNotEmpty("options.mergeStrategy", (Object)description.getOptions().getMergeStrategy())) {
            return;
        }
        if (!util.validateNotEmpty("options.record", description.getOptions().isRecord())) {
            return;
        }
        if (!util.validateV2Credentials(this.provider, description.getAccount(), description.getPointCoordinates().getNamespace())) {
            return;
        }
    }

    public boolean acceptsVersion(ProviderVersion version) {
        return version == ProviderVersion.v2;
    }
}

