/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2OnDemandCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesUnregisteredCustomResourceCachingAgent
extends KubernetesV2OnDemandCachingAgent {
    private static final Logger log = LoggerFactory.getLogger(KubernetesUnregisteredCustomResourceCachingAgent.class);
    private static final int crdExpirySeconds = 30;
    private final Supplier<List<KubernetesKind>> liveCrdSupplier = Suppliers.memoizeWithExpiration(() -> {
        try {
            return ((KubernetesV2Credentials)this.credentials).list(KubernetesKind.CUSTOM_RESOURCE_DEFINITION, "").stream().map(c -> {
                Map spec = c.getOrDefault("spec", new HashMap());
                String scope = spec.getOrDefault("scope", "");
                Map names = spec.getOrDefault("names", new HashMap());
                String name = (String)names.get("kind");
                return KubernetesKind.fromString(name, false, scope.equalsIgnoreCase("namespaced"));
            }).collect(Collectors.toList());
        }
        catch (KubectlJobExecutor.KubectlException e) {
            return new ArrayList();
        }
    }, (long)30L, (TimeUnit)TimeUnit.SECONDS);

    KubernetesUnregisteredCustomResourceCachingAgent(KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, KubernetesResourcePropertyRegistry propertyRegistry, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount) {
        super(namedAccountCredentials, propertyRegistry, objectMapper, registry, agentIndex, agentCount);
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return Collections.unmodifiableSet(this.primaryKinds().stream().map(k -> AgentDataType.Authority.AUTHORITATIVE.forType(k.toString())).collect(Collectors.toSet()));
    }

    @Override
    protected List<KubernetesKind> primaryKinds() {
        return (List)this.liveCrdSupplier.get();
    }
}

