/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.KubernetesCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.config.KubernetesCachingPolicy;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.RegistryUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KubernetesV2CachingAgent
extends KubernetesCachingAgent<KubernetesV2Credentials> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2CachingAgent.class);
    protected KubectlJobExecutor jobExecutor;
    protected String providerName = KubernetesCloudProvider.getID();
    private final KubernetesResourcePropertyRegistry propertyRegistry;

    protected KubernetesV2CachingAgent(KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, KubernetesResourcePropertyRegistry propertyRegistry, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount) {
        super(namedAccountCredentials, objectMapper, registry, agentIndex, agentCount);
        this.propertyRegistry = propertyRegistry;
    }

    protected KubernetesKind primaryKind() {
        throw new NotImplementedException("No primary kind registered, this is an implementation error.");
    }

    protected List<KubernetesKind> primaryKinds() {
        return Collections.singletonList(this.primaryKind());
    }

    protected Map<KubernetesKind, List<KubernetesManifest>> loadPrimaryResourceList() {
        Map<KubernetesKind, List<KubernetesManifest>> result = this.namespaces.stream().map(n -> {
            try {
                return ((KubernetesV2Credentials)this.credentials).list(this.primaryKinds(), (String)n);
            }
            catch (KubectlJobExecutor.KubectlException e) {
                log.warn("Failed to read kind {} from namespace {}: {}", new Object[]{this.primaryKinds(), n, e.getMessage()});
                return null;
            }
        }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.groupingBy(KubernetesManifest::getKind));
        for (KubernetesCachingPolicy policy : ((KubernetesV2Credentials)this.credentials).getCachingPolicies()) {
            List<KubernetesManifest> entries;
            KubernetesKind policyKind = KubernetesKind.fromString(policy.getKubernetesKind());
            if (!result.containsKey(policyKind) || (entries = result.get(policyKind)) == null || entries.size() <= policy.getMaxEntriesPerAgent()) continue;
            log.warn("{}: Pruning {} entries from kind {}", new Object[]{this.getAgentType(), entries.size() - policy.getMaxEntriesPerAgent(), policyKind});
            entries = entries.subList(0, policy.getMaxEntriesPerAgent());
            result.put(policyKind, entries);
        }
        return result;
    }

    protected KubernetesManifest loadPrimaryResource(KubernetesKind kind, String namespace, String name) {
        return ((KubernetesV2Credentials)this.credentials).get(kind, namespace, name);
    }

    public CacheResult loadData(ProviderCache providerCache) {
        log.info(this.getAgentType() + " is starting");
        this.reloadNamespaces();
        try {
            return this.buildCacheResult(this.loadPrimaryResourceList());
        }
        catch (KubectlJobExecutor.NoResourceTypeException e) {
            log.warn(this.getAgentType() + ": resource for this caching agent is not supported for this cluster");
            return new DefaultCacheResult(new HashMap());
        }
    }

    protected CacheResult buildCacheResult(KubernetesManifest resource) {
        return this.buildCacheResult(Collections.singletonMap(resource.getKind(), Collections.singletonList(resource)));
    }

    protected CacheResult buildCacheResult(Map<KubernetesKind, List<KubernetesManifest>> resources) {
        Map<KubernetesManifest, List<KubernetesManifest>> relationships = this.loadSecondaryResourceRelationships(resources);
        List<CacheData> resourceData = resources.values().stream().flatMap(Collection::stream).peek(m -> RegistryUtils.removeSensitiveKeys(this.propertyRegistry, this.accountName, m)).map(rs -> {
            try {
                CacheData cacheData = KubernetesCacheDataConverter.convertAsResource(this.accountName, rs, (List)relationships.get(rs));
                if (((KubernetesV2Credentials)this.credentials).getOnlySpinnakerManaged() && StringUtils.isEmpty((CharSequence)((String)cacheData.getAttributes().get("application")))) {
                    return null;
                }
                return cacheData;
            }
            catch (Exception e) {
                log.warn("Failure converting {} as resource", rs, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List invertedRelationships = resourceData.stream().map(KubernetesCacheDataConverter::invertRelationships).flatMap(Collection::stream).collect(Collectors.toList());
        resourceData.addAll(resources.values().stream().flatMap(Collection::stream).map(rs -> KubernetesCacheDataConverter.convertAsArtifact(this.accountName, rs)).filter(Objects::nonNull).collect(Collectors.toList()));
        resourceData.addAll(invertedRelationships);
        Map<String, Collection<CacheData>> entries = KubernetesCacheDataConverter.stratifyCacheDataByGroup(KubernetesCacheDataConverter.dedupCacheData(resourceData));
        KubernetesCacheDataConverter.logStratifiedCacheData(this.getAgentType(), entries);
        return new DefaultCacheResult(entries);
    }

    protected Map<KubernetesManifest, List<KubernetesManifest>> loadSecondaryResourceRelationships(Map<KubernetesKind, List<KubernetesManifest>> allResources) {
        HashMap<KubernetesManifest, List<KubernetesManifest>> result = new HashMap<KubernetesManifest, List<KubernetesManifest>>();
        allResources.keySet().forEach(k -> {
            try {
                RegistryUtils.addRelationships(this.propertyRegistry, this.accountName, k, allResources, result);
            }
            catch (Exception e) {
                log.warn("Failure adding relationships for {}", k, (Object)e);
            }
        });
        return result;
    }

    public String getProviderName() {
        return this.providerName;
    }
}

