/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.KubernetesCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.KubernetesCachingAgentDispatcher;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesMetricCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2CachingAgentDispatcher
implements KubernetesCachingAgentDispatcher {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2CachingAgentDispatcher.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private Registry registry;
    @Autowired
    private KubernetesResourcePropertyRegistry propertyRegistry;

    @Override
    public Collection<KubernetesCachingAgent> buildAllCachingAgents(KubernetesNamedAccountCredentials credentials) {
        KubernetesV2Credentials v2Credentials = (KubernetesV2Credentials)credentials.getCredentials();
        ArrayList result = new ArrayList();
        IntStream.range(0, credentials.getCacheThreads()).boxed().forEach(i -> this.propertyRegistry.values().stream().map(KubernetesResourceProperties::getHandler).filter(Objects::nonNull).filter(h -> v2Credentials.isValidKind(h.kind()) || h.kind() == KubernetesKind.NONE).map(h -> h.buildCachingAgent(credentials, this.propertyRegistry, this.objectMapper, this.registry, (int)i, credentials.getCacheThreads())).filter(Objects::nonNull).forEach(c -> result.add((KubernetesCachingAgent)c)));
        if (v2Credentials.isMetrics()) {
            IntStream.range(0, credentials.getCacheThreads()).boxed().forEach(i -> result.add(new KubernetesMetricCachingAgent(credentials, this.objectMapper, this.registry, (int)i, credentials.getCacheThreads())));
        }
        return result.stream().collect(Collectors.toMap(KubernetesCachingAgent::getAgentType, c -> c, (a, b) -> b)).values();
    }
}

