/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacerFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2Instance;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2ServerGroupSummary;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.ManifestBasedModel;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.data.KubernetesV2ServerGroupCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestTraffic;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.Instance;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerServerGroup;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import com.netflix.spinnaker.clouddriver.model.ServerGroupManager;
import com.netflix.spinnaker.clouddriver.model.ServerGroupSummary;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesV2ServerGroup
extends ManifestBasedModel
implements ServerGroup {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2ServerGroup.class);
    Boolean disabled;
    Set<String> zones = new HashSet<String>();
    Set<Instance> instances = new HashSet<Instance>();
    Set<String> loadBalancers = new HashSet<String>();
    Set<String> securityGroups = new HashSet<String>();
    List<ServerGroupManager.ServerGroupManagerSummary> serverGroupManagers = new ArrayList<ServerGroupManager.ServerGroupManagerSummary>();
    Map<String, Object> launchConfig = new HashMap<String, Object>();
    ServerGroup.Capacity capacity = new ServerGroup.Capacity();
    ServerGroup.ImageSummary imageSummary;
    ServerGroup.ImagesSummary imagesSummary;
    KubernetesManifest manifest;
    Keys.InfrastructureCacheKey key;
    @JsonIgnore
    private static final ArtifactReplacer dockerImageReplacer = new ArtifactReplacer();

    public ServerGroup.InstanceCounts getInstanceCounts() {
        return ServerGroup.InstanceCounts.builder().total(Integer.valueOf(Ints.checkedCast((long)this.instances.size()))).up(Integer.valueOf(Ints.checkedCast((long)this.instances.stream().filter(i -> i.getHealthState().equals((Object)HealthState.Up)).count()))).down(Integer.valueOf(Ints.checkedCast((long)this.instances.stream().filter(i -> i.getHealthState().equals((Object)HealthState.Down)).count()))).unknown(Integer.valueOf(Ints.checkedCast((long)this.instances.stream().filter(i -> i.getHealthState().equals((Object)HealthState.Unknown)).count()))).outOfService(Integer.valueOf(Ints.checkedCast((long)this.instances.stream().filter(i -> i.getHealthState().equals((Object)HealthState.OutOfService)).count()))).starting(Integer.valueOf(Ints.checkedCast((long)this.instances.stream().filter(i -> i.getHealthState().equals((Object)HealthState.Starting)).count()))).build();
    }

    public Map<String, Object> getBuildInfo() {
        return new ImmutableMap.Builder().put((Object)"images", dockerImageReplacer.findAll(this.getManifest()).stream().map(Artifact::getReference).collect(Collectors.toSet())).build();
    }

    public Boolean isDisabled() {
        return this.disabled;
    }

    protected KubernetesV2ServerGroup(KubernetesManifest manifest, String key, List<KubernetesV2Instance> instances, Set<String> loadBalancers, List<ServerGroupManager.ServerGroupManagerSummary> serverGroupManagers, Boolean disabled) {
        this.manifest = manifest;
        this.key = (Keys.InfrastructureCacheKey)Keys.parseKey(key).get();
        this.instances = new HashSet<KubernetesV2Instance>(instances);
        this.loadBalancers = loadBalancers;
        this.serverGroupManagers = serverGroupManagers;
        this.disabled = disabled;
        Integer odesired = ((Map)manifest.getOrDefault("spec", new HashMap())).getOrDefault("replicas", 0);
        Integer desired = 0;
        if (odesired instanceof Number) {
            desired = ((Number)odesired).intValue();
        } else {
            log.warn("Unable to cast replica count from unexpected type: {}", odesired.getClass());
        }
        this.capacity = ServerGroup.Capacity.builder().desired(desired).build();
    }

    private static KubernetesV2ServerGroup fromCacheData(CacheData cd, List<CacheData> instanceData, List<CacheData> loadBalancerData, List<Keys.InfrastructureCacheKey> serverGroupManagerKeys) {
        if (cd == null) {
            return null;
        }
        if (instanceData == null) {
            instanceData = new ArrayList<CacheData>();
        }
        if (serverGroupManagerKeys == null) {
            serverGroupManagerKeys = new ArrayList<Keys.InfrastructureCacheKey>();
        }
        List<ServerGroupManager.ServerGroupManagerSummary> serverGroupManagers = serverGroupManagerKeys.stream().map(k -> ServerGroupManager.ServerGroupManagerSummary.builder().account(k.getAccount()).location(k.getNamespace()).name(k.getName()).build()).collect(Collectors.toList());
        KubernetesManifest manifest = KubernetesCacheDataConverter.getManifest(cd);
        if (manifest == null) {
            log.warn("Cache data {} inserted without a manifest", (Object)cd.getId());
            return null;
        }
        List<KubernetesV2Instance> instances = instanceData.stream().map(KubernetesV2Instance::fromCacheData).filter(Objects::nonNull).collect(Collectors.toList());
        KubernetesManifestTraffic traffic = KubernetesManifestAnnotater.getTraffic(manifest);
        Set explicitLoadBalancers = traffic.getLoadBalancers().stream().map(KubernetesManifest::fromFullResourceName).map(p -> KubernetesManifest.getFullResourceName((KubernetesKind)p.getLeft(), (String)p.getRight())).collect(Collectors.toSet());
        Set<String> loadBalancers = loadBalancerData.stream().map(CacheData::getId).map(Keys::parseKey).filter(Optional::isPresent).map(Optional::get).map(k -> (Keys.InfrastructureCacheKey)k).map(k -> KubernetesManifest.getFullResourceName(k.getKubernetesKind(), k.getName())).collect(Collectors.toSet());
        Boolean disabled = loadBalancers.isEmpty() && !explicitLoadBalancers.isEmpty();
        loadBalancers.addAll(explicitLoadBalancers);
        return new KubernetesV2ServerGroup(manifest, cd.getId(), instances, loadBalancers, serverGroupManagers, disabled);
    }

    public static KubernetesV2ServerGroup fromCacheData(KubernetesV2ServerGroupCacheData cacheData) {
        return KubernetesV2ServerGroup.fromCacheData(cacheData.getServerGroupData(), cacheData.getInstanceData(), cacheData.getLoadBalancerData(), cacheData.getServerGroupManagerKeys());
    }

    public ServerGroupSummary toServerGroupSummary() {
        return KubernetesV2ServerGroupSummary.builder().name(this.getName()).account(this.getAccount()).namespace(this.getRegion()).moniker(this.getMoniker()).build();
    }

    public LoadBalancerServerGroup toLoadBalancerServerGroup() {
        return LoadBalancerServerGroup.builder().account(this.getAccount()).detachedInstances(new HashSet()).instances(this.instances.stream().map(i -> ((KubernetesV2Instance)i).toLoadBalancerInstance()).collect(Collectors.toSet())).name(this.getName()).region(this.getRegion()).isDisabled(this.isDisabled()).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesV2ServerGroup)) {
            return false;
        }
        KubernetesV2ServerGroup other = (KubernetesV2ServerGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$disabled = this.getDisabled();
        Boolean other$disabled = other.getDisabled();
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        Set<String> this$zones = this.getZones();
        Set<String> other$zones = other.getZones();
        if (this$zones == null ? other$zones != null : !((Object)this$zones).equals(other$zones)) {
            return false;
        }
        Set<Instance> this$instances = this.getInstances();
        Set<Instance> other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances)) {
            return false;
        }
        Set<String> this$loadBalancers = this.getLoadBalancers();
        Set<String> other$loadBalancers = other.getLoadBalancers();
        if (this$loadBalancers == null ? other$loadBalancers != null : !((Object)this$loadBalancers).equals(other$loadBalancers)) {
            return false;
        }
        Set<String> this$securityGroups = this.getSecurityGroups();
        Set<String> other$securityGroups = other.getSecurityGroups();
        if (this$securityGroups == null ? other$securityGroups != null : !((Object)this$securityGroups).equals(other$securityGroups)) {
            return false;
        }
        List<ServerGroupManager.ServerGroupManagerSummary> this$serverGroupManagers = this.getServerGroupManagers();
        List<ServerGroupManager.ServerGroupManagerSummary> other$serverGroupManagers = other.getServerGroupManagers();
        if (this$serverGroupManagers == null ? other$serverGroupManagers != null : !((Object)this$serverGroupManagers).equals(other$serverGroupManagers)) {
            return false;
        }
        Map<String, Object> this$launchConfig = this.getLaunchConfig();
        Map<String, Object> other$launchConfig = other.getLaunchConfig();
        if (this$launchConfig == null ? other$launchConfig != null : !((Object)this$launchConfig).equals(other$launchConfig)) {
            return false;
        }
        ServerGroup.Capacity this$capacity = this.getCapacity();
        ServerGroup.Capacity other$capacity = other.getCapacity();
        if (this$capacity == null ? other$capacity != null : !this$capacity.equals(other$capacity)) {
            return false;
        }
        ServerGroup.ImageSummary this$imageSummary = this.getImageSummary();
        ServerGroup.ImageSummary other$imageSummary = other.getImageSummary();
        if (this$imageSummary == null ? other$imageSummary != null : !this$imageSummary.equals(other$imageSummary)) {
            return false;
        }
        ServerGroup.ImagesSummary this$imagesSummary = this.getImagesSummary();
        ServerGroup.ImagesSummary other$imagesSummary = other.getImagesSummary();
        if (this$imagesSummary == null ? other$imagesSummary != null : !this$imagesSummary.equals(other$imagesSummary)) {
            return false;
        }
        KubernetesManifest this$manifest = this.getManifest();
        KubernetesManifest other$manifest = other.getManifest();
        if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
            return false;
        }
        Keys.InfrastructureCacheKey this$key = this.getKey();
        Keys.InfrastructureCacheKey other$key = other.getKey();
        return !(this$key == null ? other$key != null : !((Object)this$key).equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesV2ServerGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $disabled = this.getDisabled();
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        Set<String> $zones = this.getZones();
        result = result * 59 + ($zones == null ? 43 : ((Object)$zones).hashCode());
        Set<Instance> $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        Set<String> $loadBalancers = this.getLoadBalancers();
        result = result * 59 + ($loadBalancers == null ? 43 : ((Object)$loadBalancers).hashCode());
        Set<String> $securityGroups = this.getSecurityGroups();
        result = result * 59 + ($securityGroups == null ? 43 : ((Object)$securityGroups).hashCode());
        List<ServerGroupManager.ServerGroupManagerSummary> $serverGroupManagers = this.getServerGroupManagers();
        result = result * 59 + ($serverGroupManagers == null ? 43 : ((Object)$serverGroupManagers).hashCode());
        Map<String, Object> $launchConfig = this.getLaunchConfig();
        result = result * 59 + ($launchConfig == null ? 43 : ((Object)$launchConfig).hashCode());
        ServerGroup.Capacity $capacity = this.getCapacity();
        result = result * 59 + ($capacity == null ? 43 : $capacity.hashCode());
        ServerGroup.ImageSummary $imageSummary = this.getImageSummary();
        result = result * 59 + ($imageSummary == null ? 43 : $imageSummary.hashCode());
        ServerGroup.ImagesSummary $imagesSummary = this.getImagesSummary();
        result = result * 59 + ($imagesSummary == null ? 43 : $imagesSummary.hashCode());
        KubernetesManifest $manifest = this.getManifest();
        result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
        Keys.InfrastructureCacheKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        return result;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public Set<String> getZones() {
        return this.zones;
    }

    public Set<Instance> getInstances() {
        return this.instances;
    }

    public Set<String> getLoadBalancers() {
        return this.loadBalancers;
    }

    public Set<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public List<ServerGroupManager.ServerGroupManagerSummary> getServerGroupManagers() {
        return this.serverGroupManagers;
    }

    public Map<String, Object> getLaunchConfig() {
        return this.launchConfig;
    }

    public ServerGroup.Capacity getCapacity() {
        return this.capacity;
    }

    public ServerGroup.ImageSummary getImageSummary() {
        return this.imageSummary;
    }

    public ServerGroup.ImagesSummary getImagesSummary() {
        return this.imagesSummary;
    }

    @Override
    public KubernetesManifest getManifest() {
        return this.manifest;
    }

    @Override
    public Keys.InfrastructureCacheKey getKey() {
        return this.key;
    }

    public KubernetesV2ServerGroup setDisabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public KubernetesV2ServerGroup setZones(Set<String> zones) {
        this.zones = zones;
        return this;
    }

    public KubernetesV2ServerGroup setInstances(Set<Instance> instances) {
        this.instances = instances;
        return this;
    }

    public KubernetesV2ServerGroup setLoadBalancers(Set<String> loadBalancers) {
        this.loadBalancers = loadBalancers;
        return this;
    }

    public KubernetesV2ServerGroup setSecurityGroups(Set<String> securityGroups) {
        this.securityGroups = securityGroups;
        return this;
    }

    public KubernetesV2ServerGroup setServerGroupManagers(List<ServerGroupManager.ServerGroupManagerSummary> serverGroupManagers) {
        this.serverGroupManagers = serverGroupManagers;
        return this;
    }

    public KubernetesV2ServerGroup setLaunchConfig(Map<String, Object> launchConfig) {
        this.launchConfig = launchConfig;
        return this;
    }

    public KubernetesV2ServerGroup setCapacity(ServerGroup.Capacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public KubernetesV2ServerGroup setImageSummary(ServerGroup.ImageSummary imageSummary) {
        this.imageSummary = imageSummary;
        return this;
    }

    public KubernetesV2ServerGroup setImagesSummary(ServerGroup.ImagesSummary imagesSummary) {
        this.imagesSummary = imagesSummary;
        return this;
    }

    public KubernetesV2ServerGroup setManifest(KubernetesManifest manifest) {
        this.manifest = manifest;
        return this;
    }

    public KubernetesV2ServerGroup setKey(Keys.InfrastructureCacheKey key) {
        this.key = key;
        return this;
    }

    public String toString() {
        return "KubernetesV2ServerGroup(disabled=" + this.getDisabled() + ", zones=" + this.getZones() + ", instances=" + this.getInstances() + ", loadBalancers=" + this.getLoadBalancers() + ", securityGroups=" + this.getSecurityGroups() + ", serverGroupManagers=" + this.getServerGroupManagers() + ", launchConfig=" + this.getLaunchConfig() + ", capacity=" + this.getCapacity() + ", imageSummary=" + this.getImageSummary() + ", imagesSummary=" + this.getImagesSummary() + ", manifest=" + this.getManifest() + ", key=" + this.getKey() + ")";
    }

    static {
        dockerImageReplacer.addReplacer(ArtifactReplacerFactory.dockerImageReplacer());
    }
}

