/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2ServerGroup;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.ManifestBasedModel;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.data.KubernetesV2ServerGroupCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.data.KubernetesV2ServerGroupManagerCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.model.ServerGroupManager;
import com.netflix.spinnaker.clouddriver.model.ServerGroupSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesV2ServerGroupManager
extends ManifestBasedModel
implements ServerGroupManager {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2ServerGroupManager.class);
    KubernetesManifest manifest;
    Keys.InfrastructureCacheKey key;
    Set<ServerGroupSummary> serverGroups;

    KubernetesV2ServerGroupManager(KubernetesManifest manifest, String key, Set<ServerGroupSummary> serverGroups) {
        this.manifest = manifest;
        this.key = (Keys.InfrastructureCacheKey)Keys.parseKey(key).get();
        this.serverGroups = serverGroups;
    }

    private static KubernetesV2ServerGroupManager fromCacheData(CacheData cd, List<CacheData> serverGroupData) {
        KubernetesManifest manifest;
        if (cd == null) {
            return null;
        }
        if (serverGroupData == null) {
            serverGroupData = new ArrayList<CacheData>();
        }
        if ((manifest = KubernetesCacheDataConverter.getManifest(cd)) == null) {
            log.warn("Cache data {} inserted without a manifest", (Object)cd.getId());
            return null;
        }
        Set<ServerGroupSummary> serverGroups = serverGroupData.stream().map(data -> KubernetesV2ServerGroup.fromCacheData(KubernetesV2ServerGroupCacheData.builder().serverGroupData((CacheData)data).instanceData(new ArrayList<CacheData>()).loadBalancerData(new ArrayList<CacheData>()).build())).filter(Objects::nonNull).map(KubernetesV2ServerGroup::toServerGroupSummary).collect(Collectors.toSet());
        return new KubernetesV2ServerGroupManager(manifest, cd.getId(), serverGroups);
    }

    public static KubernetesV2ServerGroupManager fromCacheData(KubernetesV2ServerGroupManagerCacheData data) {
        return KubernetesV2ServerGroupManager.fromCacheData(data.getServerGroupManagerData(), data.getServerGroupData());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesV2ServerGroupManager)) {
            return false;
        }
        KubernetesV2ServerGroupManager other = (KubernetesV2ServerGroupManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesManifest this$manifest = this.getManifest();
        KubernetesManifest other$manifest = other.getManifest();
        if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
            return false;
        }
        Keys.InfrastructureCacheKey this$key = this.getKey();
        Keys.InfrastructureCacheKey other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        Set<ServerGroupSummary> this$serverGroups = this.getServerGroups();
        Set<ServerGroupSummary> other$serverGroups = other.getServerGroups();
        return !(this$serverGroups == null ? other$serverGroups != null : !((Object)this$serverGroups).equals(other$serverGroups));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesV2ServerGroupManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        KubernetesManifest $manifest = this.getManifest();
        result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
        Keys.InfrastructureCacheKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        Set<ServerGroupSummary> $serverGroups = this.getServerGroups();
        result = result * 59 + ($serverGroups == null ? 43 : ((Object)$serverGroups).hashCode());
        return result;
    }

    @Override
    public KubernetesManifest getManifest() {
        return this.manifest;
    }

    @Override
    public Keys.InfrastructureCacheKey getKey() {
        return this.key;
    }

    public Set<ServerGroupSummary> getServerGroups() {
        return this.serverGroups;
    }

    public KubernetesV2ServerGroupManager setManifest(KubernetesManifest manifest) {
        this.manifest = manifest;
        return this;
    }

    public KubernetesV2ServerGroupManager setKey(Keys.InfrastructureCacheKey key) {
        this.key = key;
        return this;
    }

    public KubernetesV2ServerGroupManager setServerGroups(Set<ServerGroupSummary> serverGroups) {
        this.serverGroups = serverGroups;
        return this;
    }

    public String toString() {
        return "KubernetesV2ServerGroupManager(manifest=" + this.getManifest() + ", key=" + this.getKey() + ", serverGroups=" + this.getServerGroups() + ")";
    }
}

