/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.model.ArtifactProvider;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2ArtifactProvider
implements ArtifactProvider {
    private final KubernetesCacheUtils cacheUtils;
    private final ObjectMapper objectMapper;

    @Autowired
    KubernetesV2ArtifactProvider(KubernetesCacheUtils cacheUtils, ObjectMapper objectMapper) {
        this.cacheUtils = cacheUtils;
        this.objectMapper = objectMapper;
    }

    public List<Artifact> getArtifacts(String type, String name, String location) {
        String key = Keys.artifact(type, name, location, "*");
        return this.cacheUtils.getAllDataMatchingPattern(Keys.Kind.ARTIFACT.toString(), key).stream().sorted(Comparator.comparing(cd -> cd.getAttributes().getOrDefault("creationTimestamp", ""))).map(this::cacheDataToArtifact).collect(Collectors.toList());
    }

    private Artifact cacheDataToArtifact(CacheData cacheData) {
        return (Artifact)this.objectMapper.convertValue(cacheData.getAttributes().get("artifact"), Artifact.class);
    }
}

